/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.tools.property;

import java.io.InputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.TreeSet;
import org.apache.commons.lang3.StringUtils;
import us.ihmc.commons.exception.DefaultExceptionHandler;
import us.ihmc.commons.exception.ExceptionHandler;
import us.ihmc.commons.exception.ExceptionTools;
import us.ihmc.commons.nio.FileTools;
import us.ihmc.commons.nio.WriteOption;
import us.ihmc.log.LogTools;
import us.ihmc.tools.property.BooleanStoredPropertyKey;
import us.ihmc.tools.property.DoubleStoredPropertyKey;
import us.ihmc.tools.property.IntegerStoredPropertyKey;
import us.ihmc.tools.property.StoredProperty;
import us.ihmc.tools.property.StoredPropertyKey;
import us.ihmc.tools.property.StoredPropertyKeyList;
import us.ihmc.tools.property.StoredPropertyKeyListReadOnly;
import us.ihmc.tools.property.StoredPropertySetBasics;

public class StoredPropertySet
implements StoredPropertySetBasics {
    private final StoredPropertyKeyList keys;
    private final Object[] values;
    private final Class<?> classForLoading;
    private final String uncapitalizedClassName;
    private final String directoryNameToAssumePresent;
    private final String subsequentPathToResourceFolder;
    private String saveFileName;
    private String currentVersionSuffix;
    private final Map<StoredPropertyKey, List<Runnable>> propertyChangedListeners = new HashMap<StoredPropertyKey, List<Runnable>>();

    public StoredPropertySet(StoredPropertyKeyList keys, Class<?> classForLoading, String directoryNameToAssumePresent, String subsequentPathToResourceFolder) {
        this(keys, classForLoading, directoryNameToAssumePresent, subsequentPathToResourceFolder, "");
    }

    public StoredPropertySet(StoredPropertyKeyList keys, Class<?> classForLoading, String directoryNameToAssumePresent, String subsequentPathToResourceFolder, String versionSuffix) {
        this.keys = keys;
        this.classForLoading = classForLoading;
        this.uncapitalizedClassName = StringUtils.uncapitalize((String)classForLoading.getSimpleName());
        this.directoryNameToAssumePresent = directoryNameToAssumePresent;
        this.subsequentPathToResourceFolder = subsequentPathToResourceFolder;
        this.updateBackingSaveFile(versionSuffix);
        this.values = new Object[keys.keys().size()];
        for (StoredPropertyKey<?> key : keys.keys()) {
            if (!key.hasDefaultValue()) continue;
            this.setInternal(key, key.getDefaultValue());
        }
    }

    @Override
    public double get(DoubleStoredPropertyKey key) {
        return (Double)this.values[key.getIndex()];
    }

    @Override
    public int get(IntegerStoredPropertyKey key) {
        return (Integer)this.values[key.getIndex()];
    }

    @Override
    public boolean get(BooleanStoredPropertyKey key) {
        return (Boolean)this.values[key.getIndex()];
    }

    @Override
    public <T> T get(StoredPropertyKey<T> key) {
        return (T)this.values[key.getIndex()];
    }

    @Override
    public void set(DoubleStoredPropertyKey key, double value) {
        this.setInternal(key, value);
    }

    @Override
    public void set(IntegerStoredPropertyKey key, int value) {
        this.setInternal(key, value);
    }

    @Override
    public void set(BooleanStoredPropertyKey key, boolean value) {
        this.setInternal(key, value);
    }

    @Override
    public <T> void set(StoredPropertyKey<T> key, T value) {
        this.setInternal(key, value);
    }

    public <T> StoredProperty<T> getProperty(StoredPropertyKey<T> key) {
        return new StoredProperty<T>(key, this);
    }

    @Override
    public List<Object> getAll() {
        return Arrays.asList(this.values);
    }

    @Override
    public List<String> getAllAsStrings() {
        ArrayList<String> stringValues = new ArrayList<String>();
        for (StoredPropertyKey<?> key : this.keys.keys()) {
            stringValues.add(this.serializeValue(this.get(key)));
        }
        return stringValues;
    }

    @Override
    public void setAll(List<Object> newValues) {
        for (int i = 0; i < this.keys.keys().size(); ++i) {
            this.setInternal(this.keys.keys().get(i), newValues.get(i));
        }
    }

    @Override
    public void setAllFromStrings(List<String> stringValues) {
        for (int i = 0; i < this.keys.keys().size(); ++i) {
            this.setInternal(this.keys.keys().get(i), this.deserializeString(this.keys.keys().get(i), stringValues.get(i)));
        }
    }

    private void setInternal(StoredPropertyKey key, Object newValue) {
        boolean valueChanged;
        if (this.values[key.getIndex()] == null) {
            valueChanged = newValue != null;
        } else {
            boolean bl = valueChanged = !this.values[key.getIndex()].equals(newValue);
        }
        if (valueChanged) {
            if (!key.getType().equals(newValue.getClass())) {
                if (key.getType().equals(Boolean.class) && newValue.getClass().equals(Integer.class)) {
                    newValue = (Integer)newValue != 0;
                } else {
                    throw new RuntimeException("Value of type " + newValue.getClass() + " cannot be set to key type " + key.getType());
                }
            }
            this.values[key.getIndex()] = newValue;
            if (this.propertyChangedListeners.get(key) != null) {
                for (Runnable propertyChangedListener : this.propertyChangedListeners.get(key)) {
                    propertyChangedListener.run();
                }
            }
        }
    }

    @Override
    public void addPropertyChangedListener(StoredPropertyKey key, Runnable onPropertyChanged) {
        if (this.propertyChangedListeners.get(key) == null) {
            this.propertyChangedListeners.put(key, new ArrayList());
        }
        this.propertyChangedListeners.get(key).add(onPropertyChanged);
    }

    @Override
    public void removePropertyChangedListener(StoredPropertyKey key, Runnable onPropertyChanged) {
        if (this.propertyChangedListeners.get(key) != null) {
            this.propertyChangedListeners.get(key).remove(onPropertyChanged);
        }
    }

    @Override
    public void updateBackingSaveFile(String versionSuffix) {
        this.currentVersionSuffix = versionSuffix;
        this.saveFileName = this.uncapitalizedClassName + this.currentVersionSuffix + ".ini";
    }

    @Override
    public void load() {
        this.load(true);
    }

    @Override
    public void load(String fileName) {
        this.load(fileName, true);
    }

    @Override
    public void load(String fileName, boolean crashIfMissingKeys) {
        if (!fileName.startsWith(StringUtils.uncapitalize((String)this.classForLoading.getSimpleName()))) {
            throw new RuntimeException("This filename " + fileName + " breaks the contract of the StoredPropertySet API. The filename should be the class name + suffix.");
        }
        fileName = fileName.replace(".ini", "");
        this.updateBackingSaveFile(fileName.substring(StringUtils.uncapitalize((String)this.classForLoading.getSimpleName()).length()));
        this.load(crashIfMissingKeys);
    }

    public void loadUnsafe() {
        this.load(false);
    }

    private void load(boolean crashIfMissingKeys) {
        ExceptionTools.handle(() -> {
            Properties properties = new Properties();
            InputStream streamForLoading = this.accessStreamForLoading();
            if (streamForLoading == null) {
                LogTools.warn((String)"Parameter file {} could not be found. Values will be null.", (Object)this.saveFileName);
            } else {
                LogTools.info((String)"Loading parameters from {}", (Object)this.saveFileName);
                properties.load(streamForLoading);
                for (StoredPropertyKey<?> key : this.keys.keys()) {
                    if (!properties.containsKey(key.getCamelCasedName())) {
                        if (!crashIfMissingKeys && key.hasDefaultValue()) {
                            this.setInternal(key, key.getDefaultValue());
                            continue;
                        }
                        throw new RuntimeException(this.accessUrlForLoading() + " does not contain key: " + key.getCamelCasedName());
                    }
                    String stringValue = (String)properties.get(key.getCamelCasedName());
                    if (stringValue.equals("null")) {
                        LogTools.warn((String)"{} is being loaded as null. Please set it in {}", (Object)key.getCamelCasedName(), (Object)this.saveFileName);
                        continue;
                    }
                    this.setInternal(key, this.deserializeString(key, stringValue));
                }
            }
        }, (ExceptionHandler)DefaultExceptionHandler.PRINT_STACKTRACE);
    }

    @Override
    public void save() {
        ExceptionTools.handle(() -> {
            Properties properties = new Properties(){

                @Override
                public synchronized Enumeration<Object> keys() {
                    TreeSet<Object> tree = new TreeSet<Object>(Comparator.comparingInt(o -> StoredPropertySet.this.indexOfCamelCaseName(o)));
                    tree.addAll(super.keySet());
                    return Collections.enumeration(tree);
                }
            };
            for (StoredPropertyKey<?> key : this.keys.keys()) {
                properties.setProperty(key.getCamelCasedName(), this.serializeValue(this.values[key.getIndex()]));
            }
            Path fileForSaving = this.findFileForSaving();
            LogTools.info((String)"Saving parameters to {}", (Object)fileForSaving.getFileName());
            properties.store(new PrintWriter(fileForSaving.toFile()), LocalDateTime.now().format(DateTimeFormatter.BASIC_ISO_DATE));
            this.convertLineEndingsToUnix(fileForSaving);
        }, (ExceptionHandler)DefaultExceptionHandler.PRINT_STACKTRACE);
    }

    private String serializeValue(Object object) {
        if (object == null) {
            return "null";
        }
        return object.toString();
    }

    private <T> T deserializeString(StoredPropertyKey<T> key, String serializedValue) {
        if (key.getType().equals(Double.class)) {
            return (T)Double.valueOf(serializedValue);
        }
        if (key.getType().equals(Integer.class)) {
            return (T)Integer.valueOf(serializedValue);
        }
        if (key.getType().equals(Boolean.class)) {
            return (T)Boolean.valueOf(serializedValue);
        }
        throw new RuntimeException("Please implement String deserialization for type: " + key.getType());
    }

    private int indexOfCamelCaseName(Object camelCaseName) {
        for (StoredPropertyKey<?> key : this.keys.keys()) {
            if (!key.getCamelCasedName().equals(camelCaseName)) continue;
            return key.getIndex();
        }
        return 0;
    }

    private void convertLineEndingsToUnix(Path fileForSaving) {
        List lines = FileTools.readAllLines((Path)fileForSaving, (ExceptionHandler)DefaultExceptionHandler.PRINT_STACKTRACE);
        PrintWriter printer = FileTools.newPrintWriter((Path)fileForSaving, (WriteOption)WriteOption.TRUNCATE, (ExceptionHandler)DefaultExceptionHandler.PRINT_STACKTRACE);
        lines.forEach(line -> printer.print(line + "\n"));
        printer.close();
    }

    public static void printInitialSaveFileContents(List<StoredPropertyKey<?>> keys) {
        for (StoredPropertyKey<?> parameterKey : keys) {
            System.out.println(parameterKey.getCamelCasedName() + "=");
        }
    }

    private InputStream accessStreamForLoading() {
        return this.classForLoading.getResourceAsStream(this.saveFileName);
    }

    private URL accessUrlForLoading() {
        return this.classForLoading.getResource(this.saveFileName);
    }

    public Path findFileForSaving() {
        return this.findSaveFileDirectory().resolve(this.saveFileName);
    }

    @Override
    public Path findSaveFileDirectory() {
        Path absoluteWorkingDirectory = Paths.get(".", new String[0]).toAbsolutePath().normalize();
        Path reworkedPath = Paths.get("/", new String[0]).toAbsolutePath().normalize();
        boolean directoryFound = false;
        for (Path path : absoluteWorkingDirectory) {
            reworkedPath = reworkedPath.resolve(path);
            if (!path.toString().equals(this.directoryNameToAssumePresent)) continue;
            directoryFound = true;
            break;
        }
        if (!directoryFound && Files.exists(reworkedPath.resolve(this.directoryNameToAssumePresent), new LinkOption[0])) {
            reworkedPath = reworkedPath.resolve(this.directoryNameToAssumePresent);
            directoryFound = true;
        }
        if (!directoryFound) {
            LogTools.warn((String)"Directory {} could not be found to save parameters. Using working directory {}. Reworked path: {}", (Object)this.directoryNameToAssumePresent, (Object)absoluteWorkingDirectory, (Object)reworkedPath);
            return absoluteWorkingDirectory;
        }
        String packageName = this.classForLoading.getPackage().toString();
        LogTools.debug((String)packageName);
        String packagePath = packageName.split(" ")[1].replaceAll("\\.", "/");
        LogTools.debug((String)packagePath);
        Path subPath = Paths.get(this.subsequentPathToResourceFolder, packagePath);
        Path finalPath = reworkedPath.resolve(subPath);
        FileTools.ensureDirectoryExists((Path)finalPath, (ExceptionHandler)DefaultExceptionHandler.PRINT_STACKTRACE);
        return finalPath;
    }

    @Override
    public StoredPropertyKeyListReadOnly getKeyList() {
        return this.keys;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof StoredPropertySet)) {
            return false;
        }
        StoredPropertySet other = (StoredPropertySet)object;
        return Objects.deepEquals(this.values, other.values);
    }

    @Override
    public String getCurrentVersionSuffix() {
        return this.currentVersionSuffix;
    }

    @Override
    public String getUncapitalizedClassName() {
        return this.uncapitalizedClassName;
    }

    @Override
    public Class<?> getClassForLoading() {
        return this.classForLoading;
    }

    @Override
    public String getDirectoryNameToAssumePresent() {
        return this.directoryNameToAssumePresent;
    }

    @Override
    public String getSubsequentPathToResourceFolder() {
        return this.subsequentPathToResourceFolder;
    }
}

