/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.tools.io;

import java.nio.file.Path;
import us.ihmc.tools.io.WorkspacePathTools;

public class HybridDirectory {
    private final Path externalDirectory;
    private final Class<?> classForLoading;
    private final Path workspaceDirectory;
    private final String pathNecessaryForClasspathLoading;

    public HybridDirectory(Path externalDirectory, String directoryNameToAssumePresent, String subsequentPathToResourceFolder, Class<?> classForResourceDirectory) {
        this(externalDirectory, directoryNameToAssumePresent, subsequentPathToResourceFolder, classForResourceDirectory, "");
    }

    public HybridDirectory(Path externalDirectory, String directoryNameToAssumePresent, String subsequentPathToResourceFolder, String absoluteResourceDirectory) {
        this(externalDirectory, directoryNameToAssumePresent, subsequentPathToResourceFolder, null, absoluteResourceDirectory);
    }

    public HybridDirectory(Path externalDirectory, String directoryNameToAssumePresent, String subsequentPathToResourceFolder, Class<?> classForResourceDirectory, String subsequentOrAbsoluteResourcePackagePath) {
        String subsequentExternalPath = subsequentOrAbsoluteResourcePackagePath;
        if (subsequentExternalPath.startsWith("/")) {
            subsequentExternalPath = subsequentExternalPath.replaceFirst("/", "");
        }
        this.externalDirectory = externalDirectory.resolve(subsequentExternalPath).toAbsolutePath().normalize();
        this.classForLoading = classForResourceDirectory;
        String putTogetherResourcePath = "";
        boolean isAbsolute = subsequentOrAbsoluteResourcePackagePath.startsWith("/");
        if (!isAbsolute && classForResourceDirectory != null) {
            putTogetherResourcePath = putTogetherResourcePath + classForResourceDirectory.getPackage().getName().replaceAll("\\.", "/");
            putTogetherResourcePath = putTogetherResourcePath + "/";
            putTogetherResourcePath = putTogetherResourcePath + subsequentOrAbsoluteResourcePackagePath;
            this.pathNecessaryForClasspathLoading = subsequentOrAbsoluteResourcePackagePath;
        } else if (isAbsolute) {
            putTogetherResourcePath = putTogetherResourcePath + subsequentOrAbsoluteResourcePackagePath.replaceFirst("/", "");
            this.pathNecessaryForClasspathLoading = subsequentOrAbsoluteResourcePackagePath;
        } else {
            this.pathNecessaryForClasspathLoading = subsequentOrAbsoluteResourcePackagePath;
        }
        this.workspaceDirectory = WorkspacePathTools.findPathToResource(directoryNameToAssumePresent, subsequentPathToResourceFolder, putTogetherResourcePath);
    }

    public Path getWorkspaceDirectory() {
        return this.workspaceDirectory;
    }

    public Path getExternalDirectory() {
        return this.externalDirectory;
    }

    public Class<?> getClassForLoading() {
        return this.classForLoading;
    }

    public String getPathNecessaryForClasspathLoading() {
        return this.pathNecessaryForClasspathLoading;
    }
}

