/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.tools.io;

import java.io.IOException;
import java.io.InputStream;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.SocketException;
import us.ihmc.tools.io.ResettableByteArrayInputStream;

public class DatagramInputStream
extends InputStream {
    private static final boolean VERBOSE = false;
    public static final int BUFFER_SIZE = 32000;
    private final byte[] bytebuffer = new byte[32000];
    private final ResettableByteArrayInputStream resettableByteArrayInputStream;
    private DatagramSocket datagramSocketToListenOn;
    private final int port;
    private boolean throwOutStalePackets = false;
    private byte expectedIndexByte = 0;

    public DatagramInputStream(int port) throws SocketException {
        this.port = port;
        this.resettableByteArrayInputStream = new ResettableByteArrayInputStream();
        this.datagramSocketToListenOn = new DatagramSocket(port);
        this.datagramSocketToListenOn.setReceiveBufferSize(32000);
        int actualBufferSize = this.datagramSocketToListenOn.getReceiveBufferSize();
    }

    public void setThrowOutStalePackets(boolean throwOutStalePackets) {
        this.throwOutStalePackets = throwOutStalePackets;
    }

    @Override
    public int read() throws IOException {
        this.refreshByteInputStreamIfNecessaryByReadingNewDatagram();
        return this.resettableByteArrayInputStream.read();
    }

    @Override
    public int read(byte[] b) throws IOException {
        this.refreshByteInputStreamIfNecessaryByReadingNewDatagram();
        return this.resettableByteArrayInputStream.read(b);
    }

    @Override
    public int read(byte[] b, int offset, int length) throws IOException {
        this.refreshByteInputStreamIfNecessaryByReadingNewDatagram();
        return this.resettableByteArrayInputStream.read(b, offset, length);
    }

    private void refreshByteInputStreamIfNecessaryByReadingNewDatagram() throws IOException {
        while (this.resettableByteArrayInputStream.available() <= 0) {
            if (this.throwOutStalePackets) {
                this.throwOutStalePackets();
            }
            DatagramPacket datagramPacket = new DatagramPacket(this.bytebuffer, this.bytebuffer.length);
            this.datagramSocketToListenOn.receive(datagramPacket);
            byte[] dataBytes = datagramPacket.getData();
            int length = datagramPacket.getLength();
            byte indexByte = dataBytes[length - 1];
            if (indexByte != this.expectedIndexByte) {
                System.out.println("DatagramInputStream: indexByte != expectedIndexByte! indexByte = " + indexByte + ", expectedIndexByte = " + this.expectedIndexByte);
                this.expectedIndexByte = indexByte;
            }
            this.expectedIndexByte = (byte)(this.expectedIndexByte + 1);
            this.resettableByteArrayInputStream.setBuffer(dataBytes, length - 1);
        }
    }

    private void throwOutStalePackets() throws SocketException {
        if (this.datagramSocketToListenOn != null) {
            this.datagramSocketToListenOn.close();
        }
        this.datagramSocketToListenOn = new DatagramSocket(this.port);
    }

    @Override
    public void close() {
        if (this.datagramSocketToListenOn != null) {
            this.datagramSocketToListenOn.close();
        }
    }
}

