/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.tools.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class GUIMessagePanel
extends JPanel {
    private static final long serialVersionUID = 627707062057513407L;
    private final String name;
    private final JTextArea textArea;
    private final JScrollPane jScrollPane;
    private boolean quiet = false;
    private static final int WIDTH = 75;

    public GUIMessagePanel(String name) {
        this.name = name;
        this.setLayout(new BorderLayout());
        this.textArea = new JTextArea();
        this.textArea.setLineWrap(true);
        this.textArea.setSelectedTextColor(Color.WHITE);
        this.jScrollPane = new JScrollPane();
        this.jScrollPane.getViewport().add(this.textArea);
        this.textArea.setEditable(false);
        this.textArea.setFont(new Font("Monospaced", 0, 12));
        this.jScrollPane.setVerticalScrollBarPolicy(22);
        this.add((Component)this.jScrollPane, "Center");
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void clear() {
        this.textArea.setText(" ");
    }

    public void setQuiet(boolean quiet) {
        this.quiet = quiet;
    }

    public String getText() {
        return this.textArea.getText();
    }

    public void appendMessage(String message) {
        if (this.quiet) {
            return;
        }
        if (message.length() > 99) {
            message = message + "\n";
        }
        this.textArea.insert(message + "\n", 0);
    }

    public void appendMessage(String message, Color color) {
        if (this.quiet) {
            return;
        }
        this.textArea.setSelectionColor(color);
        if (message.length() > 99) {
            message = message + "\n";
        }
        this.textArea.insert(message + "\n", 0);
    }
}

