/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.tools.thread;

import org.junit.jupiter.api.Test;
import us.ihmc.log.LogTools;
import us.ihmc.robotics.TestTools;
import us.ihmc.tools.UnitConversions;
import us.ihmc.tools.thread.MissingThreadTools;
import us.ihmc.tools.thread.Throttler;
import us.ihmc.tools.time.FrequencyCalculator;

public class ThrottlerAndFrequencyCounterTest {
    private static void testFrequencyCounter(double targetFrequency, double epsilon) {
        LogTools.info((String)("testFrequencyCounter targetFrequency=" + targetFrequency + " epsilon=" + epsilon));
        long start = System.currentTimeMillis();
        FrequencyCalculator frequencyCalculator = new FrequencyCalculator(true);
        while (System.currentTimeMillis() - start < 5000L) {
            frequencyCalculator.ping();
            double sleepTimeSeconds = UnitConversions.hertzToSeconds((double)targetFrequency);
            MissingThreadTools.sleep((double)sleepTimeSeconds);
        }
        frequencyCalculator.destroy();
        TestTools.assertEpsilonEquals((double)targetFrequency, (double)frequencyCalculator.getFrequency(), (double)epsilon, (String)"Frequency not correct");
    }

    private static void testFrequencyCounterDecaying(double targetFrequency, double decayTimeSeconds, double epsilon) {
        LogTools.info((String)("testFrequencyCounter (decaying) targetFrequency=" + targetFrequency + " decayTimeSeconds=" + decayTimeSeconds + " epsilon=" + epsilon));
        long start = System.currentTimeMillis();
        FrequencyCalculator frequencyCalculator = new FrequencyCalculator(true);
        while (System.currentTimeMillis() - start < 5000L) {
            frequencyCalculator.ping();
            double sleepTimeSeconds = UnitConversions.hertzToSeconds((double)targetFrequency);
            MissingThreadTools.sleep((double)sleepTimeSeconds);
        }
        frequencyCalculator.destroy();
        MissingThreadTools.sleep((double)decayTimeSeconds);
        double targetDecayFrequency = frequencyCalculator.getFrequency() / Math.exp(decayTimeSeconds);
        TestTools.assertEpsilonEquals((double)frequencyCalculator.getFrequencyDecaying(), (double)targetDecayFrequency, (double)epsilon);
    }

    private static void testThrottlerAndFrequencyCounter(double targetFrequency, double epsilon) {
        LogTools.info((String)("testThrottlerAndFrequencyCounter (using us.ihmc.tools.thread.Throttler) targetFrequency=" + targetFrequency + " epsilon=" + epsilon));
        Throttler throttler = new Throttler();
        throttler.setFrequency(targetFrequency);
        throttler.waitAndRun();
        long start = System.currentTimeMillis();
        FrequencyCalculator frequencyCalculator = new FrequencyCalculator(true);
        while (System.currentTimeMillis() - start < 5000L) {
            frequencyCalculator.ping();
            throttler.waitAndRun();
        }
        frequencyCalculator.destroy();
        TestTools.assertEpsilonEquals((double)targetFrequency, (double)frequencyCalculator.getFrequency(), (double)epsilon, (String)"Frequency not correct");
    }

    @Test
    public void testFrequencyCounter100Hz() {
        ThrottlerAndFrequencyCounterTest.testFrequencyCounter(100.0, 2.0);
    }

    @Test
    public void testThrottlerAndFrequencyCounter100Hz() {
        ThrottlerAndFrequencyCounterTest.testThrottlerAndFrequencyCounter(100.0, 2.0);
    }

    @Test
    public void testFrequencyCounter10Hz() {
        ThrottlerAndFrequencyCounterTest.testFrequencyCounter(10.0, 0.2);
    }

    @Test
    public void testThrottlerAndFrequencyCounter10Hz() {
        ThrottlerAndFrequencyCounterTest.testThrottlerAndFrequencyCounter(10.0, 0.2);
    }

    @Test
    public void testFrequencyCounter1Hz() {
        ThrottlerAndFrequencyCounterTest.testFrequencyCounter(1.0, 0.002);
    }

    @Test
    public void testThrottlerAndFrequencyCounter1Hz() {
        ThrottlerAndFrequencyCounterTest.testThrottlerAndFrequencyCounter(1.0, 0.002);
    }

    @Test
    public void testFrequencyCounter0_5Hz() {
        ThrottlerAndFrequencyCounterTest.testFrequencyCounter(0.5, 0.001);
    }

    @Test
    public void testThrottlerAndFrequencyCounter0_5Hz() {
        ThrottlerAndFrequencyCounterTest.testThrottlerAndFrequencyCounter(0.5, 0.001);
    }

    @Test
    public void testThrottlerAndFrequencyCounter100HzDecaying() {
        ThrottlerAndFrequencyCounterTest.testFrequencyCounterDecaying(100.0, 5.0, 2.0);
    }
}

