/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.tools;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.io.StringWriter;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Random;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.robotics.Assert;
import us.ihmc.tools.ArrayTools;

public class ArrayToolsTest {
    @Test
    public void testParseDoubleArrayFromMATLABString() {
        try {
            double[] expectedArray = this.generateDoubleArray();
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            printWriter.print(Arrays.toString(expectedArray));
            String matlabString = stringWriter.toString();
            double[] parsedArray = ArrayTools.parseDoubleArrayFromMATLAB((String)matlabString);
            for (int i = 0; i < expectedArray.length; ++i) {
                Assert.assertEquals((double)expectedArray[i], (double)parsedArray[i], (double)0.0);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            Assert.fail();
        }
    }

    @Test
    public void testParseDoubleArrayFromMATLABBufferedReader() {
        try {
            double[] expectedArray = this.generateDoubleArray();
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            printWriter.print(Arrays.toString(expectedArray));
            String matlabString = stringWriter.toString();
            BufferedReader reader = new BufferedReader(new StringReader(matlabString));
            double[] parsedArray = ArrayTools.parseDoubleArrayFromMATLAB((BufferedReader)reader);
            for (int i = 0; i < expectedArray.length; ++i) {
                Assert.assertEquals((double)expectedArray[i], (double)parsedArray[i], (double)0.0);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            Assert.fail();
        }
    }

    @Test
    public void testParseDoubleArrayFromDataInputStream() {
        try {
            double[] expectedArray = this.generateDoubleArray();
            ByteArrayOutputStream byteOutStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteOutStream);
            dataOutputStream.writeInt(expectedArray.length);
            for (double expected : expectedArray) {
                dataOutputStream.writeDouble(expected);
            }
            DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(byteOutStream.toByteArray()));
            double[] parsedArray = ArrayTools.parseDoubleArray((DataInputStream)dataInputStream);
            for (int i = 0; i < expectedArray.length; ++i) {
                Assert.assertEquals((double)expectedArray[i], (double)parsedArray[i], (double)0.0);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            Assert.fail();
        }
    }

    @Test
    public void testParseIntegerArrayFromString() {
        try {
            int[] expectedArray = this.generateIntegerArray();
            String sourceString = Arrays.toString(expectedArray);
            int[] parsedArray = ArrayTools.parseIntegerArray((String)sourceString);
            for (int i = 0; i < expectedArray.length; ++i) {
                Assert.assertEquals((long)expectedArray[i], (long)parsedArray[i]);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            Assert.fail();
        }
    }

    @Test
    public void testParseIntegerArrayFromBufferedReader() {
        try {
            int[] expectedArray = this.generateIntegerArray();
            BufferedReader reader = new BufferedReader(new StringReader(Arrays.toString(expectedArray)));
            int[] parsedArray = ArrayTools.parseIntegerArray((BufferedReader)reader);
            for (int i = 0; i < expectedArray.length; ++i) {
                Assert.assertEquals((long)expectedArray[i], (long)parsedArray[i]);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            Assert.fail();
        }
    }

    @Test
    public void testParseIntegerArrayFromDataInputStream() {
        try {
            int[] expectedArray = this.generateIntegerArray();
            ByteArrayOutputStream byteOutStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteOutStream);
            dataOutputStream.writeInt(expectedArray.length);
            for (int expected : expectedArray) {
                dataOutputStream.writeInt(expected);
            }
            dataOutputStream.flush();
            DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(byteOutStream.toByteArray()));
            int[] parsedArray = ArrayTools.parseIntArray((DataInputStream)dataInputStream);
            for (int i = 0; i < expectedArray.length; ++i) {
                Assert.assertEquals((long)expectedArray[i], (long)parsedArray[i]);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            Assert.fail();
        }
    }

    @Test
    public void testDeltaEquals() {
        double[] array1 = this.generateDoubleArray();
        double[] array2 = this.generateDoubleArray(array1.length);
        Double[] arrayOfDifferences = new Double[array1.length];
        for (int i = 0; i < array1.length; ++i) {
            arrayOfDifferences[i] = Math.abs(array1[i] - array2[i]);
        }
        double largestDifference = Collections.max(Arrays.asList(arrayOfDifferences));
        System.out.println(largestDifference);
        Assert.assertTrue((boolean)ArrayTools.deltaEquals((double[])array1, (double[])array2, (double)(largestDifference + 1.0)));
        Assert.assertFalse((boolean)ArrayTools.deltaEquals((double[])array1, (double[])array2, (double)(largestDifference - 1.0)));
    }

    @Test
    public void testDeltaEqualsWithNull() {
        double[] array1 = null;
        double[] array2 = null;
        double[] array3 = this.generateDoubleArray();
        double dummyDelta = 0.1;
        Assert.assertFalse((boolean)ArrayTools.deltaEquals(array1, array2, (double)dummyDelta));
        Assert.assertFalse((boolean)ArrayTools.deltaEquals(array1, (double[])array3, (double)dummyDelta));
    }

    @Test
    public void testParseDoubleArrayFromString() throws IOException {
        Random random = new Random();
        int arraySize = random.nextInt(100) + 1;
        DecimalFormat formatter = new DecimalFormat("0.000");
        for (int j = 0; j < 10000; ++j) {
            double[] originalArrayOfRandomNumbers = new double[arraySize];
            StringBuilder stringBuilder = this.generateParseableArrayString(random, arraySize, formatter, originalArrayOfRandomNumbers);
            double[] parsedArray = null;
            parsedArray = ArrayTools.parseDoubleArray((String)stringBuilder.toString());
            for (int i = 0; i < arraySize; ++i) {
                Assert.assertEquals((double)originalArrayOfRandomNumbers[i], (double)parsedArray[i], (double)0.0);
            }
        }
    }

    @Test
    public void testParseDoubleArrayFromBufferedReader() {
        Random random = new Random();
        int arraySize = random.nextInt(100) + 1;
        DecimalFormat formatter = new DecimalFormat("0.000");
        for (int j = 0; j < 100; ++j) {
            double[] originalArrayOfRandomNumbers = new double[arraySize];
            StringBuilder stringBuilder = this.generateParseableArrayString(random, arraySize, formatter, originalArrayOfRandomNumbers);
            double[] parsedArray = null;
            BufferedReader mockBufferedReader = new BufferedReader(new StringReader(stringBuilder.toString()));
            try {
                parsedArray = ArrayTools.parseDoubleArray((BufferedReader)mockBufferedReader);
            }
            catch (IOException e) {
                e.printStackTrace();
                Assert.fail();
            }
            for (int i = 0; i < arraySize; ++i) {
                Assert.assertEquals((double)originalArrayOfRandomNumbers[i], (double)parsedArray[i], (double)0.0);
            }
        }
    }

    @Test
    public void testParseDoubleArrayFromBufferedReaderWithIOException() throws IOException {
        Assertions.assertThrows(IOException.class, () -> {
            BufferedReader mockBufferedReader = new BufferedReader(new Reader(){

                @Override
                public int read(char[] cbuf, int off, int len) throws IOException {
                    throw new IOException();
                }

                @Override
                public void close() throws IOException {
                }
            });
            ArrayTools.parseDoubleArray((BufferedReader)mockBufferedReader);
        });
    }

    private StringBuilder generateParseableArrayString(Random random, int arraySize, NumberFormat formatter, double[] originalArrayOfRandomNumbers) {
        for (int i = 0; i < arraySize; ++i) {
            double nextNumber;
            originalArrayOfRandomNumbers[i] = nextNumber = Double.parseDouble(formatter.format(random.nextGaussian()));
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < arraySize; ++i) {
            stringBuilder.append(originalArrayOfRandomNumbers[i]);
            if (i == arraySize - 1) continue;
            stringBuilder.append(",");
        }
        return stringBuilder;
    }

    private double[] generateDoubleArray() {
        Random random = new Random();
        int arraySize = random.nextInt(500) + 1;
        double[] array = new double[arraySize];
        DecimalFormat formatter = new DecimalFormat("0.000");
        for (int i = 0; i < arraySize; ++i) {
            array[i] = Double.parseDouble(formatter.format(random.nextGaussian()));
        }
        return array;
    }

    private double[] generateDoubleArray(int size) {
        Random random = new Random();
        int arraySize = size;
        double[] array = new double[arraySize];
        DecimalFormat formatter = new DecimalFormat("0.000");
        for (int i = 0; i < arraySize; ++i) {
            array[i] = Double.parseDouble(formatter.format(random.nextGaussian()));
        }
        return array;
    }

    private int[] generateIntegerArray() {
        Random random = new Random();
        int arraySize = random.nextInt(500) + 1;
        int[] array = new int[arraySize];
        for (int i = 0; i < arraySize; ++i) {
            array[i] = random.nextInt();
        }
        return array;
    }

    @Test
    public void testGetRearrangedArrayList() {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        arrayList.add(1);
        arrayList.add(2);
        arrayList.add(3);
        arrayList.add(4);
        ArrayList rearrangedList = ArrayTools.getRearrangedArrayListCopy(arrayList, (int)1);
        ArrayList<Integer> expectedList = new ArrayList<Integer>();
        expectedList.add(2);
        expectedList.add(3);
        expectedList.add(4);
        expectedList.add(1);
        Assert.assertEquals(expectedList, (Object)rearrangedList);
        Assert.assertEquals(arrayList, (Object)ArrayTools.getRearrangedArrayListCopy(arrayList, (int)0));
    }

    @Test
    public void testGetMaximumAbsoluteChangeBetweenTicks() {
        double[] array = new double[]{1.7};
        double maxChange = ArrayTools.getMaximumAbsoluteChangeBetweenTicks((double[])array);
        Assert.assertEquals((double)0.0, (double)maxChange, (double)1.0E-7);
        array = new double[]{1.0, 2.0, 3.0};
        maxChange = ArrayTools.getMaximumAbsoluteChangeBetweenTicks((double[])array);
        Assert.assertEquals((double)1.0, (double)maxChange, (double)1.0E-7);
        array = new double[]{3.0, 2.0, 1.0};
        maxChange = ArrayTools.getMaximumAbsoluteChangeBetweenTicks((double[])array);
        Assert.assertEquals((double)1.0, (double)maxChange, (double)1.0E-7);
        array = new double[]{1.0, 1.01, 1.03, 1.04};
        maxChange = ArrayTools.getMaximumAbsoluteChangeBetweenTicks((double[])array);
        Assert.assertEquals((double)0.02, (double)maxChange, (double)1.0E-7);
        array = new double[]{1.0, 1.01, 1.02, 1.0};
        maxChange = ArrayTools.getMaximumAbsoluteChangeBetweenTicks((double[])array);
        Assert.assertEquals((double)0.02, (double)maxChange, (double)1.0E-7);
    }

    @Test
    public void testIsContinuous() {
        double[] array = new double[]{1.7};
        Assert.assertTrue((boolean)ArrayTools.isContinuous((double[])array, (double)1.0E-7));
        array = new double[]{1.0, 2.0, 3.0};
        Assert.assertTrue((boolean)ArrayTools.isContinuous((double[])array, (double)1.0000001));
        Assert.assertFalse((boolean)ArrayTools.isContinuous((double[])array, (double)0.9999999));
        array = new double[]{3.0, 2.0, 1.0};
        Assert.assertTrue((boolean)ArrayTools.isContinuous((double[])array, (double)1.0000001));
        Assert.assertFalse((boolean)ArrayTools.isContinuous((double[])array, (double)0.9999999));
        array = new double[]{1.0, 2.0, 3.0, 2.0, 1.0};
        Assert.assertTrue((boolean)ArrayTools.isContinuous((double[])array, (double)1.0000001));
        Assert.assertFalse((boolean)ArrayTools.isContinuous((double[])array, (double)0.9999999));
        array = new double[]{1.0, 1.01, 1.03, 1.04};
        Assert.assertTrue((boolean)ArrayTools.isContinuous((double[])array, (double)0.0200001));
        Assert.assertFalse((boolean)ArrayTools.isContinuous((double[])array, (double)0.0199999));
    }

    @Test
    public void testReverse() {
        Serializable[] expected;
        Object[] actual;
        int arraySize;
        int i;
        Random random = new Random(345346L);
        for (i = 0; i < 100; ++i) {
            int j;
            arraySize = random.nextInt(100);
            Object[] arrayOriginal = new Integer[arraySize];
            Object[] arrayReversed = new Integer[arraySize];
            Object[] arrayReReversed = new Integer[arraySize];
            for (j = 0; j < arraySize; ++j) {
                arrayOriginal[j] = new Integer(j);
            }
            System.arraycopy(arrayOriginal, 0, arrayReversed, 0, arraySize);
            ArrayTools.reverse((Object[])arrayReversed);
            for (j = 0; j < arraySize; ++j) {
                Assert.assertEquals((long)(arraySize - j - 1), (long)((Integer)arrayReversed[j]).intValue());
            }
            System.arraycopy(arrayReversed, 0, arrayReReversed, 0, arraySize);
            ArrayTools.reverse((Object[])arrayReReversed);
            Assertions.assertArrayEquals((Object[])arrayOriginal, (Object[])arrayReReversed);
        }
        for (i = 0; i < 100; ++i) {
            int j;
            arraySize = random.nextInt(100);
            actual = new float[arraySize];
            expected = new Float[arraySize];
            for (j = 0; j < arraySize; ++j) {
                float nextFloat;
                actual[j] = nextFloat = random.nextFloat();
                expected[j] = new Float(nextFloat);
            }
            ArrayTools.reverse((float[])actual);
            ArrayTools.reverse((Object[])expected);
            for (j = 0; j < arraySize; ++j) {
                Assert.assertEquals((Object)Float.valueOf(((Float)expected[j]).floatValue()), (Object)Float.valueOf(actual[j]));
            }
        }
        for (i = 0; i < 100; ++i) {
            int j;
            arraySize = random.nextInt(100);
            actual = new double[arraySize];
            expected = new Double[arraySize];
            for (j = 0; j < arraySize; ++j) {
                double nextDouble = random.nextDouble();
                actual[j] = (float)nextDouble;
                expected[j] = new Double(nextDouble);
            }
            ArrayTools.reverse((double[])actual);
            ArrayTools.reverse((Object[])expected);
            for (j = 0; j < arraySize; ++j) {
                Assert.assertEquals((Object)((Double)expected[j]), (Object)actual[j]);
            }
        }
        for (i = 0; i < 100; ++i) {
            int j;
            arraySize = random.nextInt(100);
            actual = new byte[arraySize];
            expected = new Byte[arraySize];
            for (j = 0; j < arraySize; ++j) {
                byte nextByte = (byte)random.nextInt();
                actual[j] = nextByte;
                expected[j] = new Byte(nextByte);
            }
            ArrayTools.reverse((byte[])actual);
            ArrayTools.reverse((Object[])expected);
            for (j = 0; j < arraySize; ++j) {
                Assert.assertEquals((long)((Byte)expected[j]).byteValue(), (long)((long)actual[j]));
            }
        }
        for (i = 0; i < 100; ++i) {
            int j;
            arraySize = random.nextInt(100);
            actual = new short[arraySize];
            expected = new Short[arraySize];
            for (j = 0; j < arraySize; ++j) {
                short nextShort = (short)random.nextInt();
                actual[j] = nextShort;
                expected[j] = new Short(nextShort);
            }
            ArrayTools.reverse((short[])actual);
            ArrayTools.reverse((Object[])expected);
            for (j = 0; j < arraySize; ++j) {
                Assert.assertEquals((long)((Short)expected[j]).shortValue(), (long)((long)actual[j]));
            }
        }
        for (i = 0; i < 100; ++i) {
            int j;
            arraySize = random.nextInt(100);
            actual = new int[arraySize];
            expected = new Integer[arraySize];
            for (j = 0; j < arraySize; ++j) {
                int nextInteger = random.nextInt();
                actual[j] = nextInteger;
                expected[j] = new Integer(nextInteger);
            }
            ArrayTools.reverse((int[])actual);
            ArrayTools.reverse((Object[])expected);
            for (j = 0; j < arraySize; ++j) {
                Assert.assertEquals((long)((Integer)expected[j]).intValue(), (long)((long)actual[j]));
            }
        }
        for (i = 0; i < 100; ++i) {
            int j;
            arraySize = random.nextInt(100);
            actual = new long[arraySize];
            expected = new Long[arraySize];
            for (j = 0; j < arraySize; ++j) {
                long nextLong = random.nextLong();
                actual[j] = nextLong;
                expected[j] = new Long(nextLong);
            }
            ArrayTools.reverse((long[])actual);
            ArrayTools.reverse((Object[])expected);
            for (j = 0; j < arraySize; ++j) {
                Assert.assertEquals((long)((Long)expected[j]), (long)actual[j]);
            }
        }
        for (i = 0; i < 100; ++i) {
            int j;
            arraySize = random.nextInt(100);
            actual = new boolean[arraySize];
            expected = new Boolean[arraySize];
            for (j = 0; j < arraySize; ++j) {
                boolean nextBoolean = random.nextBoolean();
                actual[j] = (float)nextBoolean;
                expected[j] = new Boolean(nextBoolean);
            }
            ArrayTools.reverse((boolean[])actual);
            ArrayTools.reverse((Object[])expected);
            for (j = 0; j < arraySize; ++j) {
                Assert.assertEquals((Object)((Boolean)expected[j]), (Object)((boolean)actual[j]));
            }
        }
    }
}

