/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.tools.processManagement;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.UUID;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.SystemUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import us.ihmc.commons.exception.DefaultExceptionHandler;
import us.ihmc.commons.exception.ExceptionHandler;
import us.ihmc.commons.nio.FileTools;
import us.ihmc.commons.thread.ThreadTools;
import us.ihmc.log.LogTools;
import us.ihmc.tools.processManagement.ExitListener;
import us.ihmc.tools.processManagement.ForkedShellProcessSpawner;
import us.ihmc.tools.processManagement.JavaProcessSpawner;
import us.ihmc.tools.processManagement.ProcessSpawner;
import us.ihmc.tools.processManagement.ShellScriptProcessSpawner;

public class ProcessSpawnerTest {
    private static final Path testFilePath = Paths.get(System.getProperty("java.io.tmpdir"), "ProcessSpawnerTest.tmp");

    private void validateFileContents(String expectedContent) throws Exception {
        byte[] binaryData = new byte[128];
        DataInputStream dis = FileTools.newFileDataInputStream((Path)testFilePath);
        dis.readFully(binaryData, 0, dis.available());
        dis.close();
        String content = new String(binaryData).trim();
        Assertions.assertEquals((Object)expectedContent, (Object)content);
    }

    @Disabled
    @Test
    public void testForkedShellProcessSpawner() throws Exception {
        String randomString = Long.toString(System.nanoTime());
        String[] arguments = new String[]{randomString};
        LogTools.info((Object)testFilePath);
        ForkedShellProcessSpawner sps = new ForkedShellProcessSpawner(true);
        sps.spawn("echo", arguments, testFilePath.toFile(), testFilePath.toFile(), null);
        while (sps.hasRunningProcesses()) {
            ThreadTools.sleep((long)500L);
        }
        sps.shutdown();
        this.validateFileContents(randomString);
    }

    @Disabled
    @Test
    public void testShelloutProcessSpawnerOnShellScript() throws Exception {
        if (SystemUtils.IS_OS_WINDOWS) {
            LogTools.error((String)"Not compatible with Windows");
            Assertions.fail((String)"Not compatible with Windows");
            return;
        }
        Path testScriptPath = ProcessSpawnerTest.extractScriptFileToKnownDirectory();
        String randomString = Long.toString(System.nanoTime());
        String[] arguments = new String[]{randomString};
        ShellScriptProcessSpawner sps = new ShellScriptProcessSpawner(true);
        sps.spawn(testScriptPath.toAbsolutePath().toString(), arguments, testFilePath.toFile(), testFilePath.toFile(), null);
        while (sps.hasRunningProcesses()) {
            ThreadTools.sleep((long)500L);
        }
        sps.shutdown();
        this.validateFileContents(randomString);
    }

    @Test
    public void testJavaProcessSpawnerWithClasspathAsArgument() throws Exception {
        String randomString = UUID.randomUUID().toString();
        String[] arguments = new String[]{randomString};
        JavaProcessSpawner spawner = new JavaProcessSpawner(true, false);
        spawner.spawn(this.getClass(), arguments);
        while (spawner.hasRunningProcesses()) {
            ThreadTools.sleep((long)500L);
        }
        this.validateFileContents(randomString);
    }

    @Test
    public void testJavaProcessSpawnerWithClasspathAsEnvironmentVariable() throws Exception {
        String randomString = UUID.randomUUID().toString();
        String[] arguments = new String[]{randomString};
        JavaProcessSpawner spawner = new JavaProcessSpawner(true, true);
        spawner.spawn(this.getClass(), arguments);
        while (spawner.hasRunningProcesses()) {
            ThreadTools.sleep((long)500L);
        }
        this.validateFileContents(randomString);
    }

    @Disabled
    @Test
    public void testExitListeners() throws Exception {
        if (SystemUtils.IS_OS_WINDOWS) {
            LogTools.error((String)"Not compatible with Windows");
            return;
        }
        final ArrayList exitValues = new ArrayList(2);
        exitValues.clear();
        String[] arguments = new String[]{"2"};
        ForkedShellProcessSpawner sps = new ForkedShellProcessSpawner(true);
        sps.spawn("sleep", arguments, null, null, new ExitListener(){

            public void exited(int statusValue) {
                exitValues.add(statusValue);
            }
        });
        Process p = sps.spawn("sleep", arguments);
        sps.setProcessExitListener(p, new ExitListener(){

            public void exited(int statusValue) {
                exitValues.add(statusValue);
            }
        });
        while (sps.hasRunningProcesses()) {
            ThreadTools.sleep((long)500L);
        }
        Assertions.assertEquals((int)exitValues.size(), (int)2);
        Assertions.assertEquals((int)((Integer)exitValues.get(0)), (int)0);
        Assertions.assertEquals((int)((Integer)exitValues.get(1)), (int)0);
    }

    private static Path extractScriptFileToKnownDirectory() {
        Path testScriptPath = Paths.get(System.getProperty("user.home"), ".ihmc", "testScript.sh");
        try {
            Files.createDirectories(testScriptPath.getParent(), new FileAttribute[0]);
            Files.write(testScriptPath, IOUtils.toByteArray((InputStream)ProcessSpawner.class.getResourceAsStream("testScript.sh")), new OpenOption[0]);
            Runtime.getRuntime().exec("chmod u+x " + testScriptPath.toAbsolutePath().toString());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return testScriptPath;
    }

    public static void main(String[] args) throws Exception {
        DataOutputStream dos = FileTools.newFileDataOutputStream((Path)testFilePath, (ExceptionHandler)DefaultExceptionHandler.PRINT_STACKTRACE);
        dos.writeBytes(args[0]);
        dos.flush();
        dos.close();
    }
}

