/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.tools.processManagement;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import org.apache.commons.lang3.mutable.MutableInt;
import org.apache.commons.lang3.mutable.MutableObject;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.commons.thread.ThreadTools;
import us.ihmc.log.LogTools;
import us.ihmc.tools.processManagement.JavaProcessSpawner;
import us.ihmc.tools.thread.PausablePeriodicThread;

public class JavaProcessSpawnerTest {
    @Test
    public void testJavaProcessSpawnerRunsWithoutErrors() {
        JavaProcessSpawner spawner = new JavaProcessSpawner(true);
        Process process = spawner.spawn(JavaProcessSpawnerTest.class);
        ThreadTools.sleepSeconds((double)2.0);
        Assertions.assertDoesNotThrow(() -> spawner.kill(process));
    }

    @Test
    public void testJavaProcessSpawnerPrintsToStream() {
        JavaProcessSpawner spawner = new JavaProcessSpawner(true);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        String utf8 = StandardCharsets.UTF_8.name();
        Process process = spawner.spawn(JavaProcessSpawnerTest.class, null, null, new PrintStream(outputStream), null);
        ThreadTools.sleepSeconds((double)2.0);
        MutableObject data = new MutableObject();
        Assertions.assertDoesNotThrow(() -> data.setValue((Object)outputStream.toString(utf8)));
        LogTools.info((String)("Output: " + (String)data.getValue()));
        Assertions.assertTrue((((String)data.getValue()).length() > 0 ? 1 : 0) != 0);
        Assertions.assertDoesNotThrow(() -> spawner.kill(process));
    }

    public static void main(String[] args) {
        MutableInt mutableInt = new MutableInt();
        new PausablePeriodicThread(JavaProcessSpawnerTest.class.getSimpleName(), 0.25, () -> LogTools.info((Object)mutableInt.getAndIncrement())).start();
    }
}

