/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.tools.calibration;

import java.io.File;
import java.util.Random;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import us.ihmc.robotics.Assert;
import us.ihmc.tools.calibration.CalibrationProperties;

public class CalibrationPropertiesTest {
    private String fileName = "testCalFile";
    private File currentPropertiesFile;
    private CalibrationProperties calibrationProperties;

    @BeforeEach
    public void setUp() {
        this.currentPropertiesFile = new File(this.fileName);
        this.calibrationProperties = new CalibrationProperties(".", this.fileName);
    }

    @AfterEach
    public void tearDown() {
        this.currentPropertiesFile.delete();
    }

    @Test
    public void testSetIntegerProperty() {
        Random random = new Random(1984L);
        int ITERATIONS = 100;
        String key = "abcd";
        for (int i = 0; i < ITERATIONS; ++i) {
            int value = random.nextInt();
            this.calibrationProperties.setProperty(key, value);
            Assert.assertEquals((long)value, (long)this.calibrationProperties.getIntegerProperty(key));
        }
        Assert.assertEquals((long)0L, (long)this.calibrationProperties.getIntegerProperty("notAKey"));
    }

    @Test
    public void testSetDoubleProperty() {
        Random random = new Random(1984L);
        int ITERATIONS = 100;
        double EPSILON = 1.0E-6;
        String key = "abcd";
        for (int i = 0; i < 100; ++i) {
            double value = random.nextDouble();
            this.calibrationProperties.setProperty(key, value);
            Assert.assertEquals((double)value, (double)this.calibrationProperties.getDoubleProperty(key), (double)1.0E-6);
        }
        Assert.assertEquals((double)0.0, (double)this.calibrationProperties.getDoubleProperty("notAKey"), (double)1.0E-6);
    }

    @Test
    public void testSaveAndLoad() {
        String key = "abcd";
        int value = 23;
        this.calibrationProperties.setProperty(key, value);
        this.calibrationProperties.save();
        CalibrationProperties calibrationProperties2 = new CalibrationProperties(".", this.fileName);
        Assert.assertEquals((long)value, (long)calibrationProperties2.getIntegerProperty(key));
    }

    @Test
    public void testArithmetic1() {
        String key = "abcd";
        int value1 = 23;
        int value2 = 56;
        String value = value1 + "+" + value2;
        this.calibrationProperties.setProperty(key, value);
        Assert.assertEquals((long)(value1 + value2), (long)this.calibrationProperties.getIntegerProperty(key));
    }

    @Test
    public void testArithmetic2() {
        String key = "abcd";
        String value = "-23 + 0-4 +8 +-5";
        this.calibrationProperties.setProperty(key, value);
        Assert.assertEquals((long)-24L, (long)this.calibrationProperties.getIntegerProperty(key));
    }
}

