/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.javadecklink;

import com.martiansoftware.jsap.FlaggedOption;
import com.martiansoftware.jsap.JSAP;
import com.martiansoftware.jsap.JSAPException;
import com.martiansoftware.jsap.JSAPResult;
import com.martiansoftware.jsap.Parameter;
import com.martiansoftware.jsap.SimpleJSAP;
import com.martiansoftware.jsap.StringParser;
import com.martiansoftware.jsap.UnflaggedOption;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import us.ihmc.javadecklink.Capture;
import us.ihmc.javadecklink.CaptureHandler;

public class Stream {
    private final Capture capture;

    public Stream(int card, String videoURL, Map<String, String> options) throws IOException {
        System.out.println("Streaming Blackmagic card " + card + " to " + videoURL);
        CaptureHandlerImpl captureHandlerImpl = new CaptureHandlerImpl();
        this.capture = new Capture(captureHandlerImpl, Capture.CodecID.AV_CODEC_ID_H264);
        for (Map.Entry<String, String> entry : options.entrySet()) {
            this.capture.setOption(entry.getKey(), entry.getValue());
        }
        this.capture.setRecordAudio(true);
        this.capture.setOption("g", "120");
        this.capture.setFormat("flv");
        this.capture.startCapture(videoURL, card);
    }

    public void stop() throws IOException {
        this.capture.stopCapture();
    }

    public static void main(String[] args) throws IOException, InterruptedException, JSAPException {
        SimpleJSAP jsap = new SimpleJSAP("Stream", "Stream Decklink capture card to streaming services", new Parameter[]{new FlaggedOption("preset", (StringParser)JSAP.STRING_PARSER, "veryfast", false, '\u0000', "preset", "H264 preset (ultrafast,superfast, veryfast, faster, fast, medium, slow, slower, veryslow)"), new FlaggedOption("profile", (StringParser)JSAP.STRING_PARSER, "high", false, '\u0000', "profile", "H264 profile (baseline, main, high, high10, high422, high444)"), new FlaggedOption("crf", (StringParser)JSAP.INTEGER_PARSER, "26", false, '\u0000', "crf", "Constant rate factor. 0-51. 26 default, useful range 18-28"), new FlaggedOption("card", (StringParser)JSAP.INTEGER_PARSER, JSAP.NO_DEFAULT, true, 'c', "card", "Capture card to use"), new UnflaggedOption("videoURL", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, true, false, "URL to stream the video to")});
        JSAPResult config = jsap.parse(args);
        if (jsap.messagePrinted()) {
            System.out.println(jsap.getUsage());
            System.out.println(jsap.getHelp());
            System.exit(-1);
        }
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("preset", config.getString("preset"));
        options.put("profile", config.getString("profile"));
        options.put("crf", String.valueOf(config.getInt("crf")));
        Stream stream = new Stream(config.getInt("card"), config.getString("videoURL"), options);
        Runtime.getRuntime().addShutdownHook(new CaptureShutdownHook(stream));
        Thread.currentThread().join();
    }

    private class CaptureHandlerImpl
    implements CaptureHandler {
        private int frame = 0;

        private CaptureHandlerImpl() {
        }

        @Override
        public void receivedFrameAtTime(long hardwareTime, long pts, long timeScaleNumerator, long timeScaleDenumerator) {
            if (this.frame % 120 == 0) {
                System.out.println("[Streaming] Published frame " + this.frame + " at time " + hardwareTime + "ns. pts: " + pts);
            }
            ++this.frame;
        }
    }

    private static class CaptureShutdownHook
    extends Thread {
        private final Stream stream;

        public CaptureShutdownHook(Stream stream) {
            this.stream = stream;
        }

        @Override
        public void run() {
            try {
                this.stream.stop();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

