/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.javadecklink;

import java.io.IOException;
import java.util.Arrays;
import java.util.concurrent.locks.ReentrantLock;
import us.ihmc.javadecklink.CaptureHandler;
import us.ihmc.tools.nativelibraries.NativeLibraryLoader;

public class Capture {
    private static boolean loaded = false;
    private static final String[] LIBAV_SUPPORTED_VERSIONS;
    private final ReentrantLock lock = new ReentrantLock();
    private final CodecID codec;
    private final CaptureHandler captureHandler;
    private final long captureSettingsPtr;
    private long ptr = 0L;
    private boolean alive = true;
    private String format = null;
    private boolean recordAudio = false;

    private native long getHardwareTime(long var1);

    private native long startCaptureNative(String var1, String var2, int var3, long var4);

    private native long startCaptureNativeWithAudio(String var1, String var2, int var3, long var4);

    private native void stopCaptureNative(long var1);

    private native long createCaptureSettings(int var1);

    private native long setQuality(long var1, int var3);

    private native void setOption(long var1, String var3, String var4);

    public Capture(CaptureHandler captureHandler, CodecID codec) {
        if (!loaded) {
            throw new UnsatisfiedLinkError("[ERROR] Cannot load JavaDecklink library, make sure you have a supported libav version installed. Supported versions are " + Arrays.toString(LIBAV_SUPPORTED_VERSIONS));
        }
        this.codec = codec;
        this.captureHandler = captureHandler;
        this.captureSettingsPtr = this.createCaptureSettings(codec.id);
    }

    public void setRecordAudio(boolean recordAudio) {
        this.recordAudio = recordAudio;
    }

    public void setOption(String option, String value) {
        this.setOption(this.captureSettingsPtr, option, value);
    }

    public void setFormat(String formatShortName) {
        this.format = formatShortName;
    }

    public void setMJPEGQuality(double quality) {
        int codecQuality;
        quality = Math.min(1.0, Math.max(quality, 0.0));
        switch (this.codec) {
            case AV_CODEC_ID_H264: {
                throw new RuntimeException("Quality settings not supported");
            }
            case AV_CODEC_ID_MJPEG: {
                codecQuality = 2 + (int)((1.0 - quality) * 30.0);
                break;
            }
            default: {
                throw new RuntimeException();
            }
        }
        this.setQuality(this.captureSettingsPtr, codecQuality);
    }

    public long getHardwareTime() {
        if (this.lock.tryLock()) {
            if (!this.alive || this.ptr == 0L) {
                return -1L;
            }
            long hardwareTime = this.getHardwareTime(this.ptr);
            this.lock.unlock();
            return hardwareTime;
        }
        return -1L;
    }

    private void receivedFrameAtHardwareTimeFromNative(long hardwareTime, long pts, long timeScaleNumerator, long timeScaleDenumerator) {
        this.captureHandler.receivedFrameAtTime(hardwareTime, pts, timeScaleNumerator, timeScaleDenumerator);
    }

    public void startCapture(String filename, int decklink) throws IOException {
        if (!this.alive) {
            throw new RuntimeException("This Capture interface has been stopped");
        }
        if (this.ptr != 0L) {
            throw new IOException("Capture already started");
        }
        this.ptr = this.recordAudio ? this.startCaptureNativeWithAudio(filename, this.format, decklink, this.captureSettingsPtr) : this.startCaptureNative(filename, this.format, decklink, this.captureSettingsPtr);
        if (this.ptr == 0L) {
            throw new IOException("Cannot open capture card");
        }
    }

    private void stopCaptureFromNative() {
        try {
            this.stopCapture();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void stopCapture() throws IOException {
        if (!this.alive) {
            return;
        }
        if (this.ptr == 0L) {
            throw new IOException("Capture not started");
        }
        this.lock.lock();
        this.stopCaptureNative(this.ptr);
        this.alive = false;
        this.ptr = 0L;
        this.lock.unlock();
    }

    public static void main(String[] args) throws IOException, InterruptedException {
        Capture capture;
        CaptureHandlerImpl captureHandlerImpl = new CaptureHandlerImpl();
        if (args.length > 0 && args[0].contains("264")) {
            capture = new Capture(captureHandlerImpl, CodecID.AV_CODEC_ID_H264);
            capture.setOption("preset", "medium");
            capture.setOption("g", "1");
            capture.setOption("crf", "25");
        } else {
            capture = new Capture(captureHandlerImpl, CodecID.AV_CODEC_ID_MJPEG);
            capture.setMJPEGQuality(0.9);
        }
        captureHandlerImpl.setCapture(capture);
        capture.startCapture("aap.mp4", 1);
        Thread.sleep(5000L);
        capture.stopCapture();
    }

    static {
        for (String version : LIBAV_SUPPORTED_VERSIONS = new String[]{"-desktopvideo10.8.5-avcodec56-swscale3-avformat56-ffmpeg", "-desktopvideo11.2-avcodec57-swscale4-avformat57"}) {
            try {
                System.out.println("[INFO] Trying to load JavaDecklink version " + version);
                NativeLibraryLoader.loadLibrary((String)"us.ihmc.javadecklink.lib", (String)("JavaDecklink" + version));
                loaded = true;
                break;
            }
            catch (UnsatisfiedLinkError e) {
                System.err.println("[WARNING] Cannot load JavaDecklink version " + version + ".");
            }
        }
    }

    private static class CaptureHandlerImpl
    implements CaptureHandler {
        private Capture capture;

        private CaptureHandlerImpl() {
        }

        @Override
        public void receivedFrameAtTime(long hardwareTime, long pts, long timeScaleNumerator, long timeScaleDenumerator) {
            long currentTime = this.capture.getHardwareTime();
            System.out.println("Received frame at " + hardwareTime + ", current time: " + currentTime + ", delay: " + (currentTime - hardwareTime) + ",  pts: " + pts + ", timescale: " + timeScaleNumerator + "/" + timeScaleDenumerator);
        }

        public void setCapture(Capture capture) {
            this.capture = capture;
        }
    }

    public static enum CodecID {
        AV_CODEC_ID_MJPEG(1),
        AV_CODEC_ID_H264(2);

        private int id;

        private CodecID(int id) {
            this.id = id;
        }
    }
}

