/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.gdx.vr;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.g3d.Model;
import com.badlogic.gdx.graphics.g3d.ModelInstance;
import com.badlogic.gdx.graphics.g3d.Renderable;
import com.badlogic.gdx.graphics.g3d.RenderableProvider;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Pool;
import java.util.ArrayList;
import java.util.HashSet;
import us.ihmc.commons.exception.DefaultExceptionHandler;
import us.ihmc.commons.exception.ExceptionHandler;
import us.ihmc.commons.exception.ExceptionTools;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.gdx.FocusBasedGDXCamera;
import us.ihmc.gdx.input.ImGui3DViewInput;
import us.ihmc.gdx.sceneManager.GDX3DSceneManager;
import us.ihmc.gdx.sceneManager.GDX3DSceneTools;
import us.ihmc.gdx.ui.gizmo.GDXPose3DGizmo;
import us.ihmc.gdx.vr.GDXVRCamera;
import us.ihmc.gdx.vr.GDXVRContext;
import us.ihmc.gdx.vr.GDXVRControllerRole;
import us.ihmc.gdx.vr.GDXVRDevice;
import us.ihmc.gdx.vr.GDXVRDeviceAdapter;
import us.ihmc.gdx.vr.GDXVRDeviceListener;
import us.ihmc.gdx.vr.GDXVRDeviceType;
import us.ihmc.gdx.vr.GDXVRPerEyeData;
import us.ihmc.log.LogTools;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.robotics.robotSide.SideDependentList;

public class GDXVRManager
implements RenderableProvider {
    private static boolean ENABLE_VR = Boolean.parseBoolean(System.getProperty("enable.vr"));
    private GDXVRContext context;
    private final HashSet<ModelInstance> modelInstances = new HashSet();
    private ModelInstance headsetModelInstance;
    private final SideDependentList<GDXVRDevice> controllers = new SideDependentList();
    private boolean skipHeadset = false;
    private boolean holdingTouchpadToMove = false;
    private final Point3D initialVRSpacePosition = new Point3D();
    private final Point3D initialVRControllerPosition = new Point3D();
    private final Point3D currentVRControllerPosition = new Point3D();
    private final Vector3D deltaVRControllerPosition = new Vector3D();
    private final Point3D resultVRSpacePosition = new Point3D();
    private final Point3D lastVRSpacePosition = new Point3D();
    private final ArrayList<Runnable> thingsToCreateOnEnable = new ArrayList();
    private final GDXPose3DGizmo scenePoseGizmo = new GDXPose3DGizmo();

    public void create(FocusBasedGDXCamera camera3D) {
        ENABLE_VR = true;
        System.setProperty("enable.vr", "true");
        this.context = new GDXVRContext();
        this.scenePoseGizmo.create(camera3D);
        ((GDXVRPerEyeData)this.context.getPerEyeData().get((Enum)RobotSide.LEFT)).getCamera().far = 100.0f;
        ((GDXVRPerEyeData)this.context.getPerEyeData().get((Enum)RobotSide.RIGHT)).getCamera().far = 100.0f;
        this.context.addListener(new GDXVRDeviceListener(){

            @Override
            public void connected(GDXVRDevice device) {
                LogTools.info((String)"{} connected", (Object)device);
                if (device.getModelInstance() != null) {
                    GDXVRManager.this.modelInstances.add(device.getModelInstance());
                    if (device.getType() == GDXVRDeviceType.HeadMountedDisplay) {
                        GDXVRManager.this.headsetModelInstance = device.getModelInstance();
                    } else if (device.getType() == GDXVRDeviceType.Controller) {
                        if (device.getControllerRole() == GDXVRControllerRole.LeftHand) {
                            GDXVRManager.this.controllers.set((Enum)RobotSide.LEFT, (Object)device);
                        } else if (device.getControllerRole() == GDXVRControllerRole.RightHand) {
                            GDXVRManager.this.controllers.set((Enum)RobotSide.RIGHT, (Object)device);
                        } else if (!GDXVRManager.this.controllers.containsKey((Object)RobotSide.LEFT)) {
                            GDXVRManager.this.controllers.set((Enum)RobotSide.LEFT, (Object)device);
                        } else if (!GDXVRManager.this.controllers.containsKey((Object)RobotSide.RIGHT)) {
                            GDXVRManager.this.controllers.set((Enum)RobotSide.RIGHT, (Object)device);
                        }
                    }
                    LogTools.info((String)"{} controllers registered.", (Object)GDXVRManager.this.controllers.sides());
                }
            }

            @Override
            public void disconnected(GDXVRDevice device) {
                LogTools.info((String)"{} disconnected", (Object)device);
            }

            @Override
            public void buttonPressed(GDXVRDevice device, int button) {
                LogTools.info((String)"{} button pressed: {}", (Object)device, (Object)button);
            }

            @Override
            public void buttonReleased(GDXVRDevice device, int button) {
                LogTools.info((String)"{} button released: {}", (Object)device, (Object)button);
            }
        });
        this.context.addListener(new GDXVRDeviceAdapter(){

            @Override
            public void buttonPressed(GDXVRDevice device, int button) {
                if (device == GDXVRManager.this.controllers.get((Enum)RobotSide.RIGHT) && button == 32) {
                    GDXVRManager.this.holdingTouchpadToMove = true;
                }
            }

            @Override
            public void buttonReleased(GDXVRDevice device, int button) {
                if (device == GDXVRManager.this.controllers.get((Enum)RobotSide.RIGHT) && button == 32) {
                    GDXVRManager.this.holdingTouchpadToMove = false;
                }
            }
        });
        for (Runnable runnable : this.thingsToCreateOnEnable) {
            runnable.run();
        }
    }

    public void pollEvents() {
        this.context.pollEvents();
    }

    public void render(GDX3DSceneManager sceneManager) {
        if (this.context.getDeviceByType(GDXVRDeviceType.HeadMountedDisplay) == null) {
            return;
        }
        this.context.teleport(this.scenePoseGizmo.getTransform());
        if (this.holdingTouchpadToMove) {
            // empty if block
        }
        this.context.begin();
        this.renderScene(RobotSide.LEFT, sceneManager);
        this.renderScene(RobotSide.RIGHT, sceneManager);
        this.context.end();
    }

    private void renderScene(RobotSide eye, GDX3DSceneManager sceneManager) {
        GDXVRPerEyeData eyeData = (GDXVRPerEyeData)this.context.getPerEyeData().get((Enum)eye);
        GDXVRCamera camera = eyeData.getCamera();
        this.context.beginEye(eye);
        int width = eyeData.getFrameBuffer().getWidth();
        int height = eyeData.getFrameBuffer().getHeight();
        Gdx.gl.glViewport(0, 0, width, height);
        GDX3DSceneTools.glClearGray();
        this.skipHeadset = true;
        sceneManager.renderToCamera(camera);
        this.skipHeadset = false;
        this.context.endEye();
    }

    public SideDependentList<GDXVRDevice> getControllers() {
        return this.controllers;
    }

    public void dispose() {
        if (this.context != null) {
            this.context.dispose();
        }
        for (ModelInstance modelInstance : this.modelInstances) {
            ExceptionTools.handle(() -> ((Model)modelInstance.model).dispose(), (ExceptionHandler)DefaultExceptionHandler.PRINT_MESSAGE);
        }
    }

    public void create(Runnable runnable) {
        this.thingsToCreateOnEnable.add(runnable);
    }

    public void process3DViewInput(ImGui3DViewInput input) {
        this.scenePoseGizmo.process3DViewInput(input);
    }

    public void getRenderables(Array<Renderable> renderables, Pool<Renderable> pool) {
        for (ModelInstance modelInstance : this.modelInstances) {
            if (this.skipHeadset && modelInstance == this.headsetModelInstance) continue;
            modelInstance.getRenderables(renderables, pool);
        }
        this.scenePoseGizmo.getRenderables(renderables, pool);
    }

    public GDXVRContext getContext() {
        return this.context;
    }

    public static boolean isVREnabled() {
        return ENABLE_VR;
    }
}

