/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.gdx.vr;

import com.badlogic.gdx.graphics.g3d.Model;
import com.badlogic.gdx.graphics.g3d.ModelInstance;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.utils.BufferUtils;
import java.nio.IntBuffer;
import org.lwjgl.openvr.HmdMatrix34;
import org.lwjgl.openvr.VRControllerState;
import org.lwjgl.openvr.VRSystem;
import us.ihmc.euclid.geometry.interfaces.Pose3DBasics;
import us.ihmc.euclid.matrix.RotationMatrix;
import us.ihmc.euclid.matrix.interfaces.CommonMatrix3DBasics;
import us.ihmc.euclid.referenceFrame.FramePose3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.gdx.tools.GDXTools;
import us.ihmc.gdx.vr.GDXVRContext;
import us.ihmc.gdx.vr.GDXVRControllerRole;
import us.ihmc.gdx.vr.GDXVRDeviceProperty;
import us.ihmc.gdx.vr.GDXVRDeviceType;

public class GDXVRDevice {
    private final GDXVRContext context;
    private final GDXVRDeviceType type;
    private final GDXVRControllerRole role;
    private long buttons = 0L;
    private final VRControllerState state = VRControllerState.create();
    private final ModelInstance modelInstance;
    private final String name;
    private final IntBuffer tempIntBuffer = BufferUtils.newIntBuffer((int)1);
    private final Vector3 velocity = new Vector3();
    private final Vector3 angularVelocity = new Vector3();
    private final FramePose3D pose = new FramePose3D();
    private final RotationMatrix tempRotationMatrix = new RotationMatrix();
    private boolean isValid;
    private final int deviceIndex;

    public GDXVRDevice(GDXVRContext context, int deviceIndex, GDXVRDeviceType type, GDXVRControllerRole role) {
        this.context = context;
        this.deviceIndex = deviceIndex;
        this.type = type;
        this.role = role;
        Model model = context.loadRenderModel(this.getStringProperty(GDXVRDeviceProperty.RenderModelName_String));
        this.modelInstance = model != null ? new ModelInstance(model) : null;
        String roleName = role == GDXVRControllerRole.LeftHand ? role.name() : "";
        roleName = roleName + (role == GDXVRControllerRole.RightHand ? role.name() : "");
        this.name = type.name() + roleName;
    }

    public void updatePoseInTrackerFrame(HmdMatrix34 openVRRigidBodyTransform) {
        this.pose.setReferenceFrame(this.context.getVRPlayAreaFrame());
        GDXTools.toEuclid(openVRRigidBodyTransform, (Pose3DBasics)this.pose);
        if (this.modelInstance != null) {
            this.getPose(ReferenceFrame.getWorldFrame(), this.modelInstance.transform);
        }
    }

    public void getPose(ReferenceFrame referenceFrame, Matrix4 gdxRigidBodyTransform) {
        this.pose.changeFrame(referenceFrame);
        this.pose.getOrientation().get((CommonMatrix3DBasics)this.tempRotationMatrix);
        GDXTools.toGDX(this.tempRotationMatrix, gdxRigidBodyTransform);
        GDXTools.toGDX((Point3DReadOnly)this.pose.getPosition(), gdxRigidBodyTransform);
    }

    public FramePose3D getPose() {
        return this.pose;
    }

    public GDXVRDeviceType getType() {
        return this.type;
    }

    public GDXVRControllerRole getControllerRole() {
        return this.role;
    }

    public boolean isConnected() {
        return VRSystem.VRSystem_IsTrackedDeviceConnected((int)this.deviceIndex);
    }

    public boolean isButtonPressed(int button) {
        if (button < 0 || button >= 64) {
            return false;
        }
        return (this.buttons & 1L << button) != 0L;
    }

    void setButton(int button, boolean pressed) {
        this.buttons = pressed ? (this.buttons |= 1L << button) : (this.buttons ^= 1L << button);
    }

    public float getAxisX(int axis) {
        if (axis < 0 || axis >= 5) {
            return 0.0f;
        }
        VRSystem.VRSystem_GetControllerState((int)this.deviceIndex, (VRControllerState)this.state);
        return this.state.rAxis(axis).x();
    }

    public float getAxisY(int axis) {
        if (axis < 0 || axis >= 5) {
            return 0.0f;
        }
        VRSystem.VRSystem_GetControllerState((int)this.deviceIndex, (VRControllerState)this.state);
        return this.state.rAxis(axis).y();
    }

    public void triggerHapticPulse(short duration) {
        VRSystem.VRSystem_TriggerHapticPulse((int)this.deviceIndex, (int)0, (short)duration);
    }

    public boolean getBooleanProperty(GDXVRDeviceProperty property) {
        this.tempIntBuffer.put(0, 0);
        boolean result = VRSystem.VRSystem_GetBoolTrackedDeviceProperty((int)this.deviceIndex, (int)property.value, (IntBuffer)this.tempIntBuffer);
        if (this.tempIntBuffer.get(0) != 0) {
            return false;
        }
        return result;
    }

    public float getFloatProperty(GDXVRDeviceProperty property) {
        this.tempIntBuffer.put(0, 0);
        float result = VRSystem.VRSystem_GetFloatTrackedDeviceProperty((int)this.deviceIndex, (int)property.value, (IntBuffer)this.tempIntBuffer);
        if (this.tempIntBuffer.get(0) != 0) {
            return 0.0f;
        }
        return result;
    }

    public int getInt32Property(GDXVRDeviceProperty property) {
        this.tempIntBuffer.put(0, 0);
        int result = VRSystem.VRSystem_GetInt32TrackedDeviceProperty((int)this.deviceIndex, (int)property.value, (IntBuffer)this.tempIntBuffer);
        if (this.tempIntBuffer.get(0) != 0) {
            return 0;
        }
        return result;
    }

    public long getUInt64Property(GDXVRDeviceProperty property) {
        this.tempIntBuffer.put(0, 0);
        long result = VRSystem.VRSystem_GetUint64TrackedDeviceProperty((int)this.deviceIndex, (int)property.value, (IntBuffer)this.tempIntBuffer);
        if (this.tempIntBuffer.get(0) != 0) {
            return 0L;
        }
        return result;
    }

    public String getStringProperty(GDXVRDeviceProperty property) {
        this.tempIntBuffer.put(0, 0);
        String result = VRSystem.VRSystem_GetStringTrackedDeviceProperty((int)this.deviceIndex, (int)property.value, (IntBuffer)this.tempIntBuffer);
        if (this.tempIntBuffer.get(0) != 0) {
            return null;
        }
        return result;
    }

    public ModelInstance getModelInstance() {
        return this.modelInstance;
    }

    public int getDeviceIndex() {
        return this.deviceIndex;
    }

    public Vector3 getVelocity() {
        return this.velocity;
    }

    public Vector3 getAngularVelocity() {
        return this.angularVelocity;
    }

    public boolean isValid() {
        return this.isValid;
    }

    public void setValid(boolean valid) {
        this.isValid = valid;
    }

    public String toString() {
        return "VRDevice[manufacturer=" + this.getStringProperty(GDXVRDeviceProperty.ManufacturerName_String) + ", renderModel=" + this.getStringProperty(GDXVRDeviceProperty.RenderModelName_String) + ", deviceIndex=" + this.deviceIndex + ", type=" + (Object)((Object)this.type) + ", role=" + (Object)((Object)this.role) + "]";
    }
}

