/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.gdx.vr;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Mesh;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.TextureData;
import com.badlogic.gdx.graphics.VertexAttribute;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.graphics.g3d.Attribute;
import com.badlogic.gdx.graphics.g3d.Material;
import com.badlogic.gdx.graphics.g3d.Model;
import com.badlogic.gdx.graphics.g3d.attributes.TextureAttribute;
import com.badlogic.gdx.graphics.g3d.model.MeshPart;
import com.badlogic.gdx.graphics.g3d.model.Node;
import com.badlogic.gdx.graphics.g3d.model.NodePart;
import com.badlogic.gdx.graphics.glutils.FrameBuffer;
import com.badlogic.gdx.graphics.glutils.GLFrameBuffer;
import com.badlogic.gdx.graphics.glutils.PixmapTextureData;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.BufferUtils;
import com.badlogic.gdx.utils.Disposable;
import com.badlogic.gdx.utils.GdxRuntimeException;
import com.badlogic.gdx.utils.ObjectMap;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.function.Consumer;
import org.lwjgl.PointerBuffer;
import org.lwjgl.openvr.HmdMatrix34;
import org.lwjgl.openvr.HmdVector3;
import org.lwjgl.openvr.OpenVR;
import org.lwjgl.openvr.RenderModel;
import org.lwjgl.openvr.RenderModelTextureMap;
import org.lwjgl.openvr.RenderModelVertex;
import org.lwjgl.openvr.Texture;
import org.lwjgl.openvr.TrackedDevicePose;
import org.lwjgl.openvr.VR;
import org.lwjgl.openvr.VRCompositor;
import org.lwjgl.openvr.VREvent;
import org.lwjgl.openvr.VRRenderModels;
import org.lwjgl.openvr.VRSystem;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformBasics;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.yawPitchRoll.YawPitchRoll;
import us.ihmc.gdx.vr.GDXVRCamera;
import us.ihmc.gdx.vr.GDXVRControllerRole;
import us.ihmc.gdx.vr.GDXVRDevice;
import us.ihmc.gdx.vr.GDXVRDeviceListener;
import us.ihmc.gdx.vr.GDXVRDeviceType;
import us.ihmc.gdx.vr.GDXVRPerEyeData;
import us.ihmc.robotics.referenceFrames.ReferenceFrameMissingTools;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.robotics.robotSide.SideDependentList;

public class GDXVRContext
implements Disposable {
    private final IntBuffer error = BufferUtils.newIntBuffer((int)1);
    private final IntBuffer scratch = BufferUtils.newIntBuffer((int)1);
    private final IntBuffer scratch2 = BufferUtils.newIntBuffer((int)1);
    private final SideDependentList<GDXVRPerEyeData> perEyeData = new SideDependentList();
    private final SpriteBatch batcher;
    private final TrackedDevicePose.Buffer trackedDevicePoses = TrackedDevicePose.create((int)64);
    private final TrackedDevicePose.Buffer trackedDeviceGamePoses = TrackedDevicePose.create((int)64);
    private final ArrayList<GDXVRDevice> devices = new ArrayList(64);
    private final Array<GDXVRDeviceListener> deviceListeners = new Array();
    private final VREvent event = VREvent.create();
    private final ObjectMap<String, Model> models = new ObjectMap();
    private RobotSide currentEye = null;
    private boolean renderingStarted = false;
    private boolean initialDevicesReported = false;
    private final RigidBodyTransformReadOnly openVRYUpToIHMCZUpSpace = new RigidBodyTransform((Orientation3DReadOnly)new YawPitchRoll(Math.toRadians(-90.0), Math.toRadians(0.0), Math.toRadians(90.0)), (Tuple3DReadOnly)new Point3D());
    private final RigidBodyTransform tempVRPlayAreaZUp = new RigidBodyTransform();
    private final RigidBodyTransform totalTransformFromVRPlayAreaToIHMCZUpWorld = new RigidBodyTransform();
    private final ReferenceFrame vrPlayAreaYUpZBackFrame = ReferenceFrameMissingTools.constructFrameWithChangingTransformToParent((String)"vrPlayAreaFrame", (ReferenceFrame)ReferenceFrame.getWorldFrame(), (RigidBodyTransformReadOnly)this.totalTransformFromVRPlayAreaToIHMCZUpWorld);

    public GDXVRContext() {
        this(1.0f, false);
    }

    public GDXVRContext(float renderTargetMultiplier, boolean hasStencil) {
        int token = VR.VR_InitInternal((IntBuffer)this.error, (int)1);
        this.checkInitError(this.error);
        OpenVR.create((int)token);
        VR.VR_GetGenericInterface((CharSequence)"IVRCompositor_022", (IntBuffer)this.error);
        this.checkInitError(this.error);
        VR.VR_GetGenericInterface((CharSequence)"IVRRenderModels_006", (IntBuffer)this.error);
        this.checkInitError(this.error);
        for (int deviceIndex = 0; deviceIndex < 64; ++deviceIndex) {
            this.devices.add(null);
        }
        VRSystem.VRSystem_GetRecommendedRenderTargetSize((IntBuffer)this.scratch, (IntBuffer)this.scratch2);
        int width = (int)((float)this.scratch.get(0) * renderTargetMultiplier);
        int height = (int)((float)this.scratch2.get(0) * renderTargetMultiplier);
        this.setupEye(RobotSide.LEFT, width, height, hasStencil);
        this.setupEye(RobotSide.RIGHT, width, height, hasStencil);
        this.batcher = new SpriteBatch();
    }

    private void setupEye(RobotSide eye, int width, int height, boolean hasStencil) {
        FrameBuffer buffer = new FrameBuffer(Pixmap.Format.RGBA8888, width, height, true, hasStencil);
        TextureRegion region = new TextureRegion((com.badlogic.gdx.graphics.Texture)buffer.getColorBufferTexture());
        region.flip(false, true);
        GDXVRCamera camera = new GDXVRCamera(this, eye);
        camera.near = 0.1f;
        camera.far = 1000.0f;
        this.perEyeData.set((Enum)eye, (Object)new GDXVRPerEyeData(buffer, region, camera));
    }

    private void checkInitError(IntBuffer errorBuffer) {
        if (errorBuffer.get(0) != 0) {
            int error = errorBuffer.get(0);
            throw new GdxRuntimeException("VR Initialization error: " + VR.VR_GetVRInitErrorAsEnglishDescription((int)error));
        }
    }

    public void teleport(Consumer<RigidBodyTransform> vrPlayAreaZUpConsumer) {
        vrPlayAreaZUpConsumer.accept(this.tempVRPlayAreaZUp);
        this.teleport(this.tempVRPlayAreaZUp);
    }

    public void teleport(RigidBodyTransform vrPlayAreaZUp) {
        this.totalTransformFromVRPlayAreaToIHMCZUpWorld.set(this.openVRYUpToIHMCZUpSpace);
        vrPlayAreaZUp.transform((RigidBodyTransformBasics)this.totalTransformFromVRPlayAreaToIHMCZUpWorld);
        this.vrPlayAreaYUpZBackFrame.update();
    }

    public void begin() {
        if (this.renderingStarted) {
            throw new GdxRuntimeException("Last begin() call not completed, call end() before starting a new render");
        }
        this.renderingStarted = true;
        ((GDXVRPerEyeData)this.perEyeData.get((Enum)RobotSide.LEFT)).getCamera().update();
        ((GDXVRPerEyeData)this.perEyeData.get((Enum)RobotSide.RIGHT)).getCamera().update();
    }

    public void pollEvents() {
        int deviceIndex;
        VRCompositor.VRCompositor_WaitGetPoses((TrackedDevicePose.Buffer)this.trackedDevicePoses, (TrackedDevicePose.Buffer)this.trackedDeviceGamePoses);
        if (!this.initialDevicesReported) {
            for (deviceIndex = 0; deviceIndex < 64; ++deviceIndex) {
                if (!VRSystem.VRSystem_IsTrackedDeviceConnected((int)deviceIndex)) continue;
                this.createDevice(deviceIndex);
                for (GDXVRDeviceListener deviceListener : this.deviceListeners) {
                    deviceListener.connected(this.devices.get(deviceIndex));
                }
            }
            this.initialDevicesReported = true;
        }
        for (deviceIndex = 0; deviceIndex < 64; ++deviceIndex) {
            GDXVRDevice device = this.devices.get(deviceIndex);
            if (device == null) continue;
            TrackedDevicePose trackedPose = (TrackedDevicePose)this.trackedDevicePoses.get(deviceIndex);
            HmdVector3 velocity = trackedPose.vVelocity();
            HmdVector3 angularVelocity = trackedPose.vAngularVelocity();
            HmdMatrix34 openVRRigidBodyTransform = trackedPose.mDeviceToAbsoluteTracking();
            device.getVelocity().set(velocity.v(0), velocity.v(1), velocity.v(2));
            device.getAngularVelocity().set(angularVelocity.v(0), angularVelocity.v(1), angularVelocity.v(2));
            device.setValid(trackedPose.bPoseIsValid());
            device.updatePoseInTrackerFrame(openVRRigidBodyTransform);
        }
        while (VRSystem.VRSystem_PollNextEvent((VREvent)this.event)) {
            deviceIndex = this.event.trackedDeviceIndex();
            if (deviceIndex < 0 || deviceIndex > 64) continue;
            int button = 0;
            switch (this.event.eventType()) {
                case 100: {
                    this.createDevice(deviceIndex);
                    for (GDXVRDeviceListener deviceListener : this.deviceListeners) {
                        deviceListener.connected(this.devices.get(deviceIndex));
                    }
                    break;
                }
                case 101: {
                    deviceIndex = this.event.trackedDeviceIndex();
                    if (this.devices.get(deviceIndex) == null) break;
                    for (GDXVRDeviceListener deviceListener : this.deviceListeners) {
                        deviceListener.disconnected(this.devices.get(deviceIndex));
                    }
                    this.devices.set(deviceIndex, null);
                    break;
                }
                case 200: {
                    if (this.devices.get(deviceIndex) == null) break;
                    button = this.event.data().controller().button();
                    this.devices.get(deviceIndex).setButton(button, true);
                    for (GDXVRDeviceListener deviceListener : this.deviceListeners) {
                        deviceListener.buttonPressed(this.devices.get(deviceIndex), button);
                    }
                    break;
                }
                case 201: {
                    if (this.devices.get(deviceIndex) == null) break;
                    button = this.event.data().controller().button();
                    this.devices.get(deviceIndex).setButton(button, false);
                    for (GDXVRDeviceListener deviceListener : this.deviceListeners) {
                        deviceListener.buttonReleased(this.devices.get(deviceIndex), button);
                    }
                    break;
                }
            }
        }
    }

    private void createDevice(int deviceIndex) {
        GDXVRDeviceType type;
        int deviceClass = VRSystem.VRSystem_GetTrackedDeviceClass((int)deviceIndex);
        switch (deviceClass) {
            case 1: {
                type = GDXVRDeviceType.HeadMountedDisplay;
                break;
            }
            case 2: {
                type = GDXVRDeviceType.Controller;
                break;
            }
            case 4: {
                type = GDXVRDeviceType.BaseStation;
                break;
            }
            case 3: {
                type = GDXVRDeviceType.Generic;
                break;
            }
            default: {
                return;
            }
        }
        GDXVRControllerRole role = GDXVRControllerRole.Unknown;
        if (type == GDXVRDeviceType.Controller) {
            int r = VRSystem.VRSystem_GetControllerRoleForTrackedDeviceIndex((int)deviceIndex);
            switch (r) {
                case 1: {
                    role = GDXVRControllerRole.LeftHand;
                    break;
                }
                case 2: {
                    role = GDXVRControllerRole.RightHand;
                }
            }
        }
        this.devices.set(deviceIndex, new GDXVRDevice(this, deviceIndex, type, role));
    }

    public void beginEye(RobotSide eye) {
        if (!this.renderingStarted) {
            throw new GdxRuntimeException("Call begin() before calling beginEye()");
        }
        if (this.currentEye != null) {
            throw new GdxRuntimeException("Last beginEye() call not completed, call endEye() before starting a new render");
        }
        this.currentEye = eye;
        ((GDXVRPerEyeData)this.perEyeData.get((Enum)eye)).getFrameBuffer().begin();
    }

    public void endEye() {
        if (this.currentEye == null) {
            throw new GdxRuntimeException("Call beginEye() before endEye()");
        }
        ((GDXVRPerEyeData)this.perEyeData.get((Enum)this.currentEye)).getFrameBuffer().end();
        this.currentEye = null;
    }

    public void end() {
        if (!this.renderingStarted) {
            throw new GdxRuntimeException("Call begin() before end()");
        }
        this.renderingStarted = false;
        VRCompositor.VRCompositor_Submit((int)0, (Texture)((GDXVRPerEyeData)this.perEyeData.get((Enum)RobotSide.LEFT)).getTexture(), null, (int)0);
        VRCompositor.VRCompositor_Submit((int)1, (Texture)((GDXVRPerEyeData)this.perEyeData.get((Enum)RobotSide.RIGHT)).getTexture(), null, (int)0);
    }

    public void dispose() {
        for (GDXVRPerEyeData eyeData : this.perEyeData) {
            eyeData.getFrameBuffer().dispose();
        }
        this.batcher.dispose();
        VR.VR_ShutdownInternal();
    }

    public void resizeCompanionWindow() {
        GLFrameBuffer<com.badlogic.gdx.graphics.Texture> buffer = ((GDXVRPerEyeData)this.perEyeData.get((Enum)RobotSide.LEFT)).getFrameBuffer();
        Gdx.graphics.setWindowedMode(buffer.getWidth(), buffer.getHeight());
    }

    public void renderToCompanionWindow(RobotSide eye) {
        GLFrameBuffer<com.badlogic.gdx.graphics.Texture> buffer = ((GDXVRPerEyeData)this.perEyeData.get((Enum)eye)).getFrameBuffer();
        TextureRegion region = ((GDXVRPerEyeData)this.perEyeData.get((Enum)eye)).getRegion();
        this.batcher.getProjectionMatrix().setToOrtho2D(0.0f, 0.0f, (float)buffer.getWidth(), (float)buffer.getHeight());
        this.batcher.begin();
        this.batcher.draw(region, 0.0f, 0.0f);
        this.batcher.end();
    }

    public Model loadRenderModel(String name) {
        if (this.models.containsKey((Object)name)) {
            return (Model)this.models.get((Object)name);
        }
        int error = 0;
        PointerBuffer modelPointer = PointerBuffer.allocateDirect((int)1);
        while ((error = VRRenderModels.VRRenderModels_LoadRenderModel_Async((CharSequence)name, (PointerBuffer)modelPointer)) == 100) {
        }
        if (error != 0) {
            return null;
        }
        RenderModel renderModel = new RenderModel(modelPointer.getByteBuffer(RenderModel.SIZEOF));
        error = 0;
        PointerBuffer texturePointer = PointerBuffer.allocateDirect((int)1);
        while ((error = VRRenderModels.VRRenderModels_LoadTexture_Async((int)renderModel.diffuseTextureId(), (PointerBuffer)texturePointer)) == 100) {
        }
        if (error != 0) {
            VRRenderModels.VRRenderModels_FreeRenderModel((RenderModel)renderModel);
            return null;
        }
        RenderModelTextureMap renderModelTexture = new RenderModelTextureMap(texturePointer.getByteBuffer(RenderModelTextureMap.SIZEOF));
        Mesh mesh = new Mesh(true, renderModel.unVertexCount(), renderModel.unTriangleCount() * 3, new VertexAttribute[]{VertexAttribute.Position(), VertexAttribute.Normal(), VertexAttribute.TexCoords((int)0)});
        MeshPart meshPart = new MeshPart(name, mesh, 0, renderModel.unTriangleCount() * 3, 4);
        RenderModelVertex.Buffer vertices = renderModel.rVertexData();
        float[] packedVertices = new float[8 * renderModel.unVertexCount()];
        int i = 0;
        while (vertices.remaining() > 0) {
            RenderModelVertex v = (RenderModelVertex)vertices.get();
            packedVertices[i++] = v.vPosition().v(0);
            packedVertices[i++] = v.vPosition().v(1);
            packedVertices[i++] = v.vPosition().v(2);
            packedVertices[i++] = v.vNormal().v(0);
            packedVertices[i++] = v.vNormal().v(1);
            packedVertices[i++] = v.vNormal().v(2);
            packedVertices[i++] = v.rfTextureCoord().get(0);
            packedVertices[i++] = v.rfTextureCoord().get(1);
        }
        mesh.setVertices(packedVertices);
        short[] indices = new short[renderModel.unTriangleCount() * 3];
        renderModel.IndexData().get(indices);
        mesh.setIndices(indices);
        Pixmap pixmap = new Pixmap((int)renderModelTexture.unWidth(), (int)renderModelTexture.unHeight(), Pixmap.Format.RGBA8888);
        byte[] pixels = new byte[renderModelTexture.unWidth() * renderModelTexture.unHeight() * 4];
        renderModelTexture.rubTextureMapData(pixels.length).get(pixels);
        pixmap.getPixels().put(pixels);
        pixmap.getPixels().position(0);
        com.badlogic.gdx.graphics.Texture texture = new com.badlogic.gdx.graphics.Texture((TextureData)new PixmapTextureData(pixmap, pixmap.getFormat(), true, true));
        Material material = new Material(new Attribute[]{new TextureAttribute(TextureAttribute.Diffuse, texture)});
        Model model = new Model();
        model.meshes.add((Object)mesh);
        model.meshParts.add((Object)meshPart);
        model.materials.add((Object)material);
        Node node = new Node();
        node.id = name;
        node.parts.add((Object)new NodePart(meshPart, material));
        model.nodes.add((Object)node);
        model.manageDisposable((Disposable)mesh);
        model.manageDisposable((Disposable)texture);
        VRRenderModels.VRRenderModels_FreeRenderModel((RenderModel)renderModel);
        VRRenderModels.VRRenderModels_FreeTexture((RenderModelTextureMap)renderModelTexture);
        this.models.put((Object)name, (Object)model);
        return model;
    }

    public void addListener(GDXVRDeviceListener listener) {
        this.deviceListeners.add((Object)listener);
    }

    public void removeListener(GDXVRDeviceListener listener) {
        this.deviceListeners.removeValue((Object)listener, true);
    }

    public GDXVRDevice getDeviceByType(GDXVRDeviceType type) {
        for (GDXVRDevice device : this.devices) {
            if (device == null || device.getType() != type) continue;
            return device;
        }
        return null;
    }

    public Array<GDXVRDevice> getDevicesByType(GDXVRDeviceType type) {
        Array result = new Array();
        for (GDXVRDevice device : this.devices) {
            if (device == null || device.getType() != type) continue;
            result.add((Object)device);
        }
        return result;
    }

    public Array<GDXVRDevice> getDevices() {
        Array result = new Array();
        for (GDXVRDevice device : this.devices) {
            if (device == null) continue;
            result.add((Object)device);
        }
        return result;
    }

    public GDXVRDevice getControllerByRole(GDXVRControllerRole role) {
        for (GDXVRDevice device : this.devices) {
            if (device == null || device.getType() != GDXVRDeviceType.Controller || device.getControllerRole() != role) continue;
            return device;
        }
        return null;
    }

    public SideDependentList<GDXVRPerEyeData> getPerEyeData() {
        return this.perEyeData;
    }

    public ReferenceFrame getVRPlayAreaFrame() {
        return this.vrPlayAreaYUpZBackFrame;
    }
}

