/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.gdx.vr;

import com.badlogic.gdx.graphics.Camera;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Vector3;
import org.lwjgl.openvr.HmdMatrix34;
import org.lwjgl.openvr.HmdMatrix44;
import org.lwjgl.openvr.VRSystem;
import us.ihmc.euclid.Axis3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.gdx.tools.GDXTools;
import us.ihmc.gdx.vr.GDXVRContext;
import us.ihmc.gdx.vr.GDXVRDevice;
import us.ihmc.gdx.vr.GDXVRDeviceType;
import us.ihmc.robotics.robotSide.RobotSide;

public class GDXVRCamera
extends Camera {
    private final GDXVRContext context;
    private final RobotSide eye;
    private final Matrix4 eyeSpace = new Matrix4();
    private final Matrix4 invEyeSpace = new Matrix4();
    private final HmdMatrix44 projectionMat = HmdMatrix44.create();
    private final HmdMatrix34 eyeMat = HmdMatrix34.create();
    private final Vector3 tmp = new Vector3();
    private final Vector3D euclidDirection = new Vector3D();
    private final Vector3D euclidUp = new Vector3D();

    public GDXVRCamera(GDXVRContext context, RobotSide eye) {
        this.context = context;
        this.eye = eye;
    }

    public void update() {
        this.update(true);
    }

    public void update(boolean updateFrustum) {
        VRSystem.VRSystem_GetProjectionMatrix((int)this.eye.ordinal(), (float)this.near, (float)this.far, (HmdMatrix44)this.projectionMat);
        GDXTools.toGDX(this.projectionMat, this.projection);
        VRSystem.VRSystem_GetEyeToHeadTransform((int)this.eye.ordinal(), (HmdMatrix34)this.eyeMat);
        GDXTools.toGDX(this.eyeMat, this.eyeSpace);
        this.invEyeSpace.set(this.eyeSpace).inv();
        GDXVRDevice hmd = this.context.getDeviceByType(GDXVRDeviceType.HeadMountedDisplay);
        hmd.getPose().changeFrame(ReferenceFrame.getWorldFrame());
        this.euclidDirection.set((Tuple3DReadOnly)Axis3D.Z);
        this.euclidDirection.negate();
        hmd.getPose().getOrientation().transform((Tuple3DBasics)this.euclidDirection);
        this.euclidUp.set((Tuple3DReadOnly)Axis3D.Y);
        hmd.getPose().getOrientation().transform((Tuple3DBasics)this.euclidUp);
        this.position.set(hmd.getPose().getPosition().getX32(), hmd.getPose().getPosition().getY32(), hmd.getPose().getPosition().getZ32());
        this.direction.set(this.euclidDirection.getX32(), this.euclidDirection.getY32(), this.euclidDirection.getZ32());
        this.up.set(this.euclidUp.getX32(), this.euclidUp.getY32(), this.euclidUp.getZ32());
        this.view.setToLookAt(this.position, this.tmp.set(this.position).add(this.direction), this.up);
        this.combined.set(this.projection);
        Matrix4.mul((float[])this.combined.val, (float[])this.invEyeSpace.val);
        Matrix4.mul((float[])this.combined.val, (float[])this.view.val);
        if (updateFrustum) {
            this.invProjectionView.set(this.combined);
            Matrix4.inv((float[])this.invProjectionView.val);
            this.frustum.update(this.invProjectionView);
        }
    }
}

