/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.gdx.ui.gizmo;

import us.ihmc.euclid.geometry.interfaces.Line3DReadOnly;
import us.ihmc.euclid.geometry.tools.EuclidGeometryTools;
import us.ihmc.euclid.shape.primitives.Cylinder3D;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.transform.interfaces.Transform;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;

public class CylinderRayIntersection {
    private final Cylinder3D cylinder = new Cylinder3D();
    private final Point3D firstIntersectionToPack = new Point3D();
    private final Point3D secondIntersectionToPack = new Point3D();

    public void setup(double length, double radius) {
        this.cylinder.setToZero();
        this.cylinder.setSize(length, radius);
    }

    public void setup(double length, double radius, RigidBodyTransformReadOnly transform) {
        this.cylinder.setToZero();
        this.cylinder.setSize(length, radius);
        this.cylinder.applyTransform((Transform)transform);
    }

    public void setup(double length, double radius, double zOffset, RigidBodyTransformReadOnly transform) {
        this.cylinder.setToZero();
        this.cylinder.setSize(length, radius);
        this.cylinder.getPosition().addZ(zOffset);
        this.cylinder.applyTransform((Transform)transform);
    }

    public double intersect(Line3DReadOnly pickRay) {
        int numberOfIntersections = EuclidGeometryTools.intersectionBetweenRay3DAndCylinder3D((double)this.cylinder.getLength(), (double)this.cylinder.getRadius(), (Point3DReadOnly)this.cylinder.getPosition(), (Vector3DReadOnly)this.cylinder.getAxis(), (Point3DReadOnly)pickRay.getPoint(), (Vector3DReadOnly)pickRay.getDirection(), (Point3DBasics)this.firstIntersectionToPack, (Point3DBasics)this.secondIntersectionToPack);
        return numberOfIntersections == 2 ? this.firstIntersectionToPack.distance(pickRay.getPoint()) : Double.NaN;
    }

    public Point3D getClosestIntersection() {
        return this.firstIntersectionToPack;
    }

    public Cylinder3D getCylinder() {
        return this.cylinder;
    }
}

