/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.gdx.tools;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Mesh;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g3d.Attribute;
import com.badlogic.gdx.graphics.g3d.Material;
import com.badlogic.gdx.graphics.g3d.Model;
import com.badlogic.gdx.graphics.g3d.ModelInstance;
import com.badlogic.gdx.graphics.g3d.attributes.ColorAttribute;
import com.badlogic.gdx.graphics.g3d.attributes.TextureAttribute;
import com.badlogic.gdx.graphics.g3d.model.MeshPart;
import com.badlogic.gdx.graphics.g3d.utils.ModelBuilder;
import java.util.function.Consumer;
import us.ihmc.euclid.axisAngle.AxisAngle;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.gdx.mesh.GDXMultiColorMeshBuilder;

public class GDXModelPrimitives {
    public static ModelInstance createCoordinateFrameInstance(double length) {
        return new ModelInstance(GDXModelPrimitives.createCoordinateFrame(length));
    }

    public static ModelInstance buildModelInstance(Consumer<GDXMultiColorMeshBuilder> buildModel, String nodeName) {
        return new ModelInstance(GDXModelPrimitives.buildModel(buildModel, nodeName));
    }

    public static Model buildModel(Consumer<GDXMultiColorMeshBuilder> buildModel, String nodeName) {
        ModelBuilder modelBuilder = new ModelBuilder();
        modelBuilder.begin();
        modelBuilder.node().id = nodeName;
        GDXMultiColorMeshBuilder meshBuilder = new GDXMultiColorMeshBuilder();
        buildModel.accept(meshBuilder);
        Mesh mesh = meshBuilder.generateMesh();
        MeshPart meshPart = new MeshPart("xyz", mesh, 0, mesh.getNumIndices(), 4);
        Material material = new Material();
        Texture paletteTexture = GDXMultiColorMeshBuilder.loadPaletteTexture();
        material.set((Attribute)TextureAttribute.createDiffuse((Texture)paletteTexture));
        material.set((Attribute)ColorAttribute.createDiffuse((Color)Color.WHITE));
        modelBuilder.part(meshPart, material);
        return modelBuilder.end();
    }

    public static Model createCoordinateFrame(double length) {
        return GDXModelPrimitives.buildModel(meshBuilder -> {
            double radius = 0.02 * length;
            double coneHeight = 0.1 * length;
            double coneRadius = 0.05 * length;
            meshBuilder.addCylinder(length, radius, (Tuple3DReadOnly)new Point3D(), (Orientation3DReadOnly)new AxisAngle(0.0, 1.0, 0.0, 1.5707963267948966), Color.RED);
            meshBuilder.addCone(coneHeight, coneRadius, (Tuple3DReadOnly)new Point3D(length, 0.0, 0.0), (Orientation3DReadOnly)new AxisAngle(0.0, 1.0, 0.0, 1.5707963267948966), Color.RED);
            meshBuilder.addCylinder(length, radius, (Tuple3DReadOnly)new Point3D(), (Orientation3DReadOnly)new AxisAngle(1.0, 0.0, 0.0, -1.5707963267948966), Color.GREEN);
            meshBuilder.addCone(coneHeight, coneRadius, (Tuple3DReadOnly)new Point3D(0.0, length, 0.0), (Orientation3DReadOnly)new AxisAngle(1.0, 0.0, 0.0, -1.5707963267948966), Color.GREEN);
            meshBuilder.addCylinder(length, radius, (Tuple3DReadOnly)new Point3D(), (Orientation3DReadOnly)new AxisAngle(), Color.BLUE);
            meshBuilder.addCone(coneHeight, coneRadius, (Tuple3DReadOnly)new Point3D(0.0, 0.0, length), (Orientation3DReadOnly)new AxisAngle(), Color.BLUE);
        }, "coordinateFrame");
    }

    public static ModelInstance createSphere(float radius, Color color) {
        return GDXModelPrimitives.createSphere(radius, color, "sphere");
    }

    public static ModelInstance createSphere(float radius, Color color, String nodeName) {
        return GDXModelPrimitives.buildModelInstance(meshBuilder -> meshBuilder.addSphere(radius, color), nodeName);
    }

    public static ModelInstance createBox(float lx, float ly, float lz, Color color) {
        return GDXModelPrimitives.buildModelInstance(meshBuilder -> meshBuilder.addBox(lx, ly, lz, color), "box");
    }

    public static ModelInstance createArrow(double length, Color color) {
        return GDXModelPrimitives.buildModelInstance(meshBuilder -> {
            double coneHeight = 0.1 * length;
            double cylinderLength = length - coneHeight;
            double cylinderRadius = cylinderLength / 20.0;
            double coneRadius = 1.5 * cylinderRadius;
            meshBuilder.addCylinder(cylinderLength, cylinderRadius, (Tuple3DReadOnly)new Point3D(), (Orientation3DReadOnly)new AxisAngle(0.0, 1.0, 0.0, 1.5707963267948966), color);
            meshBuilder.addCone(coneHeight, coneRadius, (Tuple3DReadOnly)new Point3D(cylinderLength, 0.0, 0.0), (Orientation3DReadOnly)new AxisAngle(0.0, 1.0, 0.0, 1.5707963267948966), color);
        }, "arrow");
    }

    public static ModelInstance createPose(double radius, Color color) {
        return GDXModelPrimitives.buildModelInstance(meshBuilder -> {
            double cylinderLength = radius * 6.0;
            double cylinderRadius = cylinderLength / 20.0;
            double coneHeight = 0.1 * cylinderLength;
            double coneRadius = 1.5 * cylinderRadius;
            meshBuilder.addCylinder(cylinderLength, cylinderRadius, (Tuple3DReadOnly)new Point3D(), (Orientation3DReadOnly)new AxisAngle(0.0, 1.0, 0.0, 1.5707963267948966), color);
            meshBuilder.addCone(coneHeight, coneRadius, (Tuple3DReadOnly)new Point3D(cylinderLength, 0.0, 0.0), (Orientation3DReadOnly)new AxisAngle(0.0, 1.0, 0.0, 1.5707963267948966), color);
            meshBuilder.addSphere((float)radius, color);
        }, "arrow");
    }
}

