/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.gdx.simulation;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Camera;
import com.badlogic.gdx.graphics.PerspectiveCamera;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.g3d.ModelBatch;
import com.badlogic.gdx.graphics.glutils.SensorFrameBuffer;
import com.badlogic.gdx.graphics.glutils.SensorFrameBufferBuilder;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.utils.BufferUtils;
import com.badlogic.gdx.utils.viewport.ScreenViewport;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import us.ihmc.gdx.imgui.ImGuiTools;
import us.ihmc.gdx.imgui.ImGuiVideoPanel;
import us.ihmc.gdx.sceneManager.GDX3DSceneManager;
import us.ihmc.gdx.sceneManager.GDXSceneLevel;
import us.ihmc.tools.Timer;
import us.ihmc.tools.UnitConversions;

public class GDXLowLevelImageSensorSimulator {
    private final String colorWindowName;
    private final float fieldOfViewY;
    private final int imageWidth;
    private final int imageHeight;
    private final float minRange;
    private final float maxRange;
    private final double updatePeriod;
    private final Timer throttleTimer = new Timer();
    private PerspectiveCamera camera;
    private ModelBatch modelBatch;
    private ScreenViewport viewport;
    private SensorFrameBuffer frameBuffer;
    private final ImGuiVideoPanel colorPanel;
    private ByteBuffer rawColorByteBuffer;
    private IntBuffer rawColorIntBuffer;

    public GDXLowLevelImageSensorSimulator(String sensorName, double fieldOfViewY, int imageWidth, int imageHeight, double minRange, double maxRange) {
        this.colorWindowName = ImGuiTools.uniqueLabel(sensorName + " Color");
        this.fieldOfViewY = (float)fieldOfViewY;
        this.imageWidth = imageWidth;
        this.imageHeight = imageHeight;
        this.minRange = (float)minRange;
        this.maxRange = (float)maxRange;
        this.updatePeriod = UnitConversions.hertzToSeconds((double)30.0);
        this.colorPanel = new ImGuiVideoPanel(this.colorWindowName, true);
    }

    public void create() {
        this.throttleTimer.reset();
        this.camera = new PerspectiveCamera(this.fieldOfViewY, (float)this.imageWidth, (float)this.imageHeight);
        this.camera.near = this.minRange;
        this.camera.far = this.maxRange * 2.0f;
        this.viewport = new ScreenViewport((Camera)this.camera);
        this.modelBatch = new ModelBatch();
        SensorFrameBufferBuilder frameBufferBuilder = new SensorFrameBufferBuilder(this.imageWidth, this.imageHeight);
        frameBufferBuilder.addBasicColorTextureAttachment(Pixmap.Format.RGBA8888);
        frameBufferBuilder.addDepthTextureAttachment(36012, 5126);
        this.frameBuffer = frameBufferBuilder.build();
        this.rawColorByteBuffer = BufferUtils.newByteBuffer((int)(this.imageWidth * this.imageHeight * 4));
        this.rawColorIntBuffer = this.rawColorByteBuffer.asIntBuffer();
        this.colorPanel.setTexture(this.frameBuffer.getColorTexture());
    }

    public void render(GDX3DSceneManager sceneManager) {
        boolean updateThisTick = this.throttleTimer.isExpired(this.updatePeriod);
        if (!updateThisTick) {
            return;
        }
        this.throttleTimer.reset();
        this.frameBuffer.begin();
        float clear = 0.0f;
        Gdx.gl.glClearColor(clear, clear, clear, 1.0f);
        Gdx.gl.glClear(16384);
        this.viewport.update(this.imageWidth, this.imageHeight);
        this.modelBatch.begin((Camera)this.camera);
        Gdx.gl.glViewport(0, 0, this.imageWidth, this.imageHeight);
        sceneManager.renderRegisteredObjectsWithEnvironment(this.modelBatch, GDXSceneLevel.REAL_ENVIRONMENT);
        this.modelBatch.end();
        Gdx.gl.glPixelStorei(3333, 1);
        this.rawColorByteBuffer.rewind();
        Gdx.gl.glReadPixels(0, 0, this.imageWidth, this.imageHeight, 6408, 5121, (Buffer)this.rawColorByteBuffer);
        this.frameBuffer.end();
    }

    public void dispose() {
        this.frameBuffer.dispose();
        this.modelBatch.dispose();
    }

    public void setCameraWorldTransform(Matrix4 worldTransform) {
        this.camera.position.setZero();
        this.camera.up.set(0.0f, 0.0f, 1.0f);
        this.camera.direction.set(1.0f, 0.0f, 0.0f);
        this.camera.transform(worldTransform);
    }

    public PerspectiveCamera getCamera() {
        return this.camera;
    }

    public IntBuffer getColorRGB8Buffer() {
        return this.rawColorIntBuffer;
    }

    public ByteBuffer getRawColorByteBuffer() {
        return this.rawColorByteBuffer;
    }

    public Pixmap getColorPixmap() {
        return this.frameBuffer.getColorPixmap();
    }

    public float getMaxRange() {
        return this.maxRange;
    }

    public ImGuiVideoPanel getColorPanel() {
        return this.colorPanel;
    }
}

