/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.gdx.sceneManager;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.InputMultiplexer;
import com.badlogic.gdx.InputProcessor;
import com.badlogic.gdx.graphics.Camera;
import com.badlogic.gdx.graphics.g3d.Environment;
import com.badlogic.gdx.graphics.g3d.Model;
import com.badlogic.gdx.graphics.g3d.ModelBatch;
import com.badlogic.gdx.graphics.g3d.ModelInstance;
import com.badlogic.gdx.graphics.g3d.RenderableProvider;
import com.badlogic.gdx.graphics.g3d.shaders.DefaultShader;
import com.badlogic.gdx.graphics.g3d.utils.DefaultShaderProvider;
import com.badlogic.gdx.graphics.g3d.utils.ShaderProvider;
import com.badlogic.gdx.graphics.profiling.GLProfiler;
import com.badlogic.gdx.utils.viewport.ScreenViewport;
import java.util.HashSet;
import us.ihmc.commons.exception.DefaultExceptionHandler;
import us.ihmc.commons.exception.ExceptionHandler;
import us.ihmc.commons.exception.ExceptionTools;
import us.ihmc.gdx.FocusBasedGDXCamera;
import us.ihmc.gdx.input.GDXInputMode;
import us.ihmc.gdx.sceneManager.GDX3DSceneTools;
import us.ihmc.gdx.sceneManager.GDXRenderable;
import us.ihmc.gdx.sceneManager.GDXSceneLevel;
import us.ihmc.gdx.tools.GDXModelPrimitives;
import us.ihmc.gdx.tools.GDXTools;
import us.ihmc.log.LogTools;

public class GDX3DSceneManager {
    private InputMultiplexer inputMultiplexer;
    private FocusBasedGDXCamera camera3D;
    private Environment environment;
    private ScreenViewport viewport;
    private ModelBatch modelBatch;
    private int x = 0;
    private int y = 0;
    private int width = -1;
    private int height = -1;
    private final HashSet<ModelInstance> modelInstances = new HashSet();
    private final HashSet<GDXRenderable> renderables = new HashSet();
    private boolean firstRenderStarted = false;
    private boolean addFocusSphere = true;

    public void create() {
        this.create(GDXInputMode.libGDX);
    }

    public void create(GDXInputMode inputMode) {
        new GLProfiler(Gdx.graphics).enable();
        GDXTools.syncLogLevelWithLogTools();
        this.environment = GDX3DSceneTools.createDefaultEnvironment();
        DefaultShader.Config defaultShaderConfig = new DefaultShader.Config();
        this.modelBatch = new ModelBatch((ShaderProvider)new DefaultShaderProvider(defaultShaderConfig));
        if (inputMode == GDXInputMode.libGDX) {
            this.inputMultiplexer = new InputMultiplexer();
            Gdx.input.setInputProcessor((InputProcessor)this.inputMultiplexer);
        }
        this.camera3D = new FocusBasedGDXCamera();
        if (inputMode == GDXInputMode.libGDX) {
            this.inputMultiplexer.addProcessor(this.camera3D.setInputForLibGDX());
        }
        if (this.addFocusSphere) {
            this.addModelInstance(this.camera3D.getFocusPointSphere(), GDXSceneLevel.VIRTUAL);
        }
        this.viewport = new ScreenViewport((Camera)this.camera3D);
        this.viewport.setUnitsPerPixel(1.0f);
        GDX3DSceneTools.glClearGray();
        Gdx.gl.glEnable(3553);
    }

    public void renderBefore() {
        this.renderBefore(GDXSceneLevel.VIRTUAL);
    }

    public void renderBefore(GDXSceneLevel sceneLevel) {
        if (!this.firstRenderStarted) {
            this.firstRenderStarted = true;
            LogTools.info((String)"Starting first render.");
        }
        if (this.width < 0) {
            this.width = this.getCurrentWindowWidth();
        }
        if (this.height < 0) {
            this.height = this.getCurrentWindowHeight();
        }
        this.viewport.update(this.width, this.height);
        this.modelBatch.begin((Camera)this.camera3D);
        Gdx.gl.glViewport(this.x, this.y, this.width, this.height);
        GDX3DSceneTools.glClearGray();
        this.renderRegisteredObjectsWithEnvironment(this.modelBatch, sceneLevel);
    }

    public void renderRegisteredObjectsWithEnvironment(ModelBatch modelBatch) {
        this.renderRegisteredObjectsWithEnvironment(modelBatch, GDXSceneLevel.VIRTUAL);
    }

    public void renderRegisteredObjectsWithEnvironment(ModelBatch modelBatch, GDXSceneLevel sceneLevel) {
        this.environment = GDX3DSceneTools.createDefaultEnvironment();
        for (GDXRenderable renderable : this.renderables) {
            if (sceneLevel.ordinal() < renderable.getSceneType().ordinal()) continue;
            modelBatch.render(renderable.getRenderableProvider(), this.environment);
        }
    }

    public void renderAfter() {
        this.modelBatch.end();
    }

    public void renderToCamera(Camera camera) {
        this.modelBatch.begin(camera);
        this.renderRegisteredObjectsWithEnvironment(this.modelBatch);
        this.renderAfter();
    }

    public void render() {
        this.render(GDXSceneLevel.VIRTUAL);
    }

    public void render(GDXSceneLevel sceneLevel) {
        this.renderBefore(sceneLevel);
        this.renderAfter();
    }

    public void dispose() {
        for (ModelInstance modelInstance : this.modelInstances) {
            ExceptionTools.handle(() -> ((Model)modelInstance.model).dispose(), (ExceptionHandler)DefaultExceptionHandler.PRINT_MESSAGE);
        }
        ExceptionTools.handle(() -> this.camera3D.dispose(), (ExceptionHandler)DefaultExceptionHandler.PRINT_MESSAGE);
        this.modelBatch.dispose();
    }

    public boolean closeRequested() {
        return true;
    }

    public void addModelInstance(ModelInstance modelInstance) {
        this.addModelInstance(modelInstance, GDXSceneLevel.REAL_ENVIRONMENT);
    }

    public void addModelInstance(ModelInstance modelInstance, GDXSceneLevel sceneLevel) {
        this.addRenderableProvider((RenderableProvider)modelInstance, sceneLevel);
        this.modelInstances.add(modelInstance);
    }

    public void addCoordinateFrame(double size) {
        this.addModelInstance(GDXModelPrimitives.createCoordinateFrameInstance(size), GDXSceneLevel.VIRTUAL);
    }

    public void addRenderableProvider(RenderableProvider renderableProvider) {
        this.addRenderableProvider(renderableProvider, GDXSceneLevel.REAL_ENVIRONMENT);
    }

    public void addRenderableProvider(RenderableProvider renderableProvider, GDXSceneLevel sceneLevel) {
        this.renderables.add(new GDXRenderable(renderableProvider, sceneLevel));
    }

    public void setViewportBoundsToWindow() {
        this.setViewportBounds(0, 0, Gdx.graphics.getWidth(), Gdx.graphics.getHeight());
    }

    public void setViewportBounds(int x, int y, int width, int height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
    }

    public int getCurrentWindowWidth() {
        return Gdx.graphics.getWidth();
    }

    public int getCurrentWindowHeight() {
        return Gdx.graphics.getHeight();
    }

    public FocusBasedGDXCamera getCamera3D() {
        return this.camera3D;
    }

    public void addLibGDXInputProcessor(InputProcessor inputProcessor) {
        if (this.inputMultiplexer != null) {
            this.inputMultiplexer.addProcessor(inputProcessor);
        } else {
            LogTools.error((int)1, (Object)"libGDX is not being used for input!");
        }
    }

    public ModelBatch getModelBatch() {
        return this.modelBatch;
    }

    public Environment getEnvironment() {
        return this.environment;
    }

    public void setAddFocusSphere(boolean addFocusSphere) {
        this.addFocusSphere = addFocusSphere;
    }
}

