/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.gdx.input;

import imgui.internal.ImGui;

public class ImGuiMouseDragData {
    private final int button;
    private boolean dragging = false;
    private float dragBucketX;
    private float dragBucketY;
    private float mouseDraggedX = 0.0f;
    private float mouseDraggedY = 0.0f;

    public ImGuiMouseDragData(int button) {
        this.button = button;
    }

    public void update(boolean isWindowHovered) {
        boolean mouseDown = ImGui.getIO().getMouseDown(this.button);
        float mouseDragDeltaX = ImGui.getMouseDragDeltaX((int)this.button);
        float mouseDragDeltaY = ImGui.getMouseDragDeltaY((int)this.button);
        if (!mouseDown) {
            this.dragging = false;
        } else if (isWindowHovered && !this.dragging) {
            this.dragging = true;
            this.dragBucketX = 0.0f;
            this.dragBucketY = 0.0f;
        }
        if (this.dragging) {
            this.mouseDraggedX = mouseDragDeltaX - this.dragBucketX;
            this.mouseDraggedY = mouseDragDeltaY - this.dragBucketY;
            this.dragBucketX += this.mouseDraggedX;
            this.dragBucketY += this.mouseDraggedY;
        }
    }

    public boolean isDragging() {
        return this.dragging;
    }

    public float getMouseDraggedX() {
        return this.mouseDraggedX;
    }

    public float getMouseDraggedY() {
        return this.mouseDraggedY;
    }
}

