/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.gdx.input;

import com.badlogic.gdx.math.Vector3;
import imgui.internal.ImGui;
import java.util.function.Supplier;
import us.ihmc.euclid.geometry.Line3D;
import us.ihmc.euclid.geometry.interfaces.Line3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.gdx.FocusBasedGDXCamera;
import us.ihmc.gdx.imgui.ImGuiTools;
import us.ihmc.gdx.input.ImGuiMouseDragData;
import us.ihmc.gdx.tools.GDXTools;

public class ImGui3DViewInput {
    private final FocusBasedGDXCamera camera;
    private final Supplier<Float> viewportSizeXSupplier;
    private final Supplier<Float> viewportSizeYSupplier;
    private final ImGuiMouseDragData mouseDragDataLeft = new ImGuiMouseDragData(0);
    private final ImGuiMouseDragData mouseDragDataRight = new ImGuiMouseDragData(1);
    private final ImGuiMouseDragData mouseDragDataMiddle = new ImGuiMouseDragData(2);
    private final ImGuiMouseDragData[] mouseDragData = new ImGuiMouseDragData[]{this.mouseDragDataLeft, this.mouseDragDataRight, this.mouseDragDataMiddle};
    private float mousePosX = 0.0f;
    private float mousePosY = 0.0f;
    private boolean isWindowHovered;
    private float mouseWheelDelta;
    private final Vector3 gdxOrigin = new Vector3();
    private final Vector3 gdxDirection = new Vector3();
    private final Line3D pickRayInWorld = new Line3D();
    private boolean computedPickRay = false;

    public ImGui3DViewInput(FocusBasedGDXCamera camera, Supplier<Float> viewportSizeXSupplier, Supplier<Float> viewportSizeYSupplier) {
        this.camera = camera;
        this.viewportSizeXSupplier = viewportSizeXSupplier;
        this.viewportSizeYSupplier = viewportSizeYSupplier;
    }

    public void compute() {
        this.computedPickRay = false;
        this.isWindowHovered = ImGui.isWindowHovered();
        this.mousePosX = (int)ImGui.getMousePosX() - (int)ImGui.getWindowPosX();
        this.mousePosY = (int)ImGui.getMousePosY() - (int)ImGui.getWindowPosY() - (int)ImGuiTools.TAB_BAR_HEIGHT;
        this.mouseWheelDelta = -ImGui.getIO().getMouseWheel();
        for (ImGuiMouseDragData mouseDragDatum : this.mouseDragData) {
            mouseDragDatum.update(this.isWindowHovered);
        }
    }

    public Line3DReadOnly getPickRayInWorld() {
        if (!this.computedPickRay) {
            this.computedPickRay = true;
            float viewportWidth = this.viewportSizeXSupplier.get().floatValue();
            float viewportHeight = this.viewportSizeYSupplier.get().floatValue();
            float viewportX = 2.0f * this.getMousePosX() / viewportWidth - 1.0f;
            float viewportY = 2.0f * (viewportHeight - this.getMousePosY()) / viewportHeight - 1.0f;
            this.gdxOrigin.set(viewportX, viewportY, -1.0f);
            this.gdxOrigin.prj(this.camera.invProjectionView);
            this.gdxDirection.set(viewportX, viewportY, 1.0f);
            this.gdxDirection.prj(this.camera.invProjectionView);
            this.gdxDirection.sub(this.gdxOrigin).nor();
            GDXTools.toEuclid(this.gdxOrigin, this.pickRayInWorld.getPoint());
            GDXTools.toEuclid(this.gdxDirection, (Vector3DBasics)this.pickRayInWorld.getDirection());
        }
        return this.pickRayInWorld;
    }

    public boolean mouseReleasedWithoutDrag(int button) {
        return ImGui.getMouseDragDeltaX() == 0.0f && ImGui.getMouseDragDeltaX() == 0.0f && ImGui.isMouseReleased((int)button);
    }

    public boolean isWindowHovered() {
        return this.isWindowHovered;
    }

    public boolean isDragging(int imGuiMouseButton) {
        return this.mouseDragData[imGuiMouseButton].isDragging();
    }

    public float getMouseDraggedX(int imGuiMouseButton) {
        return this.mouseDragData[imGuiMouseButton].getMouseDraggedX();
    }

    public float getMouseDraggedY(int imGuiMouseButton) {
        return this.mouseDragData[imGuiMouseButton].getMouseDraggedY();
    }

    public float getMousePosX() {
        return this.mousePosX;
    }

    public float getMousePosY() {
        return this.mousePosY;
    }

    public float getMouseWheelDelta() {
        return this.mouseWheelDelta;
    }
}

