/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.gdx.imgui;

import imgui.internal.ImGui;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicInteger;
import us.ihmc.gdx.imgui.ImGuiTools;

public class ImGuiMovingPlot {
    private static final AtomicInteger ID = new AtomicInteger();
    private final String name;
    private final int bufferSize;
    private final float[] valuesA;
    private final float[] valuesB;
    private boolean isA = true;
    private final int width;
    private final int height;
    private float nextValue = Float.NaN;
    private boolean renderValueText = true;

    public ImGuiMovingPlot(String name) {
        this(name, 1000);
    }

    public ImGuiMovingPlot(String name, int bufferSize) {
        this(name, bufferSize, 230, 50);
    }

    public ImGuiMovingPlot(String name, int bufferSize, int width, int height) {
        this.name = ImGuiTools.uniqueLabel(this.getClass().getSimpleName() + ID.getAndIncrement(), name);
        this.bufferSize = bufferSize;
        this.valuesA = new float[bufferSize];
        this.valuesB = new float[bufferSize];
        this.width = width;
        this.height = height;
        Arrays.fill(this.valuesA, Float.NaN);
        Arrays.fill(this.valuesB, Float.NaN);
    }

    public void setRenderValueText(boolean renderValueText) {
        this.renderValueText = renderValueText;
    }

    public void setNextValue(float newValue) {
        this.nextValue = newValue;
    }

    public void calculate(float newValue) {
        this.setNextValue(newValue);
        this.calculate();
    }

    public void calculate() {
        String valueText = "";
        if (this.renderValueText) {
            valueText = valueText + this.nextValue;
        }
        this.calculate(valueText, true);
    }

    public void calculate(String valueText) {
        this.calculate(valueText, true);
    }

    public void calculate(String valueText, boolean render) {
        System.arraycopy(this.isA ? this.valuesB : this.valuesA, 1, this.isA ? this.valuesA : this.valuesB, 0, this.bufferSize - 1);
        float[] values = this.isA ? this.valuesA : this.valuesB;
        this.isA = !this.isA;
        values[this.bufferSize - 1] = this.nextValue;
        if (render) {
            ImGui.plotLines((String)this.name, (float[])values, (int)this.bufferSize, (int)0, (String)valueText, (float)Float.MAX_VALUE, (float)Float.MAX_VALUE, (float)this.width, (float)this.height);
        }
        this.setNextValue(Float.NaN);
    }
}

