/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.gdx;

import com.badlogic.gdx.graphics.g3d.Renderable;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Pool;
import java.util.ArrayList;
import us.ihmc.euclid.transform.AffineTransform;
import us.ihmc.euclid.transform.interfaces.AffineTransformReadOnly;
import us.ihmc.gdx.GDXGraphicsObject;
import us.ihmc.graphicsDescription.appearance.AppearanceDefinition;
import us.ihmc.graphicsDescription.structure.Graphics3DNode;

public class GDXGraphics3DNode {
    private final Graphics3DNode graphicsNode;
    private final GDXGraphicsObject gdxGraphicsObject;
    private final ArrayList<GDXGraphics3DNode> children = new ArrayList();
    private final AffineTransform tempTransform = new AffineTransform();

    public GDXGraphics3DNode(Graphics3DNode graphicsNode) {
        this(graphicsNode, null);
    }

    public GDXGraphics3DNode(Graphics3DNode graphicsNode, AppearanceDefinition appearance) {
        this.graphicsNode = graphicsNode;
        this.gdxGraphicsObject = new GDXGraphicsObject(graphicsNode.getGraphics3DObject(), appearance);
    }

    public void update() {
        this.tempTransform.setIdentity();
        this.updateInternal(this.tempTransform);
    }

    private void updateInternal(AffineTransform parentTransform) {
        this.tempTransform.set(parentTransform);
        this.tempTransform.multiply((AffineTransformReadOnly)this.graphicsNode.getTransform());
        this.gdxGraphicsObject.setWorldTransform(this.tempTransform);
        for (GDXGraphics3DNode child : this.children) {
            child.updateInternal(this.tempTransform);
        }
    }

    public void addChild(GDXGraphics3DNode child) {
        this.children.add(child);
    }

    public void getRenderables(Array<Renderable> renderables, Pool<Renderable> pool) {
        for (GDXGraphics3DNode child : this.children) {
            child.getRenderables(renderables, pool);
        }
        this.gdxGraphicsObject.getRenderables(renderables, pool);
    }

    public void destroy() {
        for (GDXGraphics3DNode child : this.children) {
            child.destroy();
        }
        this.gdxGraphicsObject.destroy();
    }
}

