/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.gdx;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.InputAdapter;
import com.badlogic.gdx.InputProcessor;
import com.badlogic.gdx.graphics.Camera;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Mesh;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g3d.Attribute;
import com.badlogic.gdx.graphics.g3d.Material;
import com.badlogic.gdx.graphics.g3d.Model;
import com.badlogic.gdx.graphics.g3d.ModelInstance;
import com.badlogic.gdx.graphics.g3d.attributes.ColorAttribute;
import com.badlogic.gdx.graphics.g3d.attributes.TextureAttribute;
import com.badlogic.gdx.graphics.g3d.model.MeshPart;
import com.badlogic.gdx.graphics.g3d.model.Node;
import com.badlogic.gdx.graphics.g3d.utils.ModelBuilder;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Vector3;
import imgui.internal.ImGui;
import us.ihmc.commons.MathTools;
import us.ihmc.euclid.Axis3D;
import us.ihmc.euclid.axisAngle.AxisAngle;
import us.ihmc.euclid.matrix.RotationMatrix;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.FramePose3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.tools.EuclidCoreTools;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.gdx.input.ImGui3DViewInput;
import us.ihmc.gdx.mesh.GDXMultiColorMeshBuilder;

public class FocusBasedGDXCamera
extends Camera {
    private final FramePose3D cameraPose = new FramePose3D();
    private final Vector3D euclidDirection = new Vector3D();
    private final Vector3D euclidUp = new Vector3D();
    private final AxisAngle latitudeAxisAngle = new AxisAngle();
    private final AxisAngle longitudeAxisAngle = new AxisAngle();
    private final AxisAngle rollAxisAngle = new AxisAngle();
    private final AxisAngle focusPointAxisAngle = new AxisAngle();
    private final RotationMatrix cameraOrientationOffset = new RotationMatrix();
    private float fieldOfView = 45.0f;
    private double zoomSpeedFactor = 0.1;
    private double latitudeSpeed = 0.005;
    private double longitudeSpeed = 0.005;
    private double translateSpeedFactor = 0.5;
    private final FramePose3D focusPointPose = new FramePose3D();
    private double latitude = 0.0;
    private double longitude = 0.0;
    private double roll;
    private double zoom = 10.0;
    private final Model focusPointModel;
    private final ModelInstance focusPointSphere;
    private final Vector3D cameraOffsetUp;
    private final Vector3D cameraOffsetForward;
    private final Vector3D cameraOffsetLeft;
    private final Vector3D cameraOffsetDown;
    private boolean libGDXInputMode = false;
    private boolean isWPressed = false;
    private boolean isAPressed = false;
    private boolean isSPressed = false;
    private boolean isDPressed = false;
    private boolean isQPressed = false;
    private boolean isZPressed = false;
    final Vector3 tmp = new Vector3();

    public FocusBasedGDXCamera() {
        this.viewportWidth = Gdx.graphics.getWidth();
        this.viewportHeight = Gdx.graphics.getHeight();
        this.near = 0.05f;
        this.far = 2000.0f;
        this.cameraOffsetUp = new Vector3D(0.0, 0.0, 1.0);
        this.cameraOffsetForward = new Vector3D(1.0, 0.0, 0.0);
        this.cameraOffsetLeft = new Vector3D();
        this.cameraOffsetLeft.cross((Tuple3DReadOnly)this.cameraOffsetUp, (Tuple3DReadOnly)this.cameraOffsetForward);
        this.cameraOffsetDown = new Vector3D();
        this.cameraOffsetDown.setAndNegate((Tuple3DReadOnly)this.cameraOffsetUp);
        Vector3D cameraZAxis = new Vector3D((Tuple3DReadOnly)this.cameraOffsetForward);
        Vector3D cameraYAxis = new Vector3D((Tuple3DReadOnly)this.cameraOffsetUp);
        Vector3D cameraXAxis = new Vector3D();
        cameraXAxis.cross((Tuple3DReadOnly)cameraYAxis, (Tuple3DReadOnly)cameraZAxis);
        this.cameraOrientationOffset.setColumns((Tuple3DReadOnly)cameraXAxis, (Tuple3DReadOnly)cameraYAxis, (Tuple3DReadOnly)cameraZAxis);
        ModelBuilder modelBuilder = new ModelBuilder();
        modelBuilder.begin();
        modelBuilder.node().id = "focusPointSphere";
        GDXMultiColorMeshBuilder meshBuilder = new GDXMultiColorMeshBuilder();
        meshBuilder.addSphere(1.0f, (Tuple3DReadOnly)new Point3D(0.0, 0.0, 0.0), new Color(0.54509807f, 0.0f, 0.0f, 1.0f));
        Mesh mesh = meshBuilder.generateMesh();
        MeshPart meshPart = new MeshPart("xyz", mesh, 0, mesh.getNumIndices(), 4);
        Material material = new Material();
        Texture paletteTexture = GDXMultiColorMeshBuilder.loadPaletteTexture();
        material.set((Attribute)TextureAttribute.createDiffuse((Texture)paletteTexture));
        material.set((Attribute)ColorAttribute.createDiffuse((Color)Color.WHITE));
        modelBuilder.part(meshPart, material);
        this.focusPointModel = modelBuilder.end();
        this.focusPointSphere = new ModelInstance(this.focusPointModel);
        this.changeCameraPosition(-2.0, 0.7, 1.0);
        this.updateCameraPose();
        this.update(true);
    }

    public InputProcessor setInputForLibGDX() {
        this.libGDXInputMode = true;
        return new InputAdapter(){
            int lastDragX = 0;
            int lastDragY = 0;

            public boolean scrolled(float amountX, float amountY) {
                FocusBasedGDXCamera.this.scrolled(amountY);
                return false;
            }

            public boolean touchDown(int screenX, int screenY, int pointer, int button) {
                this.lastDragX = screenX;
                this.lastDragY = screenY;
                return false;
            }

            public boolean touchDragged(int screenX, int screenY, int pointer) {
                int deltaX = screenX - this.lastDragX;
                int deltaY = screenY - this.lastDragY;
                this.lastDragX = screenX;
                this.lastDragY = screenY;
                if (Gdx.input.isButtonPressed(0)) {
                    FocusBasedGDXCamera.this.mouseDragged(deltaX, deltaY);
                }
                return false;
            }
        };
    }

    public ModelInstance getFocusPointSphere() {
        return this.focusPointSphere;
    }

    public void changeCameraPosition(double x, double y, double z) {
        Point3D desiredCameraPosition = new Point3D(x, y, z);
        this.zoom = desiredCameraPosition.distance((Point3DReadOnly)this.focusPointPose.getPosition());
        Vector3D fromFocusToCamera = new Vector3D();
        fromFocusToCamera.sub((Tuple3DReadOnly)desiredCameraPosition, (Tuple3DReadOnly)this.focusPointPose.getPosition());
        fromFocusToCamera.normalize();
        Vector3D fromCameraToFocus = new Vector3D();
        fromCameraToFocus.setAndNegate((Tuple3DReadOnly)fromFocusToCamera);
        fromCameraToFocus.scaleAdd(-fromCameraToFocus.dot((Vector3DReadOnly)this.cameraOffsetDown), (Tuple3DReadOnly)this.cameraOffsetDown, (Tuple3DReadOnly)fromCameraToFocus);
        this.latitude = 1.5707963267948966 - fromFocusToCamera.angle((Vector3DReadOnly)this.cameraOffsetDown);
        this.longitude = fromCameraToFocus.angle((Vector3DReadOnly)this.cameraOffsetForward);
        Vector3D cross = new Vector3D();
        cross.cross((Tuple3DReadOnly)fromCameraToFocus, (Tuple3DReadOnly)this.cameraOffsetForward);
        if (cross.dot((Vector3DReadOnly)this.cameraOffsetDown) > 0.0) {
            this.longitude = -this.longitude;
        }
    }

    private void updateCameraPose() {
        this.zoom = MathTools.clamp((double)this.zoom, (double)0.1, (double)100.0);
        this.latitude = MathTools.clamp((double)this.latitude, (double)1.5707963267948966);
        this.longitude = EuclidCoreTools.trimAngleMinusPiToPi((double)this.longitude);
        this.roll = 0.0;
        this.latitudeAxisAngle.set((Vector3DReadOnly)Axis3D.X, -this.latitude);
        this.longitudeAxisAngle.set((Vector3DReadOnly)Axis3D.Y, -this.longitude);
        this.rollAxisAngle.set((Vector3DReadOnly)Axis3D.Z, this.roll);
        this.focusPointAxisAngle.set((Vector3DReadOnly)Axis3D.Z, -this.longitude);
        this.focusPointPose.changeFrame(ReferenceFrame.getWorldFrame());
        this.focusPointPose.getOrientation().set((Orientation3DReadOnly)this.focusPointAxisAngle);
        ((Node)this.focusPointSphere.nodes.get((int)0)).translation.set((float)this.focusPointPose.getX(), (float)this.focusPointPose.getY(), (float)this.focusPointPose.getZ());
        ((Node)this.focusPointSphere.nodes.get((int)0)).scale.set((float)(0.0035 * this.zoom), (float)(0.0035 * this.zoom), (float)(0.0035 * this.zoom));
        this.focusPointSphere.calculateTransforms();
        this.cameraPose.setToZero(ReferenceFrame.getWorldFrame());
        this.cameraPose.appendTranslation((FrameTuple3DReadOnly)this.focusPointPose.getPosition());
        this.cameraPose.appendRotation((Orientation3DReadOnly)this.cameraOrientationOffset);
        this.cameraPose.appendRotation((Orientation3DReadOnly)this.longitudeAxisAngle);
        this.cameraPose.appendRotation((Orientation3DReadOnly)this.latitudeAxisAngle);
        this.cameraPose.appendRotation((Orientation3DReadOnly)this.rollAxisAngle);
        this.cameraPose.appendTranslation(0.0, 0.0, -this.zoom);
        this.euclidDirection.set((Tuple3DReadOnly)Axis3D.Z);
        this.cameraPose.getOrientation().transform((Tuple3DBasics)this.euclidDirection);
        this.euclidUp.set((Tuple3DReadOnly)Axis3D.Y);
        this.cameraPose.getOrientation().transform((Tuple3DBasics)this.euclidUp);
        this.position.set(this.cameraPose.getPosition().getX32(), this.cameraPose.getPosition().getY32(), this.cameraPose.getPosition().getZ32());
        this.direction.set(this.euclidDirection.getX32(), this.euclidDirection.getY32(), this.euclidDirection.getZ32());
        this.up.set(this.euclidUp.getX32(), this.euclidUp.getY32(), this.euclidUp.getZ32());
    }

    public void processImGuiInput(ImGui3DViewInput input) {
        this.isWPressed = input.isWindowHovered() && ImGui.isKeyDown((int)87);
        this.isSPressed = input.isWindowHovered() && ImGui.isKeyDown((int)83);
        this.isAPressed = input.isWindowHovered() && ImGui.isKeyDown((int)65);
        this.isDPressed = input.isWindowHovered() && ImGui.isKeyDown((int)68);
        this.isQPressed = input.isWindowHovered() && ImGui.isKeyDown((int)81);
        boolean bl = this.isZPressed = input.isWindowHovered() && ImGui.isKeyDown((int)90);
        if (input.isDragging(0)) {
            this.mouseDragged(input.getMouseDraggedX(0), input.getMouseDraggedY(0));
        }
        if (input.isWindowHovered() && !ImGui.getIO().getKeyCtrl()) {
            this.scrolled(input.getMouseWheelDelta());
        }
    }

    private void mouseDragged(float deltaX, float deltaY) {
        this.latitude -= this.latitudeSpeed * (double)deltaY;
        this.longitude += this.longitudeSpeed * (double)deltaX;
    }

    private void scrolled(float amountY) {
        this.zoom += (double)Math.signum(amountY) * this.zoom * this.zoomSpeedFactor;
    }

    public void update() {
        float tpf = Gdx.app.getGraphics().getDeltaTime();
        if (this.libGDXInputMode) {
            this.isWPressed = Gdx.input.isKeyPressed(51);
            this.isSPressed = Gdx.input.isKeyPressed(47);
            this.isAPressed = Gdx.input.isKeyPressed(29);
            this.isDPressed = Gdx.input.isKeyPressed(32);
            this.isQPressed = Gdx.input.isKeyPressed(45);
            this.isZPressed = Gdx.input.isKeyPressed(54);
        }
        if (this.isWPressed) {
            this.focusPointPose.appendTranslation(this.getTranslateSpeedFactor() * (double)tpf, 0.0, 0.0);
        }
        if (this.isSPressed) {
            this.focusPointPose.appendTranslation(-this.getTranslateSpeedFactor() * (double)tpf, 0.0, 0.0);
        }
        if (this.isAPressed) {
            this.focusPointPose.appendTranslation(0.0, this.getTranslateSpeedFactor() * (double)tpf, 0.0);
        }
        if (this.isDPressed) {
            this.focusPointPose.appendTranslation(0.0, -this.getTranslateSpeedFactor() * (double)tpf, 0.0);
        }
        if (this.isQPressed) {
            this.focusPointPose.appendTranslation(0.0, 0.0, this.getTranslateSpeedFactor() * (double)tpf);
        }
        if (this.isZPressed) {
            this.focusPointPose.appendTranslation(0.0, 0.0, -this.getTranslateSpeedFactor() * (double)tpf);
        }
        this.updateCameraPose();
        this.update(true);
    }

    public void update(boolean updateFrustum) {
        float aspect = this.viewportWidth / this.viewportHeight;
        this.projection.setToProjection(Math.abs(this.near), Math.abs(this.far), this.fieldOfView, aspect);
        this.view.setToLookAt(this.position, this.tmp.set(this.position).add(this.direction), this.up);
        this.combined.set(this.projection);
        Matrix4.mul((float[])this.combined.val, (float[])this.view.val);
        if (updateFrustum) {
            this.invProjectionView.set(this.combined);
            Matrix4.inv((float[])this.invProjectionView.val);
            this.frustum.update(this.invProjectionView);
        }
    }

    public void dispose() {
        this.focusPointModel.dispose();
    }

    private double getTranslateSpeedFactor() {
        return this.translateSpeedFactor * this.zoom;
    }
}

