/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.tests.g3d.shadows.utils;

import com.badlogic.gdx.graphics.Camera;
import com.badlogic.gdx.graphics.g3d.Renderable;
import com.badlogic.gdx.graphics.g3d.RenderableProvider;
import com.badlogic.gdx.graphics.g3d.environment.BaseLight;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.math.collision.BoundingBox;
import com.badlogic.gdx.tests.g3d.shadows.utils.NearFarAnalyzer;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Pool;

public class AABBNearFarAnalyzer
implements NearFarAnalyzer {
    public static float CAMERA_NEAR = 1.0f;
    public static float CAMERA_FAR = 100.0f;
    protected final RenderablePool renderablesPool = new RenderablePool();
    protected final Array<Renderable> renderables = new Array();
    protected BoundingBox bb1 = new BoundingBox();
    protected Vector3 tmpV = new Vector3();

    @Override
    public <T extends RenderableProvider> void analyze(BaseLight light, Camera camera, Iterable<T> renderableProviders) {
        this.getRenderables(renderableProviders);
        this.prepareCamera(camera);
        this.bb1.inf();
        for (Renderable renderable : this.renderables) {
            renderable.worldTransform.getTranslation(this.tmpV);
            this.tmpV.add(renderable.meshPart.center);
            if (!camera.frustum.sphereInFrustum(this.tmpV, renderable.meshPart.radius)) continue;
            this.bb1.ext(this.tmpV, renderable.meshPart.radius);
        }
        this.computeResult(this.bb1, camera);
        this.renderablesPool.flush();
        this.renderables.clear();
    }

    protected <T extends RenderableProvider> void getRenderables(Iterable<T> renderableProviders) {
        for (RenderableProvider renderableProvider : renderableProviders) {
            renderableProvider.getRenderables(this.renderables, (Pool)this.renderablesPool);
        }
    }

    protected void prepareCamera(Camera camera) {
        camera.near = CAMERA_NEAR;
        camera.far = CAMERA_FAR;
        camera.update();
    }

    protected void computeResult(BoundingBox bb, Camera camera) {
        float radius = this.bb1.getDimensions(this.tmpV).len() * 0.5f;
        this.bb1.getCenter(this.tmpV);
        float distance = this.tmpV.dst(camera.position);
        float near = distance - radius;
        float far = distance + radius;
        if (near <= 0.0f) {
            near = CAMERA_NEAR;
        }
        if (far <= 0.0f) {
            far = CAMERA_FAR;
        }
        camera.near = near;
        camera.far = far;
        camera.update();
    }

    protected static class RenderablePool
    extends Pool<Renderable> {
        protected Array<Renderable> obtained = new Array();

        protected RenderablePool() {
        }

        protected Renderable newObject() {
            return new Renderable();
        }

        public Renderable obtain() {
            Renderable renderable = (Renderable)super.obtain();
            renderable.environment = null;
            renderable.material = null;
            renderable.meshPart.set("", null, 0, 0, 0);
            renderable.shader = null;
            this.obtained.add((Object)renderable);
            return renderable;
        }

        public void flush() {
            super.freeAll(this.obtained);
            this.obtained.clear();
        }
    }
}

