/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.tests.g3d.shadows.system.realistic;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Camera;
import com.badlogic.gdx.graphics.GLTexture;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.graphics.g3d.Attributes;
import com.badlogic.gdx.graphics.g3d.Environment;
import com.badlogic.gdx.graphics.g3d.Renderable;
import com.badlogic.gdx.graphics.g3d.attributes.DirectionalLightsAttribute;
import com.badlogic.gdx.graphics.g3d.attributes.SpotLightsAttribute;
import com.badlogic.gdx.graphics.g3d.environment.DirectionalLight;
import com.badlogic.gdx.graphics.g3d.environment.SpotLight;
import com.badlogic.gdx.graphics.g3d.shaders.BaseShader;
import com.badlogic.gdx.graphics.g3d.shaders.DefaultShader;
import com.badlogic.gdx.graphics.glutils.ShaderProgram;
import com.badlogic.gdx.tests.g3d.shadows.system.BaseShadowSystem;
import com.badlogic.gdx.tests.g3d.shadows.system.realistic.RealisticShadowSystem;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.ObjectMap;

public class MainShader
extends DefaultShader {
    protected final int u_dirShadows0uvTransform = this.register(new BaseShader.Uniform("u_dirShadows[0].uvTransform"));
    protected final int u_dirShadows1uvTransform = this.register(new BaseShader.Uniform("u_dirShadows[1].uvTransform"));
    protected int dirShadowsLoc;
    protected int dirShadowsUvTransformOffset;
    protected int dirShadowsSize;
    protected int u_dirShadowMapProjViewTrans0 = this.register(new BaseShader.Uniform("u_dirShadowMapProjViewTrans[0]"));
    protected int u_dirShadowMapProjViewTrans1 = this.register(new BaseShader.Uniform("u_dirShadowMapProjViewTrans[1]"));
    protected int dirShadowMapProjViewTransLoc;
    protected int dirShadowMapProjViewTransSize;
    protected int u_dirShadowMapUVTransform0 = this.register(new BaseShader.Uniform("u_dirShadowMapUVTransform[0]"));
    protected int u_dirShadowMapUVTransform1 = this.register(new BaseShader.Uniform("u_dirShadowMapUVTransform[1]"));
    protected int dirShadowMapUVTransformLoc;
    protected int dirShadowMapUVTransformSize;
    protected final int u_spotShadows0uvTransform = this.register(new BaseShader.Uniform("u_spotShadows[0].uvTransform"));
    protected final int u_spotShadows1uvTransform = this.register(new BaseShader.Uniform("u_spotShadows[1].uvTransform"));
    protected int spotShadowsLoc;
    protected int spotShadowsUvTransformOffset;
    protected int spotShadowsSize;
    protected int u_spotShadowMapProjViewTrans0 = this.register(new BaseShader.Uniform("u_spotShadowMapProjViewTrans[0]"));
    protected int u_spotShadowMapProjViewTrans1 = this.register(new BaseShader.Uniform("u_spotShadowMapProjViewTrans[1]"));
    protected int spotShadowMapProjViewTransLoc;
    protected int spotShadowMapProjViewTransSize;
    protected int u_spotShadowMapUVTransform0 = this.register(new BaseShader.Uniform("u_spotShadowMapUVTransform[0]"));
    protected int u_spotShadowMapUVTransform1 = this.register(new BaseShader.Uniform("u_spotShadowMapUVTransform[1]"));
    protected int spotShadowMapUVTransformLoc;
    protected int spotShadowMapUVTransformSize;
    protected RealisticShadowSystem shadowSystem;
    private static String defaultVertexShader = null;
    private static String defaultFragmentShader = null;

    public static String getDefaultVertexShader() {
        if (defaultVertexShader == null) {
            defaultVertexShader = Gdx.files.classpath("com/badlogic/gdx/tests/g3d/shadows/system/realistic/main.vertex.glsl").readString();
        }
        return defaultVertexShader;
    }

    public static String getDefaultFragmentShader() {
        if (defaultFragmentShader == null) {
            defaultFragmentShader = Gdx.files.classpath("com/badlogic/gdx/tests/g3d/shadows/system/realistic/main.fragment.glsl").readString();
        }
        return defaultFragmentShader;
    }

    public static String createPrefix(Renderable renderable, Config config) {
        return DefaultShader.createPrefix((Renderable)renderable, (DefaultShader.Config)config);
    }

    public MainShader(Renderable renderable, Config config) {
        this(renderable, config, MainShader.createPrefix(renderable, config));
    }

    public MainShader(Renderable renderable, Config config, String prefix) {
        this(renderable, config, prefix, MainShader.getDefaultVertexShader(), MainShader.getDefaultFragmentShader());
    }

    public MainShader(Renderable renderable, Config config, String prefix, String vertexShader, String fragmentShader) {
        this(renderable, config, new ShaderProgram(prefix + vertexShader, prefix + fragmentShader));
    }

    public MainShader(Renderable renderable, Config config, ShaderProgram shaderProgram) {
        super(renderable, (DefaultShader.Config)config, shaderProgram);
        this.shadowSystem = config.shadowSystem;
    }

    public void init() {
        super.init();
        this.dirShadowsLoc = this.loc(this.u_dirShadows0uvTransform);
        this.dirShadowsUvTransformOffset = this.loc(this.u_dirShadows0uvTransform) - this.dirShadowsLoc;
        this.dirShadowsSize = this.loc(this.u_dirShadows1uvTransform) - this.dirShadowsLoc;
        if (this.dirShadowsSize < 0) {
            this.dirShadowsSize = 0;
        }
        this.dirShadowMapProjViewTransLoc = this.loc(this.u_dirShadowMapProjViewTrans0);
        this.dirShadowMapProjViewTransSize = this.loc(this.u_dirShadowMapProjViewTrans1) - this.dirShadowMapProjViewTransLoc;
        this.dirShadowMapUVTransformLoc = this.loc(this.u_dirShadowMapUVTransform0);
        this.dirShadowMapUVTransformSize = this.loc(this.u_dirShadowMapUVTransform1) - this.dirShadowMapUVTransformLoc;
        this.spotShadowsLoc = this.loc(this.u_spotShadows0uvTransform);
        this.spotShadowsUvTransformOffset = this.loc(this.u_spotShadows0uvTransform) - this.spotShadowsLoc;
        this.spotShadowsSize = this.loc(this.u_spotShadows1uvTransform) - this.spotShadowsLoc;
        if (this.spotShadowsSize < 0) {
            this.spotShadowsSize = 0;
        }
        this.spotShadowMapProjViewTransLoc = this.loc(this.u_spotShadowMapProjViewTrans0);
        this.spotShadowMapProjViewTransSize = this.loc(this.u_spotShadowMapProjViewTrans1) - this.spotShadowMapProjViewTransLoc;
        this.spotShadowMapUVTransformLoc = this.loc(this.u_spotShadowMapUVTransform0);
        this.spotShadowMapUVTransformSize = this.loc(this.u_spotShadowMapUVTransform1) - this.spotShadowMapUVTransformLoc;
    }

    protected void bindLights(Renderable renderable, Attributes attributes) {
        super.bindLights(renderable, attributes);
        Environment environment = renderable.environment;
        this.bindDirectionalShadows(attributes);
        this.bindSpotShadows(attributes);
        if (this.shadowSystem.getTexture() != null) {
            this.set(this.u_shadowTexture, (GLTexture)this.shadowSystem.getTexture());
        }
    }

    public void bindDirectionalShadows(Attributes attributes) {
        Array dirs;
        DirectionalLightsAttribute dla = (DirectionalLightsAttribute)attributes.get(DirectionalLightsAttribute.class, DirectionalLightsAttribute.Type);
        Array array = dirs = dla == null ? null : dla.lights;
        if (this.dirLightsLoc >= 0) {
            for (int i = 0; i < this.directionalLights.length; ++i) {
                if (dirs == null || dirs.size <= i) continue;
                int idx = this.dirShadowsLoc + i * this.dirShadowsSize;
                ObjectMap<DirectionalLight, BaseShadowSystem.LightProperties> dirCameras = this.shadowSystem.getDirectionalCameras();
                DirectionalLight dl = (DirectionalLight)dirs.get(i);
                if (this.shadowSystem.hasLight(dl)) {
                    TextureRegion tr = ((BaseShadowSystem.LightProperties)dirCameras.get((Object)dl)).region;
                    Camera cam = ((BaseShadowSystem.LightProperties)dirCameras.get((Object)dl)).camera;
                    if (cam != null) {
                        this.program.setUniformf(idx + this.dirShadowsUvTransformOffset, tr.getU(), tr.getV(), tr.getU2() - tr.getU(), tr.getV2() - tr.getV());
                        idx = this.dirShadowMapProjViewTransLoc + i * this.dirShadowMapProjViewTransSize;
                        this.program.setUniformMatrix(idx, ((BaseShadowSystem.LightProperties)dirCameras.get((Object)dl)).camera.combined);
                    }
                }
                if (this.dirLightsSize <= 0) break;
            }
        }
    }

    public void bindSpotShadows(Attributes attributes) {
        Array spots;
        SpotLightsAttribute sla = (SpotLightsAttribute)attributes.get(SpotLightsAttribute.class, SpotLightsAttribute.Type);
        Array array = spots = sla == null ? null : sla.lights;
        if (this.spotLightsLoc >= 0) {
            for (int i = 0; i < this.spotLights.length; ++i) {
                if (spots == null || spots.size <= i) continue;
                int idx = this.spotShadowsLoc + i * this.spotShadowsSize;
                ObjectMap<SpotLight, BaseShadowSystem.LightProperties> spotCameras = this.shadowSystem.getSpotCameras();
                SpotLight sl = (SpotLight)spots.get(i);
                if (this.shadowSystem.hasLight(sl)) {
                    TextureRegion tr = ((BaseShadowSystem.LightProperties)spotCameras.get((Object)sl)).region;
                    Camera cam = ((BaseShadowSystem.LightProperties)spotCameras.get((Object)sl)).camera;
                    if (cam != null) {
                        this.program.setUniformf(idx + this.spotShadowsUvTransformOffset, tr.getU(), tr.getV(), tr.getU2() - tr.getU(), tr.getV2() - tr.getV());
                        idx = this.spotShadowMapProjViewTransLoc + i * this.spotShadowMapProjViewTransSize;
                        this.program.setUniformMatrix(idx, ((BaseShadowSystem.LightProperties)spotCameras.get((Object)sl)).camera.combined);
                    }
                }
                if (this.spotLightsSize <= 0) break;
            }
        }
    }

    public static class Config
    extends DefaultShader.Config {
        public RealisticShadowSystem shadowSystem;

        public Config(RealisticShadowSystem shadowSystem) {
            this.numBones = 12;
            this.numPointLights = 2;
            this.numSpotLights = 5;
            this.numDirectionalLights = 2;
            this.shadowSystem = shadowSystem;
        }
    }
}

