/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.tests.g3d.shadows.system;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.glutils.FrameBuffer;
import com.badlogic.gdx.tests.g3d.shadows.system.BaseShadowSystem;
import com.badlogic.gdx.tests.g3d.shadows.utils.DirectionalAnalyzer;
import com.badlogic.gdx.tests.g3d.shadows.utils.LightFilter;
import com.badlogic.gdx.tests.g3d.shadows.utils.NearFarAnalyzer;
import com.badlogic.gdx.tests.g3d.shadows.utils.ShadowMapAllocator;

public abstract class FirstPassBaseShadowSystem
extends BaseShadowSystem {
    protected static int FIRST_PASS = 0;

    public FirstPassBaseShadowSystem() {
    }

    public FirstPassBaseShadowSystem(NearFarAnalyzer nearFarAnalyzer, ShadowMapAllocator allocator, DirectionalAnalyzer directionalAnalyzer, LightFilter lightFilter) {
        super(nearFarAnalyzer, allocator, directionalAnalyzer, lightFilter);
    }

    @Override
    protected void init(int n) {
        if (n == FIRST_PASS) {
            this.init1();
        }
    }

    protected void init1() {
        this.frameBuffers[FirstPassBaseShadowSystem.FIRST_PASS] = new FrameBuffer(Pixmap.Format.RGBA8888, this.allocator.getWidth(), this.allocator.getHeight(), true);
    }

    @Override
    protected void beginPass(int n) {
        super.beginPass(n);
        if (n == FIRST_PASS) {
            this.beginPass1();
        }
    }

    protected void beginPass1() {
        this.allocator.begin();
        Gdx.gl.glClearColor(1.0f, 1.0f, 1.0f, 1.0f);
        Gdx.gl.glClear(16640);
        Gdx.gl.glEnable(3089);
    }

    @Override
    protected void endPass(int n) {
        super.endPass(n);
        if (n == FIRST_PASS) {
            this.endPass1();
        }
    }

    protected void endPass1() {
        this.allocator.end();
        Gdx.gl.glDisable(3089);
    }
}

