/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.graphicsDescription.yoGraphics;

import java.util.ArrayList;
import java.util.List;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.graphicsDescription.GraphicsUpdatable;
import us.ihmc.graphicsDescription.plotting.artifact.Artifact;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphic;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicsList;
import us.ihmc.graphicsDescription.yoGraphics.plotting.ArtifactList;
import us.ihmc.graphicsDescription.yoGraphics.plotting.PlotterInterface;
import us.ihmc.yoVariables.providers.DoubleProvider;

public class YoGraphicsListRegistry {
    private final ArrayList<YoGraphicsList> yoGraphicsLists = new ArrayList();
    private final ArrayList<ArtifactList> artifactLists = new ArrayList();
    private Object graphicsConch = null;
    private final List<GraphicsUpdatable> graphicsUpdatables = new ArrayList<GraphicsUpdatable>();
    private final List<GraphicsUpdatable> graphicsUpdatablesToUpdateInAPlaybackListener = new ArrayList<GraphicsUpdatable>();
    private boolean updateInSimulationThread = false;
    private boolean alreadyAddedToSimulationConstructionSet = false;
    private boolean alreadyAddedToPlotter = false;
    private final RigidBodyTransform rootTransform = new RigidBodyTransform();
    private final RigidBodyTransform simulatedRootToWorldTransform = new RigidBodyTransform();
    private final RigidBodyTransform controllerWorldToRootTransform = new RigidBodyTransform();

    public void setGlobalScaleProvider(DoubleProvider globalScaleProvider) {
        for (YoGraphicsList yoGraphicsList : this.yoGraphicsLists) {
            this.setGlobalScaleProvider(yoGraphicsList, globalScaleProvider);
        }
    }

    private void setGlobalScaleProvider(YoGraphicsList yoGraphicsList, DoubleProvider globalScaleProvider) {
        List<YoGraphic> yoGraphics = yoGraphicsList.getYoGraphics();
        for (YoGraphic yoGraphic : yoGraphics) {
            yoGraphic.setGlobalScaleProvider(globalScaleProvider);
        }
    }

    private void checkForRepeatNames(YoGraphicsList yoGraphicsList) {
        List<YoGraphic> yoGraphics = yoGraphicsList.getYoGraphics();
        for (YoGraphic yoGraphic : yoGraphics) {
            if (!this.doesNameExistInYoGraphicsList(yoGraphic.getName())) continue;
            throw new RuntimeException("Repeat Name: " + yoGraphic.getName() + " in YoGraphic!");
        }
    }

    private void checkForRepeatNames(ArtifactList artifactList) {
        List<Artifact> artifacts = artifactList.getArtifacts();
        for (Artifact artifact : artifacts) {
            if (!this.doesNameExistInArtifactLists(artifact.getID())) continue;
            throw new RuntimeException("Repeat Name: " + artifact.getID() + " in ArtifactList!");
        }
    }

    private boolean doesNameExistInYoGraphicsList(String nameToCheck) {
        for (YoGraphicsList yoGraphicsList : this.yoGraphicsLists) {
            List<YoGraphic> yoGraphics = yoGraphicsList.getYoGraphics();
            for (YoGraphic yoGraphic : yoGraphics) {
                String name = yoGraphic.getName();
                if (!name.equals(nameToCheck)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean doesNameExistInArtifactLists(String nameToCheck) {
        for (ArtifactList artifactList : this.artifactLists) {
            List<Artifact> artifacts = artifactList.getArtifacts();
            for (Artifact artifact : artifacts) {
                String name = artifact.getID();
                if (!name.equals(nameToCheck)) continue;
                return true;
            }
        }
        return false;
    }

    public void registerYoGraphicsList(YoGraphicsList yoGraphicsList) {
        if (this.alreadyAddedToSimulationConstructionSet) {
            throw new RuntimeException("Graphics have already been added to the SimulationConstructionSet. Cannot register more objects after this.");
        }
        if (this.yoGraphicsLists.contains(yoGraphicsList)) {
            throw new RuntimeException("Already registered YoGraphicsList " + String.valueOf(yoGraphicsList));
        }
        this.checkForRepeatNames(yoGraphicsList);
        for (YoGraphicsList list : this.yoGraphicsLists) {
            if (!list.getLabel().equals(yoGraphicsList.getLabel())) continue;
            List<YoGraphic> yoGraphics = yoGraphicsList.getYoGraphics();
            list.addAll(yoGraphics);
            return;
        }
        this.yoGraphicsLists.add(yoGraphicsList);
    }

    public void registerArtifactList(ArtifactList artifactList) {
        if (this.alreadyAddedToSimulationConstructionSet) {
            throw new RuntimeException("Graphics have already been added to the SimulationConstructionSet. Cannot register more objects after this.");
        }
        if (this.artifactLists.contains(artifactList)) {
            throw new RuntimeException("Already registered artifactList " + String.valueOf(artifactList));
        }
        this.checkForRepeatNames(artifactList);
        for (ArtifactList list : this.artifactLists) {
            if (!list.getLabel().equals(artifactList.getLabel())) continue;
            list.addAll(artifactList.getArtifacts());
            return;
        }
        this.artifactLists.add(artifactList);
    }

    public void getRegisteredYoGraphicsLists(List<YoGraphicsList> yoGraphicsLists) {
        yoGraphicsLists.addAll(this.yoGraphicsLists);
    }

    public void getRegisteredArtifactLists(List<ArtifactList> artifactLists) {
        artifactLists.addAll(this.artifactLists);
    }

    public void registerGraphicsUpdatableToUpdateInAPlaybackListener(GraphicsUpdatable graphicsUpdatable) {
        if (this.graphicsUpdatablesToUpdateInAPlaybackListener.contains(graphicsUpdatable)) {
            throw new RuntimeException("Already registered graphics updateable!");
        }
        this.graphicsUpdatablesToUpdateInAPlaybackListener.add(graphicsUpdatable);
    }

    public List<GraphicsUpdatable> getGraphicsUpdatablesToUpdateInAPlaybackListener() {
        return this.graphicsUpdatablesToUpdateInAPlaybackListener;
    }

    public void addGraphicsUpdatable(GraphicsUpdatable graphicsUpdatable) {
        if (this.graphicsUpdatables.contains(graphicsUpdatable)) {
            return;
        }
        this.graphicsUpdatables.add(graphicsUpdatable);
    }

    public void addGraphicsUpdatables(List<? extends GraphicsUpdatable> graphicsUpdatables) {
        for (int i = 0; i < graphicsUpdatables.size(); ++i) {
            this.addGraphicsUpdatable(graphicsUpdatables.get(i));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update() {
        if (this.updateInSimulationThread) {
            throw new RuntimeException("YoGraphics are already updated in the simulation thread.");
        }
        if (this.graphicsConch != null) {
            Object object = this.graphicsConch;
            synchronized (object) {
                this.updateRootTransform();
                for (int i = 0; i < this.graphicsUpdatables.size(); ++i) {
                    this.graphicsUpdatables.get(i).update();
                }
            }
        }
    }

    public void addArtifactListsToPlotter(PlotterInterface plotter) {
        if (this.alreadyAddedToPlotter) {
            throw new RuntimeException("Already added this ArtifactLists To Plotter: " + String.valueOf(this.artifactLists));
        }
        if (this.artifactLists != null) {
            for (ArtifactList artifactList : this.artifactLists) {
                if (artifactList != null) {
                    artifactList.addArtifactsToPlotter(plotter);
                    continue;
                }
                System.out.println("ArtifactList is null!");
            }
        }
        this.alreadyAddedToPlotter = true;
    }

    public void registerYoGraphicsLists(List<YoGraphicsList> yoGraphicsLists) {
        for (YoGraphicsList yoGraphicsList : yoGraphicsLists) {
            this.registerYoGraphicsList(yoGraphicsList);
        }
    }

    public void registerYoGraphic(String listName, YoGraphic yoGraphic) {
        YoGraphicsList list = new YoGraphicsList(listName, yoGraphic);
        this.registerYoGraphicsList(list);
    }

    public void registerYoGraphics(String listName, YoGraphic[] yoGraphics) {
        YoGraphicsList list = new YoGraphicsList(listName, yoGraphics);
        this.registerYoGraphicsList(list);
    }

    public void registerYoGraphics(String listName, List<? extends YoGraphic> yoGraphics) {
        YoGraphicsList list = new YoGraphicsList(listName, yoGraphics);
        this.registerYoGraphicsList(list);
    }

    public void registerArtifactLists(List<ArtifactList> artifactLists) {
        for (ArtifactList artifactList : artifactLists) {
            this.registerArtifactList(artifactList);
        }
    }

    public void registerArtifact(String listName, Artifact artifact) {
        ArtifactList list = new ArtifactList(listName, artifact);
        this.registerArtifactList(list);
    }

    public void registerArtifacts(String listName, Artifact[] artifacts) {
        ArtifactList list = new ArtifactList(listName, artifacts);
        this.registerArtifactList(list);
    }

    public void registerArtifacts(String listName, List<Artifact> artifacts) {
        ArtifactList list = new ArtifactList(listName, artifacts);
        this.registerArtifactList(list);
    }

    public void registerYoGraphicsAndArtifactsFromOtherRegistry(YoGraphicsListRegistry other) {
        this.registerYoGraphicsLists(other.yoGraphicsLists);
        this.registerArtifactLists(other.artifactLists);
    }

    public void hideYoGraphics() {
        int numberOfElements = this.yoGraphicsLists.size();
        for (int i = 0; i < numberOfElements; ++i) {
            YoGraphicsList yoGraphicsList = this.yoGraphicsLists.get(i);
            yoGraphicsList.hideYoGraphics();
        }
    }

    public void hideArtifacts() {
        int numberOfElements = this.artifactLists.size();
        for (int i = 0; i < numberOfElements; ++i) {
            ArtifactList artifactList = this.artifactLists.get(i);
            artifactList.hideArtifacts();
        }
    }

    public boolean checkAllYoGraphicsListAreShowing() {
        boolean ret = true;
        int numberOfElements = this.yoGraphicsLists.size();
        for (int i = 0; i < numberOfElements; ++i) {
            YoGraphicsList yoGraphicsList = this.yoGraphicsLists.get(i);
            ret = ret && yoGraphicsList.checkAllYoGraphicsAreShowing();
        }
        return ret;
    }

    public void setGraphicsConch(Object graphicsConch) {
        this.graphicsConch = graphicsConch;
    }

    public void setYoGraphicsUpdatedRemotely(boolean updatedRemotely) {
        this.updateInSimulationThread = updatedRemotely;
    }

    public List<YoGraphicsList> getYoGraphicsLists() {
        return this.yoGraphicsLists;
    }

    public void setYoGraphicsRegistered() {
        this.alreadyAddedToSimulationConstructionSet = true;
    }

    public boolean areYoGraphicsRegistered() {
        return this.alreadyAddedToSimulationConstructionSet;
    }

    private void updateRootTransform() {
        this.rootTransform.set(this.simulatedRootToWorldTransform);
        this.rootTransform.multiply((RigidBodyTransformReadOnly)this.controllerWorldToRootTransform);
        for (int i = 0; i < this.yoGraphicsLists.size(); ++i) {
            this.yoGraphicsLists.get(i).setRootTransform(this.rootTransform);
        }
    }

    public void setSimulationTransformToWorld(RigidBodyTransform transformToWorld) {
        this.simulatedRootToWorldTransform.set(transformToWorld);
        if (this.updateInSimulationThread) {
            this.updateRootTransform();
        }
    }

    public void setControllerTransformToWorld(RigidBodyTransform transformToWorld) {
        this.controllerWorldToRootTransform.setAndInvert((RigidBodyTransformReadOnly)transformToWorld);
        if (this.updateInSimulationThread) {
            this.updateRootTransform();
        }
    }
}

