/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.graphicsDescription.yoGraphics;

import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.transform.AffineTransform;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.graphicsDescription.appearance.AppearanceDefinition;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicVector;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFramePoint3D;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameVector3D;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;

public class YoGraphicLineSegment
extends YoGraphicVector {
    private final YoFramePoint3D start;
    private final YoFramePoint3D end;
    private final YoFrameVector3D vector;

    public YoGraphicLineSegment(String namePrefix, String nameSuffix, ReferenceFrame referenceFrame, AppearanceDefinition appearance, YoRegistry registry) {
        this(namePrefix, new YoFramePoint3D(namePrefix, nameSuffix + "Start", referenceFrame, registry), new YoFramePoint3D(namePrefix, nameSuffix + "End", referenceFrame, registry), appearance);
    }

    public YoGraphicLineSegment(String name, YoFramePoint3D startPoint, YoFramePoint3D endPoint, AppearanceDefinition appearance) {
        this(name, startPoint, endPoint, 1.0, appearance);
    }

    public YoGraphicLineSegment(String name, YoFramePoint3D startPoint, YoFramePoint3D endPoint, double scale, AppearanceDefinition appearance) {
        this(name, startPoint, endPoint, scale, appearance, false);
    }

    public YoGraphicLineSegment(String name, YoFramePoint3D startPoint, YoFramePoint3D endPoint, double scale, AppearanceDefinition appearance, boolean drawArrowhead) {
        this(name, startPoint.getYoX(), startPoint.getYoY(), startPoint.getYoZ(), endPoint.getYoX(), endPoint.getYoY(), endPoint.getYoZ(), scale, appearance, drawArrowhead);
        if (!startPoint.getReferenceFrame().isWorldFrame() || !endPoint.getReferenceFrame().isWorldFrame()) {
            System.err.println("Warning: Should be in a World Frame to create a YoGraphicLineSegment. startPoint = " + String.valueOf(startPoint) + ", endPoint = " + String.valueOf(endPoint));
        }
    }

    public YoGraphicLineSegment(String name, YoDouble baseX, YoDouble baseY, YoDouble baseZ, YoDouble x, YoDouble y, YoDouble z, double scaleFactor, AppearanceDefinition appearance) {
        this(name, baseX, baseY, baseZ, x, y, z, scaleFactor, appearance, true);
    }

    public YoGraphicLineSegment(String name, YoDouble baseX, YoDouble baseY, YoDouble baseZ, YoDouble endX, YoDouble endY, YoDouble endZ, double scaleFactor, AppearanceDefinition appearance, boolean drawArrowhead) {
        this(name, baseX, baseY, baseZ, endX, endY, endZ, YoGraphicLineSegment.createDirectionVector(name, baseX.getRegistry()), scaleFactor, appearance, drawArrowhead);
    }

    private static YoFrameVector3D createDirectionVector(String name, YoRegistry registry) {
        YoFrameVector3D directionVector = new YoFrameVector3D(name, "Direction", ReferenceFrame.getWorldFrame(), registry);
        return directionVector;
    }

    private YoGraphicLineSegment(String name, YoDouble startX, YoDouble startY, YoDouble startZ, YoDouble endX, YoDouble endY, YoDouble endZ, YoFrameVector3D yoFrameVector, double scaleFactor, AppearanceDefinition appearance, boolean drawArrowhead) {
        super(name, startX, startY, startZ, yoFrameVector.getYoX(), yoFrameVector.getYoY(), yoFrameVector.getYoZ(), scaleFactor, appearance, drawArrowhead);
        this.vector = yoFrameVector;
        this.start = new YoFramePoint3D(startX, startY, startZ, ReferenceFrame.getWorldFrame());
        this.end = new YoFramePoint3D(endX, endY, endZ, ReferenceFrame.getWorldFrame());
    }

    @Override
    protected void computeRotationTranslation(AffineTransform transform3D) {
        if (this.vector == null) {
            return;
        }
        this.vector.sub((FrameTuple3DReadOnly)this.end, (FrameTuple3DReadOnly)this.start);
        super.computeRotationTranslation(transform3D);
    }

    @Override
    public YoDouble[] getVariables() {
        return new YoDouble[]{this.start.getYoX(), this.start.getYoY(), this.start.getYoZ(), this.end.getYoX(), this.end.getYoY(), this.end.getYoZ()};
    }

    @Override
    public double[] getConstants() {
        return new double[]{this.scaleFactor};
    }

    public void setStartAndEnd(FramePoint3DReadOnly startPoint, FramePoint3DReadOnly endPoint) {
        startPoint.checkReferenceFrameMatch(ReferenceFrame.getWorldFrame());
        endPoint.checkReferenceFrameMatch(ReferenceFrame.getWorldFrame());
        this.setStartAndEnd((Point3DReadOnly)startPoint, (Point3DReadOnly)endPoint);
    }

    public void setStartAndEnd(Point3DReadOnly startPoint, Point3DReadOnly endPoint) {
        this.start.set((Tuple3DReadOnly)startPoint);
        this.end.set((Tuple3DReadOnly)endPoint);
        this.vector.sub((Tuple3DReadOnly)endPoint, (Tuple3DReadOnly)startPoint);
    }

    public void setToNaN() {
        this.start.setToNaN();
        this.end.setToNaN();
        this.vector.setToNaN();
    }

    @Override
    public YoGraphicLineSegment duplicate(YoRegistry newRegistry) {
        return new YoGraphicLineSegment(this.getName(), this.start, this.end, this.scaleFactor, this.getAppearance(), this.getDrawArrowhead());
    }
}

