/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.graphicsDescription;

import java.awt.image.BufferedImage;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import us.ihmc.euclid.Axis3D;
import us.ihmc.euclid.axisAngle.AxisAngle;
import us.ihmc.euclid.geometry.interfaces.ConvexPolygon2DReadOnly;
import us.ihmc.euclid.geometry.tools.EuclidGeometryTools;
import us.ihmc.euclid.matrix.RotationMatrix;
import us.ihmc.euclid.matrix.interfaces.Matrix3DReadOnly;
import us.ihmc.euclid.matrix.interfaces.RotationMatrixReadOnly;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.shape.primitives.interfaces.Box3DReadOnly;
import us.ihmc.euclid.shape.primitives.interfaces.Capsule3DReadOnly;
import us.ihmc.euclid.shape.primitives.interfaces.Cylinder3DReadOnly;
import us.ihmc.euclid.shape.primitives.interfaces.Ellipsoid3DReadOnly;
import us.ihmc.euclid.shape.primitives.interfaces.PointShape3DReadOnly;
import us.ihmc.euclid.shape.primitives.interfaces.Ramp3DReadOnly;
import us.ihmc.euclid.shape.primitives.interfaces.Shape3DReadOnly;
import us.ihmc.euclid.shape.primitives.interfaces.Sphere3DReadOnly;
import us.ihmc.euclid.shape.primitives.interfaces.Torus3DReadOnly;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Point2DReadOnly;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Point3D32;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.Vector3D32;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionReadOnly;
import us.ihmc.graphicsDescription.HeightMap;
import us.ihmc.graphicsDescription.MeshDataGenerator;
import us.ihmc.graphicsDescription.MeshDataHolder;
import us.ihmc.graphicsDescription.TexCoord2f;
import us.ihmc.graphicsDescription.appearance.AppearanceDefinition;
import us.ihmc.graphicsDescription.appearance.YoAppearance;
import us.ihmc.graphicsDescription.exceptions.ShapeNotSupportedException;
import us.ihmc.graphicsDescription.input.SelectedListener;
import us.ihmc.graphicsDescription.instructions.ArcTorusGraphics3DInstruction;
import us.ihmc.graphicsDescription.instructions.CapsuleGraphics3DInstruction;
import us.ihmc.graphicsDescription.instructions.ConeGraphics3DInstruction;
import us.ihmc.graphicsDescription.instructions.CubeGraphics3DInstruction;
import us.ihmc.graphicsDescription.instructions.CylinderGraphics3DInstruction;
import us.ihmc.graphicsDescription.instructions.EllipsoidGraphics3DInstruction;
import us.ihmc.graphicsDescription.instructions.ExtrudedPolygonGraphics3DInstruction;
import us.ihmc.graphicsDescription.instructions.Graphics3DAddExtrusionInstruction;
import us.ihmc.graphicsDescription.instructions.Graphics3DAddHeightMapInstruction;
import us.ihmc.graphicsDescription.instructions.Graphics3DAddMeshDataInstruction;
import us.ihmc.graphicsDescription.instructions.Graphics3DAddModelFileInstruction;
import us.ihmc.graphicsDescription.instructions.Graphics3DInstruction;
import us.ihmc.graphicsDescription.instructions.Graphics3DPrimitiveInstruction;
import us.ihmc.graphicsDescription.instructions.HemiEllipsoidGraphics3DInstruction;
import us.ihmc.graphicsDescription.instructions.PolygonGraphics3DInstruction;
import us.ihmc.graphicsDescription.instructions.PyramidCubeGraphics3DInstruction;
import us.ihmc.graphicsDescription.instructions.SphereGraphics3DInstruction;
import us.ihmc.graphicsDescription.instructions.TruncatedConeGraphics3DInstruction;
import us.ihmc.graphicsDescription.instructions.WedgeGraphics3DInstruction;
import us.ihmc.graphicsDescription.instructions.primitives.Graphics3DIdentityInstruction;
import us.ihmc.graphicsDescription.instructions.primitives.Graphics3DRotateInstruction;
import us.ihmc.graphicsDescription.instructions.primitives.Graphics3DScaleInstruction;
import us.ihmc.graphicsDescription.instructions.primitives.Graphics3DTranslateInstruction;
import us.ihmc.graphicsDescription.structure.Graphics3DNode;
import us.ihmc.tools.inputDevices.keyboard.ModifierKeyInterface;

public class Graphics3DObject {
    private static final AppearanceDefinition DEFAULT_APPEARANCE = YoAppearance.Black();
    private static final int RESOLUTION = 25;
    private static final int CAPSULE_RESOLUTION = 24;
    private List<Graphics3DPrimitiveInstruction> graphics3DInstructions;
    private List<SelectedListener> selectedListeners;
    private boolean changeable = false;

    public Graphics3DObject(Shape3DReadOnly shape, AppearanceDefinition appearance) {
        this(shape, appearance, null);
    }

    public Graphics3DObject(Shape3DReadOnly shape) {
        this(shape, null, null);
    }

    public Graphics3DObject(List<Graphics3DPrimitiveInstruction> graphics3DInstructions) {
        this(null, null, graphics3DInstructions);
    }

    private Graphics3DObject(Shape3DReadOnly shape, AppearanceDefinition appearance, List<Graphics3DPrimitiveInstruction> graphics3DInstructions) {
        this.graphics3DInstructions = graphics3DInstructions != null ? graphics3DInstructions : new ArrayList<Graphics3DPrimitiveInstruction>();
        if (shape != null) {
            if (appearance == null) {
                this.add(shape);
            } else {
                this.add(shape, appearance);
            }
        }
    }

    public Graphics3DObject() {
        this(null, null, null);
    }

    public List<Graphics3DPrimitiveInstruction> getGraphics3DInstructions() {
        return this.graphics3DInstructions;
    }

    public Graphics3DObject(Graphics3DObject graphics3DObject) {
        this();
        this.combine(graphics3DObject);
    }

    public void combine(Graphics3DObject graphics3DObject) {
        if (graphics3DObject == null) {
            return;
        }
        this.identity();
        this.graphics3DInstructions.addAll(graphics3DObject.getGraphics3DInstructions());
    }

    public void combine(Graphics3DObject graphics3DObject, Vector3DReadOnly offset) {
        if (graphics3DObject == null) {
            return;
        }
        this.identity();
        this.translate((Tuple3DReadOnly)offset);
        List<Graphics3DPrimitiveInstruction> graphics3dInstructionsToAdd = graphics3DObject.getGraphics3DInstructions();
        for (Graphics3DPrimitiveInstruction graphics3dInstructionToAdd : graphics3dInstructionsToAdd) {
            this.graphics3DInstructions.add(graphics3dInstructionToAdd);
            if (!(graphics3dInstructionToAdd instanceof Graphics3DIdentityInstruction)) continue;
            this.translate((Tuple3DReadOnly)offset);
        }
    }

    public void addInstruction(Graphics3DPrimitiveInstruction instruction) {
        this.graphics3DInstructions.add(instruction);
    }

    public void transform(RigidBodyTransformReadOnly transform) {
        this.translate(transform.getTranslation());
        this.rotate(transform.getRotation());
    }

    public void translate(double tx, double ty, double tz) {
        this.graphics3DInstructions.add(new Graphics3DTranslateInstruction(tx, ty, tz));
    }

    public void translate(Tuple3DReadOnly translation) {
        this.graphics3DInstructions.add(new Graphics3DTranslateInstruction(translation));
    }

    public void rotate(double rotationAngle, Axis3D rotationAxis) {
        RotationMatrix rot = new RotationMatrix();
        if (rotationAxis == Axis3D.X) {
            rot.setToRollOrientation(rotationAngle);
        } else if (rotationAxis == Axis3D.Y) {
            rot.setToPitchOrientation(rotationAngle);
        } else if (rotationAxis == Axis3D.Z) {
            rot.setToYawOrientation(rotationAngle);
        }
        this.rotate((Orientation3DReadOnly)rot);
    }

    public void rotate(double rotationAngle, Vector3DReadOnly rotationAxis) {
        this.rotate((Orientation3DReadOnly)new AxisAngle(rotationAxis, rotationAngle));
    }

    public void rotate(Orientation3DReadOnly orientation) {
        this.graphics3DInstructions.add(new Graphics3DRotateInstruction((RotationMatrixReadOnly)new RotationMatrix(orientation)));
    }

    public Graphics3DScaleInstruction scale(double scaleFactor) {
        return this.scale((Vector3DReadOnly)new Vector3D(scaleFactor, scaleFactor, scaleFactor));
    }

    public Graphics3DScaleInstruction scale(Vector3DReadOnly scaleFactors) {
        Graphics3DScaleInstruction graphics3DScale = new Graphics3DScaleInstruction(scaleFactors);
        this.graphics3DInstructions.add(graphics3DScale);
        return graphics3DScale;
    }

    public void preScale(double scaleFactor) {
        this.preScale(new Vector3D(scaleFactor, scaleFactor, scaleFactor));
    }

    public void preScale(Vector3D scaleFactors) {
        ArrayList<Graphics3DPrimitiveInstruction> newInstructions = new ArrayList<Graphics3DPrimitiveInstruction>();
        newInstructions.add(new Graphics3DScaleInstruction((Vector3DReadOnly)scaleFactors));
        for (int i = 0; i < this.graphics3DInstructions.size(); ++i) {
            Graphics3DPrimitiveInstruction instruction = this.graphics3DInstructions.get(i);
            newInstructions.add(instruction);
            if (!(instruction instanceof Graphics3DIdentityInstruction)) continue;
            newInstructions.add(new Graphics3DScaleInstruction((Vector3DReadOnly)scaleFactors));
        }
        this.graphics3DInstructions = newInstructions;
    }

    public void identity() {
        this.graphics3DInstructions.add(new Graphics3DIdentityInstruction());
    }

    public void addModelFile(URL fileURL) {
        this.addModelFile(fileURL, null);
    }

    public void addModelFile(URL fileURL, AppearanceDefinition yoAppearanceDefinition) {
        if (fileURL == null) {
            System.err.println("fileURL == null in addModelFile");
            return;
        }
        String fileName = fileURL.getFile();
        if (fileName == null || fileName.equals("")) {
            System.out.println("Null File Name in add3DSFile");
            return;
        }
        this.addModelFile(fileName, yoAppearanceDefinition);
    }

    public void addModelFile(String fileName) {
        this.addModelFile(fileName, null);
    }

    public Graphics3DAddModelFileInstruction addModelFile(String fileName, AppearanceDefinition app) {
        Graphics3DAddModelFileInstruction graphics3dAddModelFileInstruction = new Graphics3DAddModelFileInstruction(fileName, app);
        this.graphics3DInstructions.add(graphics3dAddModelFileInstruction);
        return graphics3dAddModelFileInstruction;
    }

    public Graphics3DAddModelFileInstruction addModelFile(String fileName, String submesh, boolean centerSubmesh, List<String> resourceDirectories, ClassLoader resourceClassLoader, AppearanceDefinition app) {
        Graphics3DAddModelFileInstruction graphics3dAddModelFileInstruction = new Graphics3DAddModelFileInstruction(fileName, submesh, centerSubmesh, app, resourceDirectories, resourceClassLoader);
        this.graphics3DInstructions.add(graphics3dAddModelFileInstruction);
        return graphics3dAddModelFileInstruction;
    }

    public Graphics3DAddModelFileInstruction addModelFile(String fileName, List<String> resourceDirectories, ClassLoader resourceClassLoader, AppearanceDefinition app) {
        return this.addModelFile(fileName, null, false, resourceDirectories, resourceClassLoader, app);
    }

    public void addCoordinateSystem(double length) {
        this.addCoordinateSystem(length, YoAppearance.Gray());
    }

    public void addCoordinateSystem(double length, AppearanceDefinition arrowAppearance) {
        this.addCoordinateSystem(length, YoAppearance.Red(), YoAppearance.White(), YoAppearance.Blue(), arrowAppearance);
    }

    public void addCoordinateSystem(double length, AppearanceDefinition xAxisAppearance, AppearanceDefinition yAxisAppearance, AppearanceDefinition zAxisAppearance, AppearanceDefinition arrowAppearance) {
        this.rotate(1.5707963267948966, Axis3D.Y);
        this.addArrow(length, YoAppearance.Red(), arrowAppearance);
        this.rotate(-1.5707963267948966, Axis3D.Y);
        this.rotate(-1.5707963267948966, Axis3D.X);
        this.addArrow(length, YoAppearance.White(), arrowAppearance);
        this.rotate(1.5707963267948966, Axis3D.X);
        this.addArrow(length, YoAppearance.Blue(), arrowAppearance);
    }

    public void add(Shape3DReadOnly shape) {
        this.add(shape, DEFAULT_APPEARANCE);
    }

    public void add(Shape3DReadOnly shape, AppearanceDefinition shapeAppearance) {
        if (shape instanceof Box3DReadOnly) {
            Box3DReadOnly box = (Box3DReadOnly)shape;
            this.transform((RigidBodyTransformReadOnly)box.getPose());
            this.addCube(box.getSizeX(), box.getSizeY(), box.getSizeZ(), true, shapeAppearance);
        } else if (shape instanceof Capsule3DReadOnly) {
            Capsule3DReadOnly capsule = (Capsule3DReadOnly)shape;
            this.translate((Tuple3DReadOnly)capsule.getPosition());
            this.rotate((Orientation3DReadOnly)EuclidGeometryTools.axisAngleFromZUpToVector3D((Vector3DReadOnly)capsule.getAxis()));
            this.addCapsule(capsule.getRadius(), capsule.getLength() + 2.0 * capsule.getRadius(), shapeAppearance);
        } else if (shape instanceof Cylinder3DReadOnly) {
            Cylinder3DReadOnly cylinder = (Cylinder3DReadOnly)shape;
            this.translate((Tuple3DReadOnly)cylinder.getPosition());
            this.rotate((Orientation3DReadOnly)EuclidGeometryTools.axisAngleFromZUpToVector3D((Vector3DReadOnly)cylinder.getAxis()));
            this.translate(0.0, 0.0, -cylinder.getHalfLength());
            this.addCylinder(cylinder.getLength(), cylinder.getRadius(), shapeAppearance);
        } else if (shape instanceof Ellipsoid3DReadOnly) {
            Ellipsoid3DReadOnly ellipsoid = (Ellipsoid3DReadOnly)shape;
            this.transform((RigidBodyTransformReadOnly)ellipsoid.getPose());
            this.addEllipsoid(ellipsoid.getRadiusX(), ellipsoid.getRadiusY(), ellipsoid.getRadiusZ(), shapeAppearance);
        } else if (shape instanceof PointShape3DReadOnly) {
            PointShape3DReadOnly pointShape = (PointShape3DReadOnly)shape;
            this.translate((Tuple3DReadOnly)pointShape);
            this.addSphere(0.005, shapeAppearance);
        } else if (shape instanceof Ramp3DReadOnly) {
            Ramp3DReadOnly ramp = (Ramp3DReadOnly)shape;
            this.transform((RigidBodyTransformReadOnly)ramp.getPose());
            this.translate(-0.5 * ramp.getSizeX(), 0.0, 0.0);
            this.addWedge(ramp.getSizeX(), ramp.getSizeY(), ramp.getSizeZ(), shapeAppearance);
        } else if (shape instanceof Sphere3DReadOnly) {
            Sphere3DReadOnly sphere = (Sphere3DReadOnly)shape;
            this.translate((Tuple3DReadOnly)sphere.getPosition());
            this.addSphere(sphere.getRadius(), shapeAppearance);
        } else if (shape instanceof Torus3DReadOnly) {
            Torus3DReadOnly torus = (Torus3DReadOnly)shape;
            this.translate((Tuple3DReadOnly)torus.getPosition());
            this.rotate((Orientation3DReadOnly)EuclidGeometryTools.axisAngleFromZUpToVector3D((Vector3DReadOnly)torus.getAxis()));
            this.addArcTorus(0.0, Math.PI * 2, torus.getRadius(), torus.getTubeRadius(), shapeAppearance);
        } else {
            throw new ShapeNotSupportedException(shape);
        }
    }

    public void addArrow(double length, AppearanceDefinition baseAppearance, AppearanceDefinition headAppearance) {
        double coneHeight = 0.1 * length;
        double cylinderHeight = length - coneHeight;
        double radius = 0.02 * length;
        double coneRadius = 2.0 * radius;
        this.addCylinder(cylinderHeight, radius, baseAppearance);
        this.translate(0.0, 0.0, cylinderHeight);
        this.addCone(coneHeight, coneRadius, headAppearance);
        this.translate(0.0, 0.0, -cylinderHeight);
    }

    public CubeGraphics3DInstruction addCube(double lengthX, double widthY, double heightZ) {
        return this.addCube(lengthX, widthY, heightZ, DEFAULT_APPEARANCE, null);
    }

    public CubeGraphics3DInstruction addCube(double lengthX, double widthY, double heightZ, AppearanceDefinition cubeApp, boolean[] textureFaces) {
        return this.addCube(lengthX, widthY, heightZ, false, cubeApp, textureFaces);
    }

    public CubeGraphics3DInstruction addCube(double lengthX, double widthY, double heightZ, AppearanceDefinition cubeAppearance) {
        return this.addCube(lengthX, widthY, heightZ, false, cubeAppearance, null);
    }

    public CubeGraphics3DInstruction addCube(double lengthX, double widthY, double heightZ, boolean centeredInTheCenter, AppearanceDefinition cubeApp, boolean[] textureFaces) {
        CubeGraphics3DInstruction cubeInstruction = new CubeGraphics3DInstruction(lengthX, widthY, heightZ, centeredInTheCenter);
        cubeInstruction.setTextureFaces(textureFaces);
        cubeInstruction.setAppearance(cubeApp);
        this.graphics3DInstructions.add(cubeInstruction);
        return cubeInstruction;
    }

    public CubeGraphics3DInstruction addCube(double lengthX, double widthY, double heightZ, boolean centered, AppearanceDefinition cubeApp) {
        return this.addCube(lengthX, widthY, heightZ, centered, cubeApp, null);
    }

    public WedgeGraphics3DInstruction addWedge(double lengthX, double widthY, double heightZ) {
        return this.addWedge(lengthX, widthY, heightZ, DEFAULT_APPEARANCE);
    }

    public WedgeGraphics3DInstruction addWedge(double lengthX, double widthY, double heightZ, AppearanceDefinition wedgeAppearance) {
        WedgeGraphics3DInstruction wedgeGraphics3DInstruction = new WedgeGraphics3DInstruction(lengthX, widthY, heightZ);
        wedgeGraphics3DInstruction.setAppearance(wedgeAppearance);
        this.graphics3DInstructions.add(wedgeGraphics3DInstruction);
        return wedgeGraphics3DInstruction;
    }

    public SphereGraphics3DInstruction addSphere(double radius) {
        return this.addSphere(radius, DEFAULT_APPEARANCE);
    }

    public SphereGraphics3DInstruction addSphere(double radius, AppearanceDefinition sphereAppearance) {
        SphereGraphics3DInstruction instruction = new SphereGraphics3DInstruction(radius, 25);
        instruction.setAppearance(sphereAppearance);
        this.graphics3DInstructions.add(instruction);
        return instruction;
    }

    public CapsuleGraphics3DInstruction addCapsule(double radius, double height) {
        return this.addCapsule(radius, height, DEFAULT_APPEARANCE);
    }

    public CapsuleGraphics3DInstruction addCapsule(double radius, double height, AppearanceDefinition capsuleAppearance) {
        CapsuleGraphics3DInstruction capsuleInstruction = new CapsuleGraphics3DInstruction(height - 2.0 * radius, radius, radius, radius, 24);
        capsuleInstruction.setAppearance(capsuleAppearance);
        this.graphics3DInstructions.add(capsuleInstruction);
        return capsuleInstruction;
    }

    public Graphics3DAddMeshDataInstruction addMeshData(MeshDataHolder meshData, AppearanceDefinition meshAppearance) {
        Graphics3DAddMeshDataInstruction instruction = Graphics3DObject.createMeshDataInstruction(meshData, meshAppearance);
        this.graphics3DInstructions.add(instruction);
        return instruction;
    }

    public static Graphics3DAddMeshDataInstruction createMeshDataInstruction(MeshDataHolder meshData, AppearanceDefinition meshAppearance) {
        if (meshData == null) {
            meshData = new MeshDataHolder(new Point3D32[0], new TexCoord2f[0], new int[0], new Vector3D32[0]);
            meshData.setName("nullMesh");
        }
        Graphics3DAddMeshDataInstruction instruction = new Graphics3DAddMeshDataInstruction(meshData, meshAppearance);
        return instruction;
    }

    public EllipsoidGraphics3DInstruction addEllipsoid(double xRadius, double yRadius, double zRadius) {
        return this.addEllipsoid(xRadius, yRadius, zRadius, DEFAULT_APPEARANCE);
    }

    public EllipsoidGraphics3DInstruction addEllipsoid(double xRadius, double yRadius, double zRadius, AppearanceDefinition ellipsoidAppearance) {
        EllipsoidGraphics3DInstruction ellipsoidInstruction = new EllipsoidGraphics3DInstruction(xRadius, yRadius, zRadius, 25);
        ellipsoidInstruction.setAppearance(ellipsoidAppearance);
        this.graphics3DInstructions.add(ellipsoidInstruction);
        return ellipsoidInstruction;
    }

    public CylinderGraphics3DInstruction addCylinder(double height, double radius) {
        return this.addCylinder(height, radius, DEFAULT_APPEARANCE);
    }

    public CylinderGraphics3DInstruction addCylinder(double height, double radius, AppearanceDefinition cylApp) {
        CylinderGraphics3DInstruction cylinderInstruction = new CylinderGraphics3DInstruction(radius, height, 25);
        cylinderInstruction.setAppearance(cylApp);
        this.graphics3DInstructions.add(cylinderInstruction);
        return cylinderInstruction;
    }

    public ConeGraphics3DInstruction addCone(double height, double radius) {
        return this.addCone(height, radius, DEFAULT_APPEARANCE);
    }

    public ConeGraphics3DInstruction addCone(double height, double radius, AppearanceDefinition coneApp) {
        ConeGraphics3DInstruction coneInstruction = new ConeGraphics3DInstruction(height, radius, 25);
        coneInstruction.setAppearance(coneApp);
        this.graphics3DInstructions.add(coneInstruction);
        return coneInstruction;
    }

    public TruncatedConeGraphics3DInstruction addGenTruncatedCone(double height, double bx, double by, double tx, double ty) {
        return this.addGenTruncatedCone(height, bx, by, tx, ty, DEFAULT_APPEARANCE);
    }

    public TruncatedConeGraphics3DInstruction addGenTruncatedCone(double height, double bx, double by, double tx, double ty, AppearanceDefinition coneApp) {
        TruncatedConeGraphics3DInstruction truncatedConeInstruction = new TruncatedConeGraphics3DInstruction(height, bx, by, tx, ty, 25);
        truncatedConeInstruction.setAppearance(coneApp);
        this.graphics3DInstructions.add(truncatedConeInstruction);
        return truncatedConeInstruction;
    }

    public HemiEllipsoidGraphics3DInstruction addHemiEllipsoid(double xRad, double yRad, double zRad) {
        return this.addHemiEllipsoid(xRad, yRad, zRad, DEFAULT_APPEARANCE);
    }

    public HemiEllipsoidGraphics3DInstruction addHemiEllipsoid(double xRad, double yRad, double zRad, AppearanceDefinition hEApp) {
        HemiEllipsoidGraphics3DInstruction hemiEllipsoidInstruction = new HemiEllipsoidGraphics3DInstruction(xRad, yRad, zRad, 25);
        hemiEllipsoidInstruction.setAppearance(hEApp);
        this.graphics3DInstructions.add(hemiEllipsoidInstruction);
        return hemiEllipsoidInstruction;
    }

    public ArcTorusGraphics3DInstruction addArcTorus(double startAngle, double endAngle, double majorRadius, double minorRadius) {
        return this.addArcTorus(startAngle, endAngle, majorRadius, minorRadius, DEFAULT_APPEARANCE);
    }

    public ArcTorusGraphics3DInstruction addArcTorus(double startAngle, double endAngle, double majorRadius, double minorRadius, AppearanceDefinition arcTorusApp) {
        ArcTorusGraphics3DInstruction arcTorusInstruction = new ArcTorusGraphics3DInstruction(startAngle, endAngle, majorRadius, minorRadius, 25);
        arcTorusInstruction.setAppearance(arcTorusApp);
        this.graphics3DInstructions.add(arcTorusInstruction);
        return arcTorusInstruction;
    }

    public PyramidCubeGraphics3DInstruction addPyramidCube(double lx, double ly, double lz, double lh) {
        return this.addPyramidCube(lx, ly, lz, lh, DEFAULT_APPEARANCE);
    }

    public PyramidCubeGraphics3DInstruction addPyramidCube(double lx, double ly, double lz, double lh, AppearanceDefinition cubeApp) {
        PyramidCubeGraphics3DInstruction pyradmidCubeInstruction = new PyramidCubeGraphics3DInstruction(lx, ly, lz, lh);
        pyradmidCubeInstruction.setAppearance(cubeApp);
        this.graphics3DInstructions.add(pyradmidCubeInstruction);
        return pyradmidCubeInstruction;
    }

    public PolygonGraphics3DInstruction addPolygon(List<? extends Point3DReadOnly> polygonPoints) {
        return this.addPolygon(polygonPoints, DEFAULT_APPEARANCE);
    }

    public PolygonGraphics3DInstruction addPolygon(List<? extends Point3DReadOnly> polygonPoints, AppearanceDefinition yoAppearance) {
        PolygonGraphics3DInstruction graphicsInstruction = new PolygonGraphics3DInstruction(polygonPoints);
        graphicsInstruction.setAppearance(yoAppearance);
        return graphicsInstruction;
    }

    public PolygonGraphics3DInstruction addPolygon(ConvexPolygon2DReadOnly convexPolygon2d, AppearanceDefinition yoAppearance) {
        ArrayList<Point3D> polygonPoints = new ArrayList<Point3D>();
        int numPoints = convexPolygon2d.getNumberOfVertices();
        for (int i = 0; i < numPoints; ++i) {
            Point2DReadOnly planarPoint = convexPolygon2d.getVertex(i);
            polygonPoints.add(new Point3D(planarPoint.getX(), planarPoint.getY(), 0.0));
        }
        return this.addPolygon(polygonPoints, yoAppearance);
    }

    public PolygonGraphics3DInstruction addPolygon(ConvexPolygon2DReadOnly convexPolygon2d) {
        return this.addPolygon(convexPolygon2d, DEFAULT_APPEARANCE);
    }

    public void addPolygons(RigidBodyTransformReadOnly transform, List<? extends ConvexPolygon2DReadOnly> convexPolygon2D) {
        this.addPolygons(transform, convexPolygon2D, YoAppearance.Black());
    }

    public void addPolygons(RigidBodyTransformReadOnly transform, List<? extends ConvexPolygon2DReadOnly> convexPolygon2D, AppearanceDefinition appearance) {
        this.transform(transform);
        for (int i = 0; i < convexPolygon2D.size(); ++i) {
            ConvexPolygon2DReadOnly convexPolygon = convexPolygon2D.get(i);
            MeshDataHolder meshDataHolder = MeshDataGenerator.ExtrudedPolygon(convexPolygon, -1.0E-4);
            this.addInstruction(new Graphics3DAddMeshDataInstruction(meshDataHolder, appearance));
        }
        RigidBodyTransform transformLocal = new RigidBodyTransform(transform);
        transformLocal.invert();
        this.transform((RigidBodyTransformReadOnly)transformLocal);
    }

    public Graphics3DAddMeshDataInstruction addPolygon(Point3DReadOnly[] polygonPoint) {
        return this.addPolygon(polygonPoint, DEFAULT_APPEARANCE);
    }

    public Graphics3DAddMeshDataInstruction addPolygon(Point3DReadOnly[] polygonPoints, AppearanceDefinition yoAppearance) {
        MeshDataHolder meshData = MeshDataGenerator.Polygon(polygonPoints);
        return this.addMeshData(meshData, yoAppearance);
    }

    public Graphics3DAddMeshDataInstruction addPolygon(AppearanceDefinition yoAppearance, Point3DReadOnly ... polygonPoints) {
        return this.addPolygon(polygonPoints, yoAppearance);
    }

    public ExtrudedPolygonGraphics3DInstruction addExtrudedPolygon(ConvexPolygon2DReadOnly convexPolygon2d, double height) {
        return this.addExtrudedPolygon(convexPolygon2d, height, DEFAULT_APPEARANCE);
    }

    public ExtrudedPolygonGraphics3DInstruction addExtrudedPolygon(ConvexPolygon2DReadOnly convexPolygon2d, double height, AppearanceDefinition appearance) {
        ArrayList<Point2DReadOnly> polygonPoints = new ArrayList<Point2DReadOnly>();
        for (int i = 0; i < convexPolygon2d.getNumberOfVertices(); ++i) {
            polygonPoints.add(convexPolygon2d.getVertex(i));
        }
        ExtrudedPolygonGraphics3DInstruction extrudedPolygonInstruction = new ExtrudedPolygonGraphics3DInstruction(polygonPoints, height);
        extrudedPolygonInstruction.setAppearance(appearance);
        this.graphics3DInstructions.add(extrudedPolygonInstruction);
        return extrudedPolygonInstruction;
    }

    public ExtrudedPolygonGraphics3DInstruction addExtrudedPolygon(List<? extends Point2DReadOnly> polygonPoints, double height) {
        return this.addExtrudedPolygon(polygonPoints, height, DEFAULT_APPEARANCE);
    }

    public ExtrudedPolygonGraphics3DInstruction addExtrudedPolygon(List<? extends Point2DReadOnly> polygonPoints, double height, AppearanceDefinition appearance) {
        ExtrudedPolygonGraphics3DInstruction graphicsInstruction = new ExtrudedPolygonGraphics3DInstruction(polygonPoints, height);
        graphicsInstruction.setAppearance(appearance);
        this.graphics3DInstructions.add(graphicsInstruction);
        return graphicsInstruction;
    }

    public Graphics3DAddExtrusionInstruction addExtrusion(BufferedImage bufferedImageToExtrude, double thickness, AppearanceDefinition appearance) {
        Graphics3DAddExtrusionInstruction instruction = new Graphics3DAddExtrusionInstruction(bufferedImageToExtrude, thickness, appearance);
        this.graphics3DInstructions.add(instruction);
        return instruction;
    }

    public Graphics3DAddExtrusionInstruction addText(String text, double thickness, AppearanceDefinition yoAppearance) {
        Graphics3DAddExtrusionInstruction instruction = new Graphics3DAddExtrusionInstruction(text, thickness, yoAppearance);
        this.graphics3DInstructions.add(instruction);
        return instruction;
    }

    public void createInertiaEllipsoid(Matrix3DReadOnly momentOfInertia, Vector3DReadOnly comOffset, double mass, AppearanceDefinition appearance) {
        double Ixx = momentOfInertia.getM00();
        double Iyy = momentOfInertia.getM11();
        double Izz = momentOfInertia.getM22();
        Vector3D ellipsoidRadii = new Vector3D();
        ellipsoidRadii.setX(Math.sqrt(2.5 * (Iyy + Izz - Ixx) / mass));
        ellipsoidRadii.setY(Math.sqrt(2.5 * (Izz + Ixx - Iyy) / mass));
        ellipsoidRadii.setZ(Math.sqrt(2.5 * (Ixx + Iyy - Izz) / mass));
        this.translate((Tuple3DReadOnly)comOffset);
        this.addEllipsoid(ellipsoidRadii.getX(), ellipsoidRadii.getY(), ellipsoidRadii.getZ(), appearance);
        this.identity();
    }

    public Graphics3DInstruction addTeaPot(AppearanceDefinition appearance) {
        return this.addModelFile("models/Teapot.obj", appearance);
    }

    public Graphics3DInstruction addHeightMap(HeightMap heightMap, int xPointsPerSide, int yPointsPerSide, AppearanceDefinition appearance) {
        Graphics3DAddHeightMapInstruction instruction = new Graphics3DAddHeightMapInstruction(heightMap, xPointsPerSide, yPointsPerSide, appearance);
        this.graphics3DInstructions.add(instruction);
        return instruction;
    }

    public void notifySelectedListeners(Graphics3DNode graphics3dNode, ModifierKeyInterface modifierKeyHolder, Point3DReadOnly location, Point3DReadOnly cameraPosition, QuaternionReadOnly cameraRotation) {
        if (this.selectedListeners != null) {
            for (SelectedListener selectedListener : this.selectedListeners) {
                selectedListener.selected(graphics3dNode, modifierKeyHolder, location, cameraPosition, cameraRotation);
            }
        }
    }

    public void registerSelectedListener(SelectedListener selectedListener) {
        if (this.selectedListeners == null) {
            this.selectedListeners = new ArrayList<SelectedListener>();
        }
        this.selectedListeners.add(selectedListener);
    }

    public boolean isChangeable() {
        return this.changeable;
    }

    public void setChangeable(boolean changeable) {
        this.changeable = changeable;
    }
}

