/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.graphicsDescription.yoGraphics;

import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.FramePose3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FrameOrientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameQuaternionBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameQuaternionReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.transform.AffineTransform;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.graphicsDescription.plotting.artifact.Artifact;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphic;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFramePoint3D;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameQuaternion;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameYawPitchRoll;
import us.ihmc.yoVariables.variable.YoDouble;
import us.ihmc.yoVariables.variable.YoVariable;

public abstract class YoGraphicAbstractShape
extends YoGraphic {
    private static final ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
    protected final YoFramePoint3D yoFramePoint;
    protected final YoFrameYawPitchRoll yoFrameYawPitchRoll;
    protected final YoFrameQuaternion yoFrameQuaternion;
    protected final double scale;
    private Vector3D rotationEulerVector = new Vector3D();

    protected YoGraphicAbstractShape(String name, YoFramePoint3D framePoint, YoFrameQuaternion frameOrientation, double scale) {
        this(name, framePoint, null, frameOrientation, scale);
    }

    protected YoGraphicAbstractShape(String name, YoFramePoint3D framePoint, YoFrameYawPitchRoll frameOrientation, double scale) {
        this(name, framePoint, frameOrientation, null, scale);
    }

    protected YoGraphicAbstractShape(String name, YoFramePoint3D framePoint, YoFrameYawPitchRoll frameYawPitchRoll, YoFrameQuaternion frameQuaternion, double scale) {
        super(name);
        framePoint.checkReferenceFrameMatch(worldFrame);
        if (frameYawPitchRoll == null && frameQuaternion == null || frameYawPitchRoll != null && frameQuaternion != null) {
            throw new IllegalArgumentException("Can only describe the orientation of this shape with either yaw-pitch-roll or quaternion.");
        }
        if (frameYawPitchRoll != null) {
            frameYawPitchRoll.checkReferenceFrameMatch(worldFrame);
        }
        if (frameQuaternion != null) {
            frameQuaternion.checkReferenceFrameMatch(worldFrame);
        }
        this.yoFramePoint = framePoint;
        this.yoFrameYawPitchRoll = frameYawPitchRoll;
        this.yoFrameQuaternion = frameQuaternion;
        this.scale = scale;
    }

    protected YoGraphicAbstractShape(String name, YoVariable[] yoVariables, double scale) {
        super(name);
        int yoIndex = 0;
        YoDouble x = (YoDouble)yoVariables[yoIndex++];
        YoDouble y = (YoDouble)yoVariables[yoIndex++];
        YoDouble z = (YoDouble)yoVariables[yoIndex++];
        this.yoFramePoint = new YoFramePoint3D(x, y, z, worldFrame);
        if (yoVariables.length == 6) {
            YoDouble yaw = (YoDouble)yoVariables[yoIndex++];
            YoDouble pitch = (YoDouble)yoVariables[yoIndex++];
            YoDouble roll = (YoDouble)yoVariables[yoIndex++];
            this.yoFrameYawPitchRoll = new YoFrameYawPitchRoll(yaw, pitch, roll, worldFrame);
            this.yoFrameQuaternion = null;
        } else if (yoVariables.length == 7) {
            YoDouble qx = (YoDouble)yoVariables[yoIndex++];
            YoDouble qy = (YoDouble)yoVariables[yoIndex++];
            YoDouble qz = (YoDouble)yoVariables[yoIndex++];
            YoDouble qs = (YoDouble)yoVariables[yoIndex++];
            this.yoFrameYawPitchRoll = null;
            this.yoFrameQuaternion = new YoFrameQuaternion(qx, qy, qz, qs, worldFrame);
        } else {
            throw new RuntimeException("Unexpected number of YoVariables. Expected either 6 or 7 but had: " + yoVariables.length);
        }
        this.scale = scale;
    }

    public void setPose(FramePose3D framePose) {
        this.yoFramePoint.checkReferenceFrameMatch(framePose.getReferenceFrame());
        this.yoFramePoint.set((FrameTuple3DReadOnly)framePose.getPosition());
        if (this.isUsingYawPitchRoll()) {
            this.yoFrameYawPitchRoll.set((FrameOrientation3DReadOnly)framePose.getOrientation());
        } else {
            this.yoFrameQuaternion.set((FrameQuaternionReadOnly)framePose.getOrientation());
        }
    }

    public void setPosition(double x, double y, double z) {
        this.yoFramePoint.set(x, y, z);
    }

    public void getPosition(FramePoint3DBasics framePointToPack) {
        framePointToPack.setIncludingFrame((FrameTuple3DReadOnly)this.yoFramePoint);
    }

    public void setPosition(FramePoint3DReadOnly position) {
        this.yoFramePoint.set((FrameTuple3DReadOnly)position);
    }

    public void getOrientation(FrameQuaternionBasics orientationToPack) {
        if (this.isUsingYawPitchRoll()) {
            orientationToPack.setIncludingFrame((FrameOrientation3DReadOnly)this.yoFrameYawPitchRoll);
        } else {
            orientationToPack.setIncludingFrame((FrameQuaternionReadOnly)this.yoFrameQuaternion);
        }
    }

    public void setOrientation(FrameQuaternionReadOnly orientation) {
        if (this.isUsingYawPitchRoll()) {
            this.yoFrameYawPitchRoll.set((FrameOrientation3DReadOnly)orientation);
        } else {
            this.yoFrameQuaternion.set(orientation);
        }
    }

    public void setYawPitchRoll(double yaw, double pitch, double roll) {
        if (this.isUsingYawPitchRoll()) {
            this.yoFrameYawPitchRoll.setYawPitchRoll(yaw, pitch, roll);
        } else {
            this.yoFrameQuaternion.setYawPitchRoll(yaw, pitch, roll);
        }
    }

    public void setTransformToWorld(RigidBodyTransformReadOnly transformToWorld) {
        this.yoFramePoint.set(transformToWorld.getTranslation());
        this.yoFrameYawPitchRoll.set(transformToWorld.getRotation());
    }

    public void setToReferenceFrame(ReferenceFrame referenceFrame) {
        if (referenceFrame == null) {
            throw new RuntimeException("referenceFrame == null");
        }
        RigidBodyTransform transformToWorld = new RigidBodyTransform();
        ReferenceFrame ancestorFrame = referenceFrame;
        while (!ancestorFrame.isWorldFrame()) {
            RigidBodyTransform transformToAncestor = ancestorFrame.getTransformToParent();
            RigidBodyTransform tempTransform3D = new RigidBodyTransform((RigidBodyTransformReadOnly)transformToAncestor);
            tempTransform3D.multiply((RigidBodyTransformReadOnly)transformToWorld);
            transformToWorld = tempTransform3D;
            ReferenceFrame newAncestorFrame = ancestorFrame.getParent();
            if (newAncestorFrame == null) {
                throw new RuntimeException("No ancestor path to world. referenceFrame = " + referenceFrame + ", most ancient = " + ancestorFrame);
            }
            ancestorFrame = newAncestorFrame;
        }
        this.setTransformToWorld((RigidBodyTransformReadOnly)transformToWorld);
    }

    @Override
    protected void computeRotationTranslation(AffineTransform transform3D) {
        transform3D.setIdentity();
        if (this.isUsingYawPitchRoll()) {
            this.yoFrameYawPitchRoll.getEuler((Tuple3DBasics)this.rotationEulerVector);
            transform3D.getLinearTransform().setEuler((Tuple3DReadOnly)this.rotationEulerVector);
        } else {
            transform3D.setLinearTransform((Orientation3DReadOnly)this.yoFrameQuaternion);
        }
        transform3D.setTranslation((Tuple3DReadOnly)this.yoFramePoint);
        transform3D.appendScale(this.scale);
    }

    @Override
    public Artifact createArtifact() {
        throw new RuntimeException("Implement Me!");
    }

    public void setPoseToNaN() {
        this.yoFramePoint.setToNaN();
        if (this.isUsingYawPitchRoll()) {
            this.yoFrameYawPitchRoll.setToNaN();
        } else {
            this.yoFrameQuaternion.setToNaN();
        }
    }

    @Override
    protected boolean containsNaN() {
        if (this.yoFramePoint.containsNaN()) {
            return true;
        }
        return this.isUsingYawPitchRoll() ? this.yoFrameYawPitchRoll.containsNaN() : this.yoFrameQuaternion.containsNaN();
    }

    public YoVariable[] getVariables() {
        YoVariable[] vars = new YoVariable[this.isUsingYawPitchRoll() ? 6 : 7];
        int i = 0;
        vars[i++] = this.yoFramePoint.getYoX();
        vars[i++] = this.yoFramePoint.getYoY();
        vars[i++] = this.yoFramePoint.getYoZ();
        if (this.isUsingYawPitchRoll()) {
            vars[i++] = this.yoFrameYawPitchRoll.getYoYaw();
            vars[i++] = this.yoFrameYawPitchRoll.getYoPitch();
            vars[i++] = this.yoFrameYawPitchRoll.getYoRoll();
        } else {
            vars[i++] = this.yoFrameQuaternion.getYoQx();
            vars[i++] = this.yoFrameQuaternion.getYoQy();
            vars[i++] = this.yoFrameQuaternion.getYoQz();
            vars[i++] = this.yoFrameQuaternion.getYoQs();
        }
        return vars;
    }

    public boolean isUsingYawPitchRoll() {
        return this.yoFrameYawPitchRoll != null;
    }
}

