/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.graphicsDescription.plotting.artifact;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import us.ihmc.euclid.geometry.BoundingBox2D;
import us.ihmc.euclid.geometry.ConvexPolygon2D;
import us.ihmc.euclid.geometry.interfaces.ConvexPolygon2DReadOnly;
import us.ihmc.euclid.geometry.interfaces.Vertex2DSupplier;
import us.ihmc.euclid.tuple2D.Point2D;
import us.ihmc.euclid.tuple2D.Vector2D;
import us.ihmc.euclid.tuple2D.interfaces.Point2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Vector2DReadOnly;
import us.ihmc.graphicsDescription.plotting.Graphics2DAdapter;
import us.ihmc.graphicsDescription.plotting.Plotter2DAdapter;
import us.ihmc.graphicsDescription.plotting.artifact.Artifact;

public class PolygonArtifact
extends Artifact {
    private List<Point2DReadOnly> points = new ArrayList<Point2DReadOnly>();
    private boolean FILL_POLYGON = false;
    private final ConvexPolygon2D tempPolygon = new ConvexPolygon2D();
    private final Point2D tempPoint = new Point2D();
    private final Vector2D tempRadii = new Vector2D();

    public PolygonArtifact(String id) {
        super(id);
        this.setLevel(2);
    }

    public PolygonArtifact(String id, boolean fill) {
        super(id);
        this.setLevel(2);
        this.FILL_POLYGON = fill;
    }

    public PolygonArtifact(String id, boolean fill, Color color) {
        super(id);
        this.setLevel(2);
        this.FILL_POLYGON = fill;
        this.color = color;
    }

    public PolygonArtifact(String id, boolean fill, Color color, List<? extends Point2DReadOnly> points) {
        super(id);
        this.setLevel(2);
        this.FILL_POLYGON = fill;
        this.color = color;
        this.setPoints(points);
    }

    public PolygonArtifact(String id, boolean fill, Color color, ConvexPolygon2D convexPolygon2d) {
        super(id);
        this.setLevel(2);
        this.FILL_POLYGON = fill;
        this.color = color;
        this.setPoints(convexPolygon2d);
    }

    public PolygonArtifact(String id, boolean fill, Color color, int level, ConvexPolygon2D convexPolygon2d) {
        super(id);
        this.setLevel(level);
        this.FILL_POLYGON = fill;
        this.color = color;
        this.setPoints(convexPolygon2d);
    }

    public PolygonArtifact(String id, boolean fill, Color color, BoundingBox2D boundingBox2d) {
        super(id);
        this.setLevel(2);
        this.FILL_POLYGON = fill;
        this.color = color;
        Point2D minPoint = boundingBox2d.getMinPoint();
        Point2D maxPoint = boundingBox2d.getMaxPoint();
        Point2D leftUpper = new Point2D(minPoint.getX(), maxPoint.getY());
        Point2D rightLower = new Point2D(maxPoint.getX(), minPoint.getY());
        ArrayList<Point2D> points = new ArrayList<Point2D>();
        points.add(minPoint);
        points.add(leftUpper);
        points.add(maxPoint);
        points.add(rightLower);
        this.setPoints(points);
    }

    public void setPoints(List<? extends Point2DReadOnly> points) {
        this.points.clear();
        this.points.addAll(points);
    }

    public void setPoints(ConvexPolygon2D polygon) {
        this.points.clear();
        for (int i = 0; i < polygon.getNumberOfVertices(); ++i) {
            this.points.add(polygon.getVertex(i));
        }
    }

    public void addPoint(Point2DReadOnly point) {
        this.points.add(point);
    }

    public void clearAllPoints() {
        this.points.clear();
    }

    public List<Point2DReadOnly> getPoints() {
        return this.points;
    }

    public int getSize() {
        return this.points.size();
    }

    @Override
    public String getID() {
        return this.id;
    }

    @Override
    public void draw(Graphics2DAdapter graphics) {
        if (this.points.isEmpty()) {
            return;
        }
        ArrayList<Point2DReadOnly> pointsCopy = new ArrayList<Point2DReadOnly>(this.points);
        if (pointsCopy.size() == 1) {
            this.tempPoint.set(pointsCopy.get(0).getX(), pointsCopy.get(0).getY());
            this.tempRadii.set(4.0, 4.0);
            graphics.drawOvalFilled((Point2DReadOnly)this.tempPoint, (Vector2DReadOnly)this.tempRadii);
        } else {
            graphics.setColor(this.color);
            this.tempPolygon.set(Vertex2DSupplier.asVertex2DSupplier(pointsCopy));
            if (this.FILL_POLYGON) {
                graphics.drawPolygonFilled((ConvexPolygon2DReadOnly)this.tempPolygon);
            } else {
                graphics.drawPolygon((ConvexPolygon2DReadOnly)this.tempPolygon);
            }
        }
    }

    @Override
    public void drawLegend(Plotter2DAdapter graphics, Point2D origin) {
        graphics.drawString(graphics.getScreenFrame(), "Polygon", (Point2DReadOnly)origin);
    }

    @Override
    public void drawHistory(Graphics2DAdapter graphics) {
        throw new RuntimeException("Not implemented!");
    }

    @Override
    public void takeHistorySnapshot() {
        throw new RuntimeException("Not implemented!");
    }
}

