/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.graphicsDescription.instructions.primitives;

import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.graphicsDescription.instructions.Graphics3DPrimitiveInstruction;
import us.ihmc.graphicsDescription.instructions.listeners.ScaleChangedListener;

public class Graphics3DScaleInstruction
implements Graphics3DPrimitiveInstruction {
    private final Vector3D scaleFactor = new Vector3D();
    private ScaleChangedListener scaleChangedListener = null;

    public Graphics3DScaleInstruction(double scale) {
        this.scaleFactor.set(scale, scale, scale);
    }

    public Graphics3DScaleInstruction(Vector3DReadOnly scale) {
        this.scaleFactor.set((Tuple3DReadOnly)scale);
    }

    public void setScale(Vector3DReadOnly scale) {
        this.scaleFactor.set((Tuple3DReadOnly)scale);
        if (this.scaleChangedListener != null) {
            this.scaleChangedListener.setScale(scale);
        }
    }

    public void setScale(double scale) {
        this.setScale((Vector3DReadOnly)new Vector3D(scale, scale, scale));
    }

    public Vector3D getScaleFactor() {
        return this.scaleFactor;
    }

    public String toString() {
        return "\t\t\t<Scale>" + this.scaleFactor + "</Scale>\n";
    }

    public void addChangeScaleListener(ScaleChangedListener scaleChangedListener) {
        this.scaleChangedListener = scaleChangedListener;
    }
}

