/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.graphicsDescription.color;

import java.awt.Color;
import java.util.StringTokenizer;

public class MutableColor {
    public float x;
    public float y;
    public float z;

    public MutableColor() {
    }

    public MutableColor(MutableColor color) {
        this.set(color);
    }

    public MutableColor(Color color) {
        this.set(color);
    }

    public MutableColor(float x, float y, float z) {
        this.set(x, y, z);
    }

    public MutableColor(float[] color) {
        this.set(color[0], color[1], color[2]);
    }

    public void set(MutableColor other) {
        this.set(other.x, other.y, other.z);
    }

    public void set(float x, float y, float z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public final void set(Color color) {
        this.x = (float)color.getRed() / 255.0f;
        this.y = (float)color.getGreen() / 255.0f;
        this.z = (float)color.getBlue() / 255.0f;
    }

    public final Color get() {
        int r = Math.round(this.x * 255.0f);
        int g = Math.round(this.y * 255.0f);
        int b = Math.round(this.z * 255.0f);
        return new Color(r, g, b);
    }

    public float getX() {
        return this.x;
    }

    public float getY() {
        return this.y;
    }

    public float getZ() {
        return this.z;
    }

    public void setX(double x) {
        this.x = (float)x;
    }

    public void setY(double y) {
        this.y = (float)y;
    }

    public void setZ(double z) {
        this.z = (float)z;
    }

    public static MutableColor parseColor3f(String color) {
        try {
            StringTokenizer s = new StringTokenizer(color, ",");
            return new MutableColor(new float[]{Float.parseFloat(s.nextToken()), Float.parseFloat(s.nextToken()), Float.parseFloat(s.nextToken())});
        }
        catch (Exception e) {
            return null;
        }
    }
}

