/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.graphicsDescription.yoGraphics;

import java.util.ArrayList;
import java.util.List;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.graphicsDescription.appearance.AppearanceDefinition;
import us.ihmc.graphicsDescription.appearance.YoAppearance;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicPosition;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicsList;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicsListRegistry;
import us.ihmc.graphicsDescription.yoGraphics.plotting.ArtifactList;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFramePoint3D;
import us.ihmc.yoVariables.registry.YoRegistry;

public class BagOfBalls {
    private static final ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
    private static final double DEFAULT_SIZE = 0.01;
    private static final int DEFAULT_NUMBER_OF_BALLS = 50;
    private static final String DEFAULT_NAME = "BagOfBalls";
    private static final AppearanceDefinition DEFAULT_COLOR = YoAppearance.Black();
    private static final YoGraphicPosition.GraphicType DEFAULT_GRAPHIC_TYPE = null;
    private final ArrayList<YoGraphicPosition> yoGraphicPositions = new ArrayList();
    private int index;
    private boolean outOfBallsWarning = false;
    private YoGraphicsList yoGraphicsList;
    private ArtifactList artifactList;

    public BagOfBalls(YoRegistry parentRegistry, YoGraphicsListRegistry yoGraphicsListRegistry) {
        this(50, 0.01, DEFAULT_NAME, DEFAULT_COLOR, DEFAULT_GRAPHIC_TYPE, parentRegistry, yoGraphicsListRegistry);
    }

    public BagOfBalls(int numberOfBalls, YoRegistry parentRegistry, YoGraphicsListRegistry yoGraphicsListRegistry) {
        this(numberOfBalls, 0.01, DEFAULT_NAME, DEFAULT_COLOR, DEFAULT_GRAPHIC_TYPE, parentRegistry, yoGraphicsListRegistry);
    }

    public BagOfBalls(int numberOfBalls, double sizeInMeters, YoRegistry parentRegistry, YoGraphicsListRegistry yoGraphicsListRegistry) {
        this(numberOfBalls, sizeInMeters, DEFAULT_NAME, DEFAULT_COLOR, DEFAULT_GRAPHIC_TYPE, parentRegistry, yoGraphicsListRegistry);
    }

    public BagOfBalls(int numberOfBalls, double sizeInMeters, String name, YoRegistry parentRegistry, YoGraphicsListRegistry yoGraphicsListRegistry) {
        this(numberOfBalls, sizeInMeters, name, DEFAULT_COLOR, DEFAULT_GRAPHIC_TYPE, parentRegistry, yoGraphicsListRegistry);
    }

    public BagOfBalls(int numberOfBalls, double sizeInMeters, AppearanceDefinition appearance, YoRegistry parentRegistry, YoGraphicsListRegistry yoGraphicsListRegistry) {
        this(numberOfBalls, sizeInMeters, DEFAULT_NAME, appearance, DEFAULT_GRAPHIC_TYPE, parentRegistry, yoGraphicsListRegistry);
    }

    public BagOfBalls(int numberOfBalls, double sizeInMeters, AppearanceDefinition appearance, YoGraphicPosition.GraphicType graphicType, YoRegistry parentRegistry, YoGraphicsListRegistry yoGraphicsListRegistry) {
        this(numberOfBalls, sizeInMeters, DEFAULT_NAME, appearance, graphicType, parentRegistry, yoGraphicsListRegistry);
    }

    public BagOfBalls(int numberOfBalls, double sizeInMeters, String name, AppearanceDefinition appearance, YoRegistry parentRegistry, YoGraphicsListRegistry yoGraphicsListRegistry) {
        this(numberOfBalls, sizeInMeters, name, appearance, DEFAULT_GRAPHIC_TYPE, parentRegistry, yoGraphicsListRegistry);
    }

    public BagOfBalls(int numberOfBalls, double sizeInMeters, String name, AppearanceDefinition appearance, YoGraphicPosition.GraphicType graphicType, YoRegistry parentRegistry, YoGraphicsListRegistry yoGraphicsListRegistry) {
        this(sizeInMeters, name, BagOfBalls.toList(appearance, numberOfBalls), graphicType, parentRegistry, yoGraphicsListRegistry);
    }

    public BagOfBalls(double sizeInMeters, String name, List<AppearanceDefinition> appearances, YoRegistry parentRegistry, YoGraphicsListRegistry yoGraphicsListRegistry) {
        this(sizeInMeters, name, appearances, DEFAULT_GRAPHIC_TYPE, parentRegistry, yoGraphicsListRegistry);
    }

    public BagOfBalls(double sizeInMeters, String name, List<AppearanceDefinition> appearances, YoGraphicPosition.GraphicType graphicType, YoRegistry parentRegistry, YoGraphicsListRegistry yoGraphicsListRegistry) {
        YoRegistry registry = new YoRegistry(name + "Balls");
        for (int i = 0; i < appearances.size(); ++i) {
            YoFramePoint3D yoFramePoint = new YoFramePoint3D(name + i, "", worldFrame, registry);
            YoGraphicPosition newPosition = graphicType != null ? new YoGraphicPosition(name + i, yoFramePoint, sizeInMeters, appearances.get(i), graphicType) : new YoGraphicPosition(name + i, yoFramePoint, sizeInMeters, appearances.get(i));
            this.yoGraphicPositions.add(newPosition);
        }
        this.index = 0;
        this.registerYoGraphics(name, registry, parentRegistry, yoGraphicsListRegistry);
        if (graphicType != null) {
            this.registerArtifacts(name, yoGraphicsListRegistry);
        }
        parentRegistry.addChild(registry);
    }

    private static List<AppearanceDefinition> toList(AppearanceDefinition appearanceDefinition, int size) {
        ArrayList<AppearanceDefinition> list = new ArrayList<AppearanceDefinition>(size);
        while (list.size() < size) {
            list.add(appearanceDefinition);
        }
        return list;
    }

    public static BagOfBalls createPatrioticBag(int numberOfBalls, double sizeInMeters, String name, YoRegistry parentYoVariableRegistry, YoGraphicsListRegistry yoGraphicsListRegistry) {
        AppearanceDefinition[] redWhiteBlue = new AppearanceDefinition[]{YoAppearance.Red(), YoAppearance.White(), YoAppearance.Blue()};
        ArrayList<AppearanceDefinition> appearances = new ArrayList<AppearanceDefinition>();
        for (int i = 0; i < numberOfBalls; ++i) {
            appearances.add(redWhiteBlue[i % redWhiteBlue.length]);
        }
        return new BagOfBalls(sizeInMeters, name, appearances, parentYoVariableRegistry, yoGraphicsListRegistry);
    }

    public static BagOfBalls createRainbowBag(int numberOfBalls, double sizeInMeters, String name, YoRegistry parentYoVariableRegistry, YoGraphicsListRegistry yoGraphicsListRegistry) {
        AppearanceDefinition[] rainbow = YoAppearance.getStandardRoyGBivRainbow();
        ArrayList<AppearanceDefinition> appearances = new ArrayList<AppearanceDefinition>();
        for (int i = 0; i < numberOfBalls; ++i) {
            appearances.add(rainbow[i % rainbow.length]);
        }
        return new BagOfBalls(sizeInMeters, name, appearances, parentYoVariableRegistry, yoGraphicsListRegistry);
    }

    private void registerYoGraphics(String name, YoRegistry registry, YoRegistry parentYoVariableRegistry, YoGraphicsListRegistry yoGraphicsListRegistry) {
        if (yoGraphicsListRegistry != null) {
            this.yoGraphicsList = new YoGraphicsList(name + "Balls");
            for (YoGraphicPosition yoGraphicPosition : this.yoGraphicPositions) {
                this.yoGraphicsList.add(yoGraphicPosition);
            }
            yoGraphicsListRegistry.registerYoGraphicsList(this.yoGraphicsList);
        }
    }

    private void registerArtifacts(String name, YoGraphicsListRegistry yoGraphicsListRegistry) {
        if (yoGraphicsListRegistry != null) {
            this.artifactList = new ArtifactList(name + "Balls");
            for (YoGraphicPosition yoGraphicPosition : this.yoGraphicPositions) {
                this.artifactList.add(yoGraphicPosition.createArtifact());
            }
            yoGraphicsListRegistry.registerArtifactList(this.artifactList);
        }
    }

    public void setBall(FramePoint3DReadOnly location, int ballIndex) {
        this.setBall(location, null, ballIndex);
    }

    public void setBall(FramePoint3DReadOnly location) {
        this.setBall(location, null);
    }

    public void setBall(FramePoint3DReadOnly location, AppearanceDefinition appearance) {
        this.setBall(location, appearance, this.index);
        ++this.index;
    }

    public void setBall(Point3DReadOnly location) {
        this.setBall((FramePoint3DReadOnly)new FramePoint3D(worldFrame, (Tuple3DReadOnly)location));
    }

    public void setBall(Point3DReadOnly location, int ballIndex) {
        this.setBall((FramePoint3DReadOnly)new FramePoint3D(worldFrame, (Tuple3DReadOnly)location), null, ballIndex);
    }

    public void setBall(Point3DReadOnly location, AppearanceDefinition appearance) {
        this.setBall((FramePoint3DReadOnly)new FramePoint3D(worldFrame, (Tuple3DReadOnly)location), appearance);
    }

    public void setBall(Point3DReadOnly location, AppearanceDefinition appearance, int ballIndex) {
        this.setBall((FramePoint3DReadOnly)new FramePoint3D(worldFrame, (Tuple3DReadOnly)location), appearance, ballIndex);
    }

    public void setBall(FramePoint3DReadOnly location, AppearanceDefinition appearance, int ballIndex) {
        if (!location.getReferenceFrame().isWorldFrame()) {
            throw new RuntimeException(location + " must be in a World Frame!");
        }
        this.setBall(location.getX(), location.getY(), location.getZ(), appearance, ballIndex);
    }

    public void setBall(double x, double y, double z) {
        this.setBall(x, y, z, null);
    }

    public void setBall(double x, double y, double z, AppearanceDefinition appearance) {
        this.setBall(x, y, z, appearance, this.index);
        ++this.index;
    }

    public void setBall(double x, double y, double z, AppearanceDefinition appearance, int ballIndex) {
        if (ballIndex < this.yoGraphicPositions.size()) {
            YoGraphicPosition yoGraphicPosition = this.yoGraphicPositions.get(ballIndex);
            yoGraphicPosition.setPosition(x, y, z);
            if (appearance != null) {
                yoGraphicPosition.setAppearance(appearance);
            }
        } else if (!this.outOfBallsWarning) {
            this.outOfBallsWarning = true;
        }
    }

    public void setBallLoop(FramePoint3DReadOnly location) {
        this.setBallLoop(location, null);
    }

    public void setBallLoop(FramePoint3DReadOnly location, AppearanceDefinition appearance) {
        location.checkReferenceFrameMatch(worldFrame);
        if (this.index >= this.yoGraphicPositions.size()) {
            this.index = 0;
        }
        YoGraphicPosition yoGraphicPosition = this.yoGraphicPositions.get(this.index);
        yoGraphicPosition.setPosition(location);
        if (appearance != null) {
            yoGraphicPosition.setAppearance(appearance);
        }
        ++this.index;
    }

    public void reset() {
        this.index = 0;
        for (int i = 0; i < this.yoGraphicPositions.size(); ++i) {
            YoGraphicPosition yoGraphicPosition = this.yoGraphicPositions.get(i);
            yoGraphicPosition.setPosition(Double.NaN, Double.NaN, Double.NaN);
        }
    }

    public void hideAll() {
        this.index = 0;
        for (int i = 0; i < this.yoGraphicPositions.size(); ++i) {
            this.yoGraphicPositions.get(i).setPositionToNaN();
        }
    }

    public void setVisible(boolean visible) {
        this.index = 0;
        this.yoGraphicsList.setVisible(visible);
    }

    public int getNumberOfBalls() {
        return this.yoGraphicPositions.size();
    }
}

