/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.graphicsDescription;

import us.ihmc.euclid.tuple3D.Point3D32;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.graphicsDescription.MeshDataGenerator;
import us.ihmc.graphicsDescription.MeshDataHolder;

public class PointCloud3DMeshGenerator {
    private final MeshDataHolder[] meshDataHolders;
    private final MeshDataHolder pointTemplate;
    private double pointRadius = 1.0;

    public PointCloud3DMeshGenerator(int numberOfPoints, int resolution) {
        this(numberOfPoints, resolution, 1.0);
    }

    public PointCloud3DMeshGenerator(int numberOfPoints, int resolution, double pointRadius) {
        this.pointRadius = pointRadius;
        this.meshDataHolders = new MeshDataHolder[numberOfPoints];
        for (int i = 0; i < numberOfPoints; ++i) {
            this.meshDataHolders[i] = MeshDataGenerator.Sphere(pointRadius, resolution, resolution);
        }
        this.pointTemplate = MeshDataGenerator.Sphere(pointRadius, resolution, resolution);
    }

    public void compute(Point3DReadOnly[] pointLocations) {
        if (pointLocations.length != this.meshDataHolders.length) {
            throw new RuntimeException("Unexpected array size. Expected: " + this.meshDataHolders.length + ", but was: " + pointLocations.length);
        }
        for (int i = 0; i < this.meshDataHolders.length; ++i) {
            Point3DReadOnly center = pointLocations[i];
            Point3D32[] pointVertices = this.meshDataHolders[i].getVertices();
            Point3D32[] templateVertices = this.pointTemplate.getVertices();
            for (int vertexIndex = 0; vertexIndex < pointVertices.length; ++vertexIndex) {
                pointVertices[vertexIndex].add((Tuple3DReadOnly)templateVertices[vertexIndex], (Tuple3DReadOnly)center);
            }
        }
    }

    public void setPointRadius(double pointRadius) {
        double scale = pointRadius / this.pointRadius;
        for (Point3D32 vertex : this.pointTemplate.getVertices()) {
            vertex.scale(scale);
        }
        this.pointRadius = pointRadius;
    }

    public int getNumberOfPoints() {
        return this.meshDataHolders.length;
    }

    public MeshDataHolder[] getMeshDataHolders() {
        return this.meshDataHolders;
    }
}

