/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.graphicsDescription.yoGraphics;

import java.util.ArrayList;
import java.util.Random;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicPolynomial3D;
import us.ihmc.robotics.Assert;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFramePose3D;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;
import us.ihmc.yoVariables.variable.YoVariable;

public class YoGraphicPolynomial3DTest {
    @Test
    public void testRemoteYoGraphicVariableOrdering() {
        Random random = new Random(345345L);
        for (int iteration = 0; iteration < 10; ++iteration) {
            String name = "writer";
            YoRegistry registry = new YoRegistry("writerRegistry");
            int numberOfPolynomials = random.nextInt(20) + 3;
            YoFramePose3D poseToPolynomialFrame = new YoFramePose3D(name + "Pose", ReferenceFrame.getWorldFrame(), registry);
            ArrayList<YoGraphicPolynomial3D.Polynomial3DVariables> yoPolynomial3Ds = new ArrayList<YoGraphicPolynomial3D.Polynomial3DVariables>();
            ArrayList<YoDouble> waypointTimes = new ArrayList<YoDouble>();
            for (int i = 0; i < numberOfPolynomials; ++i) {
                YoGraphicPolynomial3D.PolynomialVariables xPolynomial = new YoGraphicPolynomial3D.PolynomialVariables(name + "XPoly" + i, random.nextInt(20) + 1, registry);
                YoGraphicPolynomial3D.PolynomialVariables yPolynomial = new YoGraphicPolynomial3D.PolynomialVariables(name + "YPoly" + i, random.nextInt(20) + 1, registry);
                YoGraphicPolynomial3D.PolynomialVariables zPolynomial = new YoGraphicPolynomial3D.PolynomialVariables(name + "ZPoly" + i, random.nextInt(20) + 1, registry);
                yoPolynomial3Ds.add(new YoGraphicPolynomial3D.Polynomial3DVariables((YoGraphicPolynomial3D.PolynomialVariableHolder)xPolynomial, (YoGraphicPolynomial3D.PolynomialVariableHolder)yPolynomial, (YoGraphicPolynomial3D.PolynomialVariableHolder)zPolynomial));
                waypointTimes.add(new YoDouble(name + "WaypointTime" + i, registry));
            }
            double radius = random.nextDouble();
            int resolution = random.nextInt(50);
            int radialResolution = random.nextInt(50);
            YoGraphicPolynomial3D yoGraphicWriter = new YoGraphicPolynomial3D(name, poseToPolynomialFrame, yoPolynomial3Ds, waypointTimes, radius, resolution, radialResolution, registry);
            Object[] allWriterYoVariables = yoGraphicWriter.getVariables();
            double[] allWriterConstants = new double[yoGraphicWriter.getConstants().length];
            for (int i = 0; i < yoGraphicWriter.getConstants().length; ++i) {
                allWriterConstants[i] = yoGraphicWriter.getConstants()[i];
            }
            YoGraphicPolynomial3D yoGraphicReader = YoGraphicPolynomial3D.createAsRemoteYoGraphic((String)"reader", (YoVariable[])allWriterYoVariables, (double[])allWriterConstants);
            Object[] allReaderYoVariables = yoGraphicReader.getVariables();
            double[] allReaderConstants = new double[yoGraphicReader.getConstants().length];
            for (int i = 0; i < yoGraphicReader.getConstants().length; ++i) {
                allReaderConstants[i] = yoGraphicReader.getConstants()[i];
            }
            Assert.assertArrayEquals(allWriterYoVariables, allReaderYoVariables);
            Assert.assertArrayEquals(allWriterConstants, allReaderConstants, 1.0E-7);
        }
    }
}

