/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.convexOptimization.quadraticProgram;

import gnu.trove.list.TIntList;
import gnu.trove.list.array.TIntArrayList;
import java.util.ArrayList;
import java.util.List;
import org.ejml.data.DMatrix;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.data.Matrix;
import org.ejml.dense.row.CommonOps_DDRM;
import us.ihmc.convexOptimization.IntermediateSolutionListener;
import us.ihmc.convexOptimization.quadraticProgram.ActiveSetQPSolver;
import us.ihmc.convexOptimization.quadraticProgram.InverseMatrixCalculator;
import us.ihmc.log.LogTools;
import us.ihmc.matrixlib.NativeMatrix;

public class SimpleEfficientActiveSetQPSolver
implements ActiveSetQPSolver {
    private static final double violationFractionToAdd = 0.8;
    private static final double violationFractionToRemove = 0.95;
    private double convergenceThreshold = 1.0E-10;
    private double convergenceThresholdForLagrangeMultipliers = 1.0E-10;
    private int maxNumberOfIterations = 10;
    private boolean reportFailedConvergenceAsNaN = true;
    private boolean resetActiveSetOnSizeChange = true;
    protected double quadraticCostScalar;
    private final DMatrixRMaj activeVariables = new DMatrixRMaj(0, 0);
    private final TIntArrayList activeInequalityIndices = new TIntArrayList();
    private final TIntArrayList activeUpperBoundIndices = new TIntArrayList();
    private final TIntArrayList activeLowerBoundIndices = new TIntArrayList();
    protected final NativeMatrix nativexSolutionMatrix = new NativeMatrix(0, 0);
    protected final NativeMatrix costQuadraticMatrix = new NativeMatrix(0, 0);
    protected final NativeMatrix symmetricCostQuadraticMatrix = new NativeMatrix(0, 0);
    private final NativeMatrix linearInequalityConstraintsCheck = new NativeMatrix(0, 0);
    protected final NativeMatrix quadraticCostQVector = new NativeMatrix(0, 0);
    protected final NativeMatrix quadraticCostQMatrix = new NativeMatrix(0, 0);
    protected final NativeMatrix linearEqualityConstraintsAMatrix = new NativeMatrix(0, 0);
    protected final NativeMatrix linearEqualityConstraintsBVector = new NativeMatrix(0, 0);
    protected final NativeMatrix linearInequalityConstraintsCMatrixO = new NativeMatrix(0, 0);
    protected final NativeMatrix linearInequalityConstraintsDVectorO = new NativeMatrix(0, 0);
    protected final NativeMatrix variableLowerBounds = new NativeMatrix(0, 0);
    protected final NativeMatrix variableUpperBounds = new NativeMatrix(0, 0);
    private final NativeMatrix CBar = new NativeMatrix(0, 0);
    private final NativeMatrix DBar = new NativeMatrix(0, 0);
    private final NativeMatrix CHat = new NativeMatrix(0, 0);
    private final NativeMatrix DHat = new NativeMatrix(0, 0);
    private final NativeMatrix QInverse = new NativeMatrix(0, 0);
    private final NativeMatrix AQInverse = new NativeMatrix(0, 0);
    private final NativeMatrix QInverseATranspose = new NativeMatrix(0, 0);
    private final NativeMatrix CBarQInverse = new NativeMatrix(0, 0);
    private final NativeMatrix CHatQInverse = new NativeMatrix(0, 0);
    private final NativeMatrix AQInverseATranspose = new NativeMatrix(0, 0);
    private final NativeMatrix AQInverseCBarTranspose = new NativeMatrix(0, 0);
    private final NativeMatrix AQInverseCHatTranspose = new NativeMatrix(0, 0);
    private final NativeMatrix CBarQInverseATranspose = new NativeMatrix(0, 0);
    private final NativeMatrix CHatQInverseATranspose = new NativeMatrix(0, 0);
    private final NativeMatrix QInverseCBarTranspose = new NativeMatrix(0, 0);
    private final NativeMatrix QInverseCHatTranspose = new NativeMatrix(0, 0);
    private final NativeMatrix CBarQInverseCBarTranspose = new NativeMatrix(0, 0);
    private final NativeMatrix CHatQInverseCHatTranspose = new NativeMatrix(0, 0);
    private final NativeMatrix CBarQInverseCHatTranspose = new NativeMatrix(0, 0);
    private final NativeMatrix CHatQInverseCBarTranspose = new NativeMatrix(0, 0);
    private final NativeMatrix AAndC = new NativeMatrix(0, 0);
    private final NativeMatrix ATransposeMuAndCTransposeLambda = new NativeMatrix(0, 0);
    private final NativeMatrix bigMatrixForLagrangeMultiplierSolution = new NativeMatrix(0, 0);
    private final NativeMatrix lagrangeSolution = new NativeMatrix(0, 0);
    private final NativeMatrix bigMatrixInverse = new NativeMatrix(0, 0);
    private final NativeMatrix bigVectorForLagrangeMultiplierSolution = new NativeMatrix(0, 0);
    private final NativeMatrix tempVector = new NativeMatrix(0, 0);
    private final NativeMatrix augmentedLagrangeMultipliers = new NativeMatrix(0, 0);
    private final TIntArrayList inequalityIndicesToAddToActiveSet = new TIntArrayList();
    private final TIntArrayList inequalityIndicesToRemoveFromActiveSet = new TIntArrayList();
    private final TIntArrayList upperBoundIndicesToAddToActiveSet = new TIntArrayList();
    private final TIntArrayList upperBoundIndicesToRemoveFromActiveSet = new TIntArrayList();
    private final TIntArrayList lowerBoundIndicesToAddToActiveSet = new TIntArrayList();
    private final TIntArrayList lowerBoundIndicesToRemoveFromActiveSet = new TIntArrayList();
    protected final NativeMatrix computedObjectiveFunctionValue = new NativeMatrix(1, 1);
    private final NativeMatrix lowerBoundViolations = new NativeMatrix(0, 0);
    private final NativeMatrix upperBoundViolations = new NativeMatrix(0, 0);
    private InverseMatrixCalculator<NativeMatrix> inverseSolver = new DefaultInverseMatrixCalculator();
    private boolean useWarmStart = false;
    private int previousNumberOfVariables = 0;
    private int previousNumberOfEqualityConstraints = 0;
    private int previousNumberOfInequalityConstraints = 0;
    private int previousNumberOfLowerBoundConstraints = 0;
    private int previousNumberOfUpperBoundConstraints = 0;
    private final List<IntermediateSolutionListener> solutionListeners = new ArrayList<IntermediateSolutionListener>();
    private final NativeMatrix lagrangeEqualityConstraintMultipliers = new NativeMatrix(0, 0);
    private final NativeMatrix lagrangeInequalityConstraintMultipliers = new NativeMatrix(0, 0);
    private final NativeMatrix lagrangeLowerBoundMultipliers = new NativeMatrix(0, 0);
    private final NativeMatrix lagrangeUpperBoundMultipliers = new NativeMatrix(0, 0);

    @Override
    public void setConvergenceThreshold(double convergenceThreshold) {
        this.convergenceThreshold = convergenceThreshold;
    }

    public void setConvergenceThresholdForLagrangeMultipliers(double convergenceThresholdForLagrangeMultipliers) {
        this.convergenceThresholdForLagrangeMultipliers = convergenceThresholdForLagrangeMultipliers;
    }

    @Override
    public void setMaxNumberOfIterations(int maxNumberOfIterations) {
        this.maxNumberOfIterations = maxNumberOfIterations;
    }

    public void addIntermediateSolutionListener(IntermediateSolutionListener solutionListener) {
        this.solutionListeners.add(solutionListener);
    }

    public void setReportFailedConvergenceAsNaN(boolean reportFailedConvergenceAsNaN) {
        this.reportFailedConvergenceAsNaN = reportFailedConvergenceAsNaN;
    }

    public void setResetActiveSetOnSizeChange(boolean resetActiveSetOnSizeChange) {
        this.resetActiveSetOnSizeChange = resetActiveSetOnSizeChange;
    }

    public void setActiveInequalityIndices(TIntList activeInequalityIndices) {
        this.activeInequalityIndices.reset();
        for (int i = 0; i < activeInequalityIndices.size(); ++i) {
            this.activeInequalityIndices.add(activeInequalityIndices.get(i));
        }
    }

    public void setActiveLowerBoundIndices(TIntList activeLowerBoundIndices) {
        this.activeLowerBoundIndices.reset();
        for (int i = 0; i < activeLowerBoundIndices.size(); ++i) {
            this.activeLowerBoundIndices.add(activeLowerBoundIndices.get(i));
        }
    }

    public void setActiveUpperBoundIndices(TIntList activeUpperBoundIndices) {
        this.activeUpperBoundIndices.reset();
        for (int i = 0; i < activeUpperBoundIndices.size(); ++i) {
            this.activeUpperBoundIndices.add(activeUpperBoundIndices.get(i));
        }
    }

    public TIntList getActiveInequalityIndices() {
        return this.activeInequalityIndices;
    }

    public TIntList getActiveLowerBoundIndices() {
        return this.activeLowerBoundIndices;
    }

    public TIntList getActiveUpperBoundIndices() {
        return this.activeUpperBoundIndices;
    }

    @Override
    public void clear() {
        this.quadraticCostQMatrix.reshape(0, 0);
        this.quadraticCostQVector.reshape(0, 0);
        this.linearEqualityConstraintsAMatrix.reshape(0, 0);
        this.linearEqualityConstraintsBVector.reshape(0, 0);
        this.linearInequalityConstraintsCMatrixO.reshape(0, 0);
        this.linearInequalityConstraintsDVectorO.reshape(0, 0);
        this.variableLowerBounds.reshape(0, 0);
        this.variableUpperBounds.reshape(0, 0);
        this.lowerBoundViolations.reshape(0, 0);
        this.upperBoundViolations.reshape(0, 0);
    }

    @Override
    public void setLowerBounds(DMatrix variableLowerBounds) {
        if (variableLowerBounds.getNumRows() != this.quadraticCostQMatrix.getNumRows()) {
            throw new RuntimeException("variableLowerBounds.getNumRows() != quadraticCostQMatrix.getNumRows()");
        }
        this.variableLowerBounds.set((Matrix)variableLowerBounds);
    }

    @Override
    public void setUpperBounds(DMatrix variableUpperBounds) {
        if (variableUpperBounds.getNumRows() != this.quadraticCostQMatrix.getNumRows()) {
            throw new RuntimeException("variableUpperBounds.getNumRows() != quadraticCostQMatrix.getNumRows()");
        }
        this.variableUpperBounds.set((Matrix)variableUpperBounds);
    }

    @Override
    public void setQuadraticCostFunction(DMatrix costQuadraticMatrix, DMatrix costLinearVector, double quadraticCostScalar) {
        if (costLinearVector.getNumCols() != 1) {
            throw new RuntimeException("costLinearVector.getNumCols() != 1");
        }
        if (costQuadraticMatrix.getNumRows() != costLinearVector.getNumRows()) {
            throw new RuntimeException("costQuadraticMatrix.getNumRows() != costLinearVector.getNumRows()");
        }
        if (costQuadraticMatrix.getNumRows() != costQuadraticMatrix.getNumCols()) {
            throw new RuntimeException("costQuadraticMatrix.getNumRows() != costQuadraticMatrix.getNumCols()");
        }
        this.costQuadraticMatrix.set((Matrix)costQuadraticMatrix);
        this.symmetricCostQuadraticMatrix.transpose(this.costQuadraticMatrix);
        this.symmetricCostQuadraticMatrix.add(this.costQuadraticMatrix, this.symmetricCostQuadraticMatrix);
        this.quadraticCostQMatrix.set(this.symmetricCostQuadraticMatrix);
        this.quadraticCostQMatrix.scale(0.5);
        this.quadraticCostQVector.set((Matrix)costLinearVector);
        this.quadraticCostScalar = quadraticCostScalar;
    }

    @Override
    public double getObjectiveCost(DMatrixRMaj x) {
        this.nativexSolutionMatrix.set(x);
        this.computedObjectiveFunctionValue.multQuad(this.nativexSolutionMatrix, this.quadraticCostQMatrix);
        this.computedObjectiveFunctionValue.scale(0.5);
        this.computedObjectiveFunctionValue.multAddTransA(this.quadraticCostQVector, this.nativexSolutionMatrix);
        return this.computedObjectiveFunctionValue.get(0, 0) + this.quadraticCostScalar;
    }

    @Override
    public void setLinearEqualityConstraints(DMatrix linearEqualityConstraintsAMatrix, DMatrix linearEqualityConstraintsBVector) {
        if (linearEqualityConstraintsBVector.getNumCols() != 1) {
            throw new RuntimeException("linearEqualityConstraintsBVector.getNumCols() != 1");
        }
        if (linearEqualityConstraintsAMatrix.getNumRows() != linearEqualityConstraintsBVector.getNumRows()) {
            throw new RuntimeException("linearEqualityConstraintsAMatrix.getNumRows() != linearEqualityConstraintsBVector.getNumRows()");
        }
        if (linearEqualityConstraintsAMatrix.getNumCols() != this.quadraticCostQMatrix.getNumCols()) {
            throw new RuntimeException("linearEqualityConstraintsAMatrix.getNumCols() != quadraticCostQMatrix.getNumCols()");
        }
        this.linearEqualityConstraintsBVector.set((Matrix)linearEqualityConstraintsBVector);
        this.linearEqualityConstraintsAMatrix.set((Matrix)linearEqualityConstraintsAMatrix);
    }

    @Override
    public void setLinearInequalityConstraints(DMatrix linearInequalityConstraintCMatrix, DMatrix linearInequalityConstraintDVector) {
        if (linearInequalityConstraintDVector.getNumCols() != 1) {
            throw new RuntimeException("linearInequalityConstraintDVector.getNumCols() != 1");
        }
        if (linearInequalityConstraintCMatrix.getNumRows() != linearInequalityConstraintDVector.getNumRows()) {
            throw new RuntimeException("linearInequalityConstraintCMatrix.getNumRows() != linearInequalityConstraintDVector.getNumRows()");
        }
        if (linearInequalityConstraintCMatrix.getNumCols() != this.quadraticCostQMatrix.getNumCols()) {
            throw new RuntimeException("linearInequalityConstraintCMatrix.getNumCols() != quadraticCostQMatrix.getNumCols()");
        }
        this.linearInequalityConstraintsDVectorO.set((Matrix)linearInequalityConstraintDVector);
        this.linearInequalityConstraintsCMatrixO.set((Matrix)linearInequalityConstraintCMatrix);
    }

    @Override
    public void setUseWarmStart(boolean useWarmStart) {
        this.useWarmStart = useWarmStart;
    }

    @Override
    public void resetActiveSet() {
        this.CBar.reshape(0, 0);
        this.CHat.reshape(0, 0);
        this.DBar.reshape(0, 0);
        this.DHat.reshape(0, 0);
        this.activeInequalityIndices.reset();
        this.activeUpperBoundIndices.reset();
        this.activeLowerBoundIndices.reset();
    }

    @Override
    public int solve(DMatrix solutionToPack) {
        int i;
        if (!this.useWarmStart || this.resetActiveSetOnSizeChange && this.problemSizeChanged()) {
            this.resetActiveSet();
        } else {
            this.addActiveSetConstraintsAsEqualityConstraints();
        }
        int numberOfIterations = 0;
        int numberOfVariables = this.quadraticCostQMatrix.getNumRows();
        int numberOfEqualityConstraints = this.linearEqualityConstraintsAMatrix.getNumRows();
        int numberOfInequalityConstraints = this.linearInequalityConstraintsCMatrixO.getNumRows();
        int numberOfLowerBoundConstraints = this.variableLowerBounds.getNumRows();
        int numberOfUpperBoundConstraints = this.variableUpperBounds.getNumRows();
        this.nativexSolutionMatrix.reshape(numberOfVariables, 1);
        this.lagrangeEqualityConstraintMultipliers.reshape(numberOfEqualityConstraints, 1);
        this.lagrangeEqualityConstraintMultipliers.zero();
        this.lagrangeInequalityConstraintMultipliers.reshape(numberOfInequalityConstraints, 1);
        this.lagrangeInequalityConstraintMultipliers.zero();
        this.lagrangeLowerBoundMultipliers.reshape(numberOfLowerBoundConstraints, 1);
        this.lagrangeLowerBoundMultipliers.zero();
        this.lagrangeUpperBoundMultipliers.reshape(numberOfUpperBoundConstraints, 1);
        this.lagrangeUpperBoundMultipliers.zero();
        this.computeQInverseAndAQInverse();
        this.solveEqualityConstrainedSubproblemEfficiently(this.nativexSolutionMatrix, this.lagrangeEqualityConstraintMultipliers, this.lagrangeInequalityConstraintMultipliers, this.lagrangeLowerBoundMultipliers, this.lagrangeUpperBoundMultipliers);
        if (numberOfInequalityConstraints == 0 && numberOfLowerBoundConstraints == 0 && numberOfUpperBoundConstraints == 0) {
            solutionToPack.set((Matrix)this.nativexSolutionMatrix);
            return numberOfIterations;
        }
        for (i = 0; i < this.maxNumberOfIterations; ++i) {
            boolean activeSetWasModified = this.modifyActiveSetAndTryAgain(this.nativexSolutionMatrix, this.lagrangeEqualityConstraintMultipliers, this.lagrangeInequalityConstraintMultipliers, this.lagrangeLowerBoundMultipliers, this.lagrangeUpperBoundMultipliers);
            ++numberOfIterations;
            if (activeSetWasModified) continue;
            solutionToPack.set((Matrix)this.nativexSolutionMatrix);
            return numberOfIterations;
        }
        if (this.reportFailedConvergenceAsNaN) {
            if (solutionToPack.getNumRows() != numberOfVariables) {
                throw new IllegalArgumentException("Bad number of rows.");
            }
            for (i = 0; i < numberOfVariables; ++i) {
                solutionToPack.set(i, 0, Double.NaN);
            }
        } else {
            solutionToPack.set((Matrix)this.nativexSolutionMatrix);
        }
        return numberOfIterations;
    }

    private boolean problemSizeChanged() {
        boolean sizeChanged = this.checkProblemSize();
        this.previousNumberOfVariables = (int)CommonOps_DDRM.elementSum((DMatrixD1)this.activeVariables);
        this.previousNumberOfEqualityConstraints = this.linearEqualityConstraintsAMatrix.getNumRows();
        this.previousNumberOfInequalityConstraints = this.linearInequalityConstraintsCMatrixO.getNumRows();
        this.previousNumberOfLowerBoundConstraints = this.variableLowerBounds.getNumRows();
        this.previousNumberOfUpperBoundConstraints = this.variableUpperBounds.getNumRows();
        return sizeChanged;
    }

    private boolean checkProblemSize() {
        if ((double)this.previousNumberOfVariables != CommonOps_DDRM.elementSum((DMatrixD1)this.activeVariables)) {
            return true;
        }
        if (this.previousNumberOfEqualityConstraints != this.linearEqualityConstraintsAMatrix.getNumRows()) {
            return true;
        }
        if (this.previousNumberOfInequalityConstraints != this.linearInequalityConstraintsCMatrixO.getNumRows()) {
            return true;
        }
        if (this.previousNumberOfLowerBoundConstraints != this.variableLowerBounds.getNumRows()) {
            return true;
        }
        return this.previousNumberOfUpperBoundConstraints != this.variableUpperBounds.getNumRows();
    }

    private void computeQInverseAndAQInverse() {
        int numberOfVariables = this.quadraticCostQMatrix.getNumRows();
        int numberOfEqualityConstraints = this.linearEqualityConstraintsAMatrix.getNumRows();
        this.inverseSolver.computeInverse(this.quadraticCostQMatrix, this.QInverse);
        if (numberOfEqualityConstraints > 0) {
            this.AQInverse.mult(this.linearEqualityConstraintsAMatrix, this.QInverse);
            this.QInverseATranspose.multTransB(this.QInverse, this.linearEqualityConstraintsAMatrix);
            this.AQInverseATranspose.multTransB(this.AQInverse, this.linearEqualityConstraintsAMatrix);
        } else {
            this.AQInverse.reshape(numberOfEqualityConstraints, numberOfVariables);
            this.QInverseATranspose.reshape(numberOfVariables, numberOfEqualityConstraints);
            this.AQInverseATranspose.reshape(numberOfEqualityConstraints, numberOfEqualityConstraints);
        }
    }

    private void computeCBarTempMatrices() {
        if (this.CBar.getNumRows() > 0) {
            this.CBarQInverseATranspose.mult(this.CBar, this.QInverseATranspose);
            this.AQInverseCBarTranspose.transpose(this.CBarQInverseATranspose);
            this.CBarQInverse.mult(this.CBar, this.QInverse);
            this.QInverseCBarTranspose.transpose(this.CBarQInverse);
            this.CBarQInverseCBarTranspose.mult(this.CBar, this.QInverseCBarTranspose);
        } else {
            this.AQInverseCBarTranspose.reshape(0, 0);
            this.CBarQInverseATranspose.reshape(0, 0);
            this.CBarQInverse.reshape(0, 0);
            this.QInverseCBarTranspose.reshape(0, 0);
            this.CBarQInverseCBarTranspose.reshape(0, 0);
        }
    }

    private void computeCHatTempMatrices() {
        if (this.CHat.getNumRows() > 0) {
            this.CHatQInverseATranspose.mult(this.CHat, this.QInverseATranspose);
            this.AQInverseCHatTranspose.transpose(this.CHatQInverseATranspose);
            this.CHatQInverse.mult(this.CHat, this.QInverse);
            this.QInverseCHatTranspose.transpose(this.CHatQInverse);
            this.CHatQInverseCHatTranspose.mult(this.CHat, this.QInverseCHatTranspose);
            if (this.CBar.getNumRows() > 0) {
                this.CBarQInverseCHatTranspose.mult(this.CBar, this.QInverseCHatTranspose);
                this.CHatQInverseCBarTranspose.transpose(this.CBarQInverseCHatTranspose);
            } else {
                this.CBarQInverseCHatTranspose.reshape(this.CBar.getNumRows(), this.CHat.getNumRows());
                this.CHatQInverseCBarTranspose.reshape(this.CHat.getNumRows(), this.CBar.getNumRows());
            }
        } else {
            this.AQInverseCHatTranspose.reshape(0, 0);
            this.CHatQInverseATranspose.reshape(0, 0);
            this.CHatQInverse.reshape(0, 0);
            this.QInverseCHatTranspose.reshape(0, 0);
            this.CHatQInverseCHatTranspose.reshape(0, 0);
            this.CBarQInverseCHatTranspose.reshape(0, 0);
            this.CHatQInverseCBarTranspose.reshape(0, 0);
        }
    }

    private boolean modifyActiveSetAndTryAgain(NativeMatrix solutionToPack, NativeMatrix lagrangeEqualityConstraintMultipliersToPack, NativeMatrix lagrangeInequalityConstraintMultipliersToPack, NativeMatrix lagrangeLowerBoundConstraintMultipliersToPack, NativeMatrix lagrangeUpperBoundConstraintMultipliersToPack) {
        double lagrangeMultiplier;
        int indexToCheck;
        int i;
        int i2;
        int i3;
        if (solutionToPack.containsNaN()) {
            return false;
        }
        boolean activeSetWasModified = false;
        int numberOfInequalityConstraints = this.linearInequalityConstraintsCMatrixO.getNumRows();
        int numberOfLowerBoundConstraints = this.variableLowerBounds.getNumRows();
        int numberOfUpperBoundConstraints = this.variableUpperBounds.getNumRows();
        double maxInequalityViolation = Double.NEGATIVE_INFINITY;
        double maxLowerBoundViolation = Double.NEGATIVE_INFINITY;
        double maxUpperBoundViolation = Double.NEGATIVE_INFINITY;
        if (numberOfInequalityConstraints != 0) {
            this.linearInequalityConstraintsCheck.scale(-1.0, this.linearInequalityConstraintsDVectorO);
            this.linearInequalityConstraintsCheck.multAdd(this.linearInequalityConstraintsCMatrixO, solutionToPack);
            for (i3 = 0; i3 < this.linearInequalityConstraintsCheck.getNumRows(); ++i3) {
                if (this.activeInequalityIndices.contains(i3) || !(this.linearInequalityConstraintsCheck.get(i3, 0) >= maxInequalityViolation)) continue;
                maxInequalityViolation = this.linearInequalityConstraintsCheck.get(i3, 0);
            }
        }
        if (numberOfLowerBoundConstraints != 0) {
            this.lowerBoundViolations.subtract(this.variableLowerBounds, solutionToPack);
            for (i3 = 0; i3 < this.lowerBoundViolations.getNumRows(); ++i3) {
                if (this.activeLowerBoundIndices.contains(i3) || !(this.lowerBoundViolations.get(i3, 0) >= maxLowerBoundViolation)) continue;
                maxLowerBoundViolation = this.lowerBoundViolations.get(i3, 0);
            }
        } else {
            this.lowerBoundViolations.reshape(numberOfLowerBoundConstraints, 1);
        }
        if (numberOfUpperBoundConstraints != 0) {
            this.upperBoundViolations.subtract(solutionToPack, this.variableUpperBounds);
            for (i3 = 0; i3 < this.upperBoundViolations.getNumRows(); ++i3) {
                if (this.activeUpperBoundIndices.contains(i3) || !(this.upperBoundViolations.get(i3, 0) >= maxUpperBoundViolation)) continue;
                maxUpperBoundViolation = this.upperBoundViolations.get(i3, 0);
            }
        } else {
            this.upperBoundViolations.reshape(numberOfUpperBoundConstraints, 1);
        }
        double maxConstraintViolation = Math.max(maxInequalityViolation, Math.max(maxLowerBoundViolation, maxUpperBoundViolation));
        double minViolationToAdd = 0.19999999999999996 * maxConstraintViolation + this.convergenceThreshold;
        this.inequalityIndicesToAddToActiveSet.reset();
        if (maxInequalityViolation > minViolationToAdd) {
            for (i2 = 0; i2 < numberOfInequalityConstraints; ++i2) {
                if (this.activeInequalityIndices.contains(i2) || !(this.linearInequalityConstraintsCheck.get(i2, 0) > minViolationToAdd)) continue;
                activeSetWasModified = true;
                this.inequalityIndicesToAddToActiveSet.add(i2);
            }
        }
        this.lowerBoundIndicesToAddToActiveSet.reset();
        if (maxLowerBoundViolation > minViolationToAdd) {
            for (i2 = 0; i2 < numberOfLowerBoundConstraints; ++i2) {
                if (this.activeLowerBoundIndices.contains(i2) || !(this.lowerBoundViolations.get(i2, 0) > minViolationToAdd)) continue;
                activeSetWasModified = true;
                this.lowerBoundIndicesToAddToActiveSet.add(i2);
            }
        }
        this.upperBoundIndicesToAddToActiveSet.reset();
        if (maxUpperBoundViolation > minViolationToAdd) {
            for (i2 = 0; i2 < numberOfUpperBoundConstraints; ++i2) {
                if (this.activeUpperBoundIndices.contains(i2) || !(this.upperBoundViolations.get(i2, 0) > minViolationToAdd)) continue;
                activeSetWasModified = true;
                this.upperBoundIndicesToAddToActiveSet.add(i2);
            }
        }
        int numberOfActiveInequalityConstraints = this.activeInequalityIndices.size();
        int numberOfActiveUpperBounds = this.activeUpperBoundIndices.size();
        int numberOfActiveLowerBounds = this.activeLowerBoundIndices.size();
        double minLagrangeInequalityMultiplier = Double.POSITIVE_INFINITY;
        double minLagrangeLowerBoundMultiplier = Double.POSITIVE_INFINITY;
        double minLagrangeUpperBoundMultiplier = Double.POSITIVE_INFINITY;
        if (numberOfActiveInequalityConstraints != 0) {
            minLagrangeInequalityMultiplier = lagrangeInequalityConstraintMultipliersToPack.min();
        }
        if (numberOfActiveLowerBounds != 0) {
            minLagrangeLowerBoundMultiplier = lagrangeLowerBoundConstraintMultipliersToPack.min();
        }
        if (numberOfActiveUpperBounds != 0) {
            minLagrangeUpperBoundMultiplier = lagrangeUpperBoundConstraintMultipliersToPack.min();
        }
        double minLagrangeMultiplier = Math.min(minLagrangeInequalityMultiplier, Math.min(minLagrangeLowerBoundMultiplier, minLagrangeUpperBoundMultiplier));
        double maxLagrangeMultiplierToRemove = -0.050000000000000044 * minLagrangeMultiplier - this.convergenceThresholdForLagrangeMultipliers;
        this.inequalityIndicesToRemoveFromActiveSet.reset();
        if (minLagrangeInequalityMultiplier < maxLagrangeMultiplierToRemove) {
            for (i = 0; i < this.activeInequalityIndices.size(); ++i) {
                indexToCheck = this.activeInequalityIndices.get(i);
                lagrangeMultiplier = lagrangeInequalityConstraintMultipliersToPack.get(indexToCheck, 0);
                if (!(lagrangeMultiplier < maxLagrangeMultiplierToRemove)) continue;
                activeSetWasModified = true;
                this.inequalityIndicesToRemoveFromActiveSet.add(indexToCheck);
            }
        }
        this.lowerBoundIndicesToRemoveFromActiveSet.reset();
        if (minLagrangeLowerBoundMultiplier < maxLagrangeMultiplierToRemove) {
            for (i = 0; i < this.activeLowerBoundIndices.size(); ++i) {
                indexToCheck = this.activeLowerBoundIndices.get(i);
                lagrangeMultiplier = lagrangeLowerBoundConstraintMultipliersToPack.get(indexToCheck, 0);
                if (!(lagrangeMultiplier < maxLagrangeMultiplierToRemove)) continue;
                activeSetWasModified = true;
                this.lowerBoundIndicesToRemoveFromActiveSet.add(indexToCheck);
            }
        }
        this.upperBoundIndicesToRemoveFromActiveSet.reset();
        if (minLagrangeUpperBoundMultiplier < maxLagrangeMultiplierToRemove) {
            for (i = 0; i < this.activeUpperBoundIndices.size(); ++i) {
                indexToCheck = this.activeUpperBoundIndices.get(i);
                lagrangeMultiplier = lagrangeUpperBoundConstraintMultipliersToPack.get(indexToCheck, 0);
                if (!(lagrangeMultiplier < maxLagrangeMultiplierToRemove)) continue;
                activeSetWasModified = true;
                this.upperBoundIndicesToRemoveFromActiveSet.add(indexToCheck);
            }
        }
        if (!activeSetWasModified) {
            return false;
        }
        for (i = 0; i < this.inequalityIndicesToAddToActiveSet.size(); ++i) {
            this.activeInequalityIndices.add(this.inequalityIndicesToAddToActiveSet.get(i));
        }
        for (i = 0; i < this.inequalityIndicesToRemoveFromActiveSet.size(); ++i) {
            this.activeInequalityIndices.remove(this.inequalityIndicesToRemoveFromActiveSet.get(i));
        }
        for (i = 0; i < this.lowerBoundIndicesToAddToActiveSet.size(); ++i) {
            this.activeLowerBoundIndices.add(this.lowerBoundIndicesToAddToActiveSet.get(i));
        }
        for (i = 0; i < this.lowerBoundIndicesToRemoveFromActiveSet.size(); ++i) {
            this.activeLowerBoundIndices.remove(this.lowerBoundIndicesToRemoveFromActiveSet.get(i));
        }
        for (i = 0; i < this.upperBoundIndicesToAddToActiveSet.size(); ++i) {
            this.activeUpperBoundIndices.add(this.upperBoundIndicesToAddToActiveSet.get(i));
        }
        for (i = 0; i < this.upperBoundIndicesToRemoveFromActiveSet.size(); ++i) {
            this.activeUpperBoundIndices.remove(this.upperBoundIndicesToRemoveFromActiveSet.get(i));
        }
        this.addActiveSetConstraintsAsEqualityConstraints();
        this.solveEqualityConstrainedSubproblemEfficiently(solutionToPack, lagrangeEqualityConstraintMultipliersToPack, lagrangeInequalityConstraintMultipliersToPack, lagrangeLowerBoundConstraintMultipliersToPack, lagrangeUpperBoundConstraintMultipliersToPack);
        return true;
    }

    private void addActiveSetConstraintsAsEqualityConstraints() {
        int i;
        int numberOfVariables = this.quadraticCostQMatrix.getNumRows();
        int sizeOfActiveSet = this.activeInequalityIndices.size();
        this.CBar.reshape(sizeOfActiveSet, numberOfVariables);
        this.DBar.reshape(sizeOfActiveSet, 1);
        for (int i2 = 0; i2 < sizeOfActiveSet; ++i2) {
            int inequalityConstraintIndex = this.activeInequalityIndices.get(i2);
            this.CBar.insert(this.linearInequalityConstraintsCMatrixO, inequalityConstraintIndex, inequalityConstraintIndex + 1, 0, numberOfVariables, i2, 0);
            this.DBar.insert(this.linearInequalityConstraintsDVectorO, inequalityConstraintIndex, inequalityConstraintIndex + 1, 0, 1, i2, 0);
        }
        int sizeOfLowerBoundsActiveSet = this.activeLowerBoundIndices.size();
        int sizeOfUpperBoundsActiveSet = this.activeUpperBoundIndices.size();
        int sizeOfBoundsActiveSet = sizeOfLowerBoundsActiveSet + sizeOfUpperBoundsActiveSet;
        this.CHat.reshape(sizeOfBoundsActiveSet, numberOfVariables);
        this.DHat.reshape(sizeOfBoundsActiveSet, 1);
        this.CHat.zero();
        this.DHat.zero();
        int row = 0;
        for (i = 0; i < sizeOfLowerBoundsActiveSet; ++i) {
            int lowerBoundsConstraintIndex = this.activeLowerBoundIndices.get(i);
            this.CHat.set(row, lowerBoundsConstraintIndex, -1.0);
            this.DHat.set(row, 0, -this.variableLowerBounds.get(lowerBoundsConstraintIndex, 0));
            ++row;
        }
        for (i = 0; i < sizeOfUpperBoundsActiveSet; ++i) {
            int upperBoundsConstraintIndex = this.activeUpperBoundIndices.get(i);
            this.CHat.set(row, upperBoundsConstraintIndex, 1.0);
            this.DHat.set(row, 0, this.variableUpperBounds.get(upperBoundsConstraintIndex, 0));
            ++row;
        }
    }

    private void printSetChanges() {
        int i;
        if (!this.lowerBoundIndicesToAddToActiveSet.isEmpty()) {
            LogTools.info((String)"Lower bound indices added : ");
            for (i = 0; i < this.lowerBoundIndicesToAddToActiveSet.size(); ++i) {
                LogTools.info((String)("" + this.lowerBoundIndicesToAddToActiveSet.get(i)));
            }
        }
        if (!this.lowerBoundIndicesToRemoveFromActiveSet.isEmpty()) {
            LogTools.info((String)"Lower bound indices removed : ");
            for (i = 0; i < this.lowerBoundIndicesToRemoveFromActiveSet.size(); ++i) {
                LogTools.info((String)("" + this.lowerBoundIndicesToRemoveFromActiveSet.get(i)));
            }
        }
        if (!this.upperBoundIndicesToAddToActiveSet.isEmpty()) {
            LogTools.info((String)"Upper bound indices added : ");
            for (i = 0; i < this.upperBoundIndicesToAddToActiveSet.size(); ++i) {
                LogTools.info((String)("" + this.upperBoundIndicesToAddToActiveSet.get(i)));
            }
        }
        if (!this.upperBoundIndicesToRemoveFromActiveSet.isEmpty()) {
            LogTools.info((String)"Upper bound indices removed : ");
            for (i = 0; i < this.upperBoundIndicesToRemoveFromActiveSet.size(); ++i) {
                LogTools.info((String)("" + this.upperBoundIndicesToRemoveFromActiveSet.get(i)));
            }
        }
        if (!this.inequalityIndicesToAddToActiveSet.isEmpty()) {
            LogTools.info((String)"Inequality constraint indices added : ");
            for (i = 0; i < this.inequalityIndicesToAddToActiveSet.size(); ++i) {
                LogTools.info((String)("" + this.inequalityIndicesToAddToActiveSet.get(i)));
            }
        }
        if (!this.inequalityIndicesToRemoveFromActiveSet.isEmpty()) {
            LogTools.info((String)"Inequality constraint indices removed : ");
            for (i = 0; i < this.inequalityIndicesToRemoveFromActiveSet.size(); ++i) {
                LogTools.info((String)("" + this.inequalityIndicesToRemoveFromActiveSet.get(i)));
            }
        }
    }

    private void solveEqualityConstrainedSubproblemEfficiently(NativeMatrix xSolutionToPack, NativeMatrix lagrangeEqualityConstraintMultipliersToPack, NativeMatrix lagrangeInequalityConstraintMultipliersToPack, NativeMatrix lagrangeLowerBoundConstraintMultipliersToPack, NativeMatrix lagrangeUpperBoundConstraintMultipliersToPack) {
        int i;
        int numberOfActiveUpperBoundConstraints;
        int numberOfActiveLowerBoundConstraints;
        int numberOfActiveInequalityConstraints;
        int numberOfVariables = this.quadraticCostQMatrix.getNumRows();
        int numberOfOriginalEqualityConstraints = this.linearEqualityConstraintsAMatrix.getNumRows();
        int numberOfAugmentedEqualityConstraints = numberOfOriginalEqualityConstraints + (numberOfActiveInequalityConstraints = this.activeInequalityIndices.size()) + (numberOfActiveLowerBoundConstraints = this.activeLowerBoundIndices.size()) + (numberOfActiveUpperBoundConstraints = this.activeUpperBoundIndices.size());
        if (numberOfAugmentedEqualityConstraints == 0) {
            xSolutionToPack.mult(-1.0, this.QInverse, this.quadraticCostQVector);
            this.reportSolution(xSolutionToPack);
            return;
        }
        this.computeCBarTempMatrices();
        this.computeCHatTempMatrices();
        this.bigMatrixForLagrangeMultiplierSolution.reshape(numberOfAugmentedEqualityConstraints, numberOfAugmentedEqualityConstraints);
        this.bigVectorForLagrangeMultiplierSolution.reshape(numberOfAugmentedEqualityConstraints, 1);
        this.bigMatrixForLagrangeMultiplierSolution.insert(this.AQInverseATranspose, 0, 0);
        this.bigMatrixForLagrangeMultiplierSolution.insert(this.AQInverseCBarTranspose, 0, numberOfOriginalEqualityConstraints);
        this.bigMatrixForLagrangeMultiplierSolution.insert(this.AQInverseCHatTranspose, 0, numberOfOriginalEqualityConstraints + numberOfActiveInequalityConstraints);
        this.bigMatrixForLagrangeMultiplierSolution.insert(this.CBarQInverseATranspose, numberOfOriginalEqualityConstraints, 0);
        this.bigMatrixForLagrangeMultiplierSolution.insert(this.CBarQInverseCBarTranspose, numberOfOriginalEqualityConstraints, numberOfOriginalEqualityConstraints);
        this.bigMatrixForLagrangeMultiplierSolution.insert(this.CBarQInverseCHatTranspose, numberOfOriginalEqualityConstraints, numberOfOriginalEqualityConstraints + numberOfActiveInequalityConstraints);
        this.bigMatrixForLagrangeMultiplierSolution.insert(this.CHatQInverseATranspose, numberOfOriginalEqualityConstraints + numberOfActiveInequalityConstraints, 0);
        this.bigMatrixForLagrangeMultiplierSolution.insert(this.CHatQInverseCBarTranspose, numberOfOriginalEqualityConstraints + numberOfActiveInequalityConstraints, numberOfOriginalEqualityConstraints);
        this.bigMatrixForLagrangeMultiplierSolution.insert(this.CHatQInverseCHatTranspose, numberOfOriginalEqualityConstraints + numberOfActiveInequalityConstraints, numberOfOriginalEqualityConstraints + numberOfActiveInequalityConstraints);
        if (numberOfOriginalEqualityConstraints > 0) {
            this.bigVectorForLagrangeMultiplierSolution.insert(this.linearEqualityConstraintsBVector, 0, 0);
            this.bigVectorForLagrangeMultiplierSolution.multAddBlock(this.AQInverse, this.quadraticCostQVector, 0, 0);
        }
        if (numberOfActiveInequalityConstraints > 0) {
            this.bigVectorForLagrangeMultiplierSolution.insert(this.DBar, numberOfOriginalEqualityConstraints, 0);
            this.bigVectorForLagrangeMultiplierSolution.multAddBlock(this.CBarQInverse, this.quadraticCostQVector, numberOfOriginalEqualityConstraints, 0);
        }
        if (numberOfActiveLowerBoundConstraints + numberOfActiveUpperBoundConstraints > 0) {
            this.bigVectorForLagrangeMultiplierSolution.insert(this.DHat, numberOfOriginalEqualityConstraints + numberOfActiveInequalityConstraints, 0);
            this.bigVectorForLagrangeMultiplierSolution.multAddBlock(this.CHatQInverse, this.quadraticCostQVector, numberOfOriginalEqualityConstraints + numberOfActiveInequalityConstraints, 0);
        }
        this.bigVectorForLagrangeMultiplierSolution.scale(-1.0, this.bigVectorForLagrangeMultiplierSolution);
        this.augmentedLagrangeMultipliers.solve(this.bigMatrixForLagrangeMultiplierSolution, this.bigVectorForLagrangeMultiplierSolution);
        this.AAndC.reshape(numberOfAugmentedEqualityConstraints, numberOfVariables);
        this.AAndC.insert(this.linearEqualityConstraintsAMatrix, 0, 0);
        this.AAndC.insert(this.CBar, numberOfOriginalEqualityConstraints, 0);
        this.AAndC.insert(this.CHat, numberOfOriginalEqualityConstraints + numberOfActiveInequalityConstraints, 0);
        this.ATransposeMuAndCTransposeLambda.multTransA(this.AAndC, this.augmentedLagrangeMultipliers);
        this.tempVector.add(this.quadraticCostQVector, this.ATransposeMuAndCTransposeLambda);
        xSolutionToPack.mult(-1.0, this.QInverse, this.tempVector);
        this.reportSolution(xSolutionToPack);
        int startRow = 0;
        int numberOfRows = numberOfOriginalEqualityConstraints;
        lagrangeEqualityConstraintMultipliersToPack.insert(this.augmentedLagrangeMultipliers, startRow, startRow + numberOfRows, 0, 1, 0, 0);
        startRow += numberOfRows;
        lagrangeInequalityConstraintMultipliersToPack.zero();
        for (i = 0; i < numberOfActiveInequalityConstraints; ++i) {
            int inequalityConstraintIndex = this.activeInequalityIndices.get(i);
            lagrangeInequalityConstraintMultipliersToPack.insert(this.augmentedLagrangeMultipliers, startRow + i, startRow + i + 1, 0, 1, inequalityConstraintIndex, 0);
        }
        startRow += numberOfActiveInequalityConstraints;
        lagrangeLowerBoundConstraintMultipliersToPack.zero();
        for (i = 0; i < numberOfActiveLowerBoundConstraints; ++i) {
            int lowerBoundConstraintIndex = this.activeLowerBoundIndices.get(i);
            lagrangeLowerBoundConstraintMultipliersToPack.insert(this.augmentedLagrangeMultipliers, startRow + i, startRow + i + 1, 0, 1, lowerBoundConstraintIndex, 0);
        }
        startRow += numberOfActiveLowerBoundConstraints;
        lagrangeUpperBoundConstraintMultipliersToPack.zero();
        for (i = 0; i < numberOfActiveUpperBoundConstraints; ++i) {
            int upperBoundConstraintIndex = this.activeUpperBoundIndices.get(i);
            lagrangeUpperBoundConstraintMultipliersToPack.insert(this.augmentedLagrangeMultipliers, startRow + i, startRow + i + 1, 0, 1, upperBoundConstraintIndex, 0);
        }
    }

    private void reportSolution(NativeMatrix solution) {
        for (int i = 0; i < this.solutionListeners.size(); ++i) {
            this.solutionListeners.get(i).reportSolution(solution, this.activeInequalityIndices, this.activeLowerBoundIndices, this.activeUpperBoundIndices);
        }
    }

    @Override
    public void getLagrangeEqualityConstraintMultipliers(DMatrixRMaj multipliersMatrixToPack) {
        this.lagrangeEqualityConstraintMultipliers.get(multipliersMatrixToPack);
    }

    @Override
    public void getLagrangeInequalityConstraintMultipliers(DMatrixRMaj multipliersMatrixToPack) {
        this.lagrangeInequalityConstraintMultipliers.get(multipliersMatrixToPack);
    }

    @Override
    public void getLagrangeLowerBoundsMultipliers(DMatrixRMaj multipliersMatrixToPack) {
        this.lagrangeLowerBoundMultipliers.get(multipliersMatrixToPack);
    }

    @Override
    public void getLagrangeUpperBoundsMultipliers(DMatrixRMaj multipliersMatrixToPack) {
        this.lagrangeUpperBoundMultipliers.get(multipliersMatrixToPack);
    }

    public void setInverseHessianCalculator(InverseMatrixCalculator<NativeMatrix> inverseSolver) {
        this.inverseSolver = inverseSolver;
    }

    private static class DefaultInverseMatrixCalculator
    implements InverseMatrixCalculator<NativeMatrix> {
        private DefaultInverseMatrixCalculator() {
        }

        @Override
        public void computeInverse(NativeMatrix matrixToInvert, NativeMatrix inverseMatrixToPack) {
            inverseMatrixToPack.invert(matrixToInvert);
        }
    }
}

