/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.convexOptimization.quadraticProgram;

import gnu.trove.list.array.TIntArrayList;
import org.ejml.MatrixDimensionException;
import org.ejml.data.DMatrix;
import org.ejml.data.DMatrix1Row;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.data.Matrix;
import org.ejml.dense.row.CommonOps_DDRM;
import org.ejml.dense.row.factory.DecompositionFactory_DDRM;
import org.ejml.interfaces.decomposition.CholeskyDecomposition;
import us.ihmc.commons.MathTools;
import us.ihmc.convexOptimization.quadraticProgram.AbstractSimpleActiveSetQPSolver;
import us.ihmc.matrixlib.MatrixTools;
import us.ihmc.matrixlib.NativeCommonOps;

public class JavaQuadProgSolver
extends AbstractSimpleActiveSetQPSolver {
    private static final boolean bulkHandleEqualityConstraints = false;
    private static final int TRUE = 1;
    private static final int FALSE = 0;
    private boolean requireInequalityConstraintsSatisfied = true;
    private static final int defaultSize = 100;
    private static final double epsilon = 1.0E-24;
    private final DMatrixRMaj R = new DMatrixRMaj(0, 0);
    private final DMatrixRMaj inequalityConstraintViolations = new DMatrixRMaj(0, 0);
    private final DMatrixRMaj stepDirectionInPrimalSpace = new DMatrixRMaj(0, 0);
    private final DMatrixRMaj infeasibilityMultiplier = new DMatrixRMaj(0, 0);
    private final DMatrixRMaj d = new DMatrixRMaj(0, 0);
    private final DMatrixRMaj violatedConstraintNormal = new DMatrixRMaj(0, 0);
    private final DMatrixRMaj lagrangeMultipliers = new DMatrixRMaj(0, 0);
    private final DMatrixRMaj previousLagrangeMultipliers = new DMatrixRMaj(0, 0);
    private final DMatrixRMaj previousSolution = new DMatrixRMaj(0, 0);
    private final TIntArrayList activeSetIndices = new TIntArrayList(0);
    private final TIntArrayList previousActiveSetIndices = new TIntArrayList(0);
    private final TIntArrayList inactiveSetIndices = new TIntArrayList(0);
    private final TIntArrayList excludeConstraintFromActiveSet = new TIntArrayList(0);
    private final DMatrixRMaj J = new DMatrixRMaj(0, 0);
    private final DMatrixRMaj Q_augmented = new DMatrixRMaj(0, 0);
    private final DMatrixRMaj q_augmented = new DMatrixRMaj(0, 0);
    private final DMatrixRMaj Q_augmented_inv = new DMatrixRMaj(0, 0);
    private final CholeskyDecomposition<DMatrixRMaj> decomposer = DecompositionFactory_DDRM.chol((int)100, (boolean)false);
    private final DMatrixRMaj decomposedQuadraticCostQMatrix = new DMatrixRMaj(0, 0);
    private final DMatrixRMaj totalLinearInequalityConstraintsCMatrix = new DMatrixRMaj(0, 0);
    private final DMatrixRMaj totalLinearInequalityConstraintsDVector = new DMatrixRMaj(0, 0);
    protected final DMatrixRMaj lowerBoundsCMatrix = new DMatrixRMaj(0, 0);
    protected final DMatrixRMaj upperBoundsCMatrix = new DMatrixRMaj(0, 0);
    private int problemSize;
    private int numberOfInequalityConstraints;
    private int totalNumberOfInequalityConstraints;
    private int numberOfEqualityConstraints;
    private int numberOfLowerBounds;
    private int numberOfUpperBounds;
    private int numberOfActiveConstraints;
    private double R_norm;
    private int constraintIndexForPartialStep;
    private int maxNumberOfIterations = 500;
    private double convergenceThreshold = 1.0E-14;
    protected final DMatrixRMaj computedObjectiveFunctionValue = new DMatrixRMaj(1, 1);
    private final DMatrixRMaj lagrangeEqualityConstraintMultipliers = new DMatrixRMaj(0, 0);
    private final DMatrixRMaj lagrangeInequalityConstraintMultipliers = new DMatrixRMaj(0, 0);
    private final DMatrixRMaj lagrangeLowerBoundMultipliers = new DMatrixRMaj(0, 0);
    private final DMatrixRMaj lagrangeUpperBoundMultipliers = new DMatrixRMaj(0, 0);
    private final DMatrixRMaj internalSolution = new DMatrixRMaj(0, 0);
    private final DMatrixRMaj tempMatrix = new DMatrixRMaj(100, 100);

    public void setRequireInequalityConstraintsSatisfied(boolean requireInequalityConstraintsSatisfied) {
        this.requireInequalityConstraintsSatisfied = requireInequalityConstraintsSatisfied;
    }

    @Override
    public void setConvergenceThreshold(double convergenceThreshold) {
        this.convergenceThreshold = convergenceThreshold;
    }

    @Override
    public void setMaxNumberOfIterations(int maxNumberOfIterations) {
        this.maxNumberOfIterations = maxNumberOfIterations;
    }

    @Override
    public void clear() {
        this.problemSize = 0;
        this.numberOfEqualityConstraints = 0;
        this.numberOfInequalityConstraints = 0;
        this.totalNumberOfInequalityConstraints = 0;
        this.numberOfLowerBounds = 0;
        this.numberOfUpperBounds = 0;
        this.quadraticCostQMatrix.reshape(0, 0);
        this.decomposedQuadraticCostQMatrix.reshape(0, 0);
        this.quadraticCostQVector.reshape(0, 0);
        this.linearEqualityConstraintsAMatrix.reshape(0, 0);
        this.linearEqualityConstraintsBVector.reshape(0, 0);
        this.linearInequalityConstraintsCMatrixO.reshape(0, 0);
        this.linearInequalityConstraintsDVectorO.reshape(0, 0);
        this.lowerBoundsCMatrix.reshape(0, 0);
        this.variableLowerBounds.reshape(0, 0);
        this.upperBoundsCMatrix.reshape(0, 0);
        this.variableUpperBounds.reshape(0, 0);
    }

    @Override
    public void setLowerBounds(DMatrix variableLowerBounds) {
        int numberOfLowerBounds = variableLowerBounds.getNumRows();
        if (numberOfLowerBounds != this.quadraticCostQMatrix.getNumRows()) {
            throw new RuntimeException("variableLowerBounds.getNumRows() != quadraticCostQMatrix.getNumRows()");
        }
        this.lowerBoundsCMatrix.reshape(numberOfLowerBounds, numberOfLowerBounds);
        CommonOps_DDRM.setIdentity((DMatrix1Row)this.lowerBoundsCMatrix);
        this.variableLowerBounds.set((Matrix)variableLowerBounds);
        CommonOps_DDRM.scale((double)-1.0, (DMatrixD1)this.variableLowerBounds);
    }

    @Override
    public void setUpperBounds(DMatrix variableUpperBounds) {
        int numberOfUpperBounds = variableUpperBounds.getNumRows();
        if (numberOfUpperBounds != this.quadraticCostQMatrix.getNumRows()) {
            throw new RuntimeException("variableUpperBounds.getNumRows() != quadraticCostQMatrix.getNumRows()");
        }
        this.upperBoundsCMatrix.reshape(numberOfUpperBounds, numberOfUpperBounds);
        CommonOps_DDRM.setIdentity((DMatrix1Row)this.upperBoundsCMatrix);
        CommonOps_DDRM.scale((double)-1.0, (DMatrixD1)this.upperBoundsCMatrix);
        this.variableUpperBounds.set((Matrix)variableUpperBounds);
    }

    @Override
    public void setQuadraticCostFunction(DMatrix costQuadraticMatrix, DMatrix costLinearVector, double quadraticCostScalar) {
        if (costLinearVector.getNumCols() != 1) {
            throw new RuntimeException("costLinearVector.getNumCols() != 1");
        }
        if (costQuadraticMatrix.getNumRows() != costLinearVector.getNumRows()) {
            throw new RuntimeException("costQuadraticMatrix.getNumRows() != costLinearVector.getNumRows()");
        }
        if (costQuadraticMatrix.getNumRows() != costQuadraticMatrix.getNumCols()) {
            throw new RuntimeException("costQuadraticMatrix.getNumRows() != costQuadraticMatrix.getNumCols()");
        }
        this.quadraticCostQMatrix.set((Matrix)costQuadraticMatrix);
        this.quadraticCostQVector.set((Matrix)costLinearVector);
        this.quadraticCostScalar = quadraticCostScalar;
    }

    @Override
    public double getObjectiveCost(DMatrixRMaj x) {
        NativeCommonOps.multQuad((DMatrix1Row)x, (DMatrix1Row)this.quadraticCostQMatrix, (DMatrix1Row)this.computedObjectiveFunctionValue);
        CommonOps_DDRM.scale((double)0.5, (DMatrixD1)this.computedObjectiveFunctionValue);
        CommonOps_DDRM.multAddTransA((DMatrix1Row)this.quadraticCostQVector, (DMatrix1Row)x, (DMatrix1Row)this.computedObjectiveFunctionValue);
        return this.computedObjectiveFunctionValue.get(0, 0) + this.quadraticCostScalar;
    }

    @Override
    public void setLinearEqualityConstraints(DMatrix linearEqualityConstraintsAMatrix, DMatrix linearEqualityConstraintsBVector) {
        int numberOfEqualityConstraints = linearEqualityConstraintsBVector.getNumRows();
        if (linearEqualityConstraintsBVector.getNumCols() != 1) {
            throw new RuntimeException("linearEqualityConstraintsBVector.getNumCols() != 1");
        }
        if (linearEqualityConstraintsAMatrix.getNumRows() != linearEqualityConstraintsBVector.getNumRows()) {
            throw new RuntimeException("linearEqualityConstraintsAMatrix.getNumRows() != linearEqualityConstraintsBVector.getNumRows()");
        }
        if (linearEqualityConstraintsAMatrix.getNumCols() != this.quadraticCostQMatrix.getNumCols()) {
            throw new RuntimeException("linearEqualityConstraintsAMatrix.getNumCols() != quadraticCostQMatrix.getNumCols()");
        }
        this.linearEqualityConstraintsAMatrix.reshape(this.quadraticCostQMatrix.getNumCols(), numberOfEqualityConstraints);
        JavaQuadProgSolver.standardTranspose(linearEqualityConstraintsAMatrix, (DMatrix1Row)this.linearEqualityConstraintsAMatrix);
        CommonOps_DDRM.scale((double)-1.0, (DMatrixD1)this.linearEqualityConstraintsAMatrix);
        this.linearEqualityConstraintsBVector.set((Matrix)linearEqualityConstraintsBVector);
    }

    @Override
    public void setLinearInequalityConstraints(DMatrix linearInequalityConstraintCMatrix, DMatrix linearInequalityConstraintDVector) {
        int numberOfInequalityConstraints = linearInequalityConstraintDVector.getNumRows();
        if (linearInequalityConstraintDVector.getNumCols() != 1) {
            throw new RuntimeException("linearInequalityConstraintDVector.getNumCols() != 1");
        }
        if (linearInequalityConstraintCMatrix.getNumRows() != linearInequalityConstraintDVector.getNumRows()) {
            throw new RuntimeException("linearInequalityConstraintCMatrix.getNumRows() != linearInequalityConstraintDVector.getNumRows()");
        }
        if (linearInequalityConstraintCMatrix.getNumCols() != this.quadraticCostQMatrix.getNumCols()) {
            throw new RuntimeException("linearInequalityConstraintCMatrix.getNumCols() != quadraticCostQMatrix.getNumCols()");
        }
        this.linearInequalityConstraintsCMatrixO.reshape(this.quadraticCostQMatrix.getNumCols(), numberOfInequalityConstraints);
        JavaQuadProgSolver.standardTranspose(linearInequalityConstraintCMatrix, (DMatrix1Row)this.linearInequalityConstraintsCMatrixO);
        CommonOps_DDRM.scale((double)-1.0, (DMatrixD1)this.linearInequalityConstraintsCMatrixO);
        this.linearInequalityConstraintsDVectorO.set((Matrix)linearInequalityConstraintDVector);
    }

    @Override
    public void setUseWarmStart(boolean useWarmStart) {
    }

    @Override
    public void resetActiveSet() {
    }

    @Override
    public int solve(DMatrix solutionToPack) {
        this.numberOfEqualityConstraints = this.linearEqualityConstraintsBVector.getNumRows();
        this.numberOfLowerBounds = this.variableLowerBounds.getNumRows();
        this.numberOfUpperBounds = this.variableUpperBounds.getNumRows();
        this.numberOfInequalityConstraints = this.linearInequalityConstraintsDVectorO.getNumRows();
        this.problemSize = this.quadraticCostQMatrix.getNumCols();
        if (solutionToPack.getNumRows() != this.problemSize || solutionToPack.getNumCols() != 1) {
            throw new IllegalArgumentException("Invalid matrix dimensions.");
        }
        solutionToPack.zero();
        this.internalSolution.reshape(this.problemSize, 1);
        this.internalSolution.zero();
        this.lagrangeEqualityConstraintMultipliers.reshape(this.numberOfEqualityConstraints, 1);
        this.lagrangeEqualityConstraintMultipliers.zero();
        this.lagrangeInequalityConstraintMultipliers.reshape(this.numberOfInequalityConstraints, 1);
        this.lagrangeInequalityConstraintMultipliers.zero();
        this.lagrangeLowerBoundMultipliers.reshape(this.numberOfLowerBounds, 1);
        this.lagrangeLowerBoundMultipliers.zero();
        this.lagrangeUpperBoundMultipliers.reshape(this.numberOfUpperBounds, 1);
        this.lagrangeUpperBoundMultipliers.zero();
        this.reshape();
        this.zero();
        QuadProgStep currentStep = QuadProgStep.COMPUTE_CONSTRAINT_VIOLATIONS;
        int mostViolatedConstraintIndex = 0;
        this.J.reshape(this.problemSize, this.problemSize);
        double c1 = CommonOps_DDRM.trace((DMatrix1Row)this.quadraticCostQMatrix);
        this.decomposedQuadraticCostQMatrix.set((DMatrixD1)this.quadraticCostQMatrix);
        this.decomposer.decompose((Matrix)this.decomposedQuadraticCostQMatrix);
        this.R_norm = 1.0;
        NativeCommonOps.invert((DMatrix1Row)this.decomposedQuadraticCostQMatrix, (DMatrix1Row)this.J);
        double c2 = CommonOps_DDRM.trace((DMatrix1Row)this.J);
        int numberOfIterations = 0;
        this.tempMatrix.reshape(this.problemSize, 1);
        CommonOps_DDRM.multTransA((DMatrix1Row)this.J, (DMatrix1Row)this.quadraticCostQVector, (DMatrix1Row)this.tempMatrix);
        CommonOps_DDRM.mult((double)-1.0, (DMatrix1Row)this.J, (DMatrix1Row)this.tempMatrix, (DMatrix1Row)this.internalSolution);
        this.numberOfActiveConstraints = 0;
        for (int equalityConstraintIndex = 0; equalityConstraintIndex < this.numberOfEqualityConstraints; ++equalityConstraintIndex) {
            MatrixTools.setMatrixBlock((DMatrix)this.violatedConstraintNormal, (int)0, (int)0, (DMatrix)this.linearEqualityConstraintsAMatrix, (int)0, (int)equalityConstraintIndex, (int)this.problemSize, (int)1, (double)1.0);
            this.compute_d();
            this.updateStepDirectionInPrimalSpace();
            this.updateInfeasibilityMultiplier();
            double stepLengthForEqualityConstraint = this.computeStepLengthForEqualityConstraint(this.internalSolution, equalityConstraintIndex);
            CommonOps_DDRM.addEquals((DMatrixD1)this.internalSolution, (double)stepLengthForEqualityConstraint, (DMatrixD1)this.stepDirectionInPrimalSpace);
            this.lagrangeMultipliers.set(this.numberOfActiveConstraints, stepLengthForEqualityConstraint);
            MatrixTools.addMatrixBlock((DMatrix)this.lagrangeMultipliers, (int)0, (int)0, (DMatrix1Row)this.infeasibilityMultiplier, (int)0, (int)0, (int)this.numberOfActiveConstraints, (int)1, (double)stepLengthForEqualityConstraint);
            this.activeSetIndices.set(equalityConstraintIndex, -equalityConstraintIndex - 1);
            if (this.addConstraint()) continue;
            CommonOps_DDRM.fill((DMatrixD1)this.internalSolution, (double)Double.NaN);
            CommonOps_DDRM.fill((DMatrixD1)this.lagrangeEqualityConstraintMultipliers, (double)Double.POSITIVE_INFINITY);
            CommonOps_DDRM.fill((DMatrixD1)this.lagrangeInequalityConstraintMultipliers, (double)Double.POSITIVE_INFINITY);
            CommonOps_DDRM.fill((DMatrixD1)this.lagrangeLowerBoundMultipliers, (double)Double.POSITIVE_INFINITY);
            CommonOps_DDRM.fill((DMatrixD1)this.lagrangeUpperBoundMultipliers, (double)Double.POSITIVE_INFINITY);
            solutionToPack.set((Matrix)this.internalSolution);
            return numberOfIterations - 1;
        }
        for (int inequalityConstraintIndex = 0; inequalityConstraintIndex < this.totalNumberOfInequalityConstraints; ++inequalityConstraintIndex) {
            this.inactiveSetIndices.set(inequalityConstraintIndex, inequalityConstraintIndex);
        }
        this.constraintIndexForPartialStep = 0;
        boolean isValid = true;
        while (true) {
            double stepLength;
            double fullStepLength;
            switch (currentStep) {
                case COMPUTE_CONSTRAINT_VIOLATIONS: {
                    if (this.computeConstraintViolations(this.internalSolution, c1, c2)) {
                        this.partitionLagrangeMultipliers(this.lagrangeEqualityConstraintMultipliers, this.lagrangeInequalityConstraintMultipliers, this.lagrangeLowerBoundMultipliers, this.lagrangeUpperBoundMultipliers);
                        solutionToPack.set((Matrix)this.internalSolution);
                        return numberOfIterations;
                    }
                }
                case FIND_MOST_VIOLATED_CONSTRAINT: {
                    double biggestConstraintViolation = 0.0;
                    mostViolatedConstraintIndex = 0;
                    for (int inequalityConstraintIndex = 0; inequalityConstraintIndex < this.totalNumberOfInequalityConstraints; ++inequalityConstraintIndex) {
                        if (!(this.inequalityConstraintViolations.get(inequalityConstraintIndex) < biggestConstraintViolation) || this.inactiveSetIndices.get(inequalityConstraintIndex) == -1 || this.excludeConstraintFromActiveSet.get(inequalityConstraintIndex) != 1) continue;
                        biggestConstraintViolation = this.inequalityConstraintViolations.get(inequalityConstraintIndex);
                        mostViolatedConstraintIndex = inequalityConstraintIndex;
                    }
                    if (biggestConstraintViolation >= 0.0) {
                        if (this.requireInequalityConstraintsSatisfied) {
                            CommonOps_DDRM.fill((DMatrixD1)this.internalSolution, (double)Double.NaN);
                            CommonOps_DDRM.fill((DMatrixD1)this.lagrangeEqualityConstraintMultipliers, (double)Double.POSITIVE_INFINITY);
                            CommonOps_DDRM.fill((DMatrixD1)this.lagrangeInequalityConstraintMultipliers, (double)Double.POSITIVE_INFINITY);
                            CommonOps_DDRM.fill((DMatrixD1)this.lagrangeLowerBoundMultipliers, (double)Double.POSITIVE_INFINITY);
                            CommonOps_DDRM.fill((DMatrixD1)this.lagrangeUpperBoundMultipliers, (double)Double.POSITIVE_INFINITY);
                            solutionToPack.set((Matrix)this.internalSolution);
                            return numberOfIterations;
                        }
                        this.partitionLagrangeMultipliers(this.lagrangeEqualityConstraintMultipliers, this.lagrangeInequalityConstraintMultipliers, this.lagrangeLowerBoundMultipliers, this.lagrangeUpperBoundMultipliers);
                        solutionToPack.set((Matrix)this.internalSolution);
                        return numberOfIterations;
                    }
                    MatrixTools.setMatrixBlock((DMatrix)this.violatedConstraintNormal, (int)0, (int)0, (DMatrix)this.totalLinearInequalityConstraintsCMatrix, (int)0, (int)mostViolatedConstraintIndex, (int)this.problemSize, (int)1, (double)1.0);
                    this.lagrangeMultipliers.set(this.numberOfActiveConstraints, 0.0);
                    this.activeSetIndices.set(this.numberOfActiveConstraints, mostViolatedConstraintIndex);
                }
                case COMPUTE_STEP_LENGTH: {
                    this.compute_d();
                    this.updateStepDirectionInPrimalSpace();
                    this.updateInfeasibilityMultiplier();
                    this.constraintIndexForPartialStep = 0;
                    double partialStepLength = this.computePartialStepLength();
                    fullStepLength = this.computeFullStepLength(mostViolatedConstraintIndex);
                    stepLength = Math.min(partialStepLength, fullStepLength);
                    break;
                }
                case FAILED: {
                    CommonOps_DDRM.fill((DMatrixD1)this.internalSolution, (double)Double.NaN);
                    CommonOps_DDRM.fill((DMatrixD1)this.lagrangeEqualityConstraintMultipliers, (double)Double.POSITIVE_INFINITY);
                    CommonOps_DDRM.fill((DMatrixD1)this.lagrangeInequalityConstraintMultipliers, (double)Double.POSITIVE_INFINITY);
                    CommonOps_DDRM.fill((DMatrixD1)this.lagrangeLowerBoundMultipliers, (double)Double.POSITIVE_INFINITY);
                    CommonOps_DDRM.fill((DMatrixD1)this.lagrangeUpperBoundMultipliers, (double)Double.POSITIVE_INFINITY);
                    solutionToPack.set((Matrix)this.internalSolution);
                    return numberOfIterations;
                }
                default: {
                    throw new RuntimeException("This is an empty state.");
                }
            }
            if (!isValid) break;
            if (!Double.isFinite(stepLength)) {
                CommonOps_DDRM.fill((DMatrixD1)this.internalSolution, (double)Double.NaN);
                CommonOps_DDRM.fill((DMatrixD1)this.lagrangeEqualityConstraintMultipliers, (double)Double.POSITIVE_INFINITY);
                CommonOps_DDRM.fill((DMatrixD1)this.lagrangeInequalityConstraintMultipliers, (double)Double.POSITIVE_INFINITY);
                CommonOps_DDRM.fill((DMatrixD1)this.lagrangeLowerBoundMultipliers, (double)Double.POSITIVE_INFINITY);
                CommonOps_DDRM.fill((DMatrixD1)this.lagrangeUpperBoundMultipliers, (double)Double.POSITIVE_INFINITY);
                solutionToPack.set((Matrix)this.internalSolution);
                return numberOfIterations;
            }
            if (!Double.isFinite(fullStepLength)) {
                if (++numberOfIterations > this.maxNumberOfIterations) break;
                currentStep = this.takeStepInDualSpace(stepLength);
                continue;
            }
            if (++numberOfIterations > this.maxNumberOfIterations) break;
            currentStep = this.takeStepInPrimalAndDualSpace(this.internalSolution, stepLength, fullStepLength, mostViolatedConstraintIndex);
        }
        CommonOps_DDRM.fill((DMatrixD1)this.internalSolution, (double)Double.NaN);
        CommonOps_DDRM.fill((DMatrixD1)this.lagrangeEqualityConstraintMultipliers, (double)Double.POSITIVE_INFINITY);
        CommonOps_DDRM.fill((DMatrixD1)this.lagrangeInequalityConstraintMultipliers, (double)Double.POSITIVE_INFINITY);
        CommonOps_DDRM.fill((DMatrixD1)this.lagrangeLowerBoundMultipliers, (double)Double.POSITIVE_INFINITY);
        CommonOps_DDRM.fill((DMatrixD1)this.lagrangeUpperBoundMultipliers, (double)Double.POSITIVE_INFINITY);
        solutionToPack.set((Matrix)this.internalSolution);
        return numberOfIterations - 1;
    }

    private void compute_d() {
        CommonOps_DDRM.multTransA((DMatrix1Row)this.J, (DMatrix1Row)this.violatedConstraintNormal, (DMatrix1Row)this.d);
    }

    private void updateStepDirectionInPrimalSpace() {
        for (int i = 0; i < this.problemSize; ++i) {
            double sum = 0.0;
            for (int j = this.numberOfActiveConstraints; j < this.problemSize; ++j) {
                sum += this.J.get(i, j) * this.d.get(j);
            }
            this.stepDirectionInPrimalSpace.set(i, sum);
        }
    }

    private void updateInfeasibilityMultiplier() {
        for (int i = this.numberOfActiveConstraints - 1; i >= 0; --i) {
            double sum = 0.0;
            for (int j = i + 1; j < this.numberOfActiveConstraints; ++j) {
                sum += this.R.get(i, j) * this.infeasibilityMultiplier.get(j);
            }
            this.infeasibilityMultiplier.set(i, (sum - this.d.get(i)) / this.R.get(i, i));
        }
    }

    private boolean computeConstraintViolations(DMatrixRMaj solutionToPack, double c1, double c2) {
        for (int activeInequalityIndex = this.numberOfEqualityConstraints; activeInequalityIndex < this.numberOfActiveConstraints; ++activeInequalityIndex) {
            int activeConstraintIndex = this.activeSetIndices.get(activeInequalityIndex);
            this.inactiveSetIndices.set(activeConstraintIndex, -1);
        }
        double totalInequalityViolation = 0.0;
        for (int inequalityConstraintIndex = 0; inequalityConstraintIndex < this.totalNumberOfInequalityConstraints; ++inequalityConstraintIndex) {
            this.excludeConstraintFromActiveSet.set(inequalityConstraintIndex, 1);
            double constraintValue = 0.0;
            for (int j = 0; j < this.problemSize; ++j) {
                constraintValue += this.totalLinearInequalityConstraintsCMatrix.get(j, inequalityConstraintIndex) * solutionToPack.get(j);
            }
            this.inequalityConstraintViolations.set(inequalityConstraintIndex, constraintValue += this.totalLinearInequalityConstraintsDVector.get(inequalityConstraintIndex));
            totalInequalityViolation += Math.min(0.0, constraintValue);
        }
        if (Math.abs(totalInequalityViolation) < (1.0 + (double)this.totalNumberOfInequalityConstraints) * this.convergenceThreshold * c1 * c2 * 100.0) {
            return true;
        }
        MatrixTools.setMatrixBlock((DMatrix)this.previousLagrangeMultipliers, (int)0, (int)0, (DMatrix)this.lagrangeMultipliers, (int)0, (int)0, (int)this.numberOfActiveConstraints, (int)1, (double)1.0);
        this.previousSolution.set((DMatrixD1)solutionToPack);
        for (int i = 0; i < this.numberOfActiveConstraints; ++i) {
            this.previousActiveSetIndices.set(i, this.activeSetIndices.get(i));
        }
        return false;
    }

    private double computeStepLengthForEqualityConstraint(DMatrixRMaj solutionToPack, int equalityConstraintIndex) {
        double fullStepLength = 0.0;
        if (!MathTools.epsilonEquals((double)CommonOps_DDRM.dot((DMatrixD1)this.stepDirectionInPrimalSpace, (DMatrixD1)this.stepDirectionInPrimalSpace), (double)0.0, (double)1.0E-24)) {
            fullStepLength = (-CommonOps_DDRM.dot((DMatrixD1)this.violatedConstraintNormal, (DMatrixD1)solutionToPack) - this.linearEqualityConstraintsBVector.get(equalityConstraintIndex)) / CommonOps_DDRM.dot((DMatrixD1)this.stepDirectionInPrimalSpace, (DMatrixD1)this.violatedConstraintNormal);
        }
        return fullStepLength;
    }

    private double computePartialStepLength() {
        double partialStepLength = Double.POSITIVE_INFINITY;
        for (int k = this.numberOfEqualityConstraints; k < this.numberOfActiveConstraints; ++k) {
            double minimumStepLength = -this.lagrangeMultipliers.get(k) / this.infeasibilityMultiplier.get(k);
            if (!(this.infeasibilityMultiplier.get(k) < 0.0) || !(minimumStepLength < partialStepLength)) continue;
            partialStepLength = minimumStepLength;
            this.constraintIndexForPartialStep = this.activeSetIndices.get(k);
        }
        return partialStepLength;
    }

    private double computeFullStepLength(int violatedConstraintIndex) {
        double fullStepLength = Double.POSITIVE_INFINITY;
        fullStepLength = -this.inequalityConstraintViolations.get(violatedConstraintIndex) / CommonOps_DDRM.dot((DMatrixD1)this.stepDirectionInPrimalSpace, (DMatrixD1)this.violatedConstraintNormal);
        if (fullStepLength < 0.0) {
            fullStepLength = Double.POSITIVE_INFINITY;
        }
        return fullStepLength;
    }

    private QuadProgStep takeStepInDualSpace(double stepLength) {
        MatrixTools.addMatrixBlock((DMatrix)this.lagrangeMultipliers, (int)0, (int)0, (DMatrix1Row)this.infeasibilityMultiplier, (int)0, (int)0, (int)this.numberOfActiveConstraints, (int)1, (double)stepLength);
        this.lagrangeMultipliers.set(this.numberOfActiveConstraints, this.lagrangeMultipliers.get(this.numberOfActiveConstraints) + stepLength);
        this.inactiveSetIndices.set(this.constraintIndexForPartialStep, this.constraintIndexForPartialStep);
        if (this.deleteConstraint(this.J)) {
            return QuadProgStep.COMPUTE_STEP_LENGTH;
        }
        return QuadProgStep.FAILED;
    }

    private QuadProgStep takeStepInPrimalAndDualSpace(DMatrixRMaj solutionToPack, double stepLength, double fullStepLength, int mostViolatedConstraintIndex) {
        CommonOps_DDRM.addEquals((DMatrixD1)solutionToPack, (double)stepLength, (DMatrixD1)this.stepDirectionInPrimalSpace);
        MatrixTools.addMatrixBlock((DMatrix)this.lagrangeMultipliers, (int)0, (int)0, (DMatrix1Row)this.infeasibilityMultiplier, (int)0, (int)0, (int)this.numberOfActiveConstraints, (int)1, (double)stepLength);
        this.lagrangeMultipliers.set(this.numberOfActiveConstraints, this.lagrangeMultipliers.get(this.numberOfActiveConstraints) + stepLength);
        if (MathTools.epsilonEquals((double)stepLength, (double)fullStepLength, (double)1.0E-24)) {
            if (!this.addConstraint()) {
                int i;
                if (!this.requireInequalityConstraintsSatisfied) {
                    this.excludeConstraintFromActiveSet.set(mostViolatedConstraintIndex, 0);
                }
                if (!this.deleteConstraint(this.J)) {
                    return QuadProgStep.FAILED;
                }
                for (i = 0; i < this.totalNumberOfInequalityConstraints; ++i) {
                    this.inactiveSetIndices.set(i, i);
                }
                for (i = 0; i < this.numberOfActiveConstraints; ++i) {
                    this.activeSetIndices.set(i, this.previousActiveSetIndices.get(i));
                    this.inactiveSetIndices.set(this.activeSetIndices.get(i), -1);
                }
                MatrixTools.setMatrixBlock((DMatrix)this.lagrangeMultipliers, (int)0, (int)0, (DMatrix)this.previousLagrangeMultipliers, (int)0, (int)0, (int)this.numberOfActiveConstraints, (int)1, (double)1.0);
                solutionToPack.set((DMatrixD1)this.previousSolution);
                return QuadProgStep.FIND_MOST_VIOLATED_CONSTRAINT;
            }
            this.inactiveSetIndices.set(mostViolatedConstraintIndex, -1);
            return QuadProgStep.COMPUTE_CONSTRAINT_VIOLATIONS;
        }
        this.inactiveSetIndices.set(this.constraintIndexForPartialStep, this.constraintIndexForPartialStep);
        if (!this.deleteConstraint(this.J)) {
            return QuadProgStep.FAILED;
        }
        double sum = 0.0;
        for (int k = 0; k < this.problemSize; ++k) {
            sum += this.totalLinearInequalityConstraintsCMatrix.get(k, mostViolatedConstraintIndex) * solutionToPack.get(k);
        }
        this.inequalityConstraintViolations.set(mostViolatedConstraintIndex, sum + this.totalLinearInequalityConstraintsDVector.get(mostViolatedConstraintIndex));
        return QuadProgStep.COMPUTE_STEP_LENGTH;
    }

    private boolean addConstraint() {
        for (int j = this.problemSize - 1; j >= this.numberOfActiveConstraints + 1; --j) {
            double ss;
            double cc = this.d.get(j - 1);
            double h = JavaQuadProgSolver.distance(cc, ss = this.d.get(j));
            if (MathTools.epsilonEquals((double)h, (double)0.0, (double)1.0E-24)) continue;
            this.d.set(j, 0.0);
            ss /= h;
            cc /= h;
            if (cc < 0.0) {
                cc = -cc;
                ss = -ss;
                this.d.set(j - 1, -h);
            } else {
                this.d.set(j - 1, h);
            }
            double xny = ss / (1.0 + cc);
            for (int k = 0; k < this.problemSize; ++k) {
                double t1 = this.J.get(k, j - 1);
                double t2 = this.J.get(k, j);
                this.J.set(k, j - 1, t1 * cc + t2 * ss);
                this.J.set(k, j, xny * (t1 + this.J.get(k, j - 1)) - t2);
            }
        }
        ++this.numberOfActiveConstraints;
        if (this.numberOfActiveConstraints > this.problemSize) {
            return false;
        }
        for (int i = 0; i < this.numberOfActiveConstraints; ++i) {
            this.R.set(i, this.numberOfActiveConstraints - 1, this.d.get(i));
        }
        if (Math.abs(this.d.get(this.numberOfActiveConstraints - 1)) < 1.0E-24 * this.R_norm) {
            return false;
        }
        this.R_norm = Math.max(this.R_norm, Math.abs(this.d.get(this.numberOfActiveConstraints - 1)));
        return true;
    }

    private boolean deleteConstraint(DMatrixRMaj J) {
        int j;
        int i;
        int qq = -1;
        for (i = this.numberOfEqualityConstraints; i < this.numberOfActiveConstraints; ++i) {
            if (this.activeSetIndices.get(i) != this.constraintIndexForPartialStep) continue;
            qq = i;
            break;
        }
        if (qq == -1) {
            return false;
        }
        for (i = qq; i < this.numberOfActiveConstraints - 1; ++i) {
            this.activeSetIndices.set(i, this.activeSetIndices.get(i + 1));
            this.lagrangeMultipliers.set(i, this.lagrangeMultipliers.get(i + 1));
            for (int j2 = 0; j2 < this.problemSize; ++j2) {
                this.R.set(j2, i, this.R.get(j2, i + 1));
            }
        }
        this.activeSetIndices.set(this.numberOfActiveConstraints - 1, this.activeSetIndices.get(this.numberOfActiveConstraints));
        this.lagrangeMultipliers.set(this.numberOfActiveConstraints - 1, this.lagrangeMultipliers.get(this.numberOfActiveConstraints));
        this.activeSetIndices.set(this.numberOfActiveConstraints, 0);
        this.lagrangeMultipliers.set(this.numberOfActiveConstraints, 0.0);
        for (j = 0; j < this.numberOfActiveConstraints; ++j) {
            this.R.set(j, this.numberOfActiveConstraints - 1, 0.0);
        }
        --this.numberOfActiveConstraints;
        if (this.numberOfActiveConstraints == 0) {
            return true;
        }
        for (j = qq + this.numberOfEqualityConstraints; j < this.numberOfActiveConstraints; ++j) {
            double t2;
            double t1;
            int k;
            double ss;
            double cc = this.R.get(j, j);
            double h = JavaQuadProgSolver.distance(cc, ss = this.R.get(j + 1, j));
            if (MathTools.epsilonEquals((double)h, (double)0.0, (double)1.0E-24)) continue;
            cc /= h;
            ss /= h;
            this.R.set(j + 1, j, 0.0);
            if (cc < 0.0) {
                this.R.set(j, j, -h);
                cc = -cc;
                ss = -ss;
            } else {
                this.R.set(j, j, h);
            }
            double xny = ss / (1.0 + cc);
            for (k = j + 1; k < this.numberOfActiveConstraints; ++k) {
                t1 = this.R.get(j, k);
                t2 = this.R.get(j + 1, k);
                this.R.set(j, k, t1 * cc + t2 * ss);
                this.R.set(j + 1, k, xny * (t1 + this.R.get(j, k)) - t2);
            }
            for (k = 0; k < this.problemSize; ++k) {
                t1 = J.get(k, j);
                t2 = J.get(k, j + 1);
                J.set(k, j, t1 * cc + t2 * ss);
                J.set(k, j + 1, xny * (J.get(k, j) + t1) - t2);
            }
        }
        return true;
    }

    public void reshape() {
        int numberOfInequalityConstraints = this.linearInequalityConstraintsDVectorO.getNumRows();
        int numberOfLowerBounds = this.variableLowerBounds.getNumRows();
        int numberOfUpperBounds = this.variableUpperBounds.getNumRows();
        int numberOfConstraints = this.numberOfEqualityConstraints + numberOfInequalityConstraints + numberOfLowerBounds + numberOfUpperBounds;
        this.totalNumberOfInequalityConstraints = numberOfInequalityConstraints + numberOfLowerBounds + numberOfUpperBounds;
        this.R.reshape(this.problemSize, this.problemSize);
        this.inequalityConstraintViolations.reshape(this.totalNumberOfInequalityConstraints, 1);
        this.stepDirectionInPrimalSpace.reshape(this.problemSize, 1);
        this.infeasibilityMultiplier.reshape(numberOfConstraints, 1);
        this.d.reshape(this.problemSize, 1);
        this.violatedConstraintNormal.reshape(this.problemSize, 1);
        this.lagrangeMultipliers.reshape(numberOfConstraints, 1);
        this.previousSolution.reshape(this.problemSize, 1);
        this.previousLagrangeMultipliers.reshape(numberOfConstraints, 1);
        this.activeSetIndices.resetQuick();
        this.previousActiveSetIndices.resetQuick();
        this.inactiveSetIndices.resetQuick();
        this.excludeConstraintFromActiveSet.resetQuick();
        this.activeSetIndices.fill(0, numberOfConstraints, 0);
        this.previousActiveSetIndices.fill(0, numberOfConstraints, 0);
        this.inactiveSetIndices.fill(0, this.totalNumberOfInequalityConstraints, 0);
        this.excludeConstraintFromActiveSet.fill(0, this.totalNumberOfInequalityConstraints, 0);
        this.totalLinearInequalityConstraintsCMatrix.reshape(this.problemSize, numberOfInequalityConstraints + numberOfLowerBounds + numberOfUpperBounds);
        this.totalLinearInequalityConstraintsDVector.reshape(numberOfInequalityConstraints + numberOfLowerBounds + numberOfUpperBounds, 1);
        MatrixTools.setMatrixBlock((DMatrix)this.totalLinearInequalityConstraintsCMatrix, (int)0, (int)0, (DMatrix)this.linearInequalityConstraintsCMatrixO, (int)0, (int)0, (int)this.problemSize, (int)numberOfInequalityConstraints, (double)1.0);
        MatrixTools.setMatrixBlock((DMatrix)this.totalLinearInequalityConstraintsDVector, (int)0, (int)0, (DMatrix)this.linearInequalityConstraintsDVectorO, (int)0, (int)0, (int)numberOfInequalityConstraints, (int)1, (double)1.0);
        MatrixTools.setMatrixBlock((DMatrix)this.totalLinearInequalityConstraintsCMatrix, (int)0, (int)numberOfInequalityConstraints, (DMatrix)this.lowerBoundsCMatrix, (int)0, (int)0, (int)this.problemSize, (int)numberOfLowerBounds, (double)1.0);
        MatrixTools.setMatrixBlock((DMatrix)this.totalLinearInequalityConstraintsDVector, (int)numberOfInequalityConstraints, (int)0, (DMatrix)this.variableLowerBounds, (int)0, (int)0, (int)numberOfLowerBounds, (int)1, (double)1.0);
        MatrixTools.setMatrixBlock((DMatrix)this.totalLinearInequalityConstraintsCMatrix, (int)0, (int)(numberOfInequalityConstraints + numberOfLowerBounds), (DMatrix)this.upperBoundsCMatrix, (int)0, (int)0, (int)this.problemSize, (int)numberOfUpperBounds, (double)1.0);
        MatrixTools.setMatrixBlock((DMatrix)this.totalLinearInequalityConstraintsDVector, (int)(numberOfInequalityConstraints + numberOfLowerBounds), (int)0, (DMatrix)this.variableUpperBounds, (int)0, (int)0, (int)numberOfUpperBounds, (int)1, (double)1.0);
    }

    private void partitionLagrangeMultipliers(DMatrixRMaj lagrangeEqualityConstraintMultipliersToPack, DMatrixRMaj lagrangeInequalityConstraintMultipliersToPack, DMatrixRMaj lagrangeLowerBoundMultipliersToPack, DMatrixRMaj lagrangeUpperBoundMultipliersToPack) {
        MatrixTools.setMatrixBlock((DMatrix)lagrangeEqualityConstraintMultipliersToPack, (int)0, (int)0, (DMatrix)this.lagrangeMultipliers, (int)0, (int)0, (int)this.numberOfEqualityConstraints, (int)1, (double)1.0);
        for (int inequalityConstraintNumber = this.numberOfEqualityConstraints; inequalityConstraintNumber < this.numberOfActiveConstraints; ++inequalityConstraintNumber) {
            int localIndex;
            int inequalityConstraintIndex = this.activeSetIndices.get(inequalityConstraintNumber);
            if (inequalityConstraintIndex < 0) continue;
            if (inequalityConstraintIndex < this.numberOfInequalityConstraints) {
                lagrangeInequalityConstraintMultipliersToPack.set(inequalityConstraintIndex, 0, this.lagrangeMultipliers.get(inequalityConstraintNumber));
                continue;
            }
            if (inequalityConstraintIndex < this.numberOfInequalityConstraints + this.numberOfLowerBounds) {
                localIndex = inequalityConstraintIndex - this.numberOfInequalityConstraints;
                lagrangeLowerBoundMultipliersToPack.set(localIndex, 0, this.lagrangeMultipliers.get(inequalityConstraintNumber));
                continue;
            }
            localIndex = inequalityConstraintIndex - this.numberOfInequalityConstraints - this.numberOfLowerBounds;
            lagrangeUpperBoundMultipliersToPack.set(localIndex, 0, this.lagrangeMultipliers.get(inequalityConstraintNumber));
        }
    }

    private void zero() {
        this.R.zero();
        this.inequalityConstraintViolations.zero();
        this.stepDirectionInPrimalSpace.zero();
        this.infeasibilityMultiplier.zero();
        this.d.zero();
        this.violatedConstraintNormal.zero();
        this.lagrangeMultipliers.zero();
        this.previousSolution.zero();
        this.previousLagrangeMultipliers.zero();
    }

    private static double distance(double a, double b) {
        double b1;
        double a1 = Math.abs(a);
        if (a1 > (b1 = Math.abs(b))) {
            double t = b1 / a1;
            return a1 * Math.sqrt(1.0 + t * t);
        }
        if (b1 > a1) {
            double t = a1 / b1;
            return b1 * Math.sqrt(1.0 + t * t);
        }
        return a1 * Math.sqrt(2.0);
    }

    @Override
    public void getLagrangeEqualityConstraintMultipliers(DMatrixRMaj multipliersMatrixToPack) {
        multipliersMatrixToPack.set((DMatrixD1)this.lagrangeEqualityConstraintMultipliers);
    }

    @Override
    public void getLagrangeInequalityConstraintMultipliers(DMatrixRMaj multipliersMatrixToPack) {
        multipliersMatrixToPack.set((DMatrixD1)this.lagrangeInequalityConstraintMultipliers);
    }

    @Override
    public void getLagrangeLowerBoundsMultipliers(DMatrixRMaj multipliersMatrixToPack) {
        multipliersMatrixToPack.set((DMatrixD1)this.lagrangeLowerBoundMultipliers);
    }

    @Override
    public void getLagrangeUpperBoundsMultipliers(DMatrixRMaj multipliersMatrixToPack) {
        multipliersMatrixToPack.set((DMatrixD1)this.lagrangeUpperBoundMultipliers);
    }

    protected static void standardTranspose(DMatrix A, DMatrix1Row A_tran) {
        if (A instanceof DMatrixRMaj && A_tran instanceof DMatrixRMaj) {
            CommonOps_DDRM.transpose((DMatrixRMaj)((DMatrixRMaj)A), (DMatrixRMaj)((DMatrixRMaj)A_tran));
            return;
        }
        if (A_tran == null) {
            A_tran = new DMatrixRMaj(A.getNumCols(), A.getNumRows());
        } else if (A.getNumRows() != A_tran.numCols || A.getNumCols() != A_tran.numRows) {
            throw new MatrixDimensionException("Incompatible matrix dimensions");
        }
        for (int row = 0; row < A.getNumRows(); ++row) {
            for (int col = 0; col < A.getNumCols(); ++col) {
                A_tran.set(col, row, A.get(row, col));
            }
        }
    }

    private static enum QuadProgStep {
        COMPUTE_CONSTRAINT_VIOLATIONS,
        FIND_MOST_VIOLATED_CONSTRAINT,
        COMPUTE_STEP_LENGTH,
        FAILED;

    }
}

