/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.convexOptimization.quadraticProgram;

import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;
import us.ihmc.convexOptimization.QuadProgWrapper;
import us.ihmc.convexOptimization.exceptions.NoConvergenceException;
import us.ihmc.convexOptimization.quadraticProgram.ConstrainedQPSolver;

public class QuadProgSolver
extends ConstrainedQPSolver {
    QuadProgWrapper qpWrapper;
    DMatrixRMaj negAin = new DMatrixRMaj(0);
    DMatrixRMaj negAeq = new DMatrixRMaj(0);

    public QuadProgSolver() {
        this(1, 0, 0);
    }

    public QuadProgSolver(int nvar, int neq, int nin) {
        this.qpWrapper = new QuadProgWrapper(nvar, neq, nin);
        this.allocateTempraryMatrixOnDemand(nvar, neq, nin);
    }

    private void allocateTempraryMatrixOnDemand(int nvar, int neq, int nin) {
        this.negAin.reshape(nvar, nin);
        this.negAeq.reshape(nvar, neq);
    }

    @Override
    public boolean supportBoxConstraints() {
        return false;
    }

    @Override
    public int solve(DMatrixRMaj Q, DMatrixRMaj f, DMatrixRMaj Aeq, DMatrixRMaj beq, DMatrixRMaj Ain, DMatrixRMaj bin, DMatrixRMaj x, boolean initialize) throws NoConvergenceException {
        return this.solve(Q, f, Aeq, beq, Ain, bin, null, null, x, initialize);
    }

    @Override
    public int solve(DMatrixRMaj Q, DMatrixRMaj f, DMatrixRMaj Aeq, DMatrixRMaj beq, DMatrixRMaj Ain, DMatrixRMaj bin, DMatrixRMaj lb, DMatrixRMaj ub, DMatrixRMaj x, boolean initialize) throws NoConvergenceException {
        this.allocateTempraryMatrixOnDemand(Q.numCols, Aeq.numRows, Ain.numRows);
        CommonOps_DDRM.transpose((DMatrixRMaj)Aeq, (DMatrixRMaj)this.negAeq);
        CommonOps_DDRM.scale((double)-1.0, (DMatrixD1)this.negAeq);
        CommonOps_DDRM.transpose((DMatrixRMaj)Ain, (DMatrixRMaj)this.negAin);
        CommonOps_DDRM.scale((double)-1.0, (DMatrixD1)this.negAin);
        return this.qpWrapper.solve(Q, f, this.negAeq, beq, this.negAin, bin, x, initialize);
    }

    public double getCost() {
        return this.qpWrapper.getObjVal();
    }
}

