/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.convexOptimization.experimental;

import com.joptimizer.functions.ConvexMultivariateRealFunction;
import com.joptimizer.functions.LinearMultivariateRealFunction;
import com.joptimizer.functions.PSDQuadraticMultivariateRealFunction;
import com.joptimizer.optimizers.JOptimizer;
import com.joptimizer.optimizers.OptimizationRequest;
import com.joptimizer.optimizers.OptimizationResponse;
import java.util.ArrayList;
import org.ejml.data.DMatrix1Row;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;
import us.ihmc.convexOptimization.experimental.ExperimentalSOCPSolver;

public class ExperimentalSOCPSolverUsingJOptimizer
implements ExperimentalSOCPSolver {
    JOptimizer jOptimizer = new JOptimizer();
    OptimizationRequest optimizationRequest = new OptimizationRequest();

    @Override
    public void setOptimizationFunctionVectorF(double[] optimizationFunctionVectorF) {
        LinearMultivariateRealFunction linearFunctionToOptimize = new LinearMultivariateRealFunction(optimizationFunctionVectorF, 0.0);
        this.optimizationRequest.setF0((ConvexMultivariateRealFunction)linearFunctionToOptimize);
    }

    @Override
    public void setOptimizationFunctionVectorF(DMatrixRMaj optimizationFunctionVectorF) {
        this.setOptimizationFunctionVectorF(optimizationFunctionVectorF.getData());
    }

    @Override
    public void setLinearEqualityConstraints(double[][] linearEqualityAMatrix, double[] linearEqualityBVector) {
        this.optimizationRequest.setA(linearEqualityAMatrix);
        this.optimizationRequest.setB(linearEqualityBVector);
    }

    @Override
    public void setLinearEqualityConstraints(DMatrixRMaj linearEqualityAMatrix, DMatrixRMaj linearEqualityBVector) {
        this.setLinearEqualityConstraints(this.convertMatrixToTwoDimensionalDoubleArray(linearEqualityAMatrix), linearEqualityBVector.getData());
    }

    @Override
    public void setSpecialSecondOrderConeInequality(double[][] coneInequalityMatrixB, double[] coneInequalityVectorU, ArrayList<ConvexMultivariateRealFunction> otherInequalities) {
        int numberOfRows = coneInequalityMatrixB.length;
        int numberOfColumns = coneInequalityMatrixB[0].length;
        if (numberOfRows != numberOfColumns) {
            throw new RuntimeException("coneInequalityMatrixB must be square!");
        }
        if (coneInequalityVectorU.length != numberOfRows) {
            throw new RuntimeException("coneInequalityVectorU must be have correct length!");
        }
        DMatrixRMaj coneInequalityDenseMatrixB = new DMatrixRMaj(coneInequalityMatrixB);
        DMatrixRMaj coneInequalityVectorUAsDenseMatrix = new DMatrixRMaj(numberOfRows, 1);
        coneInequalityVectorUAsDenseMatrix.setData(coneInequalityVectorU);
        this.setSpecialSecondOrderConeInequality(coneInequalityDenseMatrixB, coneInequalityVectorUAsDenseMatrix, otherInequalities);
    }

    @Override
    public void setSpecialSecondOrderConeInequality(DMatrixRMaj coneInequalityMatrixB, DMatrixRMaj coneInequalityVectorU, ArrayList<ConvexMultivariateRealFunction> otherInequalities) {
        int numberOfColumns;
        int numberOfRows = coneInequalityMatrixB.getNumRows();
        if (numberOfRows != (numberOfColumns = coneInequalityMatrixB.getNumCols())) {
            throw new RuntimeException("coneInequalityMatrixB must be square!");
        }
        if (coneInequalityVectorU.getNumRows() != numberOfRows) {
            throw new RuntimeException("coneInequalityVectorU must be the correct size!");
        }
        if (coneInequalityVectorU.getNumCols() != 1) {
            throw new RuntimeException("coneInequalityVectorU must have one column!");
        }
        ConvexMultivariateRealFunction[] inequalities = new ConvexMultivariateRealFunction[otherInequalities.size() + 2];
        DMatrixRMaj coneInequalityMatrixBTransposeB = new DMatrixRMaj(numberOfRows, numberOfColumns);
        CommonOps_DDRM.multTransA((DMatrix1Row)coneInequalityMatrixB, (DMatrix1Row)coneInequalityMatrixB, (DMatrix1Row)coneInequalityMatrixBTransposeB);
        DMatrixRMaj coneInequalityMatrixUUTranspose = new DMatrixRMaj(numberOfRows, numberOfColumns);
        CommonOps_DDRM.multTransB((DMatrix1Row)coneInequalityVectorU, (DMatrix1Row)coneInequalityVectorU, (DMatrix1Row)coneInequalityMatrixUUTranspose);
        DMatrixRMaj quadraticInequalityMatrixP = new DMatrixRMaj(numberOfRows, numberOfColumns);
        CommonOps_DDRM.subtract((DMatrixD1)coneInequalityMatrixBTransposeB, (DMatrixD1)coneInequalityMatrixUUTranspose, (DMatrixD1)quadraticInequalityMatrixP);
        CommonOps_DDRM.scale((double)2.0, (DMatrixD1)quadraticInequalityMatrixP);
        double[][] quadraticInequalityMatrixPAsDoubleArray = this.convertMatrixToTwoDimensionalDoubleArray(quadraticInequalityMatrixP);
        double[] qVector = new double[numberOfRows];
        double r = 0.0;
        PSDQuadraticMultivariateRealFunction quadraticInequalityFunction = new PSDQuadraticMultivariateRealFunction(quadraticInequalityMatrixPAsDoubleArray, qVector, r);
        inequalities[0] = quadraticInequalityFunction;
        qVector = new double[numberOfRows];
        for (int row = 0; row < numberOfRows; ++row) {
            qVector[row] = -coneInequalityVectorU.get(row, 0);
        }
        r = 0.0;
        LinearMultivariateRealFunction linearInequalityFunction = new LinearMultivariateRealFunction(qVector, r);
        inequalities[1] = linearInequalityFunction;
        for (int i = 0; i < otherInequalities.size(); ++i) {
            inequalities[i + 2] = otherInequalities.get(i);
        }
        this.optimizationRequest.setFi(inequalities);
    }

    @Override
    public double[] solveAndReturnOptimalVector() {
        this.optimizationRequest.setToleranceFeas(1.0E-6);
        this.optimizationRequest.setTolerance(2.0E-6);
        this.optimizationRequest.setMaxIteration(500);
        this.jOptimizer.setOptimizationRequest(this.optimizationRequest);
        try {
            this.jOptimizer.optimize();
        }
        catch (Exception e) {
            return null;
        }
        OptimizationResponse response = this.jOptimizer.getOptimizationResponse();
        if (response.getReturnCode() == 2) {
            return null;
        }
        return response.getSolution();
    }

    private double[][] convertMatrixToTwoDimensionalDoubleArray(DMatrixRMaj matrix) {
        int numberOfRows = matrix.getNumRows();
        int numberOfColumns = matrix.getNumCols();
        double[][] returnDoubleArray = new double[numberOfRows][numberOfColumns];
        for (int row = 0; row < numberOfRows; ++row) {
            for (int column = 0; column < numberOfColumns; ++column) {
                returnDoubleArray[row][column] = matrix.get(row, column);
            }
        }
        return returnDoubleArray;
    }
}

