/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.convexOptimization.experimental;

import com.joptimizer.functions.LinearMultivariateRealFunction;
import java.util.ArrayList;
import org.ejml.data.DMatrix1Row;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import us.ihmc.convexOptimization.experimental.ExperimentalSOCPSolverUsingJOptimizer;

public class ExperimentalSOCPSolverUsingJOptimizerTest {
    public static final boolean VERBOSE = false;

    @Disabled
    @Test
    public void testASimpleSecondOrderConeProblem() {
        ExperimentalSOCPSolverUsingJOptimizer specialSOCPSolverUsingJOptimizer = new ExperimentalSOCPSolverUsingJOptimizer();
        double[] minimizeF = new double[]{-1.0, -1.0, 0.0};
        specialSOCPSolverUsingJOptimizer.setOptimizationFunctionVectorF(minimizeF);
        double[][] coneInequalityMatrixB = new double[][]{{1.0, 0.0, 0.0}, {0.0, 1.0, 0.0}, {0.0, 0.0, 0.0}};
        double[] coneInequalityVectorU = new double[]{0.0, 0.0, 1.0};
        ArrayList<LinearMultivariateRealFunction> otherInequalities = new ArrayList<LinearMultivariateRealFunction>();
        double[] qVector = new double[]{0.0, 0.0, 1.0};
        double r = -Math.sqrt(18.0);
        otherInequalities.add(new LinearMultivariateRealFunction(qVector, r));
        specialSOCPSolverUsingJOptimizer.setSpecialSecondOrderConeInequality((double[][])coneInequalityMatrixB, coneInequalityVectorU, otherInequalities);
        double[] solution = specialSOCPSolverUsingJOptimizer.solveAndReturnOptimalVector();
        Assertions.assertEquals((double)3.0, (double)solution[0], (double)1.0E-5);
        Assertions.assertEquals((double)3.0, (double)solution[1], (double)1.0E-5);
        Assertions.assertEquals((double)Math.sqrt(18.0), (double)solution[2], (double)1.0E-5);
    }

    @Disabled
    @Test
    public void testARotatedSecondOrderConeProblem() {
        ExperimentalSOCPSolverUsingJOptimizer specialSOCPSolverUsingJOptimizer = new ExperimentalSOCPSolverUsingJOptimizer();
        double[] minimizeF = new double[]{0.0, 0.0, 1.0};
        specialSOCPSolverUsingJOptimizer.setOptimizationFunctionVectorF(minimizeF);
        double[][] linearEqualityAMatrix = new double[][]{{0.0, 1.0, 0.0}};
        double[] linearEqualityBVector = new double[]{0.0};
        specialSOCPSolverUsingJOptimizer.setLinearEqualityConstraints((double[][])linearEqualityAMatrix, linearEqualityBVector);
        DMatrixRMaj surfaceNormal = new DMatrixRMaj((double[][])new double[][]{{0.0}, {0.0}, {1.0}});
        DMatrixRMaj identityMatrix = CommonOps_DDRM.identity((int)3);
        DMatrixRMaj coneInequalityMatrixB = new DMatrixRMaj(3, 3);
        DMatrixRMaj normalNormalTranspose = new DMatrixRMaj(3, 3);
        CommonOps_DDRM.multTransB((DMatrix1Row)surfaceNormal, (DMatrix1Row)surfaceNormal, (DMatrix1Row)normalNormalTranspose);
        CommonOps_DDRM.subtract((DMatrixD1)identityMatrix, (DMatrixD1)normalNormalTranspose, (DMatrixD1)coneInequalityMatrixB);
        double mu = 1.0;
        DMatrixRMaj coneInequalityVectorU = new DMatrixRMaj(surfaceNormal);
        CommonOps_DDRM.scale((double)mu, (DMatrixD1)coneInequalityVectorU);
        System.out.println("coneInequalityMatrixB = " + coneInequalityMatrixB);
        System.out.println("coneInequalityVectorU = " + coneInequalityVectorU);
        ArrayList otherInequalities = new ArrayList();
        specialSOCPSolverUsingJOptimizer.setSpecialSecondOrderConeInequality(coneInequalityMatrixB, coneInequalityVectorU, otherInequalities);
        double[] solution = specialSOCPSolverUsingJOptimizer.solveAndReturnOptimalVector();
        System.out.println("solution = (" + solution[0] + ", " + solution[1] + ", " + solution[2] + ")");
        Assertions.assertEquals((double)3.0, (double)solution[0], (double)1.0E-5);
        Assertions.assertEquals((double)3.0, (double)solution[1], (double)1.0E-5);
        Assertions.assertEquals((double)Math.sqrt(18.0), (double)solution[2], (double)1.0E-5);
    }
}

