/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.convexOptimization.quadraticProgram;

import org.ejml.data.DMatrix1Row;
import org.ejml.data.DMatrixRMaj;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.convexOptimization.quadraticProgram.AbstractSimpleActiveSetQPSolverWithInactiveVariablesTest;
import us.ihmc.convexOptimization.quadraticProgram.ActiveSetQPSolverWithInactiveVariablesInterface;
import us.ihmc.convexOptimization.quadraticProgram.ActualDatasetFrom20160319;
import us.ihmc.convexOptimization.quadraticProgram.ActualDatasetFromKiwi20170712;
import us.ihmc.convexOptimization.quadraticProgram.ActualDatasetFromKiwi20171013;
import us.ihmc.convexOptimization.quadraticProgram.ActualDatasetFromKiwi20171015A;
import us.ihmc.convexOptimization.quadraticProgram.ActualDatasetFromKiwi20171015B;
import us.ihmc.convexOptimization.quadraticProgram.SimpleEfficientActiveSetQPSolverWithInactiveVariables;
import us.ihmc.matrixlib.MatrixTools;

public class SimpleEfficientActiveSetQPSolverWithInactiveVariablesTest
extends AbstractSimpleActiveSetQPSolverWithInactiveVariablesTest {
    @Override
    @Test
    public void testMaxIterations() {
        this.testMaxIterations(2, true);
    }

    @Override
    @Test
    public void testClear() {
        this.testClear(2, 2, false);
    }

    @Override
    @Test
    public void testSimpleCasesWithBoundsConstraints() {
        this.testSimpleCasesWithBoundsConstraints(1, 3, 2, 2, false);
    }

    @Override
    @Test
    public void testSimpleCasesWithBoundsConstraintsAndInactiveVariables() {
        this.testSimpleCasesWithBoundsConstraintsAndInactiveVariables(1, 2, 2, 2, false);
    }

    @Override
    public DMatrixRMaj getLowerBounds() {
        return MatrixTools.createVector((double[])new double[]{-5.0, 6.0, -2.0});
    }

    @Override
    public ActiveSetQPSolverWithInactiveVariablesInterface createSolverToTest() {
        SimpleEfficientActiveSetQPSolverWithInactiveVariables simpleEfficientActiveSetQPSolver = new SimpleEfficientActiveSetQPSolverWithInactiveVariables();
        simpleEfficientActiveSetQPSolver.setUseWarmStart(false);
        return simpleEfficientActiveSetQPSolver;
    }

    @Test
    public void testChallengingCasesWithPolygonConstraintsCheckFailsWithSimpleSolverWithWarmStart() {
        ActiveSetQPSolverWithInactiveVariablesInterface solver = this.createSolverToTest();
        solver.setMaxNumberOfIterations(10);
        solver.setUseWarmStart(true);
        DMatrixRMaj costQuadraticMatrix = new DMatrixRMaj((double[][])new double[][]{{2.0, 0.0}, {0.0, 2.0}});
        DMatrixRMaj costLinearVector = MatrixTools.createVector((double[])new double[]{0.0, 0.0});
        double quadraticCostScalar = 0.0;
        solver.setQuadraticCostFunction(costQuadraticMatrix, costLinearVector, quadraticCostScalar);
        DMatrixRMaj linearInequalityConstraintsCMatrix = new DMatrixRMaj((double[][])new double[][]{{-1.0, -1.0}, {-10.0, 1.0}, {1.0, -10.0}});
        DMatrixRMaj linearInqualityConstraintsDVector = MatrixTools.createVector((double[])new double[]{-2.0, -2.0, -2.0});
        solver.setLinearInequalityConstraints(linearInequalityConstraintsCMatrix, linearInqualityConstraintsDVector);
        DMatrixRMaj solution = new DMatrixRMaj(2, 1);
        DMatrixRMaj lagrangeEqualityMultipliers = new DMatrixRMaj(0, 1);
        DMatrixRMaj lagrangeInequalityMultipliers = new DMatrixRMaj(3, 1);
        int numberOfIterations1 = solver.solve(solution);
        solver.getLagrangeEqualityConstraintMultipliers(lagrangeEqualityMultipliers);
        solver.getLagrangeInequalityConstraintMultipliers(lagrangeInequalityMultipliers);
        int numberOfIterations2 = solver.solve(solution);
        solver.getLagrangeEqualityConstraintMultipliers(lagrangeEqualityMultipliers);
        solver.getLagrangeInequalityConstraintMultipliers(lagrangeInequalityMultipliers);
        int numberOfIterations = numberOfIterations2;
        Assertions.assertEquals((int)2, (int)solution.getNumRows());
        Assertions.assertTrue((boolean)Double.isNaN(solution.get(0)));
        Assertions.assertTrue((boolean)Double.isNaN(solution.get(1)));
        Assertions.assertTrue((Double.isInfinite(lagrangeInequalityMultipliers.get(0)) || Double.isNaN(lagrangeInequalityMultipliers.get(0)) ? 1 : 0) != 0);
        Assertions.assertTrue((Double.isInfinite(lagrangeInequalityMultipliers.get(1)) || Double.isNaN(lagrangeInequalityMultipliers.get(1)) ? 1 : 0) != 0);
        Assertions.assertTrue((Double.isInfinite(lagrangeInequalityMultipliers.get(2)) || Double.isNaN(lagrangeInequalityMultipliers.get(2)) ? 1 : 0) != 0);
        Assertions.assertEquals((int)numberOfIterations, (int)1);
    }

    @Test
    public void testFindValidSolutionForDataset20160319WithWarmStart() {
        ActualDatasetFrom20160319 dataset = new ActualDatasetFrom20160319();
        ActiveSetQPSolverWithInactiveVariablesInterface solver = this.createSolverToTest();
        solver.setUseWarmStart(true);
        solver.clear();
        solver.setQuadraticCostFunction(dataset.getCostQuadraticMatrix(), dataset.getCostLinearVector(), 0.0);
        solver.setVariableBounds(dataset.getVariableLowerBounds(), dataset.getVariableUpperBounds());
        DMatrixRMaj solution = new DMatrixRMaj(dataset.getProblemSize(), 1);
        solver.solve(solution);
        int numberOfIterations = solver.solve(solution);
        Assertions.assertFalse((boolean)MatrixTools.containsNaN((DMatrix1Row)solution));
        Assertions.assertEquals((int)numberOfIterations, (int)1);
    }

    @Test
    public void testFindValidSolutionForKiwiDataset20170712WithWarmStart() {
        ActualDatasetFromKiwi20170712 dataset = new ActualDatasetFromKiwi20170712();
        ActiveSetQPSolverWithInactiveVariablesInterface solver = this.createSolverToTest();
        solver.setUseWarmStart(true);
        solver.clear();
        solver.setQuadraticCostFunction(dataset.getCostQuadraticMatrix(), dataset.getCostLinearVector(), 0.0);
        solver.setVariableBounds(dataset.getVariableLowerBounds(), dataset.getVariableUpperBounds());
        DMatrixRMaj solution = new DMatrixRMaj(dataset.getProblemSize(), 1);
        solver.solve(solution);
        int numberOfIterations = solver.solve(solution);
        Assertions.assertFalse((boolean)MatrixTools.containsNaN((DMatrix1Row)solution));
        Assertions.assertEquals((int)numberOfIterations, (int)1);
    }

    @Test
    public void testFindValidSolutionForKiwiDataset20171013WithWarmStart() {
        ActualDatasetFromKiwi20171013 dataset = new ActualDatasetFromKiwi20171013();
        ActiveSetQPSolverWithInactiveVariablesInterface solver = this.createSolverToTest();
        solver.setUseWarmStart(true);
        solver.clear();
        solver.setQuadraticCostFunction(dataset.getCostQuadraticMatrix(), dataset.getCostLinearVector(), 0.0);
        solver.setVariableBounds(dataset.getVariableLowerBounds(), dataset.getVariableUpperBounds());
        DMatrixRMaj solution = new DMatrixRMaj(dataset.getProblemSize(), 1);
        solver.solve(solution);
        int numberOfIterations = solver.solve(solution);
        Assertions.assertFalse((boolean)MatrixTools.containsNaN((DMatrix1Row)solution));
        Assertions.assertEquals((int)1, (int)numberOfIterations);
    }

    @Test
    public void testFindValidSolutionForKiwiDatasetProblemWithWarmStart() {
        ActualDatasetFromKiwi20171015A datasetA = new ActualDatasetFromKiwi20171015A();
        ActualDatasetFromKiwi20171015B datasetB = new ActualDatasetFromKiwi20171015B();
        DMatrixRMaj solution = new DMatrixRMaj(datasetA.getProblemSize(), 1);
        ActiveSetQPSolverWithInactiveVariablesInterface solver = this.createSolverToTest();
        solver.setUseWarmStart(true);
        solver.clear();
        solver.setQuadraticCostFunction(datasetA.getCostQuadraticMatrix(), datasetA.getCostLinearVector(), 0.0);
        solver.setVariableBounds(datasetA.getVariableLowerBounds(), datasetA.getVariableUpperBounds());
        solver.solve(solution);
        solver.clear();
        solver.setQuadraticCostFunction(datasetA.getCostQuadraticMatrix(), datasetA.getCostLinearVector(), 0.0);
        solver.setVariableBounds(datasetA.getVariableLowerBounds(), datasetA.getVariableUpperBounds());
        solver.solve(solution);
        solver.clear();
        solver.setQuadraticCostFunction(datasetB.getCostQuadraticMatrix(), datasetB.getCostLinearVector(), 0.0);
        solver.setVariableBounds(datasetB.getVariableLowerBounds(), datasetB.getVariableUpperBounds());
        int numberOfIterationsWithWarmStart = solver.solve(solution);
        Assertions.assertFalse((boolean)MatrixTools.containsNaN((DMatrix1Row)solution));
        solver.setUseWarmStart(false);
        solver.clear();
        solver.setQuadraticCostFunction(datasetB.getCostQuadraticMatrix(), datasetB.getCostLinearVector(), 0.0);
        solver.setVariableBounds(datasetB.getVariableLowerBounds(), datasetB.getVariableUpperBounds());
        int numberOfIterationsWithoutWarmStart = solver.solve(solution);
        Assertions.assertTrue((numberOfIterationsWithWarmStart < numberOfIterationsWithoutWarmStart ? 1 : 0) != 0);
    }
}

