/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commons.lists;

import java.lang.reflect.Array;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.BiConsumer;
import java.util.function.Supplier;

public class RingBuffer<T>
implements Iterable<T> {
    private int currentIndex = -1;
    private int capacity;
    private boolean isBufferFull = false;
    private transient int modCount = 0;
    private T[] buffer;
    private final BiConsumer<T, T> copier;
    private final Supplier<T> allocator;
    private final Class<T> elementType;

    public RingBuffer(int capacity, Supplier<T> allocator) {
        this(capacity, allocator, null);
    }

    public RingBuffer(int capacity, Supplier<T> allocator, BiConsumer<T, T> copier) {
        this.allocator = allocator;
        if (capacity <= 0) {
            throw new IllegalArgumentException("Cannot instantiate a buffer with a size of zero or less.");
        }
        this.capacity = capacity;
        this.copier = copier;
        T firstElement = allocator.get();
        this.elementType = firstElement.getClass();
        this.buffer = new Object[capacity];
        this.buffer[0] = firstElement;
        for (int i = 1; i < capacity; ++i) {
            this.buffer[i] = allocator.get();
        }
    }

    public void changeCapacity(int newCapacity) {
        if (this.capacity == newCapacity) {
            return;
        }
        ++this.modCount;
        Object[] newBuffer = new Object[newCapacity];
        int size = this.size();
        if (newCapacity > size) {
            int index = this.isBufferFull ? this.currentIndex + 1 : 0;
            for (int offset = 0; offset < Math.min(this.capacity, newCapacity); ++offset) {
                newBuffer[offset] = this.buffer[index % this.capacity];
                ++index;
            }
            this.currentIndex = this.size() - 1;
            this.isBufferFull = false;
            for (int i = this.capacity; i < newCapacity; ++i) {
                newBuffer[i] = this.allocator.get();
            }
        } else {
            int index = this.currentIndex;
            for (int offset = newCapacity - 1; offset >= 0; --offset) {
                if (index < 0) {
                    index += this.capacity;
                }
                newBuffer[offset] = this.buffer[index];
                --index;
            }
            this.currentIndex = newCapacity - 1;
            this.isBufferFull = true;
        }
        this.buffer = newBuffer;
        this.capacity = newCapacity;
    }

    public void reset() {
        ++this.modCount;
        this.currentIndex = -1;
        this.isBufferFull = false;
    }

    public T add() {
        ++this.modCount;
        ++this.currentIndex;
        if (this.currentIndex >= this.capacity) {
            this.isBufferFull = true;
            this.currentIndex = 0;
        }
        return this.buffer[this.currentIndex];
    }

    public void add(T newElementToCopy) {
        if (this.copier == null) {
            throw new UnsupportedOperationException("Unable to copy new data to internal element without a copier. Use add() instead.");
        }
        this.copier.accept(this.add(), newElementToCopy);
    }

    public T getFirst() {
        if (this.currentIndex == -1) {
            return null;
        }
        if (!this.isBufferFull) {
            return this.buffer[0];
        }
        return this.buffer[(this.currentIndex + 1) % this.capacity];
    }

    public T getLast() {
        if (this.currentIndex == -1) {
            return null;
        }
        return this.buffer[this.currentIndex];
    }

    public T getFromFirst(int offsetFromFirst) {
        if (offsetFromFirst >= this.size() || offsetFromFirst < 0) {
            throw new IndexOutOfBoundsException(this.outOfBoundsMessage(offsetFromFirst));
        }
        if (!this.isBufferFull) {
            return this.buffer[offsetFromFirst];
        }
        int index = this.currentIndex + 1 + offsetFromFirst;
        return this.buffer[index % this.capacity];
    }

    public T getFromLast(int offsetFromLast) {
        if (offsetFromLast >= this.size()) {
            throw new IndexOutOfBoundsException(this.outOfBoundsMessage(offsetFromLast));
        }
        int index = this.currentIndex - offsetFromLast;
        if (index < 0 && this.isBufferFull) {
            index += this.capacity;
        }
        return this.buffer[index];
    }

    public boolean isBufferFull() {
        return this.isBufferFull;
    }

    public boolean isEmpty() {
        return this.currentIndex == -1;
    }

    public int size() {
        if (this.isBufferFull) {
            return this.capacity;
        }
        return this.currentIndex + 1;
    }

    public int capacity() {
        return this.capacity;
    }

    public T[] toArrayFromFirstToLast() {
        int size = this.size();
        Object[] array = (Object[])Array.newInstance(this.elementType, size);
        int index = this.isBufferFull ? this.currentIndex + 1 : 0;
        for (int offset = 0; offset < size; ++offset) {
            array[offset] = this.buffer[index % this.capacity];
            ++index;
        }
        return array;
    }

    public T[] toArrayFromLastToFirst() {
        int size = this.size();
        Object[] array = (Object[])Array.newInstance(this.elementType, size);
        int index = this.currentIndex;
        for (int offset = 0; offset < size; ++offset) {
            if (index < 0) {
                index += this.capacity;
            }
            array[offset] = this.buffer[index];
            --index;
        }
        return array;
    }

    @Override
    public Iterator<T> iterator() {
        return new RingBufferIterator(false);
    }

    public Iterator<T> reverseIterator() {
        return new RingBufferIterator(true);
    }

    private String outOfBoundsMessage(int index) {
        return "Index: " + index + ", Size: " + this.size();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof RingBuffer) {
            RingBuffer other = (RingBuffer)object;
            if (this.size() != other.size()) {
                return false;
            }
            for (int i = 0; i < this.size(); ++i) {
                if (this.getFromFirst(i).equals(other.getFromFirst(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public String toString() {
        if (this.isEmpty()) {
            return "Empty";
        }
        StringBuilder sb = new StringBuilder();
        int size = this.size();
        sb.append("Size: ").append(size).append(", [");
        sb.append(this.getFirst().toString());
        for (int i = 1; i < size; ++i) {
            sb.append(',').append(' ').append(this.getFromFirst(i));
        }
        sb.append(']');
        return sb.toString();
    }

    private class RingBufferIterator
    implements Iterator<T> {
        int cursor = 0;
        int expectedModCount = RingBuffer.access$100(RingBuffer.this);
        private final boolean reverse;

        private RingBufferIterator(boolean reverse) {
            this.reverse = reverse;
        }

        @Override
        public boolean hasNext() {
            return this.cursor != RingBuffer.this.size();
        }

        @Override
        public T next() {
            this.checkForComodification();
            try {
                int offset = this.cursor;
                Object next = this.reverse ? RingBuffer.this.getFromLast(offset) : RingBuffer.this.getFromFirst(offset);
                this.cursor = offset + 1;
                return next;
            }
            catch (IndexOutOfBoundsException e) {
                this.checkForComodification();
                throw new NoSuchElementException();
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Removing elements from the buffer is not supported.");
        }

        final void checkForComodification() {
            if (RingBuffer.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
        }
    }
}

