/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commons.lists;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Comparator;

public class PreallocatedEnumList<T extends Enum> {
    private final Class<T> clazz;
    private final T[] values;
    private int pos = -1;
    private final Enum[] constants;

    @Deprecated
    public PreallocatedEnumList() {
        this.clazz = null;
        this.values = null;
        this.constants = null;
    }

    public PreallocatedEnumList(Class<T> clazz, Enum[] constants, int maxSize) {
        this.clazz = clazz;
        this.values = (Enum[])Array.newInstance(clazz, maxSize);
        this.constants = constants;
    }

    public T[] toArray() {
        Enum[] array = (Enum[])Array.newInstance(this.clazz, this.size());
        System.arraycopy(this.values, 0, array, 0, this.size());
        return array;
    }

    public void toArray(T[] dest) {
        if (dest.length < this.size()) {
            throw new IndexOutOfBoundsException("Cannot copy data in destination array, insufficient space.");
        }
        System.arraycopy(this.values, 0, dest, 0, this.size());
    }

    public Enum[] getEnumConstants() {
        return this.constants;
    }

    public void resetQuick() {
        this.pos = -1;
    }

    public void add(T value) {
        this.maxCapacityCheck(this.pos + 1);
        this.values[++this.pos] = value;
    }

    public void remove() {
        this.nonEmptyCheck();
        --this.pos;
    }

    public void remove(int i) {
        if (i == this.pos) {
            this.remove();
            return;
        }
        this.rangeCheck(i);
        T t = this.values[i];
        while (i < this.pos) {
            this.values[i++] = this.values[i];
        }
        this.values[this.pos] = t;
        --this.pos;
    }

    public void swap(int i, int j) {
        this.rangeCheck(i);
        this.rangeCheck(j);
        if (i == j) {
            return;
        }
        this.unsafeSwap(i, j);
    }

    private void unsafeSwap(int i, int j) {
        T t = this.values[i];
        this.values[i] = this.values[j];
        this.values[j] = t;
    }

    public T get(int i) {
        this.rangeCheck(i);
        return this.values[i];
    }

    public T getFirst() {
        if (this.isEmpty()) {
            return null;
        }
        return this.values[0];
    }

    public T getLast() {
        if (this.isEmpty()) {
            return null;
        }
        return this.values[this.pos];
    }

    public void setEnum(int i, T value) {
        this.rangeCheck(i);
        this.values[i] = value;
    }

    public void clear() {
        this.resetQuick();
    }

    public int size() {
        return this.pos + 1;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public int capacity() {
        return this.values.length;
    }

    public void sort(Comparator<? super T> comparator) {
        if (this.size() == 0) {
            return;
        }
        Arrays.sort(this.values, 0, this.size(), comparator);
    }

    public int remaining() {
        return this.capacity() - this.size();
    }

    private void nonEmptyCheck() {
        if (this.pos < 0) {
            throw new ArrayIndexOutOfBoundsException("List is empty");
        }
    }

    private void rangeCheck(int i) {
        if (i < 0 || i > this.pos) {
            throw new ArrayIndexOutOfBoundsException("Position is not valid in the list, size is " + this.size() + ", requested element is " + i);
        }
    }

    private void maxCapacityCheck(int newSize) {
        if (newSize >= this.values.length) {
            throw new ArrayIndexOutOfBoundsException("Cannot add element to sequence, max size is violated");
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.clazz == null ? 0 : this.clazz.hashCode());
        result = 31 * result + Arrays.hashCode(this.constants);
        result = 31 * result + 1231;
        result = 31 * result + this.pos;
        result = 31 * result + Arrays.hashCode(this.values);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PreallocatedEnumList other = (PreallocatedEnumList)obj;
        if (this.clazz == null ? other.clazz != null : !this.clazz.equals(other.clazz)) {
            return false;
        }
        if (!Arrays.equals(this.constants, other.constants)) {
            return false;
        }
        if (this.pos != other.pos) {
            return false;
        }
        for (int i = 0; i < this.size(); ++i) {
            if (((Enum)this.values[i]).equals(other.values[i])) continue;
            return false;
        }
        return true;
    }
}

