/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commons.allocations;

import java.util.List;
import org.apache.commons.lang3.mutable.MutableDouble;
import org.apache.commons.lang3.mutable.MutableInt;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;
import us.ihmc.commons.MutationTestFacilitator;
import us.ihmc.commons.allocations.AllocationProfiler;
import us.ihmc.commons.allocations.AllocationRecord;
import us.ihmc.commons.thread.ThreadTools;
import us.ihmc.log.LogTools;

@Tag(value="allocation")
public class AllocationTestTest {
    @Execution(value=ExecutionMode.SAME_THREAD)
    @Test
    public void testSettingOfVector() {
        MutableDouble data = new MutableDouble();
        List allocations = new AllocationProfiler().recordAllocations(() -> data.setValue(1.0));
        Assertions.assertEquals((int)0, (int)allocations.size());
    }

    @Execution(value=ExecutionMode.SAME_THREAD)
    @Test
    public void testAllocationOfArray() {
        List allocations = new AllocationProfiler().recordAllocations(() -> {
            double[] someArray = new double[12];
        });
        Assertions.assertEquals((int)1, (int)allocations.size());
        this.assertAllocationsContain(allocations, double[].class);
        LogTools.info((String)((AllocationRecord)allocations.get(0)).toString());
    }

    @Execution(value=ExecutionMode.SAME_THREAD)
    @Test
    public void testSingleAllocation() {
        List allocations = new AllocationProfiler().recordAllocations(() -> new MutableDouble());
        this.printAllocations(allocations);
        Assertions.assertEquals((int)1, (int)allocations.size());
        Assertions.assertTrue((boolean)((AllocationRecord)allocations.get(0)).getAllocatedObject().getClass().equals(MutableDouble.class));
        LogTools.info((String)((AllocationRecord)allocations.get(0)).toString());
    }

    @Execution(value=ExecutionMode.SAME_THREAD)
    @Test
    public void testSingleAllocationConstructorFilter() {
        AllocationProfiler allocationProfiler = new AllocationProfiler();
        allocationProfiler.setRecordConstructorAllocations(true);
        List allocations = allocationProfiler.recordAllocations(() -> new LilAllocator());
        this.printAllocations(allocations);
        Assertions.assertEquals((int)3, (int)allocations.size());
        allocationProfiler.setRecordConstructorAllocations(false);
        allocations = allocationProfiler.recordAllocations(() -> new LilAllocator());
        this.printAllocations(allocations);
        Assertions.assertEquals((int)1, (int)allocations.size());
    }

    @Execution(value=ExecutionMode.SAME_THREAD)
    @Test
    public void testWhitelist() {
        AllocationProfiler allocationProfiler = new AllocationProfiler();
        allocationProfiler.setIncludeAllAllocations(false);
        allocationProfiler.startRecordingAllocations();
        LilAllocator lilAllocator = new LilAllocator();
        MutableInt mutableInt = new MutableInt();
        lilAllocator.doStuff();
        allocationProfiler.stopRecordingAllocations();
        List allocations = allocationProfiler.pollAllocations();
        this.printAllocations(allocations);
        Assertions.assertEquals((int)0, (int)allocations.size());
        allocationProfiler.includeAllocationsInsideClass(LilAllocator.class.getName());
        allocationProfiler.startRecordingAllocations();
        lilAllocator = new LilAllocator();
        mutableInt = new MutableInt();
        lilAllocator.doStuff();
        allocationProfiler.stopRecordingAllocations();
        allocations = allocationProfiler.pollAllocations();
        this.printAllocations(allocations);
        Assertions.assertEquals((int)2, (int)allocations.size());
    }

    @Execution(value=ExecutionMode.SAME_THREAD)
    @Test
    public void testBlacklist() {
        AllocationProfiler allocationProfiler = new AllocationProfiler();
        allocationProfiler.setRecordConstructorAllocations(false);
        allocationProfiler.excludeAllocationsInsideClass(LilAllocator.class.getName());
        allocationProfiler.startRecordingAllocations();
        LilAllocator lilAllocator = new LilAllocator();
        if (lilAllocator != null) {
            ThreadTools.sleep((long)10L);
            new MutableInt();
        }
        lilAllocator.doStuff();
        allocationProfiler.stopRecordingAllocations();
        List allocations = allocationProfiler.pollAllocations();
        this.printAllocations(allocations);
        this.assertAllocationsContain(allocations, LilAllocator.class);
        this.assertAllocationsContain(allocations, MutableInt.class);
        Assertions.assertEquals((int)2, (int)allocations.size());
    }

    private void assertAllocationsContain(List<AllocationRecord> allocations, Class clazz) {
        boolean found = false;
        for (AllocationRecord record : allocations) {
            if (!record.getAllocatedObject().getClass().equals(clazz)) continue;
            found = true;
        }
        Assertions.assertTrue((boolean)found);
    }

    @Execution(value=ExecutionMode.SAME_THREAD)
    @Test
    public void testMethodIncludeExclude() {
        AllocationProfiler allocationProfiler = new AllocationProfiler();
        String qualifiedMethodName = "us.ihmc.commons.allocations.AllocationTestTest$BrokenClass.imNotSupposedToAllocate";
        allocationProfiler.includeAllocationsInsideMethod(qualifiedMethodName);
        allocationProfiler.startRecordingAllocations();
        LilAllocator lilAllocator = new LilAllocator();
        MutableInt mutableInt = new MutableInt();
        lilAllocator.doStuff();
        allocationProfiler.stopRecordingAllocations();
        List allocations = allocationProfiler.pollAllocations();
        LogTools.info((String)"testMethodIncludeExclude1");
        this.printAllocations(allocations);
        Assertions.assertTrue((boolean)((AllocationRecord)allocations.get(0)).toString().contains(qualifiedMethodName));
        Assertions.assertEquals((int)1, (int)allocations.size());
        allocationProfiler.setIncludeAllAllocations(true);
        allocationProfiler.excludeAllocationsInsideMethod(qualifiedMethodName);
        allocationProfiler.startRecordingAllocations();
        lilAllocator = new LilAllocator();
        mutableInt = new MutableInt();
        lilAllocator.doStuff();
        allocationProfiler.stopRecordingAllocations();
        allocations = allocationProfiler.pollAllocations();
        LogTools.info((String)"testMethodIncludeExclude2");
        this.printAllocations(allocations);
        Assertions.assertEquals((int)3, (int)allocations.size());
    }

    @Execution(value=ExecutionMode.SAME_THREAD)
    @Test
    public void testReset() {
        AllocationProfiler allocationProfiler = new AllocationProfiler();
        String qualifiedMethodName = "us.ihmc.commons.allocations.AllocationTestTest$BrokenClass.imNotSupposedToAllocate";
        allocationProfiler.includeAllocationsInsideMethod(qualifiedMethodName);
        allocationProfiler.startRecordingAllocations();
        LilAllocator lilAllocator = new LilAllocator();
        MutableInt mutableInt = new MutableInt();
        lilAllocator.doStuff();
        allocationProfiler.stopRecordingAllocations();
        List allocations = allocationProfiler.pollAllocations();
        this.printAllocations(allocations);
        Assertions.assertTrue((boolean)((AllocationRecord)allocations.get(0)).toString().contains(qualifiedMethodName));
        Assertions.assertEquals((int)1, (int)allocations.size());
        allocationProfiler.reset();
        allocationProfiler.startRecordingAllocations();
        lilAllocator = new LilAllocator();
        mutableInt = new MutableInt();
        lilAllocator.doStuff();
        allocationProfiler.stopRecordingAllocations();
        allocations = allocationProfiler.pollAllocations();
        this.printAllocations(allocations);
        Assertions.assertEquals((int)4, (int)allocations.size());
    }

    private void printAllocations(List<AllocationRecord> allocations) {
        for (AllocationRecord allocation : allocations) {
            LogTools.info((String)allocation.toString());
        }
    }

    @Disabled
    @Execution(value=ExecutionMode.SAME_THREAD)
    @Test
    public void testSwitchTable() {
        List allocations = new AllocationProfiler().recordAllocations(() -> {
            switch (MyEnum.A) {
                default: 
            }
        });
        this.printAllocations(allocations);
        Assertions.assertEquals((int)2, (int)allocations.size(), (String)"allocated");
        allocations = new AllocationProfiler().recordAllocations(() -> {
            switch (MyEnum.B) {
                default: 
            }
        });
        this.printAllocations(allocations);
        Assertions.assertEquals((int)0, (int)allocations.size(), (String)"allocated");
    }

    public static void main(String[] args) {
        MutationTestFacilitator.facilitateMutationTestForClass(AllocationProfiler.class, AllocationTestTest.class);
    }

    private class LilAllocator {
        private BrokenClass brokenClass;
        private KnownAllocator knownAllocator;

        public LilAllocator() {
            this.knownAllocator = new KnownAllocator();
            this.brokenClass = new BrokenClass();
        }

        public void doStuff() {
            this.brokenClass.imNotSupposedToAllocate();
            this.knownAllocator.whoCaresIfIAllocate();
        }
    }

    private static enum MyEnum {
        A,
        B,
        C,
        D;

    }

    private class KnownAllocator {
        public MutableInt mutableInt;

        private KnownAllocator() {
        }

        public void whoCaresIfIAllocate() {
            this.mutableInt = new MutableInt();
        }
    }

    private class BrokenClass {
        public MutableInt mutableInt;

        private BrokenClass() {
        }

        public void imNotSupposedToAllocate() {
            this.mutableInt = new MutableInt();
        }
    }
}

