/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commons.allocations;

import java.io.IOException;
import java.util.List;
import org.apache.commons.lang3.mutable.MutableDouble;
import us.ihmc.commons.allocations.AllocationProfiler;
import us.ihmc.commons.lists.RecyclingArrayList;
import us.ihmc.log.LogTools;

public class AllocationRecordingDemo {
    public AllocationRecordingDemo() {
        AllocationProfiler allocationProfiler = new AllocationProfiler();
        allocationProfiler.includeAllocationsInsideClass(RecyclingArrayList.class.getName());
        int initialSize = 6;
        RecyclingArrayList myList = new RecyclingArrayList(initialSize, MutableDouble.class);
        allocationProfiler.startRecordingAllocations();
        myList.clear();
        for (int i = 0; i < initialSize; ++i) {
            myList.add();
        }
        allocationProfiler.stopRecordingAllocations();
        List allocations = allocationProfiler.pollAllocations();
        LogTools.info((String)("Number of places where allocations occured: " + allocations.size()));
        allocations.forEach(allocation -> System.out.println(allocation.toString()));
        allocations = allocationProfiler.recordAllocations(() -> myList.add());
        LogTools.info((String)("Number of places where allocations occured: " + allocations.size()));
        allocations.forEach(allocation -> System.out.println(allocation.toString()));
    }

    public static void main(String[] args) throws IOException {
        new AllocationRecordingDemo();
    }
}

