/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.tuple2D.interfaces;

import org.ejml.data.DMatrix;
import org.ejml.data.Matrix;
import us.ihmc.euclid.Axis2D;
import us.ihmc.euclid.interfaces.Clearable;
import us.ihmc.euclid.interfaces.Transformable;
import us.ihmc.euclid.tools.EuclidCoreTools;
import us.ihmc.euclid.transform.interfaces.Transform;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;

public interface Tuple2DBasics
extends Tuple2DReadOnly,
Clearable,
Transformable {
    public void setX(double var1);

    public void setY(double var1);

    @Override
    default public void setToZero() {
        this.set(0.0, 0.0);
    }

    @Override
    default public void setToNaN() {
        this.set(Double.NaN, Double.NaN);
    }

    @Override
    default public boolean containsNaN() {
        return Tuple2DReadOnly.super.containsNaN();
    }

    default public void absolute() {
        this.set(Math.abs(this.getX()), Math.abs(this.getY()));
    }

    default public void negate() {
        this.set(-this.getX(), -this.getY());
    }

    default public void normalize() {
        if (this.containsNaN()) {
            return;
        }
        this.scale(1.0 / this.norm());
    }

    default public void clipToMax(double max) {
        this.set(Math.min(max, this.getX()), Math.min(max, this.getY()));
    }

    default public void clipToMin(double min) {
        this.set(Math.max(min, this.getX()), Math.max(min, this.getY()));
    }

    default public void clipToMinMax(double min, double max) {
        this.setAndClipToMinMax(min, max, this);
    }

    default public boolean clipToMaxNorm(double maxNorm) {
        if (maxNorm < 1.0E-7) {
            this.setToZero();
            return true;
        }
        double normSquared = this.normSquared();
        if (normSquared < maxNorm * maxNorm) {
            return false;
        }
        this.scale(maxNorm / EuclidCoreTools.squareRoot(normSquared));
        return true;
    }

    default public void setElement(Axis2D axis, double value) {
        axis.insert(this, value);
    }

    default public void setElement(int index, double value) {
        switch (index) {
            case 0: {
                this.setX(value);
                break;
            }
            case 1: {
                this.setY(value);
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(Integer.toString(index));
            }
        }
    }

    default public void set(double x, double y) {
        this.setX(x);
        this.setY(y);
    }

    default public void set(Tuple2DReadOnly other) {
        this.set(other.getX(), other.getY());
    }

    default public void set(Tuple3DReadOnly tuple3DReadOnly) {
        this.set(tuple3DReadOnly.getX(), tuple3DReadOnly.getY());
    }

    default public void set(double[] tupleArray) {
        this.set(tupleArray[0], tupleArray[1]);
    }

    default public void set(int startIndex, double[] tupleArray) {
        this.set(tupleArray[startIndex++], tupleArray[startIndex]);
    }

    default public void set(float[] tupleArray) {
        this.set(tupleArray[0], tupleArray[1]);
    }

    default public void set(int startIndex, float[] tupleArray) {
        this.set(tupleArray[startIndex++], tupleArray[startIndex]);
    }

    default public void set(DMatrix matrix) {
        EuclidCoreTools.checkMatrixMinimumSize(2, 1, (Matrix)matrix);
        this.set(matrix.unsafe_get(0, 0), matrix.unsafe_get(1, 0));
    }

    default public void set(int startRow, DMatrix matrix) {
        EuclidCoreTools.checkMatrixMinimumSize(startRow + 2, 1, (Matrix)matrix);
        this.set(matrix.unsafe_get(startRow++, 0), matrix.unsafe_get(startRow, 0));
    }

    default public void set(int startRow, int column, DMatrix matrix) {
        EuclidCoreTools.checkMatrixMinimumSize(startRow + 2, column + 1, (Matrix)matrix);
        this.set(matrix.unsafe_get(startRow++, column), matrix.unsafe_get(startRow, column));
    }

    default public void setAndAbsolute(Tuple2DReadOnly other) {
        this.set(Math.abs(other.getX()), Math.abs(other.getY()));
    }

    default public void setAndNegate(Tuple2DReadOnly other) {
        this.set(-other.getX(), -other.getY());
    }

    default public void setAndNormalize(Tuple2DReadOnly other) {
        this.set(other);
        this.normalize();
    }

    default public void setAndScale(double scalar, Tuple2DReadOnly other) {
        this.set(scalar * other.getX(), scalar * other.getY());
    }

    default public void setAndClipToMax(double max, Tuple2DReadOnly other) {
        this.set(Math.min(max, other.getX()), Math.min(max, other.getY()));
    }

    default public void setAndClipToMin(double min, Tuple2DReadOnly other) {
        this.set(Math.max(min, other.getX()), Math.max(min, other.getY()));
    }

    default public void setAndClipToMinMax(double min, double max, Tuple2DReadOnly other) {
        double x = other.getX();
        double y = other.getY();
        if (x < min) {
            x = min;
        } else if (x > max) {
            x = max;
        }
        if (y < min) {
            y = min;
        } else if (y > max) {
            y = max;
        }
        this.set(x, y);
    }

    default public void addX(double x) {
        this.setX(this.getX() + x);
    }

    default public void addY(double y) {
        this.setY(this.getY() + y);
    }

    default public void add(double x, double y) {
        this.set(this.getX() + x, this.getY() + y);
    }

    default public void add(Tuple2DReadOnly other) {
        this.add(other.getX(), other.getY());
    }

    default public void add(Tuple2DReadOnly tuple1, Tuple2DReadOnly tuple2) {
        this.set(tuple1.getX() + tuple2.getX(), tuple1.getY() + tuple2.getY());
    }

    default public void subX(double x) {
        this.setX(this.getX() - x);
    }

    default public void subY(double y) {
        this.setY(this.getY() - y);
    }

    default public void sub(double x, double y) {
        this.set(this.getX() - x, this.getY() - y);
    }

    default public void sub(Tuple2DReadOnly tupleReadOnly) {
        this.sub(tupleReadOnly.getX(), tupleReadOnly.getY());
    }

    default public void sub(Tuple2DReadOnly tuple1, Tuple2DReadOnly tuple2) {
        this.set(tuple1.getX() - tuple2.getX(), tuple1.getY() - tuple2.getY());
    }

    default public void scale(double scalar) {
        this.scale(scalar, scalar);
    }

    default public void scale(double scalarX, double scalarY) {
        this.set(scalarX * this.getX(), scalarY * this.getY());
    }

    default public void scaleAdd(double scalar, Tuple2DReadOnly other) {
        this.scale(scalar);
        this.add(other);
    }

    default public void scaleAdd(double scalar, Tuple2DReadOnly tuple1, Tuple2DReadOnly tuple2) {
        double x = scalar * tuple1.getX() + tuple2.getX();
        double y = scalar * tuple1.getY() + tuple2.getY();
        this.set(x, y);
    }

    default public void scaleSub(double scalar, Tuple2DReadOnly other) {
        this.scale(scalar);
        this.sub(other);
    }

    default public void scaleSub(double scalar, Tuple2DReadOnly tuple1, Tuple2DReadOnly tuple2) {
        double x = scalar * tuple1.getX() - tuple2.getX();
        double y = scalar * tuple1.getY() - tuple2.getY();
        this.set(x, y);
    }

    default public void interpolate(Tuple2DReadOnly other, double alpha) {
        this.interpolate(this, other, alpha);
    }

    default public void interpolate(Tuple2DReadOnly tuple1, Tuple2DReadOnly tuple2, double alpha) {
        double x = EuclidCoreTools.interpolate(tuple1.getX(), tuple2.getX(), alpha);
        double y = EuclidCoreTools.interpolate(tuple1.getY(), tuple2.getY(), alpha);
        this.set(x, y);
    }

    @Override
    default public void applyTransform(Transform transform) {
        this.applyTransform(transform, true);
    }

    public void applyTransform(Transform var1, boolean var2);

    @Override
    default public void applyInverseTransform(Transform transform) {
        this.applyInverseTransform(transform, true);
    }

    public void applyInverseTransform(Transform var1, boolean var2);
}

