/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.transform.interfaces;

import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.matrix.interfaces.Matrix3DBasics;
import us.ihmc.euclid.matrix.interfaces.Matrix3DReadOnly;
import us.ihmc.euclid.matrix.interfaces.RotationMatrixBasics;
import us.ihmc.euclid.orientation.interfaces.Orientation3DBasics;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.tools.TupleTools;
import us.ihmc.euclid.transform.interfaces.AffineTransformBasics;
import us.ihmc.euclid.transform.interfaces.AffineTransformReadOnly;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformBasics;
import us.ihmc.euclid.transform.interfaces.Transform;
import us.ihmc.euclid.tuple2D.interfaces.Point2DBasics;
import us.ihmc.euclid.tuple2D.interfaces.Point2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Vector2DBasics;
import us.ihmc.euclid.tuple2D.interfaces.Vector2DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.euclid.tuple4D.interfaces.Vector4DBasics;
import us.ihmc.euclid.tuple4D.interfaces.Vector4DReadOnly;

public interface RigidBodyTransformReadOnly
extends Transform {
    public static final double EPS_ZERO_TRANSLATION = 1.0E-10;

    public Orientation3DReadOnly getRotation();

    public Tuple3DReadOnly getTranslation();

    default public boolean hasRotation() {
        return !this.getRotation().isZeroOrientation();
    }

    default public boolean hasTranslation() {
        return !TupleTools.isTupleZero(this.getTranslation(), 1.0E-10);
    }

    default public boolean containsNaN() {
        return this.getRotation().containsNaN() || this.getTranslation().containsNaN();
    }

    default public boolean isRotation2D() {
        return !this.hasRotation() || this.getRotation().isOrientation2D();
    }

    default public void checkIfRotation2D() {
        if (this.hasRotation()) {
            this.getRotation().checkIfOrientation2D();
        }
    }

    @Override
    default public void transform(Point3DReadOnly pointOriginal, Point3DBasics pointTransformed) {
        if (this.hasRotation()) {
            this.getRotation().transform(pointOriginal, pointTransformed);
        } else {
            pointTransformed.set(pointOriginal);
        }
        if (this.hasTranslation()) {
            pointTransformed.add(this.getTranslation());
        }
    }

    @Override
    default public void transform(Vector3DReadOnly vectorOriginal, Vector3DBasics vectorTransformed) {
        if (this.hasRotation()) {
            this.getRotation().transform(vectorOriginal, vectorTransformed);
        } else {
            vectorTransformed.set(vectorOriginal);
        }
    }

    @Override
    default public void transform(Orientation3DReadOnly orientationOriginal, Orientation3DBasics orientationTransformed) {
        if (this.hasRotation()) {
            this.getRotation().transform(orientationOriginal, orientationTransformed);
        } else {
            orientationTransformed.set(orientationOriginal);
        }
    }

    @Override
    default public void transform(Vector4DReadOnly vectorOriginal, Vector4DBasics vectorTransformed) {
        if (this.hasRotation()) {
            this.getRotation().transform(vectorOriginal, vectorTransformed);
        } else {
            vectorTransformed.set(vectorOriginal);
        }
        if (this.hasTranslation()) {
            vectorTransformed.addX(vectorTransformed.getS() * this.getTranslation().getX());
            vectorTransformed.addY(vectorTransformed.getS() * this.getTranslation().getY());
            vectorTransformed.addZ(vectorTransformed.getS() * this.getTranslation().getZ());
        }
    }

    @Override
    default public void transform(Point2DReadOnly point2DOriginal, Point2DBasics point2DTransformed, boolean checkIfTransformInXYPlane) {
        if (this.hasRotation()) {
            this.getRotation().transform(point2DOriginal, point2DTransformed, checkIfTransformInXYPlane);
        } else {
            point2DTransformed.set(point2DOriginal);
        }
        if (this.hasTranslation()) {
            point2DTransformed.add(this.getTranslation().getX(), this.getTranslation().getY());
        }
    }

    @Override
    default public void transform(Vector2DReadOnly vector2DOriginal, Vector2DBasics vector2DTransformed, boolean checkIfTransformInXYPlane) {
        if (this.hasRotation()) {
            this.getRotation().transform(vector2DOriginal, vector2DTransformed, checkIfTransformInXYPlane);
        } else {
            vector2DTransformed.set(vector2DOriginal);
        }
    }

    @Override
    default public void transform(Matrix3DReadOnly matrixOriginal, Matrix3DBasics matrixTransformed) {
        if (this.hasRotation()) {
            this.getRotation().transform(matrixOriginal, matrixTransformed);
        } else {
            matrixTransformed.set(matrixOriginal);
        }
    }

    @Override
    default public void transform(RigidBodyTransformReadOnly original, RigidBodyTransformBasics transformed) {
        transformed.set(original);
        transformed.preMultiply(this);
    }

    @Override
    default public void transform(AffineTransformReadOnly original, AffineTransformBasics transformed) {
        transformed.set(original);
        transformed.preMultiply(this);
    }

    @Override
    default public void inverseTransform(Point3DReadOnly pointOriginal, Point3DBasics pointTransformed) {
        pointTransformed.set(pointOriginal);
        if (this.hasTranslation()) {
            pointTransformed.sub(this.getTranslation());
        }
        if (this.hasRotation()) {
            this.getRotation().inverseTransform(pointTransformed);
        }
    }

    @Override
    default public void inverseTransform(Vector3DReadOnly vectorOriginal, Vector3DBasics vectorTransformed) {
        if (this.hasRotation()) {
            this.getRotation().inverseTransform(vectorOriginal, vectorTransformed);
        } else {
            vectorTransformed.set(vectorOriginal);
        }
    }

    @Override
    default public void inverseTransform(Orientation3DReadOnly orientationOriginal, Orientation3DBasics orientationTransformed) {
        if (this.hasRotation()) {
            this.getRotation().inverseTransform(orientationOriginal, orientationTransformed);
        } else {
            orientationTransformed.set(orientationOriginal);
        }
    }

    @Override
    default public void inverseTransform(Vector4DReadOnly vectorOriginal, Vector4DBasics vectorTransformed) {
        vectorTransformed.set(vectorOriginal);
        if (this.hasTranslation()) {
            vectorTransformed.subX(vectorTransformed.getS() * this.getTranslation().getX());
            vectorTransformed.subY(vectorTransformed.getS() * this.getTranslation().getY());
            vectorTransformed.subZ(vectorTransformed.getS() * this.getTranslation().getZ());
        }
        if (this.hasRotation()) {
            this.getRotation().inverseTransform(vectorTransformed, vectorTransformed);
        }
    }

    @Override
    default public void inverseTransform(Point2DReadOnly point2DOriginal, Point2DBasics point2DTransformed, boolean checkIfTransformInXYPlane) {
        point2DTransformed.set(point2DOriginal);
        if (this.hasTranslation()) {
            point2DTransformed.sub(this.getTranslation().getX(), this.getTranslation().getY());
        }
        if (this.hasRotation()) {
            this.getRotation().inverseTransform(point2DTransformed, checkIfTransformInXYPlane);
        }
    }

    @Override
    default public void inverseTransform(Vector2DReadOnly vector2DOriginal, Vector2DBasics vector2DTransformed, boolean checkIfTransformInXYPlane) {
        if (this.hasRotation()) {
            this.getRotation().inverseTransform(vector2DOriginal, vector2DTransformed, checkIfTransformInXYPlane);
        } else {
            vector2DTransformed.set(vector2DOriginal);
        }
    }

    @Override
    default public void inverseTransform(Matrix3DReadOnly matrixOriginal, Matrix3DBasics matrixTransformed) {
        if (this.hasRotation()) {
            this.getRotation().inverseTransform(matrixOriginal, matrixTransformed);
        } else {
            matrixTransformed.set(matrixOriginal);
        }
    }

    @Override
    default public void inverseTransform(RigidBodyTransformReadOnly original, RigidBodyTransformBasics transformed) {
        transformed.set(original);
        transformed.preMultiplyInvertOther(this);
    }

    @Override
    default public void inverseTransform(AffineTransformReadOnly original, AffineTransformBasics transformed) {
        transformed.set(original);
        transformed.preMultiplyInvertOther(this);
    }

    default public double getTranslationX() {
        return this.getTranslation().getX();
    }

    default public double getTranslationY() {
        return this.getTranslation().getY();
    }

    default public double getTranslationZ() {
        return this.getTranslation().getZ();
    }

    default public void get(Orientation3DBasics orientationToPack, Tuple3DBasics translationToPack) {
        orientationToPack.set(this.getRotation());
        translationToPack.set(this.getTranslation());
    }

    default public void get(Vector3DBasics rotationVectorToPack, Tuple3DBasics translationToPack) {
        this.getRotation().getRotationVector(rotationVectorToPack);
        translationToPack.set(this.getTranslation());
    }

    default public void get(RotationMatrixBasics rotationMatrixToPack, Tuple3DBasics translationToPack) {
        rotationMatrixToPack.set(this.getRotation());
        translationToPack.set(this.getTranslation());
    }

    @Override
    default public boolean geometricallyEquals(EuclidGeometry geometry, double epsilon) {
        if (geometry == this) {
            return true;
        }
        if (geometry == null) {
            return false;
        }
        if (!(geometry instanceof RigidBodyTransformReadOnly)) {
            return false;
        }
        RigidBodyTransformReadOnly other = (RigidBodyTransformReadOnly)geometry;
        return this.getRotation().geometricallyEquals(other.getRotation(), epsilon) && this.getTranslation().geometricallyEquals(other.getTranslation(), epsilon);
    }
}

