/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid;

import us.ihmc.euclid.axisAngle.AxisAngle;
import us.ihmc.euclid.rotationConversion.QuaternionConversion;
import us.ihmc.euclid.tools.EuclidCoreTools;
import us.ihmc.euclid.tools.QuaternionTools;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.euclid.tuple4D.Quaternion;
import us.ihmc.euclid.tuple4D.Vector4D;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionBasics;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionReadOnly;
import us.ihmc.euclid.tuple4D.interfaces.Tuple4DReadOnly;
import us.ihmc.euclid.tuple4D.interfaces.Vector4DBasics;
import us.ihmc.euclid.tuple4D.interfaces.Vector4DReadOnly;

public class QuaternionCalculus {
    private final AxisAngle axisAngleForLog = new AxisAngle();
    private final Quaternion tempQ1ForInterpolation = new Quaternion();
    private final AxisAngle axisAngleForPow = new AxisAngle();
    private final Quaternion qConj = new Quaternion();
    private final Vector4D intermediateQDot = new Vector4D();
    private final Vector4D qDotConj = new Vector4D();
    private final Vector3D intermediateAngularAcceleration = new Vector3D();
    private final Vector3D intermediateAngularVelocity = new Vector3D();
    private final Vector4D intermediateQDDot = new Vector4D();
    private final Vector4D pureQuatForMultiply = new Vector4D();

    public void log(QuaternionReadOnly q, Vector4DBasics resultToPack) {
        this.axisAngleForLog.set(q);
        resultToPack.set(this.axisAngleForLog.getX(), this.axisAngleForLog.getY(), this.axisAngleForLog.getZ(), 0.0);
        resultToPack.scale(this.axisAngleForLog.getAngle());
    }

    public void log(QuaternionReadOnly q, Vector3DBasics resultToPack) {
        this.axisAngleForLog.set(q);
        resultToPack.set(this.axisAngleForLog.getX(), this.axisAngleForLog.getY(), this.axisAngleForLog.getZ());
        resultToPack.scale(this.axisAngleForLog.getAngle());
    }

    public static void exp(Vector3DReadOnly rotationVector, QuaternionBasics quaternionToPack) {
        QuaternionConversion.convertRotationVectorToQuaternion(rotationVector, quaternionToPack);
    }

    public void interpolate(double alpha, QuaternionReadOnly q0, QuaternionReadOnly q1, QuaternionBasics qInterpolatedToPack) {
        this.interpolate(alpha, q0, q1, qInterpolatedToPack, true);
    }

    public void interpolate(double alpha, QuaternionReadOnly q0, QuaternionReadOnly q1, QuaternionBasics qInterpolatedToPack, boolean preventExtraSpin) {
        this.tempQ1ForInterpolation.set(q1);
        if (preventExtraSpin && q0.dot(this.tempQ1ForInterpolation) < 0.0) {
            this.tempQ1ForInterpolation.negate();
        }
        qInterpolatedToPack.difference(q0, this.tempQ1ForInterpolation);
        this.pow(qInterpolatedToPack, alpha, qInterpolatedToPack);
        qInterpolatedToPack.multiply(q0, qInterpolatedToPack);
    }

    public void pow(QuaternionReadOnly q, double power, QuaternionBasics resultToPack) {
        this.axisAngleForPow.set(q);
        this.axisAngleForPow.setAngle(power * this.axisAngleForPow.getAngle());
        resultToPack.set(this.axisAngleForPow);
    }

    public void computeAngularVelocityInRotatedFrame(QuaternionReadOnly q, Vector4DReadOnly qDot, Vector3DBasics angularVelocityToPack) {
        this.qConj.setAndConjugate(q);
        this.multiply(this.qConj, qDot, angularVelocityToPack);
        angularVelocityToPack.scale(2.0);
    }

    public void computeAngularVelocityInParentFrame(QuaternionReadOnly q, Vector4DReadOnly qDot, Vector3DBasics angularVelocityToPack) {
        this.qConj.setAndConjugate(q);
        this.multiply(qDot, this.qConj, angularVelocityToPack);
        angularVelocityToPack.scale(2.0);
    }

    public static void computeQDotInParentFrame(QuaternionReadOnly q, Vector3DReadOnly angularVelocityInParent, Vector4DBasics qDotToPack) {
        QuaternionCalculus.multiply(angularVelocityInParent, q, qDotToPack);
        qDotToPack.scale(0.5);
    }

    public static void computeQDotInRotatedFrame(QuaternionReadOnly q, Vector3DReadOnly angularVelocityInRotated, Vector4DBasics qDotToPack) {
        QuaternionCalculus.multiply(q, angularVelocityInRotated, qDotToPack);
        qDotToPack.scale(0.5);
    }

    public void computeQDDotInParentFrame(QuaternionReadOnly q, Vector4DReadOnly qDot, Vector3DReadOnly angularAccelerationInParent, Vector4DBasics qDDotToPack) {
        this.computeAngularVelocityInParentFrame(q, qDot, this.intermediateAngularVelocity);
        this.computeQDDotInParentFrame(q, qDot, this.intermediateAngularVelocity, angularAccelerationInParent, qDDotToPack);
    }

    public void computeQDDotInParentFrame(QuaternionReadOnly q, Vector3DReadOnly angularVelocityInParent, Vector3DReadOnly angularAccelerationInParent, Vector4DBasics qDDotToPack) {
        QuaternionCalculus.computeQDotInParentFrame(q, angularVelocityInParent, this.intermediateQDot);
        this.computeQDDotInParentFrame(q, this.intermediateQDot, angularVelocityInParent, angularAccelerationInParent, qDDotToPack);
    }

    public void computeAngularAccelerationInParentFrame(QuaternionReadOnly q, Vector4DReadOnly qDDot, Vector3DReadOnly angularVelocityInParent, Vector3DBasics angularAccelerationInParentToPack) {
        QuaternionCalculus.computeQDotInParentFrame(q, angularVelocityInParent, this.intermediateQDot);
        this.computeAngularAccelerationInRotatedFrame(q, this.intermediateQDot, qDDot, angularAccelerationInParentToPack);
    }

    public void computeAngularAccelerationInRotatedFrame(QuaternionReadOnly q, Vector4DReadOnly qDot, Vector4DReadOnly qDDot, Vector3DBasics angularAccelerationInRotatedToPack) {
        this.qConj.setAndConjugate(q);
        this.qDotConj.set(-qDot.getX(), -qDot.getY(), -qDot.getZ(), qDot.getS());
        this.multiply(qDot, (Vector4DReadOnly)this.qDotConj, (Vector3DBasics)this.intermediateAngularAcceleration);
        this.multiply(qDDot, this.qConj, angularAccelerationInRotatedToPack);
        angularAccelerationInRotatedToPack.add(this.intermediateAngularAcceleration);
        angularAccelerationInRotatedToPack.scale(2.0);
    }

    public static void computeQDotByFiniteDifferenceCentral(QuaternionReadOnly qPrevious, QuaternionReadOnly qNext, double dt, Vector4DBasics qDotToPack) {
        qDotToPack.sub(qNext, qPrevious);
        qDotToPack.scale(0.5 / dt);
    }

    public static void computeQDDotByFiniteDifferenceCentral(QuaternionReadOnly qPrevious, QuaternionReadOnly q, QuaternionReadOnly qNext, double dt, Vector4DBasics qDDotToPack) {
        qDDotToPack.sub(qNext, q);
        qDDotToPack.sub(q);
        qDDotToPack.add(qPrevious);
        qDDotToPack.scale(1.0 / EuclidCoreTools.square(dt));
    }

    void computeQDDotInParentFrame(QuaternionReadOnly q, Vector4DReadOnly qDot, Vector3DReadOnly angularVelocityInParent, Vector3DReadOnly angularAccelerationInParent, Vector4DBasics qDDotToPack) {
        QuaternionCalculus.multiply(angularAccelerationInParent, q, (Vector4DBasics)this.intermediateQDDot);
        QuaternionCalculus.multiply(angularVelocityInParent, qDot, qDDotToPack);
        qDDotToPack.add(this.intermediateQDDot);
        qDDotToPack.scale(0.5);
    }

    private static void multiply(QuaternionReadOnly q, Vector3DReadOnly v, Vector4DBasics resultToPack) {
        QuaternionCalculus.setAsPureQuaternion(v, resultToPack);
        QuaternionTools.multiply((Tuple4DReadOnly)q, resultToPack, resultToPack);
    }

    private static void multiply(Vector3DReadOnly v, Vector4DReadOnly q, Vector4DBasics resultToPack) {
        QuaternionCalculus.setAsPureQuaternion(v, resultToPack);
        QuaternionTools.multiply(resultToPack, q, resultToPack);
    }

    private static void multiply(Vector3DReadOnly v, QuaternionReadOnly q, Vector4DBasics resultToPack) {
        QuaternionCalculus.setAsPureQuaternion(v, resultToPack);
        QuaternionTools.multiply(resultToPack, (Tuple4DReadOnly)q, resultToPack);
    }

    private void multiply(Vector4DReadOnly q1, Vector4DReadOnly q2, Vector3DBasics resultToPack) {
        QuaternionTools.multiply(q1, q2, this.pureQuatForMultiply);
        QuaternionCalculus.setVectorFromPureQuaternion(this.pureQuatForMultiply, resultToPack);
    }

    private void multiply(Vector4DReadOnly q1, QuaternionReadOnly q2, Vector3DBasics resultToPack) {
        QuaternionTools.multiply(q1, (Tuple4DReadOnly)q2, this.pureQuatForMultiply);
        QuaternionCalculus.setVectorFromPureQuaternion(this.pureQuatForMultiply, resultToPack);
    }

    private void multiply(QuaternionReadOnly q1, Vector4DReadOnly q2, Vector3DBasics resultToPack) {
        QuaternionTools.multiply((Tuple4DReadOnly)q1, q2, this.pureQuatForMultiply);
        QuaternionCalculus.setVectorFromPureQuaternion(this.pureQuatForMultiply, resultToPack);
    }

    private static void setAsPureQuaternion(Vector3DReadOnly vector, Vector4DBasics pureQuaternionToSet) {
        pureQuaternionToSet.set(vector.getX(), vector.getY(), vector.getZ(), 0.0);
    }

    private static void setVectorFromPureQuaternion(Vector4DReadOnly pureQuaternion, Vector3DBasics vectorToPack) {
        vectorToPack.set(pureQuaternion.getX(), pureQuaternion.getY(), pureQuaternion.getZ());
    }
}

